/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.codegen.util.CodegenXtendPlugin;
import org.eclipse.gmf.codegen.util.IExtensionTemplatesProvider;
import org.eclipse.gmf.codegen.util.ManifestUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;

public class ExtensionTemplatesProviderImpl
implements IExtensionTemplatesProvider {
    public static String DEFAULT_DYNAMIC_TEMPLATES_FOLDER = "/aspects";
    public static String POINT_SEPARATOR = ".";
    public static String EMPLTY_STRING = "";
    public static String TEMPLATE_FILE_EXTENSIION = "xtend";
    private final String myCustomTemplatePath;
    private final IProject myProject;
    private List<Class<?>> myDinamicClasses;
    private List<Class<?>> myCustomClasses;
    private static final String SLASH = "/";
    private final Bundle myBundle;

    public ExtensionTemplatesProviderImpl(String customPath) {
        if (customPath.startsWith(SLASH)) {
            customPath = customPath.substring(1, customPath.length() - 1);
        }
        String[] parts = customPath.split(SLASH);
        this.myProject = ResourcesPlugin.getWorkspace().getRoot().getProject(parts[0]);
        this.myCustomTemplatePath = ExtensionTemplatesProviderImpl.concatWithoutFirst(parts);
        ManifestUtil.createOrFillManifest(this.myProject);
        try {
            this.myBundle = ExtensionTemplatesProviderImpl.loadBundle(this.myProject);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot create correct URL for Bundle.", e);
        }
        catch (BundleException e) {
            throw new RuntimeException("Error. Bundle was not load.", e);
        }
    }

    private static Bundle loadBundle(IProject project) throws MalformedURLException, BundleException {
        String url = project.getLocation().toFile().toURI().toURL().toExternalForm();
        return CodegenXtendPlugin.getInstance().getContext().installBundle(url);
    }

    private static String concatWithoutFirst(String[] parts) {
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i < parts.length) {
            builder.append(SLASH).append(parts[i]);
            ++i;
        }
        return builder.toString();
    }

    @Override
    public List<Class<?>> getCustomTemplateClasses() {
        if (this.myCustomClasses == null) {
            this.myCustomClasses = new LinkedList();
            this.myCustomClasses.addAll(this.loadCustomClasses(EMPLTY_STRING, false));
        }
        return this.myCustomClasses;
    }

    @Override
    public List<Class<?>> getDynamicTemplateClasses() {
        if (this.myDinamicClasses == null) {
            this.myDinamicClasses = new LinkedList();
            this.myDinamicClasses.addAll(this.loadCustomClasses(DEFAULT_DYNAMIC_TEMPLATES_FOLDER, true));
        }
        return this.myDinamicClasses;
    }

    @Override
    public Class<?> getSuperClassForDynamic(Class<?> _class) {
        return _class.getSuperclass();
    }

    private List<Class<?>> loadCustomClasses(String pathSuffix, boolean aspectNotCustom) {
        return this.loadFolder(this.myProject.getFolder(String.valueOf(this.myCustomTemplatePath) + pathSuffix), aspectNotCustom ? "aspects" : "");
    }

    private List<Class<?>> loadFolder(IFolder parentFolder, String relativPath) {
        int n;
        int n2;
        IFile[] iFileArray;
        LinkedList result = new LinkedList();
        IFile[] files = null;
        IFolder[] folders = null;
        try {
            files = (IFile[])this.getSubResources(parentFolder, true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (files != null && files.length > 0) {
            iFileArray = files;
            n2 = files.length;
            n = 0;
            while (n < n2) {
                IFile fileToLoad = iFileArray[n];
                try {
                    result.add(this.loadClass(fileToLoad, relativPath));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error. Did not load " + fileToLoad.getName() + ". Class not found.", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error has occurred when try to load " + fileToLoad.getName(), e);
                }
                ++n;
            }
        }
        try {
            folders = (IFolder[])this.getSubResources(parentFolder, false);
            if (folders != null && folders.length > 0) {
                iFileArray = folders;
                n2 = folders.length;
                n = 0;
                while (n < n2) {
                    IFile folderToLoad = iFileArray[n];
                    result.addAll(this.loadFolder((IFolder)folderToLoad, this.createRelativPath(relativPath, folderToLoad.getName())));
                    ++n;
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Error.  Cannot load folder/package " + parentFolder.getName(), e);
        }
        return result;
    }

    private String createRelativPath(String relativePath, String child) {
        return relativePath.length() > 0 ? String.valueOf(relativePath) + "." + child : child;
    }

    private IResource[] getSubResources(IFolder parentFolder, boolean filesNotFolders) throws CoreException {
        LinkedList<Object> result = new LinkedList<Object>();
        IResource[] iResourceArray = parentFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (filesNotFolders) {
                IFile xtendFile;
                if (res instanceof IFile && TEMPLATE_FILE_EXTENSIION.equals((xtendFile = (IFile)res).getFileExtension())) {
                    result.add(xtendFile);
                }
            } else if (res instanceof IFolder) {
                result.add((IFolder)res);
            }
            ++n2;
        }
        if (result.size() > 0) {
            if (filesNotFolders) {
                return (IResource[])result.toArray(new IFile[result.size()]);
            }
            return (IResource[])result.toArray(new IFolder[result.size()]);
        }
        return null;
    }

    private Class<?> loadClass(IFile classFile, String relativePath) throws ClassNotFoundException, IOException {
        String className = this.createRelativPath(relativePath, classFile.getName().replace(String.valueOf(POINT_SEPARATOR) + TEMPLATE_FILE_EXTENSIION, EMPLTY_STRING));
        return this.myBundle.loadClass(className);
    }

    @Override
    public void dispose() {
        try {
            Bundle systemBundle = CodegenXtendPlugin.getInstance().getContext().getBundle(0L);
            this.myBundle.uninstall();
            FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
            frameworkWiring.refreshBundles(frameworkWiring.getRemovalPendingBundles(), new FrameworkListener[0]);
        }
        catch (BundleException e) {
            throw new RuntimeException("Error while unloading bundle.", e);
        }
    }
}

