/*
 * Decompiled with CFR 0.152.
 */
package xpt.diagram.updater;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;
import xpt.diagram.updater.UpdaterLinkType;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private LinkUtils_qvto _linkUtils_qvto;

    public String getLinkMethodSuffix(UpdaterLinkType type) {
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.CONTAINED))) {
            _matched = true;
            return "Contained";
        }
        if (!_matched && Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.INCOMING))) {
            _matched = true;
            return "Incoming";
        }
        if (!_matched && Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.OUTGOING))) {
            _matched = true;
            return "Outgoing";
        }
        String _plus = "Unknown updaterLinkType: " + (Object)((Object)type);
        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
        throw _illegalArgumentException;
    }

    public Iterable<GenLink> computeContainedLinks(final GenClass metaClass, GenDiagram diagram) {
        EList _links = diagram.getLinks();
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                boolean _canBeContainer = Utils_qvto.this._linkUtils_qvto.canBeContainer(link, metaClass);
                return _canBeContainer;
            }
        };
        return IterableExtensions.filter((Iterable)_links, (Functions.Function1)_function);
    }

    public Iterable<GenLink> computeOutgoingLinks(final GenLinkEnd linkEnd) {
        GenDiagram _diagram = linkEnd.getDiagram();
        EList _links = _diagram.getLinks();
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                EList _genOutgoingLinks = linkEnd.getGenOutgoingLinks();
                boolean _contains = _genOutgoingLinks.contains((Object)link);
                return _contains;
            }
        };
        return IterableExtensions.filter((Iterable)_links, (Functions.Function1)_function);
    }

    public Iterable<GenLink> computeIncomingLinks(final GenLinkEnd linkEnd) {
        GenDiagram _diagram = linkEnd.getDiagram();
        EList _links = _diagram.getLinks();
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                EList _genIncomingLinks = linkEnd.getGenIncomingLinks();
                boolean _contains = _genIncomingLinks.contains((Object)link);
                return _contains;
            }
        };
        return IterableExtensions.filter((Iterable)_links, (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAllContainedLinks(final GenDiagram diagram) {
        EList _links = diagram.getLinks();
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(final GenLink link) {
                Iterable<GenCommonBase> _allSemanticElements = Utils_qvto.this.getAllSemanticElements(diagram);
                Functions.Function1<GenCommonBase, Boolean> _function = new Functions.Function1<GenCommonBase, Boolean>(){

                    public Boolean apply(GenCommonBase commonBase) {
                        GenClass _metaClass = Utils_qvto.this.getMetaClass((EObject)commonBase);
                        boolean _canBeContainer = Utils_qvto.this._linkUtils_qvto.canBeContainer(link, _metaClass);
                        return _canBeContainer;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allSemanticElements, (Functions.Function1)_function);
                boolean _notEmpty = Utils_qvto.this._common_qvto.notEmpty(_filter);
                return _notEmpty;
            }
        };
        return IterableExtensions.filter((Iterable)_links, (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAllIncomingLinks(GenDiagram diagram) {
        EList _links = diagram.getLinks();
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                EList _targets = link.getTargets();
                boolean _notEmpty = Utils_qvto.this._common_qvto.notEmpty(_targets);
                return _notEmpty;
            }
        };
        return IterableExtensions.filter((Iterable)_links, (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAllOutgoingLinks(GenDiagram diagram) {
        EList _links = diagram.getLinks();
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                boolean _isOutgoingLink = Utils_qvto.this.isOutgoingLink(link);
                return _isOutgoingLink;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_links, (Functions.Function1)_function);
        Functions.Function1<GenLink, Boolean> _function_1 = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                EList _sources = link.getSources();
                boolean _notEmpty = Utils_qvto.this._common_qvto.notEmpty(_sources);
                return _notEmpty;
            }
        };
        return IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public boolean isOutgoingLink(GenLink link) {
        boolean _notEquals;
        boolean _and = false;
        LinkModelFacet _modelFacet = link.getModelFacet();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_modelFacet);
        if (!_notEquals) {
            _and = false;
        } else {
            LinkModelFacet _modelFacet_1 = link.getModelFacet();
            boolean _isOutgoingLinkModelFacet = this.isOutgoingLinkModelFacet(_modelFacet_1);
            _and = _notEquals && _isOutgoingLinkModelFacet;
        }
        return _and;
    }

    protected boolean _isOutgoingLinkModelFacet(LinkModelFacet facet) {
        return true;
    }

    protected boolean _isOutgoingLinkModelFacet(TypeLinkModelFacet facet) {
        GenFeature _sourceMetaFeature = facet.getSourceMetaFeature();
        return !Objects.equal(null, (Object)_sourceMetaFeature);
    }

    public Iterable<GenLinkEnd> getAllSemanticDiagramElements(GenDiagram diagram) {
        LinkedList result = CollectionLiterals.newLinkedList((Object[])new GenLinkEnd[0]);
        EList _allNodes = diagram.getAllNodes();
        result.addAll(_allNodes);
        EList _links = diagram.getLinks();
        result.addAll(_links);
        Functions.Function1<GenLinkEnd, Boolean> _function = new Functions.Function1<GenLinkEnd, Boolean>(){

            public Boolean apply(GenLinkEnd linkEnd) {
                GenClass _metaClass = Utils_qvto.this.getMetaClass((EObject)linkEnd);
                boolean _notEquals = !Objects.equal((Object)_metaClass, null);
                return _notEquals;
            }
        };
        return IterableExtensions.filter((Iterable)result, (Functions.Function1)_function);
    }

    public Iterable<GenCommonBase> getAllSemanticElements(GenDiagram diagram) {
        boolean _notEquals;
        GenClass _domainDiagramElement = diagram.getDomainDiagramElement();
        boolean bl = _notEquals = !Objects.equal((Object)_domainDiagramElement, null);
        if (_notEquals) {
            LinkedList result = CollectionLiterals.newLinkedList((Object[])new GenCommonBase[]{diagram});
            Iterable<GenLinkEnd> _allSemanticDiagramElements = this.getAllSemanticDiagramElements(diagram);
            Iterables.addAll((Collection)result, _allSemanticDiagramElements);
            return result;
        }
        Iterable<GenLinkEnd> _allSemanticDiagramElements_1 = this.getAllSemanticDiagramElements(diagram);
        return Iterables.filter(_allSemanticDiagramElements_1, GenCommonBase.class);
    }

    protected GenClass _getMetaClass(GenCommonBase some) {
        return null;
    }

    protected GenClass _getMetaClass(GenDiagram some) {
        return some.getDomainDiagramElement();
    }

    protected GenClass _getMetaClass(GenNode some) {
        GenClass _xifexpression = null;
        TypeModelFacet _modelFacet = some.getModelFacet();
        boolean _equals = Objects.equal((Object)_modelFacet, null);
        if (_equals) {
            _xifexpression = null;
        } else {
            GenClass _metaClass;
            TypeModelFacet _modelFacet_1 = some.getModelFacet();
            _xifexpression = _metaClass = _modelFacet_1.getMetaClass();
        }
        return _xifexpression;
    }

    protected GenClass _getMetaClass(GenLink some) {
        GenClass _xifexpression = null;
        LinkModelFacet _modelFacet = some.getModelFacet();
        boolean _equals = Objects.equal((Object)_modelFacet, null);
        if (_equals) {
            _xifexpression = null;
        } else {
            GenClass _metaClass;
            LinkModelFacet _modelFacet_1 = some.getModelFacet();
            _xifexpression = _metaClass = this.getMetaClass((EObject)_modelFacet_1);
        }
        return _xifexpression;
    }

    protected GenClass _getMetaClass(LinkModelFacet facet) {
        return null;
    }

    protected GenClass _getMetaClass(TypeLinkModelFacet facet) {
        return facet.getMetaClass();
    }

    public boolean hasSemanticChildren(GenContainerBase container) {
        boolean _not;
        boolean _and = false;
        boolean _isSansDomain = container.isSansDomain();
        boolean bl = _not = !_isSansDomain;
        if (!_not) {
            _and = false;
        } else {
            EList _containedNodes = container.getContainedNodes();
            boolean _notEmpty = this._common_qvto.notEmpty(_containedNodes);
            _and = _not && _notEmpty;
        }
        return _and;
    }

    protected GenClass _getModelElementType(GenContainerBase base) {
        return null;
    }

    protected GenClass _getModelElementType(GenDiagram diagram) {
        return diagram.getDomainDiagramElement();
    }

    protected GenClass _getModelElementType(GenCompartment compartment) {
        GenNode _node = compartment.getNode();
        return this.getModelElementType((GenContainerBase)_node);
    }

    protected GenClass _getModelElementType(GenNode node) {
        TypeModelFacet _modelFacet = node.getModelFacet();
        return _modelFacet.getMetaClass();
    }

    public Set<GenFeature> getSemanticChildrenChildFeatures(GenContainerBase containerBase) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet((Object[])new GenFeature[0]);
        Iterable<GenNode> _nonPhantomSemanticChildren = this.getNonPhantomSemanticChildren(containerBase);
        Functions.Function1<GenNode, GenFeature> _function = new Functions.Function1<GenNode, GenFeature>(){

            public GenFeature apply(GenNode node) {
                TypeModelFacet _modelFacet = node.getModelFacet();
                GenFeature _childMetaFeature = _modelFacet.getChildMetaFeature();
                return _childMetaFeature;
            }
        };
        Iterable _map = IterableExtensions.map(_nonPhantomSemanticChildren, (Functions.Function1)_function);
        Iterables.addAll((Collection)result, (Iterable)_map);
        return result;
    }

    public Set<GenFeature> getSemanticChildrenContainmentFeatures(GenContainerBase containerBase) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet((Object[])new GenFeature[0]);
        Iterable<GenNode> _nonPhantomSemanticChildren = this.getNonPhantomSemanticChildren(containerBase);
        Functions.Function1<GenNode, GenFeature> _function = new Functions.Function1<GenNode, GenFeature>(){

            public GenFeature apply(GenNode node) {
                TypeModelFacet _modelFacet = node.getModelFacet();
                GenFeature _containmentMetaFeature = _modelFacet.getContainmentMetaFeature();
                return _containmentMetaFeature;
            }
        };
        Iterable _map = IterableExtensions.map(_nonPhantomSemanticChildren, (Functions.Function1)_function);
        Iterables.addAll((Collection)result, (Iterable)_map);
        return result;
    }

    public Iterable<GenNode> getSemanticChildren(GenContainerBase containerBase, final GenFeature childMetaFeature) {
        Iterable<GenNode> _nonPhantomSemanticChildren = this.getNonPhantomSemanticChildren(containerBase);
        Functions.Function1<GenNode, Boolean> _function = new Functions.Function1<GenNode, Boolean>(){

            public Boolean apply(GenNode node) {
                TypeModelFacet _modelFacet = node.getModelFacet();
                GenFeature _childMetaFeature = _modelFacet.getChildMetaFeature();
                boolean _equals = Objects.equal((Object)_childMetaFeature, (Object)childMetaFeature);
                return _equals;
            }
        };
        return IterableExtensions.filter(_nonPhantomSemanticChildren, (Functions.Function1)_function);
    }

    public Iterable<GenNode> getNonPhantomSemanticChildren(GenContainerBase containerBase) {
        Iterable<GenNode> _semanticChildren = this.getSemanticChildren(containerBase);
        Functions.Function1<GenNode, Boolean> _function = new Functions.Function1<GenNode, Boolean>(){

            public Boolean apply(GenNode node) {
                TypeModelFacet _modelFacet = node.getModelFacet();
                boolean _isPhantomElement = _modelFacet.isPhantomElement();
                boolean _not = !_isPhantomElement;
                return _not;
            }
        };
        return IterableExtensions.filter(_semanticChildren, (Functions.Function1)_function);
    }

    protected Iterable<GenNode> _getPhantomNodes(GenContainerBase it) {
        return CollectionLiterals.newLinkedList((Object[])new GenNode[0]);
    }

    protected Iterable<GenNode> _getPhantomNodes(GenNode it) {
        Iterable<GenNode> _semanticChildren = this.getSemanticChildren((GenContainerBase)it);
        Functions.Function1<GenNode, Boolean> _function = new Functions.Function1<GenNode, Boolean>(){

            public Boolean apply(GenNode node) {
                TypeModelFacet _modelFacet = node.getModelFacet();
                boolean _isPhantomElement = _modelFacet.isPhantomElement();
                return _isPhantomElement;
            }
        };
        return IterableExtensions.filter(_semanticChildren, (Functions.Function1)_function);
    }

    public Iterable<GenNode> getSemanticChildren(GenContainerBase containerBase) {
        EList _containedNodes = containerBase.getContainedNodes();
        Functions.Function1<GenNode, Boolean> _function = new Functions.Function1<GenNode, Boolean>(){

            public Boolean apply(GenNode node) {
                TypeModelFacet _modelFacet = node.getModelFacet();
                boolean _notEquals = !Objects.equal((Object)_modelFacet, null);
                return _notEquals;
            }
        };
        return IterableExtensions.filter((Iterable)_containedNodes, (Functions.Function1)_function);
    }

    public boolean hasConformableSemanticChildren(GenContainerBase containerBase) {
        Set _set;
        int _size_1;
        Functions.Function1<GenNode, GenClass> _function;
        Iterable<GenNode> _semanticChildren = this.getSemanticChildren(containerBase);
        Iterable childMetaClasses = IterableExtensions.map(_semanticChildren, (Functions.Function1)(_function = new Functions.Function1<GenNode, GenClass>(){

            public GenClass apply(GenNode child) {
                TypeModelFacet _modelFacet = child.getModelFacet();
                GenClass _metaClass = _modelFacet.getMetaClass();
                return _metaClass;
            }
        }));
        int _size = IterableExtensions.size((Iterable)childMetaClasses);
        return _size != (_size_1 = (_set = IterableExtensions.toSet((Iterable)childMetaClasses)).size());
    }

    protected GenClass _getLinkEndType(LinkModelFacet facet, UpdaterLinkType type) {
        return null;
    }

    protected GenClass _getLinkEndType(FeatureLinkModelFacet facet, UpdaterLinkType type) {
        GenClass _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.INCOMING))) {
            GenClass _targetType;
            _matched = true;
            _switchResult = _targetType = facet.getTargetType();
        }
        if (!_matched && Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.OUTGOING))) {
            GenClass _sourceType;
            _matched = true;
            _switchResult = _sourceType = facet.getSourceType();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    protected GenClass _getLinkEndType(TypeLinkModelFacet facet, UpdaterLinkType type) {
        boolean _equals = Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.INCOMING));
        if (_equals) {
            return facet.getSourceType();
        }
        boolean _and = false;
        boolean _equals_1 = Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.OUTGOING));
        if (!_equals_1) {
            _and = false;
        } else {
            GenFeature _sourceMetaFeature = facet.getSourceMetaFeature();
            boolean _notEquals = !Objects.equal((Object)_sourceMetaFeature, null);
            boolean bl = _and = _equals_1 && _notEquals;
        }
        if (_and) {
            return facet.getSourceType();
        }
        GenFeature _containmentMetaFeature = facet.getContainmentMetaFeature();
        boolean _equals_2 = Objects.equal((Object)_containmentMetaFeature, null);
        if (_equals_2) {
            return null;
        }
        GenFeature _containmentMetaFeature_1 = facet.getContainmentMetaFeature();
        return _containmentMetaFeature_1.getGenClass();
    }

    public boolean isOutgoingLinkModelFacet(LinkModelFacet facet) {
        if (facet instanceof TypeLinkModelFacet) {
            return this._isOutgoingLinkModelFacet((TypeLinkModelFacet)facet);
        }
        if (facet != null) {
            return this._isOutgoingLinkModelFacet(facet);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(facet).toString());
    }

    public GenClass getMetaClass(EObject some) {
        if (some instanceof GenNode) {
            return this._getMetaClass((GenNode)some);
        }
        if (some instanceof GenDiagram) {
            return this._getMetaClass((GenDiagram)some);
        }
        if (some instanceof GenLink) {
            return this._getMetaClass((GenLink)some);
        }
        if (some instanceof TypeLinkModelFacet) {
            return this._getMetaClass((TypeLinkModelFacet)some);
        }
        if (some instanceof LinkModelFacet) {
            return this._getMetaClass((LinkModelFacet)some);
        }
        if (some instanceof GenCommonBase) {
            return this._getMetaClass((GenCommonBase)some);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(some).toString());
    }

    public GenClass getModelElementType(GenContainerBase compartment) {
        if (compartment instanceof GenCompartment) {
            return this._getModelElementType((GenCompartment)compartment);
        }
        if (compartment instanceof GenNode) {
            return this._getModelElementType((GenNode)compartment);
        }
        if (compartment instanceof GenDiagram) {
            return this._getModelElementType((GenDiagram)compartment);
        }
        if (compartment != null) {
            return this._getModelElementType(compartment);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(compartment).toString());
    }

    public Iterable<GenNode> getPhantomNodes(GenContainerBase it) {
        if (it instanceof GenNode) {
            return this._getPhantomNodes((GenNode)it);
        }
        if (it != null) {
            return this._getPhantomNodes(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public GenClass getLinkEndType(LinkModelFacet facet, UpdaterLinkType type) {
        if (facet instanceof FeatureLinkModelFacet) {
            return this._getLinkEndType((FeatureLinkModelFacet)facet, type);
        }
        if (facet instanceof TypeLinkModelFacet) {
            return this._getLinkEndType((TypeLinkModelFacet)facet, type);
        }
        if (facet != null) {
            return this._getLinkEndType(facet, type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{facet, type}).toString());
    }
}

