/**
 * Copyright (c) 2006, 2009, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package impl.diagram.editparts

import com.google.inject.Inject
import org.eclipse.gmf.codegen.gmfgen.GenDiagram
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel
import xpt.Common
import xpt.diagram.editparts.Utils_qvto
import xpt.diagram.editpolicies.TextSelectionEditPolicy

class NodeLabelEditPart {
	@Inject extension Common;
	@Inject extension Utils_qvto;

	@Inject xpt.diagram.editparts.Common xptEditpartsCommon;
	@Inject TextSelectionEditPolicy textSelection;
	
	def className(GenNodeLabel it) '''«editPartClassName»'''

	def packageName(GenNodeLabel it) '''«getDiagram().editPartsPackageName»'''

	def constructor(GenNodeLabel it) '''
		«generatedMemberComment»
		public «className(it)»(org.eclipse.gmf.runtime.notation.View view) {
			super(view);
		}
	'''

	def createDefaultEditPoliciesBody(GenNodeLabel it) '''
		super.createDefaultEditPolicies();
		installEditPolicy(org.eclipse.gef.EditPolicy.SELECTION_FEEDBACK_ROLE, new «
			textSelection.qualifiedClassName(getDiagram())»());
		installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());
		installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new «nodeLabelDragPolicyQualifiedClassName(it.diagram)»());
		«xptEditpartsCommon.behaviour(it)»
	'''

	def refreshBounds(GenNodeLabel it) '''
		«IF isStoringChildPositions(it.node)»
			«generatedMemberComment»
			protected void refreshBounds() {
				int width = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Width())).intValue();
				int height = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Height())).intValue();
				org.eclipse.draw2d.geometry.Dimension size = new org.eclipse.draw2d.geometry.Dimension(width, height);
				int x = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_X())).intValue();
				int y = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_Y())).intValue();
				org.eclipse.draw2d.geometry.Point loc = new org.eclipse.draw2d.geometry.Point(x, y);
				((org.eclipse.gef.GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), new org.eclipse.draw2d.geometry.Rectangle(loc, size));
			}
		«ENDIF»
	'''

	def handleNotificationEventBody(GenNodeLabel it) '''
		Object feature = event.getFeature();
		«IF isStoringChildPositions(node)»
			«xptEditpartsCommon.handleBounds(it)»
		«ENDIF»
		«xptEditpartsCommon.handleText(it)»
		super.handleNotificationEvent(event);
	'''

	/**
 * since 3.1, old generated NodeLabelDragPolicy extracted to GMFT-runtime, 
 * see org.eclipse.gmf.tooling.runtime.edit.policies.DefaultNodeLabelDragPolicy.
 * The next 2 DEFINE's are left here as a hook for possible AROUND's
 */
	def nodeLabelDragPolicyQualifiedClassName(GenDiagram it) '''org.eclipse.gmf.tooling.runtime.edit.policies.DefaultNodeLabelDragPolicy'''

	def nodeLabelDragPolicyClass(GenDiagram it) '''«/*not generated by default anymore*/»'''
}
