/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

public class Conversions {
    private Conversions() {
    }

    public static String escapeXML(String text) {
        if (text == null) {
            text = "";
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == '<') {
                result.append("&lt;");
            } else if (ch == '>') {
                result.append("&gt;");
            } else if (ch == '&') {
                result.append("&amp;");
            } else if (ch == '\'') {
                result.append("&apos;");
            } else if (ch == '\"') {
                result.append("&quot;");
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String toStringLiteral(String strValue) {
        if (strValue == null) {
            return "null";
        }
        int len = strValue.length();
        StringBuffer result = new StringBuffer(len + 16);
        result.append('\"');
        int i = 0;
        while (i < len) {
            result.append(Conversions.escapeChar(strValue.charAt(i)));
            ++i;
        }
        result.append('\"');
        return result.toString();
    }

    private static String escapeChar(char c) {
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c >= ' ' && c < '\u007f') {
            return String.valueOf(c);
        }
        String num = Integer.toHexString(c);
        switch (num.length()) {
            case 1: {
                return "\\u000" + num;
            }
            case 2: {
                return "\\u00" + num;
            }
            case 3: {
                return "\\u0" + num;
            }
        }
        return "\\u" + num;
    }

    public static String escapeUnicode(String text) {
        StringBuffer result = new StringBuffer(text.length());
        int i = 0;
        int size = text.length();
        while (i < size) {
            char character = text.charAt(i);
            if (character > '\u00ff') {
                result.append("\\u");
                String hex = Integer.toString(character, 16);
                int j = hex.length();
                while (j < 4) {
                    result.append("0");
                    ++j;
                }
                result.append(hex);
            } else {
                result.append(character);
            }
            ++i;
        }
        return result.toString();
    }
}

