/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.part;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.GMFToolingRuntimePlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultElementChooserDialog
extends Dialog {
    private final Context myContext;
    private TreeViewer myTreeViewer;
    private List<URI> mySelectedModelElementURIs;
    private View myView;
    private TransactionalEditingDomain myEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();

    public DefaultElementChooserDialog(Shell parentShell, View view, Context context) {
        super(parentShell);
        this.myContext = context;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.myView = view;
    }

    public URI getSelectedModelElementURI() {
        return this.getSelectedModelElementURIs().size() > 0 ? this.getSelectedModelElementURIs().get(0) : null;
    }

    public List<URI> getSelectedModelElementURIs() {
        if (this.mySelectedModelElementURIs == null) {
            this.mySelectedModelElementURIs = new LinkedList<URI>();
        }
        return this.mySelectedModelElementURIs;
    }

    public int open() {
        int result = super.open();
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        this.myEditingDomain.dispose();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.myContext.getDialogTitle());
        this.createModelBrowser(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.setOkButtonEnabled(false);
        return buttonBar;
    }

    private void createModelBrowser(Composite composite) {
        this.myTreeViewer = new TreeViewer(composite, this.myContext.allowMultiSelection() ? 2 : 2820);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.myTreeViewer.getTree().setLayoutData((Object)layoutData);
        this.myTreeViewer.setContentProvider((IContentProvider)new ModelElementsTreeContentProvider(this.myContext.getTreeContentProvider(), this.myContext.getAdapterFactory()));
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementsTreeLabelProvider(this.myContext.getAdapterFactory()));
        this.myTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.myTreeViewer.addFilter((ViewerFilter)new ModelFilesFilter());
        this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new OkButtonEnabler(this.myContext.getPreferenceHint()));
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    private boolean isValidModelFile(IFile file) {
        String fileExtension = file.getFullPath().getFileExtension();
        int i = 0;
        while (i < this.myContext.getFileExtesions().length) {
            String currentExtension = this.myContext.getFileExtesions()[i];
            if (currentExtension != null && currentExtension.equals(fileExtension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static interface Context {
        public AdapterFactory getAdapterFactory();

        public PreferencesHint getPreferenceHint();

        public String[] getFileExtesions();

        public String getDialogTitle();

        public ITreeContentProvider getTreeContentProvider();

        public boolean allowMultiSelection();
    }

    private class ModelElementsTreeContentProvider
    implements ITreeContentProvider {
        private final ITreeContentProvider myWorkbenchContentProvider;
        private final AdapterFactoryContentProvider myAdapterFactoryContentProvier;

        private ModelElementsTreeContentProvider(ITreeContentProvider iTreeContentProvider, AdapterFactory adapterFactory) {
            this.myWorkbenchContentProvider = iTreeContentProvider;
            this.myAdapterFactoryContentProvier = new AdapterFactoryContentProvider(adapterFactory);
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = this.myWorkbenchContentProvider.getChildren(parentElement);
            if (result != null && result.length > 0) {
                return result;
            }
            if (parentElement instanceof IFile) {
                IFile modelFile = (IFile)parentElement;
                IPath resourcePath = modelFile.getFullPath();
                ResourceSet resourceSet = DefaultElementChooserDialog.this.myEditingDomain.getResourceSet();
                try {
                    Resource modelResource = resourceSet.getResource(URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true), true);
                    return this.myAdapterFactoryContentProvier.getChildren((Object)modelResource);
                }
                catch (WrappedException e) {
                    GMFToolingRuntimePlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.gmf.tooling.runtime", "Unable to load resource: " + resourcePath.toString(), (Throwable)e));
                    return Collections.EMPTY_LIST.toArray();
                }
            }
            return this.myAdapterFactoryContentProvier.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            Object parent = this.myWorkbenchContentProvider.getParent(element);
            if (parent != null) {
                return parent;
            }
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                if (eObject.eContainer() == null && eObject.eResource().getURI().isFile()) {
                    String path = eObject.eResource().getURI().path();
                    return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
                }
                return this.myAdapterFactoryContentProvier.getParent((Object)eObject);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return DefaultElementChooserDialog.this.isValidModelFile((IFile)element);
            }
            return this.myWorkbenchContentProvider.hasChildren(element) || this.myAdapterFactoryContentProvier.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.myWorkbenchContentProvider.getElements(inputElement);
            return elements;
        }

        public void dispose() {
            this.myWorkbenchContentProvider.dispose();
            this.myAdapterFactoryContentProvier.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myWorkbenchContentProvider.inputChanged(viewer, oldInput, newInput);
            this.myAdapterFactoryContentProvier.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class ModelElementsTreeLabelProvider
    implements ILabelProvider {
        private final WorkbenchLabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();
        private final AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;

        private ModelElementsTreeLabelProvider(AdapterFactory adapterFactory) {
            this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        }

        public Image getImage(Object element) {
            Image result = this.myWorkbenchLabelProvider.getImage(element);
            return result != null ? result : this.myAdapterFactoryLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            String result = this.myWorkbenchLabelProvider.getText(element);
            return result != null && result.length() > 0 ? result : this.myAdapterFactoryLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.addListener(listener);
            this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myWorkbenchLabelProvider.dispose();
            this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWorkbenchLabelProvider.isLabelProperty(element, property) || this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.removeListener(listener);
            this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private class ModelFilesFilter
    extends ViewerFilter {
        private ModelFilesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                return true;
            }
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return DefaultElementChooserDialog.this.isValidModelFile(file);
            }
            return true;
        }
    }

    private class OkButtonEnabler
    implements ISelectionChangedListener {
        private final PreferencesHint myPreferenceHint;

        private OkButtonEnabler(PreferencesHint preferenceHint) {
            this.myPreferenceHint = preferenceHint;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                DefaultElementChooserDialog.this.getSelectedModelElementURIs().clear();
                boolean isAllOk = true;
                for (Object selectedElement : selection.toList()) {
                    URI elementURI = this.getElementURI(selectedElement);
                    if (elementURI != null) {
                        DefaultElementChooserDialog.this.getSelectedModelElementURIs().add(elementURI);
                        continue;
                    }
                    DefaultElementChooserDialog.this.getSelectedModelElementURIs().clear();
                    isAllOk = false;
                    break;
                }
                DefaultElementChooserDialog.this.setOkButtonEnabled(isAllOk);
            }
        }

        private URI getElementURI(Object selectedElement) {
            URI result = null;
            if (selectedElement instanceof IWrapperItemProvider) {
                selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
            }
            if (selectedElement instanceof FeatureMap.Entry) {
                selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
            }
            if (selectedElement instanceof EObject) {
                EObject selectedModelElement = (EObject)selectedElement;
                if (ViewService.getInstance().provides(Node.class, (IAdaptable)new EObjectAdapter(selectedModelElement), DefaultElementChooserDialog.this.myView, null, -1, true, this.myPreferenceHint)) {
                    result = EcoreUtil.getURI((EObject)selectedModelElement);
                }
            }
            return result;
        }
    }
}

