/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.part;

import java.util.Collections;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.services.IEvaluationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastClickPositionProvider
extends AbstractSourceProvider {
    public static String SOURCE_LAST_CLICK = String.valueOf(LastClickPositionProvider.class.getName()) + ".lastClickPosition";
    private MouseListener myMouseListener;
    private IFigure myDiagramFigure;
    private DiagramEditor myDiagramEditor;
    private IEvaluationService myEvaluationService;
    private Point myLastClickedAt = new Point(0, 0);

    public LastClickPositionProvider(DiagramEditor diagramEditor) {
        this.myDiagramEditor = diagramEditor;
        EditPart diagramEditPart = this.myDiagramEditor.getDiagramGraphicalViewer().getContents();
        if (diagramEditPart instanceof DiagramEditPart) {
            this.myDiagramFigure = ((DiagramEditPart)diagramEditPart).getFigure();
            this.myMouseListener = new DiagramMouseListner();
            this.myDiagramFigure.addMouseListener(this.myMouseListener);
        }
    }

    public void attachToService() {
        if (this.myEvaluationService == null) {
            this.myEvaluationService = (IEvaluationService)this.myDiagramEditor.getSite().getService(IEvaluationService.class);
            if (this.myEvaluationService != null) {
                this.myEvaluationService.addSourceProvider((ISourceProvider)this);
            }
        }
    }

    public void detachFromService() {
        if (this.myEvaluationService != null) {
            this.myEvaluationService.removeSourceProvider((ISourceProvider)this);
            this.myEvaluationService = null;
        }
    }

    public void fireLastClickedAt(int x, int y) {
        this.myLastClickedAt = new Point(x, y);
        this.fireSourceChanged(0, SOURCE_LAST_CLICK, this.myLastClickedAt);
    }

    public void dispose() {
        if (this.myMouseListener != null) {
            this.myDiagramFigure.removeMouseListener(this.myMouseListener);
            this.myDiagramFigure = null;
        }
        if (this.myMouseListener != null) {
            this.myMouseListener = null;
        }
    }

    public Map<?, ?> getCurrentState() {
        return Collections.singletonMap(SOURCE_LAST_CLICK, this.myLastClickedAt);
    }

    public String[] getProvidedSourceNames() {
        return new String[]{SOURCE_LAST_CLICK};
    }

    private class DiagramMouseListner
    implements MouseListener {
        private DiagramMouseListner() {
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (me.button == 3) {
                LastClickPositionProvider.this.myLastClickedAt.setX(me.x);
                LastClickPositionProvider.this.myLastClickedAt.setY(me.y);
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }
}

