/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;
import org.eclipse.gmf.graphdef.editor.edit.policies.GridFigure;
import org.eclipse.gmf.graphdef.editor.edit.policies.GridLayoutHelper;
import org.eclipse.gmf.graphdef.editor.edit.policies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.swt.graphics.Color;

public class GridLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    private static final Color FEEDBACK_COLOR = ColorConstants.lightBlue;
    private static final Color GRID_COLOR = ColorConstants.lightGreen;
    private static final Color INNER_FIGURES_COLOR = ColorConstants.red;
    private RoundedRectangle myFeedbackFigure;
    private GridLayoutHelper myFeedbackBoundsHelper;
    private GridFigure myGridFigure;

    protected void showLayoutTargetFeedback(Request request) {
        if ("move".equals(request.getType())) {
            Rectangle feedbackBounds;
            DropRequest dropRequest = (DropRequest)request;
            IFigure figure = this.getLayoutContainer();
            Point where = dropRequest.getLocation().getCopy();
            figure.translateToRelative((Translatable)where);
            figure.translateFromParent((Translatable)where);
            where.translate(this.getLayoutOrigin().getNegated());
            if (this.myFeedbackBoundsHelper == null) {
                this.myFeedbackBoundsHelper = new GridLayoutHelper(this.getAbstractFigureEditPart());
            }
            if (this.myGridFigure == null) {
                this.myGridFigure = new GridFigure(this.myFeedbackBoundsHelper.getGrid(), this.myFeedbackBoundsHelper.getHeights(), this.myFeedbackBoundsHelper.getWidths(), this.myFeedbackBoundsHelper.getGridLayout());
                Rectangle bounds = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)bounds);
                this.getFeedbackLayer().translateToRelative((Translatable)bounds);
                this.myGridFigure.setBounds(bounds);
                this.myGridFigure.setForegroundColor(GRID_COLOR);
                this.myGridFigure.setInnerFigureBoundsColor(INNER_FIGURES_COLOR);
                this.myGridFigure.setLineWidth(2);
                this.getFeedbackLayer().add((IFigure)this.myGridFigure);
            }
            IFigure childFigure = null;
            if (dropRequest instanceof GroupRequest) {
                List editParts = ((GroupRequest)dropRequest).getEditParts();
                assert (editParts.size() == 1);
                childFigure = ((AbstractFigureEditPart)((Object)editParts.get(0))).getFigure();
            }
            if ((feedbackBounds = this.myFeedbackBoundsHelper.getFeedbackBounds(where, childFigure)) == null) {
                this.eraseTargetFeedback(request);
                return;
            }
            figure.translateToParent((Translatable)feedbackBounds);
            figure.translateToAbsolute((Translatable)feedbackBounds);
            this.getFeedbackLayer().translateToRelative((Translatable)feedbackBounds);
            if (this.myFeedbackFigure == null) {
                this.myFeedbackFigure = new RoundedRectangle();
                this.myFeedbackFigure.setFill(false);
                this.myFeedbackFigure.setOutline(true);
                this.myFeedbackFigure.setForegroundColor(FEEDBACK_COLOR);
                this.myFeedbackFigure.setLineWidth(1);
                this.myFeedbackFigure.setAntialias(1);
                this.myFeedbackFigure.setBounds(feedbackBounds);
                this.getFeedbackLayer().add((IFigure)this.myFeedbackFigure);
            } else {
                this.myFeedbackFigure.setBounds(feedbackBounds);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("move".equals(request.getType()) || "drop".equals(request.getType())) {
            if (this.myFeedbackFigure != null) {
                this.getFeedbackLayer().remove((IFigure)this.myFeedbackFigure);
                this.myFeedbackFigure = null;
            }
            if (this.myGridFigure != null) {
                this.getFeedbackLayer().remove((IFigure)this.myGridFigure);
                this.myGridFigure = null;
            }
            this.myFeedbackBoundsHelper = null;
        } else {
            super.eraseTargetFeedback(request);
        }
    }

    protected Command getMoveChildrenCommand(Request request) {
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        IFigure figure = this.getLayoutContainer();
        Point where = changeBoundsRequest.getLocation().getCopy();
        figure.translateToRelative((Translatable)where);
        figure.translateFromParent((Translatable)where);
        where.translate(this.getLayoutOrigin().getNegated());
        if (changeBoundsRequest.getEditParts().size() != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        final AbstractFigureEditPart childEditPart = (AbstractFigureEditPart)((Object)changeBoundsRequest.getEditParts().get(0));
        final int newChildPosition = new GridLayoutHelper(this.getAbstractFigureEditPart()).getNewChildPosition(where);
        return newChildPosition == -1 ? UnexecutableCommand.INSTANCE : new ICommandProxy((ICommand)new AbstractTransactionalCommand(childEditPart.getEditingDomain(), "Moving child figure", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)this.getRealFigure().eResource()))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                GridLayoutEditPolicy.this.getRealFigure().getChildren().move(newChildPosition, (Object)childEditPart.getRealFigure());
                GridLayoutEditPolicy.this.getAbstractFigureEditPart().getNotationView().persistChildren();
                GridLayoutEditPolicy.this.getAbstractFigureEditPart().getNotationView().getPersistedChildren().move(newChildPosition, (Object)childEditPart.getNotationView());
                return CommandResult.newOKCommandResult();
            }
        });
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Object getConstraintFor(Point point) {
        return null;
    }

    protected Object getConstraintFor(Rectangle rect) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new ResizableEditPolicy();
    }

    private AbstractFigureEditPart getAbstractFigureEditPart() {
        return (AbstractFigureEditPart)this.getHost();
    }

    private RealFigure getRealFigure() {
        return ((AbstractFigureEditPart)this.getHost()).getRealFigure();
    }
}

