/*
 * Decompiled with CFR 0.152.
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ConnectionFigure;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DecorationFigure;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureRef;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Polyline;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.gmfgraph.SVGProperty;
import org.eclipse.gmf.gmfgraph.SVGPropertyType;
import org.eclipse.gmf.gmfgraph.Shape;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common_qvto;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private Common_qvto _common_qvto;

    public String compilationUnitName(FigureDescriptor figure) {
        String _name = figure.getName();
        return StringExtensions.toFirstUpper((String)_name);
    }

    public boolean hasSourceDecoration(PolylineConnection figure) {
        DecorationFigure _sourceDecoration = figure.getSourceDecoration();
        return !Objects.equal(null, (Object)_sourceDecoration);
    }

    public Iterable<String> requiredBundles(Iterable<String> referencedBundles) {
        LinkedList result = CollectionLiterals.newLinkedList((Object[])new String[]{"org.eclipse.core.runtime", "org.eclipse.draw2d"});
        boolean _isFullRuntime = this.isFullRuntime();
        if (_isFullRuntime) {
            result.add("org.eclipse.gmf.runtime.draw2d.ui");
        }
        Iterables.addAll((Collection)result, referencedBundles);
        return IterableExtensions.sort((Iterable)result);
    }

    public boolean isFullRuntime() {
        return true;
    }

    public boolean hasTargetDecoration(PolylineConnection figure) {
        DecorationFigure _targetDecoration = figure.getTargetDecoration();
        return !Objects.equal(null, (Object)_targetDecoration);
    }

    public boolean needsField(final RealFigure figure) {
        boolean _notEquals;
        boolean _and = false;
        FigureDescriptor _descriptor = figure.getDescriptor();
        boolean bl = _notEquals = !Objects.equal((Object)_descriptor, null);
        if (!_notEquals) {
            _and = false;
        } else {
            FigureDescriptor _descriptor_1 = figure.getDescriptor();
            EList _accessors = _descriptor_1.getAccessors();
            Functions.Function1<ChildAccess, Boolean> _function = new Functions.Function1<ChildAccess, Boolean>(){

                public Boolean apply(ChildAccess a) {
                    Figure _figure = a.getFigure();
                    boolean _equals = Objects.equal((Object)_figure, (Object)figure);
                    return _equals;
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)_accessors, (Functions.Function1)_function);
            _and = _notEquals && _exists;
        }
        return _and;
    }

    public String figureVariableName(RealFigure figure, int count) {
        boolean _needsField = this.needsField(figure);
        if (_needsField) {
            return this.figureFieldName(figure);
        }
        String _xifexpression = null;
        String _name = figure.getName();
        boolean _nullOrSpaces = this._common_qvto.nullOrSpaces(_name);
        if (_nullOrSpaces) {
            String _variableNameStem;
            _xifexpression = _variableNameStem = this.variableNameStem((Figure)figure);
        } else {
            String _firstLower;
            String _name_1 = figure.getName();
            _xifexpression = _firstLower = StringExtensions.toFirstLower((String)_name_1);
        }
        String base = _xifexpression;
        return String.valueOf(base) + Integer.valueOf(count);
    }

    protected String _nameStem(FigureRef xptSelf) {
        RealFigure _figure = xptSelf.getFigure();
        return this.variableNameStem((Figure)_figure);
    }

    protected String _nameStem(Figure xptSelf) {
        return this.variableNameStem(xptSelf);
    }

    protected String _variableNameStem(Figure xptSelf) {
        return "fig";
    }

    protected String _variableNameStem(RealFigure xptSelf) {
        return "fig";
    }

    protected String _variableNameStem(Shape xptSelf) {
        return "shape";
    }

    protected String _variableNameStem(Rectangle xptSelf) {
        return "rect";
    }

    protected String _variableNameStem(RoundedRectangle xptSelf) {
        return "rrect";
    }

    protected String _variableNameStem(Ellipse xptSelf) {
        return "elli";
    }

    protected String _variableNameStem(Polyline xptSelf) {
        return "polyline";
    }

    protected String _variableNameStem(Label xptSelf) {
        return "l";
    }

    protected String _variableNameStem(DecorationFigure xptSelf) {
        return "dec";
    }

    protected String _variableNameStem(ConnectionFigure xptSelf) {
        return "conn";
    }

    public String figureFieldName(final RealFigure xptSelf) {
        FigureDescriptor _descriptor = xptSelf.getDescriptor();
        EList _accessors = _descriptor.getAccessors();
        Functions.Function1<ChildAccess, Boolean> _function = new Functions.Function1<ChildAccess, Boolean>(){

            public Boolean apply(ChildAccess a) {
                Figure _figure = a.getFigure();
                boolean _equals = Objects.equal((Object)xptSelf, (Object)_figure);
                return _equals;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_accessors, (Functions.Function1)_function);
        return this.figureFieldName(_filter);
    }

    public String figureFieldName(ChildAccess xptSelf) {
        String _accessor = xptSelf.getAccessor();
        String _trimPrefixIfAny = this.trimPrefixIfAny(_accessor, "get");
        return "f" + _trimPrefixIfAny;
    }

    public String figureFieldName(Iterable<ChildAccess> accesses) {
        Functions.Function1<ChildAccess, String> _function = new Functions.Function1<ChildAccess, String>(){

            public String apply(ChildAccess x) {
                String _figureFieldName = Utils_qvto.this.figureFieldName(x);
                return _figureFieldName;
            }
        };
        Iterable _map = IterableExtensions.map(accesses, (Functions.Function1)_function);
        return (String)IterableExtensions.head((Iterable)_map);
    }

    public String borderLayoutConstant(BorderLayoutData layoutData) {
        Alignment _alignment;
        String _switchResult = null;
        Alignment _switchValue = _alignment = layoutData.getAlignment();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_switchValue, (Object)Alignment.BEGINNING_LITERAL)) {
            _matched = true;
            String _xifexpression = null;
            boolean _isVertical = layoutData.isVertical();
            _xifexpression = _isVertical ? "TOP" : "LEFT";
            _switchResult = _xifexpression;
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)Alignment.END_LITERAL)) {
            _matched = true;
            String _xifexpression_1 = null;
            boolean _isVertical_1 = layoutData.isVertical();
            _xifexpression_1 = _isVertical_1 ? "BOTTOM" : "RIGHT";
            _switchResult = _xifexpression_1;
        }
        if (!_matched) {
            _switchResult = "CENTER";
        }
        return _switchResult;
    }

    public Iterable<FigureAccessor> allCustomAccessors(FigureDescriptor fd) {
        Figure _actualFigure = fd.getActualFigure();
        LinkedList _newLinkedList = CollectionLiterals.newLinkedList((Object[])new Figure[]{_actualFigure});
        Iterable<CustomFigure> _filterCustom = this.filterCustom(_newLinkedList);
        Functions.Function1<CustomFigure, EList<FigureAccessor>> _function = new Functions.Function1<CustomFigure, EList<FigureAccessor>>(){

            public EList<FigureAccessor> apply(CustomFigure cf) {
                EList _customChildren = cf.getCustomChildren();
                return _customChildren;
            }
        };
        Iterable _map = IterableExtensions.map(_filterCustom, (Functions.Function1)_function);
        return Iterables.concat((Iterable)_map);
    }

    public Iterable<CustomFigure> filterCustom(Iterable<Figure> figures) {
        LinkedList result = CollectionLiterals.newLinkedList((Object[])new CustomFigure[0]);
        this.deepCollectCustom(figures, result);
        return result;
    }

    protected void deepCollectCustom(Iterable<Figure> figures, List<CustomFigure> acc) {
        boolean _isEmpty = IterableExtensions.isEmpty(figures);
        if (_isEmpty) {
            return;
        }
        Iterable _filter = Iterables.filter(figures, CustomFigure.class);
        Iterables.addAll(acc, (Iterable)_filter);
        Iterable _filter_1 = Iterables.filter(figures, RealFigure.class);
        Functions.Function1<RealFigure, EList<Figure>> _function = new Functions.Function1<RealFigure, EList<Figure>>(){

            public EList<Figure> apply(RealFigure rf) {
                EList _children = rf.getChildren();
                return _children;
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        this.deepCollectCustom(_flatten, acc);
    }

    public String svgPropertyType(SVGProperty p) {
        SVGPropertyType _type;
        String _switchResult = null;
        SVGPropertyType _switchValue = _type = p.getType();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_switchValue, (Object)SVGPropertyType.COLOR)) {
            _matched = true;
            _switchResult = "org.eclipse.swt.graphics.Color";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)SVGPropertyType.FLOAT)) {
            _matched = true;
            _switchResult = "float";
        }
        if (!_matched) {
            _switchResult = "String";
        }
        return _switchResult;
    }

    @MetaDef
    public String fontVariableName(BasicFont it, String figureVarName) {
        String _upperCase = figureVarName.toUpperCase();
        String _plus = String.valueOf(_upperCase) + "_FONT";
        return _plus;
    }

    @MetaDef
    public String backgroundColorVariableName(Color it, String figureVarName) {
        String _upperCase = figureVarName.toUpperCase();
        String _plus = String.valueOf(_upperCase) + "_BACK";
        return _plus;
    }

    @MetaDef
    public String foregroundColorVariableName(Color it, String figureVarName) {
        String _upperCase = figureVarName.toUpperCase();
        String _plus = String.valueOf(_upperCase) + "_FORE";
        return _plus;
    }

    protected String trimPrefixIfAny(String text, String prefix) {
        String _xifexpression = null;
        boolean _and = false;
        boolean _startsWith = text.startsWith(prefix);
        if (!_startsWith) {
            _and = false;
        } else {
            int _length_1;
            int _length = text.length();
            boolean _greaterThan = _length > (_length_1 = prefix.length());
            boolean bl = _and = _startsWith && _greaterThan;
        }
        if (_and) {
            String _substring;
            int _length_2 = prefix.length();
            _xifexpression = _substring = text.substring(_length_2);
        } else {
            _xifexpression = text;
        }
        return _xifexpression;
    }

    public String nameStem(Figure xptSelf) {
        if (xptSelf instanceof FigureRef) {
            return this._nameStem((FigureRef)xptSelf);
        }
        if (xptSelf != null) {
            return this._nameStem(xptSelf);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(xptSelf).toString());
    }

    public String variableNameStem(Figure xptSelf) {
        if (xptSelf instanceof Ellipse) {
            return this._variableNameStem((Ellipse)xptSelf);
        }
        if (xptSelf instanceof Polyline) {
            return this._variableNameStem((Polyline)xptSelf);
        }
        if (xptSelf instanceof Rectangle) {
            return this._variableNameStem((Rectangle)xptSelf);
        }
        if (xptSelf instanceof RoundedRectangle) {
            return this._variableNameStem((RoundedRectangle)xptSelf);
        }
        if (xptSelf instanceof ConnectionFigure) {
            return this._variableNameStem((ConnectionFigure)xptSelf);
        }
        if (xptSelf instanceof DecorationFigure) {
            return this._variableNameStem((DecorationFigure)xptSelf);
        }
        if (xptSelf instanceof Label) {
            return this._variableNameStem((Label)xptSelf);
        }
        if (xptSelf instanceof Shape) {
            return this._variableNameStem((Shape)xptSelf);
        }
        if (xptSelf instanceof RealFigure) {
            return this._variableNameStem((RealFigure)xptSelf);
        }
        if (xptSelf != null) {
            return this._variableNameStem(xptSelf);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(xptSelf).toString());
    }
}

