/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;
import xpt.diagram.updater.Utils_qvto;
import xpt.expressions.getExpression;

@Singleton
public class VisualIDRegistry {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    @Extension
    private LinkUtils_qvto _linkUtils_qvto;
    @Inject
    private Activator xptActivator;
    @Inject
    private CodeStyle xptCodeStyle;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private getExpression xptGetExpression;

    @MetaDef
    public CharSequence getVisualIdMethodName(GenDiagram xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"getVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence getModelIDMethodName(GenDiagram xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"getModelID");
        return _builder;
    }

    @MetaDef
    public CharSequence getVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
        _builder.append((Object)_visualIdMethodName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getModelIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
        _builder.append((Object)_modelIDMethodName, "");
        return _builder;
    }

    @MetaDef
    public static CharSequence visualID(GenCommonBase xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        String _editPartQualifiedClassName = xptSelf.getEditPartQualifiedClassName();
        _builder.append((Object)_editPartQualifiedClassName, "");
        _builder.append((Object)".VISUAL_ID");
        return _builder;
    }

    @MetaDef
    public static CharSequence modelID(GenDiagram xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        String _editPartQualifiedClassName = xptSelf.getEditPartQualifiedClassName();
        _builder.append((Object)_editPartQualifiedClassName, "");
        _builder.append((Object)".MODEL_ID");
        return _builder;
    }

    @MetaDef
    public CharSequence typeMethodCall(GenCommonBase xptSelf, CharSequence visualIdVar) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagram _diagram = xptSelf.getDiagram();
        String _visualIDRegistryQualifiedClassName = _diagram.getVisualIDRegistryQualifiedClassName();
        _builder.append((Object)_visualIDRegistryQualifiedClassName, "");
        _builder.append((Object)".");
        GenDiagram _diagram_1 = xptSelf.getDiagram();
        CharSequence _typeMethodName = this.getTypeMethodName(_diagram_1);
        _builder.append((Object)_typeMethodName, "");
        _builder.append((Object)"(");
        _builder.append((Object)visualIdVar, "");
        _builder.append((Object)")");
        return _builder;
    }

    @MetaDef
    public CharSequence typeMethodCall(GenCommonBase xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _visualID = VisualIDRegistry.visualID(xptSelf);
        String _string = _visualID.toString();
        CharSequence _typeMethodCall = this.typeMethodCall(xptSelf, _string);
        _builder.append((Object)_typeMethodCall, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getTypeMethodName(GenDiagram xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"getType");
        return _builder;
    }

    @MetaDef
    public CharSequence runtimeTypedInstanceName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"TYPED_INSTANCE");
        return _builder;
    }

    @MetaDef
    public CharSequence runtimeTypedInstanceCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
        _builder.append((Object)_runtimeTypedInstanceName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getDiagramVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"getDiagramVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence getDiagramVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _diagramVisualIDMethodName = this.getDiagramVisualIDMethodName(it);
        _builder.append((Object)_diagramVisualIDMethodName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getNodeVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"getNodeVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence getNodeVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
        _builder.append((Object)_nodeVisualIDMethodName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence canCreateNodeMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"canCreateNode");
        return _builder;
    }

    @MetaDef
    public CharSequence canCreateNodeMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _canCreateNodeMethodName = this.canCreateNodeMethodName(it);
        _builder.append((Object)_canCreateNodeMethodName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getLinkWithClassVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _linkWithClassVisualIDMethodName = this.getLinkWithClassVisualIDMethodName(it);
        _builder.append((Object)_linkWithClassVisualIDMethodName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getLinkWithClassVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"getLinkWithClassVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence domainElementConstraintMethodName(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"is");
        String _uniqueIdentifier = it.getUniqueIdentifier();
        _builder.append((Object)_uniqueIdentifier, "");
        return _builder;
    }

    @MetaDef
    public CharSequence checkNodeVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"checkNodeVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence checkNodeVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
        _builder.append((Object)_checkNodeVisualIDMethodName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence isCompartmentVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"isCompartmentVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence isCompartmentVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
        _builder.append((Object)_isCompartmentVisualIDMethodName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence isSemanticLeafVisualIDMethodName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"isSemanticLeafVisualID");
        return _builder;
    }

    @MetaDef
    public CharSequence isSemanticLeafVisualIDMethodCall(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
        _builder.append((Object)_isSemanticLeafVisualIDMethodName, "");
        return _builder;
    }

    protected Iterable<GenCommonBase> _getEssentialVisualChildren(GenCommonBase it) {
        return CollectionLiterals.newLinkedList((Object[])new GenCommonBase[0]);
    }

    protected Iterable<GenCommonBase> _getEssentialVisualChildren(GenLink it) {
        EList _labels = it.getLabels();
        return Iterables.filter((Iterable)_labels, GenCommonBase.class);
    }

    protected Iterable<GenCommonBase> _getEssentialVisualChildren(GenContainerBase it) {
        EList _containedNodes = it.getContainedNodes();
        return Iterables.filter((Iterable)_containedNodes, GenCommonBase.class);
    }

    protected Iterable<GenCommonBase> _getEssentialVisualChildren(GenNode it) {
        LinkedList result = CollectionLiterals.newLinkedList((Object[])new GenCommonBase[0]);
        EList _labels = it.getLabels();
        result.addAll(_labels);
        EList _compartments = it.getCompartments();
        result.addAll(_compartments);
        EList _containedNodes = it.getContainedNodes();
        result.addAll(_containedNodes);
        return result;
    }

    public Iterable<GenNode> getContainedSemanticNodes(GenContainerBase container) {
        EList _containedNodes = container.getContainedNodes();
        Functions.Function1<GenNode, Boolean> _function = new Functions.Function1<GenNode, Boolean>(){

            public Boolean apply(GenNode node) {
                TypeModelFacet _modelFacet = node.getModelFacet();
                boolean _notEquals = !Objects.equal(null, (Object)_modelFacet);
                return _notEquals;
            }
        };
        return IterableExtensions.filter((Iterable)_containedNodes, (Functions.Function1)_function);
    }

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _visualIDRegistryClassName = it.getVisualIDRegistryClassName();
        _builder.append((Object)_visualIDRegistryClassName, "");
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenEditorView _editor = _editorGen.getEditor();
        String _packageName = _editor.getPackageName();
        _builder.append((Object)_packageName, "");
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    public CharSequence VisualIDRegistry(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagram _diagram = it.getDiagram();
        GenEditorGenerator _editorGen = _diagram.getEditorGen();
        CharSequence _copyright = this._common.copyright(_editorGen);
        _builder.append((Object)_copyright, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _plus = "This registry is used to determine which type of visual object should be\ncreated for the corresponding Diagram, Node, ChildNode or Link represented\n";
        String _plus_1 = String.valueOf(_plus) + "by a domain model object.\n";
        CharSequence _generatedClassComment = this._common.generatedClassComment(_plus_1);
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _attributes = this.attributes(it);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _viewVisualID = this.getViewVisualID(it);
        _builder.append((Object)_viewVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _modelID = this.getModelID(it);
        _builder.append((Object)_modelID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _visualID = this.getVisualID(it);
        _builder.append((Object)_visualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _type = this.getType(it);
        _builder.append((Object)_type, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _diagramVisualID = this.getDiagramVisualID(it);
        _builder.append((Object)_diagramVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _nodeVisualID = this.getNodeVisualID(it);
        _builder.append((Object)_nodeVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _canCreateNode = this.canCreateNode(it);
        _builder.append((Object)_canCreateNode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _linkWithClassVisualID = this.getLinkWithClassVisualID(it);
        _builder.append((Object)_linkWithClassVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _isDiagram = this.isDiagram(it);
        _builder.append((Object)_isDiagram, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _constraintMethods = this.constraintMethods(it);
        _builder.append((Object)_constraintMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _checkNodeVisualID = this.checkNodeVisualID(it);
        _builder.append((Object)_checkNodeVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _isCompartmentVisualID = this.isCompartmentVisualID(it);
        _builder.append((Object)_isCompartmentVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        String _isSemanticLeafVisualID = this.isSemanticLeafVisualID(it);
        _builder.append((Object)_isSemanticLeafVisualID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _runtimeTypedInstance = this.runtimeTypedInstance(it);
        _builder.append((Object)_runtimeTypedInstance, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t");
        _builder.append((Object)"\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributes(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static final String DEBUG_KEY = \"");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenPlugin _plugin = _editorGen.getPlugin();
        String _iD = _plugin.getID();
        _builder.append((Object)_iD, "");
        _builder.append((Object)"/debug/visualID\"; ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getViewVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static int ");
        CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
        _builder.append((Object)_visualIdMethodName, "");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (view instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t\t");
        _builder.append((Object)".equals(view.getType())) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "\t\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t");
        _builder.append((Object)"(view.getType());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getModelID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static String ");
        CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
        _builder.append((Object)_modelIDMethodName, "");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View diagram = view.getDiagram();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"while (view != diagram) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.EAnnotation annotation = view.getEAnnotation(\"Shortcut\"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (annotation != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return (String) annotation.getDetails().get(\"modelID\"); ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"view = (org.eclipse.gmf.runtime.notation.View) view.eContainer();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return diagram != null ? diagram.getType() : null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static int ");
        CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
        _builder.append((Object)_visualIdMethodName, "");
        _builder.append((Object)"(String type) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Integer.parseInt(type);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} catch (NumberFormatException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (Boolean.TRUE.toString().equalsIgnoreCase(org.eclipse.core.runtime.Platform.getDebugOption(DEBUG_KEY))) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenPlugin _plugin = _editorGen.getPlugin();
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName, "\t\t\t");
        _builder.append((Object)".getInstance().logError(\"Unable to parse view type as a visualID number: \" + type);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getType(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static String ");
        CharSequence _typeMethodName = this.getTypeMethodName(it);
        _builder.append((Object)_typeMethodName, "");
        _builder.append((Object)"(int visualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return Integer.toString(visualID);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getDiagramVisualID(GenDiagram it) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static int ");
        CharSequence _diagramVisualIDMethodName = this.getDiagramVisualIDMethodName(it);
        _builder.append((Object)_diagramVisualIDMethodName, "");
        _builder.append((Object)"(org.eclipse.emf.ecore.EObject domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (domainElement == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_domainDiagramElement);
        if (_notEquals) {
            CharSequence _returnVisualID = this.returnVisualID((GenCommonBase)it);
            _builder.append((Object)_returnVisualID, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence returnVisualID(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (");
        CharSequence _checkSemanticElement = this.checkSemanticElement(it);
        _builder.append((Object)_checkSemanticElement, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _visualID = VisualIDRegistry.visualID(it);
        _builder.append((Object)_visualID, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _checkSemanticElement(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        String _plus = "checkSemanticElement not supported for: " + it;
        this._common_qvto.ERROR(_plus);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _checkSemanticElement(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(_domainDiagramElement);
        _builder.append((Object)_checkDomainElementMetaclass, "");
        _builder.append((Object)" && isDiagram(");
        GenClass _domainDiagramElement_1 = it.getDomainDiagramElement();
        CharSequence _CastEObject = this.xptMetaModel.CastEObject(_domainDiagramElement_1, "domainElement");
        _builder.append((Object)_CastEObject, "");
        _builder.append((Object)")");
        return _builder;
    }

    protected CharSequence _checkSemanticElement(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        TypeModelFacet _modelFacet = it.getModelFacet();
        GenClass _metaClass = _modelFacet.getMetaClass();
        CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(_metaClass);
        _builder.append((Object)_checkDomainElementMetaclass, "");
        TypeModelFacet _modelFacet_1 = it.getModelFacet();
        CharSequence _checkDomainElementConstraints = this.checkDomainElementConstraints(_modelFacet_1, (GenCommonBase)it);
        _builder.append((Object)_checkDomainElementConstraints, "");
        return _builder;
    }

    protected CharSequence _checkSemanticElement(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        LinkModelFacet _modelFacet = it.getModelFacet();
        CharSequence _checkSemanticElement = this.checkSemanticElement(_modelFacet, it);
        _builder.append((Object)_checkSemanticElement, "");
        return _builder;
    }

    public CharSequence checkDomainElementMetaclass(GenClass it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _MetaClass = this.xptMetaModel.MetaClass((GenClassifier)it);
        _builder.append((Object)_MetaClass, "");
        _builder.append((Object)".isSuperTypeOf(domainElement.eClass())");
        return _builder;
    }

    public CharSequence checkDomainElementConstraints(TypeModelFacet it, GenCommonBase commonBase) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenConstraint _modelElementSelector = it.getModelElementSelector();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_modelElementSelector);
        if (_notEquals) {
            _builder.append((Object)" && ");
            CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(commonBase);
            _builder.append((Object)_domainElementConstraintMethodName, "");
            _builder.append((Object)"(");
            GenClass _metaClass = it.getMetaClass();
            CharSequence _CastEObject = this.xptMetaModel.CastEObject(_metaClass, "domainElement");
            _builder.append((Object)_CastEObject, "");
            _builder.append((Object)")");
        }
        return _builder;
    }

    protected CharSequence _checkSemanticElement(LinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        String _plus = "checkSemanticElement is supported only for TypeLinkModelFacet: " + it;
        this._common_qvto.ERROR(_plus);
        return _builder;
    }

    protected CharSequence _checkSemanticElement(TypeLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        GenClass _metaClass = it.getMetaClass();
        CharSequence _checkDomainElementMetaclass = this.checkDomainElementMetaclass(_metaClass);
        _builder.append((Object)_checkDomainElementMetaclass, "");
        CharSequence _checkDomainElementConstraints = this.checkDomainElementConstraints((TypeModelFacet)it, (GenCommonBase)genLink);
        _builder.append((Object)_checkDomainElementConstraints, "");
        return _builder;
    }

    public CharSequence getNodeVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static int ");
        CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
        _builder.append((Object)_nodeVisualIDMethodName, "");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (domainElement == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"String containerModelID = ");
        CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
        _builder.append((Object)_modelIDMethodCall, "\t");
        _builder.append((Object)"(containerView);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (!");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t");
        _builder.append((Object)".equals(containerModelID)");
        EList _shortcutsProvidedFor = it.getShortcutsProvidedFor();
        for (String spf : _shortcutsProvidedFor) {
            CharSequence _checkContainerModelID = this.checkContainerModelID(spf);
            _builder.append((Object)_checkContainerModelID, "\t");
        }
        _builder.append((Object)") { ");
        EList _shortcutsProvidedFor_1 = it.getShortcutsProvidedFor();
        CharSequence _nonNLS_All = this._common.nonNLS_All((Iterable<? extends Object>)_shortcutsProvidedFor_1);
        _builder.append((Object)_nonNLS_All, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int containerVisualID;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (");
        CharSequence _modelID_1 = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID_1, "\t");
        _builder.append((Object)".equals(containerModelID)) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"containerVisualID = ");
        CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t\t");
        _builder.append((Object)"(containerView);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (containerView instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"containerVisualID = ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "\t\t\t");
        _builder.append((Object)";\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        CharSequence _unrecognizedVID_2 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_2, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"switch (containerVisualID) {");
        _builder.newLine();
        EList _allContainers = it.getAllContainers();
        for (GenContainerBase container : _allContainers) {
            _builder.append((Object)"\t\t");
            CharSequence _caseDomainContainerVisualID = this.caseDomainContainerVisualID(container);
            _builder.append((Object)_caseDomainContainerVisualID, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _unrecognizedVID_3 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence caseDomainContainerVisualID(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<GenNode> _containedSemanticNodes = this.getContainedSemanticNodes(it);
        boolean _notEmpty = this._common_qvto.notEmpty(_containedSemanticNodes);
        if (_notEmpty) {
            CharSequence _caseVisualID = this.caseVisualID((GenCommonBase)it);
            _builder.append((Object)_caseVisualID, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            Iterable<GenNode> _containedSemanticNodes_1 = this.getContainedSemanticNodes(it);
            for (GenNode node : _containedSemanticNodes_1) {
                CharSequence _returnVisualID = this.returnVisualID((GenCommonBase)node);
                _builder.append((Object)_returnVisualID, "\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence canCreateNode(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static boolean ");
        CharSequence _canCreateNodeMethodName = this.canCreateNodeMethodName(it);
        _builder.append((Object)_canCreateNodeMethodName, "");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View containerView, int nodeVisualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"String containerModelID = ");
        CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
        _builder.append((Object)_modelIDMethodCall, "\t");
        _builder.append((Object)"(containerView);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (!");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t");
        _builder.append((Object)".equals(containerModelID)");
        EList _shortcutsProvidedFor = it.getShortcutsProvidedFor();
        for (String spf : _shortcutsProvidedFor) {
            CharSequence _checkContainerModelID = this.checkContainerModelID(spf);
            _builder.append((Object)_checkContainerModelID, "\t");
        }
        _builder.append((Object)") { ");
        EList _shortcutsProvidedFor_1 = it.getShortcutsProvidedFor();
        CharSequence _nonNLS_All = this._common.nonNLS_All((Iterable<? extends Object>)_shortcutsProvidedFor_1);
        _builder.append((Object)_nonNLS_All, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int containerVisualID;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (");
        CharSequence _modelID_1 = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID_1, "\t");
        _builder.append((Object)".equals(containerModelID)) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"containerVisualID = ");
        CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t\t");
        _builder.append((Object)"(containerView);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (containerView instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"containerVisualID = ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "\t\t\t");
        _builder.append((Object)";\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"switch (containerVisualID) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList _allContainers = it.getAllContainers();
        Functions.Function1<GenContainerBase, Boolean> _function = new Functions.Function1<GenContainerBase, Boolean>(){

            public Boolean apply(GenContainerBase e) {
                Iterable<GenCommonBase> _essentialVisualChildren = VisualIDRegistry.this.getEssentialVisualChildren((GenCommonBase)e);
                boolean _notEmpty = VisualIDRegistry.this._common_qvto.notEmpty(_essentialVisualChildren);
                return _notEmpty;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_allContainers, (Functions.Function1)_function);
        for (GenContainerBase container : _filter) {
            CharSequence _checkEssentialChildren = this.checkEssentialChildren((GenCommonBase)container);
            _builder.append((Object)_checkEssentialChildren, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        EList _links = it.getLinks();
        Functions.Function1<GenLink, Boolean> _function_1 = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink l) {
                Iterable<GenCommonBase> _essentialVisualChildren = VisualIDRegistry.this.getEssentialVisualChildren((GenCommonBase)l);
                boolean _notEmpty = VisualIDRegistry.this._common_qvto.notEmpty(_essentialVisualChildren);
                return _notEmpty;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_links, (Functions.Function1)_function_1);
        for (GenLink link : _filter_1) {
            CharSequence _checkEssentialChildren_1 = this.checkEssentialChildren((GenCommonBase)link);
            _builder.append((Object)_checkEssentialChildren_1, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence checkContainerModelID(String someModelId) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)" ");
        _builder.append((Object)"&& !\"");
        _builder.append((Object)someModelId, " ");
        _builder.append((Object)"\".equals(containerModelID)");
        return _builder;
    }

    public CharSequence checkEssentialChildren(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _caseVisualID = this.caseVisualID(it);
        _builder.append((Object)_caseVisualID, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Iterable<GenCommonBase> _essentialVisualChildren = this.getEssentialVisualChildren(it);
        for (GenCommonBase child : _essentialVisualChildren) {
            CharSequence _checkEssentialChild = this.checkEssentialChild(child);
            _builder.append((Object)_checkEssentialChild, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence checkEssentialChild(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (");
        CharSequence _visualID = VisualIDRegistry.visualID(it);
        _builder.append((Object)_visualID, "");
        _builder.append((Object)" == nodeVisualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getLinkWithClassVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static int ");
        CharSequence _linkWithClassVisualIDMethodName = this.getLinkWithClassVisualIDMethodName(it);
        _builder.append((Object)_linkWithClassVisualIDMethodName, "");
        _builder.append((Object)"(org.eclipse.emf.ecore.EObject domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (domainElement == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _unrecognizedVID = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        EList _links = it.getLinks();
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink l) {
                boolean _isTypeLink = VisualIDRegistry.this._linkUtils_qvto.isTypeLink(l);
                return _isTypeLink;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_links, (Functions.Function1)_function);
        for (GenLink typeLink : _filter) {
            CharSequence _returnVisualID = this.returnVisualID((GenCommonBase)typeLink);
            _builder.append((Object)_returnVisualID, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
        _builder.append((Object)_unrecognizedVID_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isDiagram(GenDiagram it) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_domainDiagramElement);
        if (_notEquals) {
            String _plus = "User can change implementation of this method to handle some specific\nsituations not covered by default logic.\n";
            CharSequence _generatedMemberComment = this._common.generatedMemberComment(_plus);
            _builder.append((Object)_generatedMemberComment, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private static boolean isDiagram(");
            GenClass _domainDiagramElement_1 = it.getDomainDiagramElement();
            CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_domainDiagramElement_1);
            _builder.append((Object)_QualifiedClassName, "");
            _builder.append((Object)" element) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return true;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence constraintMethods(GenDiagram it) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenExpressionProviderContainer _expressionProviders = _editorGen.getExpressionProviders();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_expressionProviders);
        if (_notEquals) {
            EList _topLevelNodes = it.getTopLevelNodes();
            Functions.Function1<GenTopLevelNode, Boolean> _function = new Functions.Function1<GenTopLevelNode, Boolean>(){

                public Boolean apply(GenTopLevelNode n) {
                    TypeModelFacet _modelFacet = n.getModelFacet();
                    GenConstraint _modelElementSelector = _modelFacet.getModelElementSelector();
                    boolean _notEquals = !Objects.equal((Object)_modelElementSelector, null);
                    return _notEquals;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_topLevelNodes, (Functions.Function1)_function);
            for (GenTopLevelNode topNode : _filter) {
                CharSequence _constraintMethod = this.constraintMethod((GenNode)topNode);
                _builder.append((Object)_constraintMethod, "");
            }
            _builder.newLineIfNotEmpty();
            EList _childNodes = it.getChildNodes();
            Functions.Function1<GenChildNode, Boolean> _function_1 = new Functions.Function1<GenChildNode, Boolean>(){

                public Boolean apply(GenChildNode n) {
                    TypeModelFacet _modelFacet = n.getModelFacet();
                    GenConstraint _modelElementSelector = _modelFacet.getModelElementSelector();
                    boolean _notEquals = !Objects.equal((Object)_modelElementSelector, null);
                    return _notEquals;
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_childNodes, (Functions.Function1)_function_1);
            for (GenChildNode childNode : _filter_1) {
                CharSequence _constraintMethod_1 = this.constraintMethod((GenNode)childNode);
                _builder.append((Object)_constraintMethod_1, "");
            }
            _builder.newLineIfNotEmpty();
            EList _links = it.getLinks();
            for (GenLink link : _links) {
                LinkModelFacet _modelFacet = link.getModelFacet();
                CharSequence _constraintMethod_2 = this.constraintMethod(_modelFacet, link);
                _builder.append((Object)_constraintMethod_2, "");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence constraintMethod(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        TypeModelFacet _modelFacet = it.getModelFacet();
        GenConstraint _modelElementSelector = _modelFacet.getModelElementSelector();
        GenExpressionProviderBase _provider = _modelElementSelector.getProvider();
        TypeModelFacet _modelFacet_1 = it.getModelFacet();
        GenConstraint _modelElementSelector_1 = _modelFacet_1.getModelElementSelector();
        TypeModelFacet _modelFacet_2 = it.getModelFacet();
        GenClass _metaClass = _modelFacet_2.getMetaClass();
        CharSequence _domainElementConstraintMethod = this.domainElementConstraintMethod(_provider, (GenCommonBase)it, (ValueExpression)_modelElementSelector_1, _metaClass);
        _builder.append((Object)_domainElementConstraintMethod, "");
        return _builder;
    }

    protected CharSequence _constraintMethod(LinkModelFacet it, GenLink l) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _constraintMethod(TypeLinkModelFacet it, GenLink l) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenConstraint _modelElementSelector = it.getModelElementSelector();
        boolean bl = _notEquals = !Objects.equal((Object)_modelElementSelector, null);
        if (_notEquals) {
            GenConstraint _modelElementSelector_1 = it.getModelElementSelector();
            GenExpressionProviderBase _provider = _modelElementSelector_1.getProvider();
            GenConstraint _modelElementSelector_2 = it.getModelElementSelector();
            GenClass _metaClass = it.getMetaClass();
            CharSequence _domainElementConstraintMethod = this.domainElementConstraintMethod(_provider, (GenCommonBase)l, (ValueExpression)_modelElementSelector_2, _metaClass);
            _builder.append((Object)_domainElementConstraintMethod, "");
        }
        return _builder;
    }

    protected CharSequence _domainElementConstraintMethod(GenExpressionProviderBase it, GenCommonBase diagramElement, ValueExpression expression, GenClass context) {
        StringConcatenation _builder = new StringConcatenation();
        String _plus = "Constraint method is not supported for " + it;
        this._common_qvto.ERROR(_plus);
        return _builder;
    }

    protected CharSequence _domainElementConstraintMethod(GenJavaExpressionProvider it, GenCommonBase diagramElement, ValueExpression expression, GenClass context) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static boolean ");
        CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(diagramElement);
        _builder.append((Object)_domainElementConstraintMethodName, "");
        _builder.append((Object)"(");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)context);
        _builder.append((Object)_QualifiedClassName, "");
        _builder.append((Object)" domainElement) {");
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        boolean _isInjectExpressionBody = it.isInjectExpressionBody();
        if (!_isInjectExpressionBody) {
            _and = false;
        } else {
            boolean _notEquals;
            boolean _and_1 = false;
            String _body = expression.getBody();
            boolean bl = _notEquals = !Objects.equal((Object)_body, null);
            if (!_notEquals) {
                _and_1 = false;
            } else {
                String _body_1 = expression.getBody();
                boolean _isEmpty = _body_1.isEmpty();
                boolean _not = !_isEmpty;
                _and_1 = _notEquals && _not;
            }
            boolean bl2 = _and = _isInjectExpressionBody && _and_1;
        }
        if (_and) {
            String _body_2 = expression.getBody();
            _builder.append((Object)_body_2, "");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _or = false;
            boolean _isThrowException = it.isThrowException();
            if (_isThrowException) {
                _or = true;
            } else {
                boolean _and_2 = false;
                boolean _isInjectExpressionBody_1 = it.isInjectExpressionBody();
                if (!_isInjectExpressionBody_1) {
                    _and_2 = false;
                } else {
                    boolean _or_1 = false;
                    String _body_3 = expression.getBody();
                    boolean _equals = Objects.equal((Object)_body_3, null);
                    if (_equals) {
                        _or_1 = true;
                    } else {
                        String _body_4 = expression.getBody();
                        boolean _isEmpty_1 = _body_4.isEmpty();
                        _or_1 = _equals || _isEmpty_1;
                    }
                    _and_2 = _isInjectExpressionBody_1 && _or_1;
                }
                boolean bl = _or = _isThrowException || _and_2;
            }
            if (_or) {
                _builder.append((Object)"// FIXME: implement this method ");
                _builder.newLine();
                _builder.append((Object)"// Ensure that you remove @generated or mark it @generated NOT");
                _builder.newLine();
                _builder.append((Object)"throw new java.lang.UnsupportedOperationException(\"No java implementation provided in '");
                CharSequence _domainElementConstraintMethodName_1 = this.domainElementConstraintMethodName(diagramElement);
                _builder.append((Object)_domainElementConstraintMethodName_1, "");
                _builder.append((Object)"' operation\");");
                CharSequence _nonNLS = this._common.nonNLS(1);
                _builder.append((Object)_nonNLS, "");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"return false;");
                _builder.newLine();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _domainElementConstraintMethod(GenExpressionInterpreter it, GenCommonBase diagramElement, ValueExpression expression, GenClass context) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static boolean ");
        CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(diagramElement);
        _builder.append((Object)_domainElementConstraintMethodName, "");
        _builder.append((Object)"(");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)context);
        _builder.append((Object)_QualifiedClassName, "");
        _builder.append((Object)" domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"Object result = ");
        CharSequence _expression = this.xptGetExpression.getExpression((GenExpressionProviderBase)it, expression, context);
        _builder.append((Object)_expression, "\t");
        _builder.append((Object)".evaluate(domainElement);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result instanceof Boolean && ((Boolean)result).booleanValue();");
        _builder.newLine();
        _builder.append((Object)"}\t\t\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence unrecognizedVID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"return -1;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence checkNodeVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static boolean ");
        CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
        _builder.append((Object)_checkNodeVisualIDMethodName, "");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement, int candidate) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (candidate == -1){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//unrecognized id is always bad");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int basic = ");
        CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
        _builder.append((Object)_nodeVisualIDMethodName, "\t");
        _builder.append((Object)"(containerView, domainElement);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return basic == candidate;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isCompartmentVisualID(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static boolean ");
        CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
        _builder.append((Object)_isCompartmentVisualIDMethodName, "");
        _builder.append((Object)"(int visualID) {");
        _builder.newLineIfNotEmpty();
        EList _compartments = it.getCompartments();
        boolean _notEmpty = this._common_qvto.notEmpty(_compartments);
        if (_notEmpty) {
            _builder.append((Object)"\t");
            _builder.append((Object)"switch (visualID) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            EList _compartments_1 = it.getCompartments();
            for (GenCompartment compartment : _compartments_1) {
                CharSequence _caseVisualID = this.caseVisualID((GenCommonBase)compartment);
                _builder.append((Object)_caseVisualID, "\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return true;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"default:");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public String isSemanticLeafVisualID(GenDiagram it) {
        EList _allNodes = it.getAllNodes();
        Functions.Function1<GenNode, Boolean> _function = new Functions.Function1<GenNode, Boolean>(){

            public Boolean apply(GenNode n) {
                boolean _and = false;
                Iterable<GenNode> _semanticChildren = VisualIDRegistry.this._utils_qvto.getSemanticChildren((GenContainerBase)n);
                boolean _isEmpty = IterableExtensions.isEmpty(_semanticChildren);
                if (!_isEmpty) {
                    _and = false;
                } else {
                    EList _compartments = n.getCompartments();
                    Functions.Function1<GenCompartment, Boolean> _function = new Functions.Function1<GenCompartment, Boolean>(){

                        public Boolean apply(GenCompartment c) {
                            Iterable<GenNode> _semanticChildren = VisualIDRegistry.this._utils_qvto.getSemanticChildren((GenContainerBase)c);
                            boolean _isEmpty = IterableExtensions.isEmpty(_semanticChildren);
                            return _isEmpty;
                        }
                    };
                    boolean _forall = IterableExtensions.forall((Iterable)_compartments, (Functions.Function1)_function);
                    _and = _isEmpty && _forall;
                }
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_allNodes, (Functions.Function1)_function);
        Functions.Function1<GenNode, Integer> _function_1 = new Functions.Function1<GenNode, Integer>(){

            public Integer apply(GenNode n) {
                int _visualID = n.getVisualID();
                return _visualID;
            }
        };
        List leafs = IterableExtensions.sortBy((Iterable)_filter, (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static boolean ");
        CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
        _builder.append((Object)_isSemanticLeafVisualIDMethodName, "");
        _builder.append((Object)"(int visualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"switch (visualID) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _caseVisualID = this.caseVisualID((GenCommonBase)it);
        _builder.append((Object)_caseVisualID, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        boolean _notEmpty = this._common_qvto.notEmpty(leafs);
        if (_notEmpty) {
            _builder.append((Object)"\t\t");
            for (GenNode leaf : leafs) {
                CharSequence _caseVisualID_1 = this.caseVisualID((GenCommonBase)leaf);
                _builder.append((Object)_caseVisualID_1, "\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return true;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence runtimeTypedInstance(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static final org.eclipse.gmf.tooling.runtime.structure.DiagramStructure ");
        CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
        _builder.append((Object)_runtimeTypedInstanceName, "");
        _builder.append((Object)" = new org.eclipse.gmf.tooling.runtime.structure.DiagramStructure() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _overrideI = this.xptCodeStyle.overrideI((GenCommonBase)it);
        _builder.append((Object)_overrideI, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int ");
        CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
        _builder.append((Object)_visualIdMethodName, "\t");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
        _builder.append((Object)_visualIDMethodCall, "\t\t");
        _builder.append((Object)"(view);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _overrideI_1 = this.xptCodeStyle.overrideI((GenCommonBase)it);
        _builder.append((Object)_overrideI_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String ");
        CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
        _builder.append((Object)_modelIDMethodName, "\t");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
        _builder.append((Object)_modelIDMethodCall, "\t\t");
        _builder.append((Object)"(view);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _overrideI_2 = this.xptCodeStyle.overrideI((GenCommonBase)it);
        _builder.append((Object)_overrideI_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int ");
        CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
        _builder.append((Object)_nodeVisualIDMethodName, "\t");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _nodeVisualIDMethodCall = this.getNodeVisualIDMethodCall(it);
        _builder.append((Object)_nodeVisualIDMethodCall, "\t\t");
        _builder.append((Object)"(containerView, domainElement);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _overrideI_3 = this.xptCodeStyle.overrideI((GenCommonBase)it);
        _builder.append((Object)_overrideI_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean ");
        CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
        _builder.append((Object)_checkNodeVisualIDMethodName, "\t");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement, int candidate) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _checkNodeVisualIDMethodCall = this.checkNodeVisualIDMethodCall(it);
        _builder.append((Object)_checkNodeVisualIDMethodCall, "\t\t");
        _builder.append((Object)"(containerView, domainElement, candidate);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _overrideI_4 = this.xptCodeStyle.overrideI((GenCommonBase)it);
        _builder.append((Object)_overrideI_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean ");
        CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
        _builder.append((Object)_isCompartmentVisualIDMethodName, "\t");
        _builder.append((Object)"(int visualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _isCompartmentVisualIDMethodCall = this.isCompartmentVisualIDMethodCall(it);
        _builder.append((Object)_isCompartmentVisualIDMethodCall, "\t\t");
        _builder.append((Object)"(visualID);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _overrideI_5 = this.xptCodeStyle.overrideI((GenCommonBase)it);
        _builder.append((Object)_overrideI_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean ");
        CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
        _builder.append((Object)_isSemanticLeafVisualIDMethodName, "\t");
        _builder.append((Object)"(int visualID) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _isSemanticLeafVisualIDMethodCall = this.isSemanticLeafVisualIDMethodCall(it);
        _builder.append((Object)_isSemanticLeafVisualIDMethodCall, "\t\t");
        _builder.append((Object)"(visualID);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder;
    }

    public CharSequence caseVisualID(GenCommonBase xptSelf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"case ");
        CharSequence _visualID = VisualIDRegistry.visualID(xptSelf);
        _builder.append((Object)_visualID, "");
        _builder.append((Object)":");
        return _builder;
    }

    public CharSequence additions(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public Iterable<GenCommonBase> getEssentialVisualChildren(GenCommonBase it) {
        if (it instanceof GenNode) {
            return this._getEssentialVisualChildren((GenNode)it);
        }
        if (it instanceof GenLink) {
            return this._getEssentialVisualChildren((GenLink)it);
        }
        if (it instanceof GenContainerBase) {
            return this._getEssentialVisualChildren((GenContainerBase)it);
        }
        if (it != null) {
            return this._getEssentialVisualChildren(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence checkSemanticElement(GenCommonBase it) {
        if (it instanceof GenNode) {
            return this._checkSemanticElement((GenNode)it);
        }
        if (it instanceof GenDiagram) {
            return this._checkSemanticElement((GenDiagram)it);
        }
        if (it instanceof GenLink) {
            return this._checkSemanticElement((GenLink)it);
        }
        if (it != null) {
            return this._checkSemanticElement(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence checkSemanticElement(LinkModelFacet it, GenLink genLink) {
        if (it instanceof TypeLinkModelFacet) {
            return this._checkSemanticElement((TypeLinkModelFacet)it, genLink);
        }
        if (it != null) {
            return this._checkSemanticElement(it, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, genLink).toString());
    }

    public CharSequence constraintMethod(LinkModelFacet it, GenLink l) {
        if (it instanceof TypeLinkModelFacet) {
            return this._constraintMethod((TypeLinkModelFacet)it, l);
        }
        if (it != null) {
            return this._constraintMethod(it, l);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, l).toString());
    }

    public CharSequence domainElementConstraintMethod(GenExpressionProviderBase it, GenCommonBase diagramElement, ValueExpression expression, GenClass context) {
        if (it instanceof GenExpressionInterpreter) {
            return this._domainElementConstraintMethod((GenExpressionInterpreter)it, diagramElement, expression, context);
        }
        if (it instanceof GenJavaExpressionProvider) {
            return this._domainElementConstraintMethod((GenJavaExpressionProvider)it, diagramElement, expression, context);
        }
        if (it != null) {
            return this._domainElementConstraintMethod(it, diagramElement, expression, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, diagramElement, expression, context).toString());
    }
}

