/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.parent;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooling.simplemap.model.triggers.parent.NewTopNodeTrigger;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleParentNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleSubNode;

public class NewSubNodeTrigger
extends NewTopNodeTrigger {
    public NewSubNodeTrigger(TransactionalEditingDomain domain, SimpleParentNode parent, SimpleSubNode newSubNode) {
        super(domain, parent, (SimpleNode)newSubNode);
    }

    @Override
    public void executeTrigger() {
        Node newNode = GMFGraphFactory.eINSTANCE.createNode();
        DiagramLabel newLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        Label parentLabel = this.getLabelFigure(this.parent);
        BasicFont parentFont = parentLabel != null ? (BasicFont)parentLabel.getFont() : null;
        this.updateCanvas(newNode, newLabel, parentFont);
        CreationTool newCreationTool = this.createNewTool();
        if (this.parent instanceof SimpleCompartment) {
            SimpleNode parentNode = ((SimpleCompartment)this.parent).getParent();
            this.updateMapping(parentNode, newNode, newLabel, newCreationTool, ((SimpleCompartment)this.parent).getCompartmentMapping());
        } else {
            this.updateMapping((SimpleNode)this.parent, newNode, newLabel, newCreationTool);
        }
    }

    @Override
    protected void updateCanvas(Node newNode, DiagramLabel newLabel, BasicFont parentFont) {
        this.canvasFactory.createDefaultRoundedRectangleWithLabel(newNode, newLabel, false, parentFont);
    }

    private void updateMapping(SimpleNode parentNode, Node newNode, DiagramLabel newLabel, CreationTool newCreationTool) {
        this.updateMapping(parentNode, newNode, newLabel, newCreationTool, null);
    }

    private void updateMapping(SimpleNode parentNode, Node newNode, DiagramLabel newLabel, CreationTool newCreationTool, CompartmentMapping compartment) {
        NodeMapping newNodeMapping = this.createNewNodeMapping(newNode, newLabel, newCreationTool);
        ChildReference newChildReference = GMFMapFactory.eINSTANCE.createChildReference();
        newChildReference.setOwnedChild(newNodeMapping);
        if (compartment != null) {
            newChildReference.setCompartment(compartment);
        }
        parentNode.getNodeReference().getChild().getChildren().add((Object)newChildReference);
        this.newSimpleNode.setNodeReference((NodeReference)newChildReference);
    }
}

