/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.parsers;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.tooling.runtime.Messages;
import org.eclipse.gmf.tooling.runtime.parsers.AbstractFeatureParser;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractAttributeParser
extends AbstractFeatureParser {
    private String viewPattern;
    private String editorPattern;
    private String editPattern;
    protected final EAttribute[] features;
    protected final EAttribute[] editableFeatures;

    public AbstractAttributeParser(EAttribute[] features) {
        super((EStructuralFeature[])features);
        this.editableFeatures = features;
        this.features = features;
    }

    public AbstractAttributeParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super((EStructuralFeature[])features, (EStructuralFeature[])editableFeatures);
        this.features = features;
        this.editableFeatures = editableFeatures;
    }

    @Override
    protected Object getValue(EObject element, EStructuralFeature feature) {
        Object value = super.getValue(element, feature);
        Class iClass = ((EAttribute)feature).getEAttributeType().getInstanceClass();
        if (String.class.equals((Object)iClass) && value == null) {
            value = "";
        }
        return value;
    }

    @Override
    protected Object getValidNewValue(EStructuralFeature feature, Object value) {
        EClassifier type = feature.getEType();
        if (type instanceof EDataType) {
            Class iClass = type.getInstanceClass();
            if (value instanceof String && !(type instanceof EEnum)) {
                try {
                    value = EcoreFactory.eINSTANCE.createFromString((EDataType)type, (String)value);
                }
                catch (Exception e) {
                    value = this.wrapException(iClass, value, e);
                }
            } else if (Boolean.TYPE.equals(iClass) || Boolean.class.equals((Object)iClass)) {
                if (!(value instanceof Boolean || Boolean.class.equals((Object)iClass) && value == null)) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Character.TYPE.equals(iClass) || Character.class.equals((Object)iClass)) {
                if (!(value instanceof Character || Character.class.equals((Object)iClass) && value == null)) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Byte.TYPE.equals(iClass) || Byte.class.equals((Object)iClass)) {
                if (value instanceof Number) {
                    value = new Byte(((Number)value).byteValue());
                } else if (value != null || !Byte.class.equals((Object)iClass)) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Short.TYPE.equals(iClass) || Short.class.equals((Object)iClass)) {
                if (value instanceof Number) {
                    value = new Short(((Number)value).shortValue());
                } else if (value != null || !Short.class.equals((Object)iClass)) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Integer.TYPE.equals(iClass) || Integer.class.equals((Object)iClass)) {
                if (value instanceof Number) {
                    value = new Integer(((Number)value).intValue());
                } else if (value != null || !Integer.class.equals((Object)iClass)) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Long.TYPE.equals(iClass) || Long.class.equals((Object)iClass)) {
                if (value instanceof Number) {
                    value = new Long(((Number)value).longValue());
                } else if (value != null || !Long.class.equals((Object)iClass)) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Float.TYPE.equals(iClass) || Float.class.equals((Object)iClass)) {
                if (value instanceof Number) {
                    value = new Float(((Number)value).floatValue());
                } else if (value != null || !Float.class.equals((Object)iClass)) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Double.TYPE.equals(iClass) || Double.class.equals((Object)iClass)) {
                if (value instanceof Number) {
                    value = new Double(((Number)value).doubleValue());
                } else if (value != null || !Double.class.equals((Object)iClass)) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (type instanceof EEnum) {
                EEnumLiteral literal = null;
                if (value instanceof String) {
                    literal = ((EEnum)type).getEEnumLiteralByLiteral((String)value);
                } else if (value instanceof Number) {
                    literal = ((EEnum)type).getEEnumLiteral(((Number)value).intValue());
                } else if (value instanceof Enumerator) {
                    literal = ((EEnum)type).getEEnumLiteral(((Enumerator)value).getValue());
                }
                value = literal == null ? new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnknownLiteral, (Object)value)) : literal.getInstance();
            } else if (Date.class.equals((Object)iClass)) {
                if (!(value instanceof Date) && value != null) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)String.class.getName()));
                }
            } else if (BigDecimal.class.equals((Object)iClass)) {
                if (value instanceof Number) {
                    value = new BigDecimal(((Number)value).doubleValue());
                } else if (value != null) {
                    value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)String.class.getName()));
                }
            }
        }
        return value;
    }

    private AbstractFeatureParser.InvalidValue wrapException(Class<?> className, Object value, Throwable e) {
        return new AbstractFeatureParser.InvalidValue(NLS.bind((String)(String.valueOf(Messages.AbstractAttributeParser_UnexpectedValueType) + ", " + e.getMessage()), className));
    }

    public String getViewPattern() {
        return this.viewPattern;
    }

    public void setViewPattern(String viewPattern) {
        this.viewPattern = viewPattern;
    }

    public String getEditorPattern() {
        return this.editorPattern;
    }

    public void setEditorPattern(String editorPattern) {
        this.editorPattern = editorPattern;
    }

    public String getEditPattern() {
        return this.editPattern;
    }

    public void setEditPattern(String editPattern) {
        this.editPattern = editPattern;
    }
}

