/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.figures;

import java.util.Collection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;

public abstract class SideAffixedElementPositioner {
    private static final Dimension BORDER_ITEM_OFFSET_DEFAULT = new Dimension(1, 1);
    private static final Dimension GAP_DEFAULT = new Dimension(8, 8);
    private Dimension borderItemOffset = BORDER_ITEM_OFFSET_DEFAULT;
    private Dimension myGap = GAP_DEFAULT;

    public Dimension getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setBorderItemOffset(Dimension borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    protected Rectangle getParentBorder() {
        if (this.getHostFigure() instanceof HandleBounds) {
            return ((HandleBounds)this.getHostFigure()).getHandleBounds().getCopy();
        }
        return this.getHostFigure().getBounds().getCopy();
    }

    private Rectangle locateOnParent(Rectangle suggestedLocation, int suggestedSide) {
        int newY;
        int newX;
        Rectangle bounds = this.getParentBorder();
        Dimension borderItemOffset = this.getBorderItemOffset();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        int westX = parentFigureX - suggestedLocation.width + borderItemOffset.width;
        int eastX = parentFigureX + parentFigureWidth - borderItemOffset.width;
        int southY = parentFigureY + parentFigureHeight - borderItemOffset.height;
        int northY = parentFigureY - suggestedLocation.height + borderItemOffset.height;
        if (suggestedSide == 8) {
            newX = westX;
            newY = SideAffixedElementPositioner.constrainValue(northY + suggestedLocation.height, southY - suggestedLocation.height, suggestedLocation.y);
        } else if (suggestedSide == 16) {
            newX = eastX;
            newY = SideAffixedElementPositioner.constrainValue(northY + suggestedLocation.height, southY - suggestedLocation.height, suggestedLocation.y);
        } else if (suggestedSide == 4) {
            newY = southY;
            newX = SideAffixedElementPositioner.constrainValue(westX + suggestedLocation.width, eastX - suggestedLocation.width, suggestedLocation.x);
        } else {
            newY = northY;
            newX = SideAffixedElementPositioner.constrainValue(westX + suggestedLocation.width, eastX - suggestedLocation.width, suggestedLocation.x);
        }
        return new Rectangle(newX, newY, suggestedLocation.width, suggestedLocation.height);
    }

    private static int constrainValue(int min, int max, int defaultValue) {
        if (defaultValue < min) {
            return min;
        }
        if (defaultValue > max) {
            return max;
        }
        return defaultValue;
    }

    protected final Rectangle locateOnBorder(Rectangle suggestedLocation, int suggestedSide, int circuitCount) {
        Rectangle recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide);
        Dimension gap = this.getGap();
        int vertical_gap = gap.height;
        int horizontal_gap = gap.width;
        if (circuitCount < 4 && this.conflicts(recommendedLocation)) {
            if (suggestedSide == 8) {
                do {
                    recommendedLocation.y += recommendedLocation.height + vertical_gap;
                } while (this.conflicts(recommendedLocation));
                if (recommendedLocation.y > this.getParentBorder().getBottomLeft().y - recommendedLocation.height) {
                    return this.locateOnBorder(recommendedLocation, 4, circuitCount + 1);
                }
            } else if (suggestedSide == 4) {
                do {
                    recommendedLocation.x += recommendedLocation.width + horizontal_gap;
                } while (this.conflicts(recommendedLocation));
                if (recommendedLocation.x > this.getParentBorder().getBottomRight().x - recommendedLocation.width) {
                    return this.locateOnBorder(recommendedLocation, 16, circuitCount + 1);
                }
            } else if (suggestedSide == 16) {
                do {
                    recommendedLocation.y -= recommendedLocation.height + vertical_gap;
                } while (this.conflicts(recommendedLocation));
                if (recommendedLocation.y < this.getParentBorder().getTopRight().y) {
                    return this.locateOnBorder(recommendedLocation, 1, circuitCount + 1);
                }
            } else {
                do {
                    recommendedLocation.x -= recommendedLocation.width + horizontal_gap;
                } while (this.conflicts(recommendedLocation));
                if (recommendedLocation.x < this.getParentBorder().getTopLeft().x) {
                    return this.locateOnBorder(recommendedLocation, 8, circuitCount + 1);
                }
            }
        }
        return recommendedLocation;
    }

    protected boolean conflicts(Rectangle recommendedLocation) {
        for (IFigure iFigure : this.getSiblings()) {
            if (!iFigure.isVisible() || !iFigure.getBounds().intersects(recommendedLocation)) continue;
            return true;
        }
        return false;
    }

    protected abstract Collection<? extends IFigure> getSiblings();

    protected Dimension getGap() {
        return this.myGap;
    }

    protected void setGap(Dimension gap) {
        this.myGap = gap;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation) {
        int side = SideAffixedElementPositioner.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        Rectangle realLocation = new Rectangle(proposedLocation.getTopLeft(), this.getBorderItemSize());
        return this.locateOnBorder(realLocation, side, 0);
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        if (childCenter.x < parentCenter.x) {
            if (childCenter.y < parentCenter.y) {
                Point parentTopLeft = parentBorder.getTopLeft();
                if (childCenter.x - parentTopLeft.x <= childCenter.y - parentTopLeft.y) {
                    return 8;
                }
                return 1;
            }
            Point parentBottomLeft = parentBorder.getBottomLeft();
            if (childCenter.x - parentBottomLeft.x <= parentBottomLeft.y - childCenter.y) {
                return 8;
            }
            return 4;
        }
        if (childCenter.y < parentCenter.y) {
            Point parentTopRight = parentBorder.getTopRight();
            if (parentTopRight.x - childCenter.x <= childCenter.y - parentTopRight.y) {
                return 16;
            }
            return 1;
        }
        Point parentBottomRight = parentBorder.getBottomRight();
        if (parentBottomRight.x - childCenter.x <= parentBottomRight.y - childCenter.y) {
            return 16;
        }
        return 4;
    }

    protected abstract IFigure getHostFigure();

    protected abstract Dimension getBorderItemSize();
}

