/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor.palette;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.Separator;
import org.eclipse.gmf.codegen.gmfgen.StandardEntry;
import org.eclipse.gmf.codegen.gmfgen.StandardEntryKind;
import org.eclipse.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.editor.palette.Utils_qvto;
import xpt.providers.ElementTypes;

@Singleton
public class PaletteFactory {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    private ElementTypes xptElementTypes;
    @Inject
    private Externalizer xptExternalizer;

    public CharSequence className(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        String _factoryClassName = it.getFactoryClassName();
        _builder.append((Object)_factoryClassName, "");
        return _builder;
    }

    public CharSequence packageName(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getPackageName();
        _builder.append((Object)_packageName, "");
        return _builder;
    }

    public CharSequence qualifiedClassName(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        return _builder;
    }

    public CharSequence fullPath(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    @Deprecated
    public CharSequence Factory(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _PaletteFactory = this.PaletteFactory(it);
        _builder.append((Object)_PaletteFactory, "");
        return _builder;
    }

    public CharSequence PaletteFactory(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagram _diagram = it.getDiagram();
        GenEditorGenerator _editorGen = _diagram.getEditorGen();
        CharSequence _copyright = this._common.copyright(_editorGen);
        _builder.append((Object)_copyright, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void fillPalette(org.eclipse.gef.palette.PaletteRoot paletteRoot) {");
        _builder.newLine();
        boolean _definesStandardTools = it.definesStandardTools();
        if (_definesStandardTools) {
            _builder.append((Object)"cleanStandardTools(paletteRoot);");
            _builder.newLine();
        }
        EList _groups = it.getGroups();
        for (ToolGroup group : _groups) {
            CharSequence _addEntry = this.addEntry((ToolGroupItem)group, "paletteRoot");
            _builder.append((Object)_addEntry, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean _definesStandardTools_1 = it.definesStandardTools();
        if (_definesStandardTools_1) {
            CharSequence _cleanStandardToolsHack = this.cleanStandardToolsHack(it);
            _builder.append((Object)_cleanStandardToolsHack, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Iterable<ToolGroup> _collectGroups = this._utils_qvto.collectGroups(it);
        for (ToolGroup group_1 : _collectGroups) {
            CharSequence _createGroup = this.createGroup(group_1);
            _builder.append((Object)_createGroup, "");
            _builder.newLineIfNotEmpty();
        }
        Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
        for (AbstractToolEntry tool : _collectTools) {
            CharSequence _createEntry = this.createEntry(tool);
            _builder.append((Object)_createEntry, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _needsNodeToolEntryClass = this._utils_qvto.needsNodeToolEntryClass(it);
        if (_needsNodeToolEntryClass) {
            CharSequence _nodeToolEntry = this.nodeToolEntry(it);
            _builder.append((Object)_nodeToolEntry, "");
        }
        _builder.newLineIfNotEmpty();
        boolean _needsLinkToolEntryClass = this._utils_qvto.needsLinkToolEntryClass(it);
        if (_needsLinkToolEntryClass) {
            CharSequence _linkToolEntry = this.linkToolEntry(it);
            _builder.append((Object)_linkToolEntry, "");
        }
        _builder.newLineIfNotEmpty();
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createGroup(ToolGroup it) {
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        String _plus = "Creates \"" + _title;
        String _plus_1 = String.valueOf(_plus) + "\" palette tool group";
        CharSequence _generatedMemberComment = this._common.generatedMemberComment(_plus_1);
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private org.eclipse.gef.palette.PaletteContainer ");
        String _createMethodName = it.getCreateMethodName();
        _builder.append((Object)_createMethodName, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _newContainer = this.newContainer(it, "paletteContainer");
        _builder.append((Object)_newContainer, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _setIdentity = this.setIdentity((EntryBase)it, "paletteContainer");
        _builder.append((Object)_setIdentity, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _setDescription = this.setDescription(it, "paletteContainer");
        _builder.append((Object)_setDescription, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Palette _palette = it.getPalette();
        CharSequence _setSmallImage = this.setSmallImage((EntryBase)it, "paletteContainer", _palette);
        _builder.append((Object)_setSmallImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Palette _palette_1 = it.getPalette();
        CharSequence _setLargeImage = this.setLargeImage((EntryBase)it, "paletteContainer", _palette_1);
        _builder.append((Object)_setLargeImage, "\t");
        _builder.newLineIfNotEmpty();
        EList _entries = it.getEntries();
        for (ToolGroupItem entry : _entries) {
            _builder.append((Object)"\t");
            CharSequence _addEntry = this.addEntry(entry, "paletteContainer");
            _builder.append((Object)_addEntry, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return paletteContainer;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence newContainer(ToolGroup it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean _isCollapse = it.isCollapse();
        if (!_isCollapse) {
            _and = false;
        } else {
            boolean _isToolsOnly = it.isToolsOnly();
            boolean bl = _and = _isCollapse && _isToolsOnly;
        }
        if (_and) {
            _builder.append((Object)"org.eclipse.gef.palette.PaletteDrawer ");
            _builder.append((Object)varName, "");
            _builder.append((Object)" = new org.eclipse.gef.palette.PaletteDrawer(");
            CharSequence _i18nTitle = this.i18nTitle((EObject)it);
            _builder.append((Object)_i18nTitle, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _isStack = it.isStack();
            if (_isStack) {
                _builder.append((Object)"org.eclipse.gef.palette.PaletteStack ");
                _builder.append((Object)varName, "");
                _builder.append((Object)" = new org.eclipse.gef.palette.PaletteStack(");
                CharSequence _i18nTitle_1 = this.i18nTitle((EObject)it);
                _builder.append((Object)_i18nTitle_1, "");
                _builder.append((Object)", null, null);");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"org.eclipse.gef.palette.PaletteGroup ");
                _builder.append((Object)varName, "");
                _builder.append((Object)" = new org.eclipse.gef.palette.PaletteGroup(");
                CharSequence _i18nTitle_2 = this.i18nTitle((EObject)it);
                _builder.append((Object)_i18nTitle_2, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence setDescription(ToolGroup gr, String varName) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _description = gr.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)varName, "");
            _builder.append((Object)".setDescription(");
            CharSequence _i18nDesc = this.i18nDesc((EObject)gr);
            _builder.append((Object)_i18nDesc, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _addEntry(ToolGroupItem it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        String _plus = "abstract addEntry(ToolGroupItem,String) template for" + it;
        this._common_qvto.ERROR(_plus);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _addEntry(AbstractToolEntry it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)varName, "");
        _builder.append((Object)".add(");
        String _createMethodName = it.getCreateMethodName();
        _builder.append((Object)_createMethodName, "");
        _builder.append((Object)"());");
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        boolean _isDefault = it.isDefault();
        if (!_isDefault) {
            _and = false;
        } else {
            ToolGroup _group = it.getGroup();
            boolean _isStack = _group.isStack();
            boolean bl = _and = _isDefault && _isStack;
        }
        if (_and) {
            _builder.append((Object)varName, "");
            _builder.append((Object)".setActiveEntry((org.eclipse.gef.palette.ToolEntry) paletteContainer.getChildren().get(paletteContainer.getChildren().size() - 1));");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _addEntry(Separator it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)varName, "");
        _builder.append((Object)".add(new org.eclipse.gef.palette.PaletteSeparator());");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _addEntry(ToolGroup it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)varName, "");
        _builder.append((Object)".add(");
        String _createMethodName = it.getCreateMethodName();
        _builder.append((Object)_createMethodName, "");
        _builder.append((Object)"());");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence createEntry(AbstractToolEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private org.eclipse.gef.palette.ToolEntry ");
        String _createMethodName = it.getCreateMethodName();
        _builder.append((Object)_createMethodName, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _newEntry = this.newEntry(it, "entry");
        _builder.append((Object)_newEntry, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _setIdentity = this.setIdentity((EntryBase)it, "entry");
        _builder.append((Object)_setIdentity, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        ToolGroup _group = it.getGroup();
        Palette _palette = _group.getPalette();
        CharSequence _setSmallImage = this.setSmallImage((EntryBase)it, "entry", _palette);
        _builder.append((Object)_setSmallImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        ToolGroup _group_1 = it.getGroup();
        Palette _palette_1 = _group_1.getPalette();
        CharSequence _setLargeImage = this.setLargeImage((EntryBase)it, "entry", _palette_1);
        _builder.append((Object)_setLargeImage, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _setToolClass = this.setToolClass(it, "entry");
        _builder.append((Object)_setToolClass, "\t");
        _builder.newLineIfNotEmpty();
        EMap _properties = it.getProperties();
        for (Map.Entry prop : _properties) {
            _builder.append((Object)"\t");
            CharSequence _setToolProperty = this.setToolProperty(prop, "entry");
            _builder.append((Object)_setToolProperty, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return entry;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected String toolEntryClass(ToolEntry entry) {
        String _xifexpression = null;
        EList _genNodes = entry.getGenNodes();
        boolean _isEmpty = _genNodes.isEmpty();
        _xifexpression = _isEmpty ? "LinkToolEntry" : "NodeToolEntry";
        return _xifexpression;
    }

    protected CharSequence _newEntry(AbstractToolEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        String _plus = "abstract newEntry(AbstractToolEntry,String) template for: " + it;
        this._common_qvto.ERROR(_plus);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _newEntry(ToolEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        EList _elements = it.getElements();
        boolean _isEmpty = _elements.isEmpty();
        if (_isEmpty) {
            _builder.append((Object)"org.eclipse.gef.palette.ToolEntry ");
            _builder.append((Object)toolVarName, "");
            _builder.append((Object)" = new org.eclipse.gef.palette.ToolEntry(");
            CharSequence _i18nTitle = this.i18nTitle((EObject)it);
            _builder.append((Object)_i18nTitle, "");
            _builder.append((Object)", ");
            CharSequence _i18nDesc = this.i18nDesc((EObject)it);
            _builder.append((Object)_i18nDesc, "");
            _builder.append((Object)", null, null) {};");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _greaterThan;
            EList _elements_1 = it.getElements();
            int _size = _elements_1.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                _builder.append((Object)"java.util.ArrayList<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<org.eclipse.gmf.runtime.emf.type.core.IElementType>(");
                EList _elements_2 = it.getElements();
                int _size_1 = _elements_2.size();
                _builder.append((Object)_size_1, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                EList _elements_3 = it.getElements();
                for (GenCommonBase e : _elements_3) {
                    _builder.append((Object)"types.add(");
                    CharSequence _accessElementType = this.xptElementTypes.accessElementType(e);
                    _builder.append((Object)_accessElementType, "");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                String _olEntryClass = this.toolEntryClass(it);
                _builder.append((Object)_olEntryClass, "");
                _builder.append((Object)" ");
                _builder.append((Object)toolVarName, "");
                _builder.append((Object)" = new ");
                String _olEntryClass_1 = this.toolEntryClass(it);
                _builder.append((Object)_olEntryClass_1, "");
                _builder.append((Object)"(");
                CharSequence _i18nTitle_1 = this.i18nTitle((EObject)it);
                _builder.append((Object)_i18nTitle_1, "");
                _builder.append((Object)", ");
                CharSequence _i18nDesc_1 = this.i18nDesc((EObject)it);
                _builder.append((Object)_i18nDesc_1, "");
                _builder.append((Object)", types);");
                _builder.newLineIfNotEmpty();
            } else {
                String _olEntryClass_2 = this.toolEntryClass(it);
                _builder.append((Object)_olEntryClass_2, "");
                _builder.append((Object)" ");
                _builder.append((Object)toolVarName, "");
                _builder.append((Object)" = new ");
                String _olEntryClass_3 = this.toolEntryClass(it);
                _builder.append((Object)_olEntryClass_3, "");
                _builder.append((Object)"(");
                CharSequence _i18nTitle_2 = this.i18nTitle((EObject)it);
                _builder.append((Object)_i18nTitle_2, "");
                _builder.append((Object)", ");
                CharSequence _i18nDesc_2 = this.i18nDesc((EObject)it);
                _builder.append((Object)_i18nDesc_2, "");
                _builder.append((Object)", java.util.Collections.singletonList(");
                EList _elements_4 = it.getElements();
                GenCommonBase _head = (GenCommonBase)IterableExtensions.head((Iterable)_elements_4);
                CharSequence _accessElementType_1 = this.xptElementTypes.accessElementType(_head);
                _builder.append((Object)_accessElementType_1, "");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence _newEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        StandardEntryKind _kind = it.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)StandardEntryKind.SELECT_LITERAL);
        if (_equals) {
            CharSequence _newStdSelectEntry = this.newStdSelectEntry(it, toolVarName);
            _builder.append((Object)_newStdSelectEntry, "");
            _builder.newLineIfNotEmpty();
        } else {
            StandardEntryKind _kind_1 = it.getKind();
            boolean _equals_1 = Objects.equal((Object)_kind_1, (Object)StandardEntryKind.MARQUEE_LITERAL);
            if (_equals_1) {
                CharSequence _newStdMarqueeEntry = this.newStdMarqueeEntry(it, toolVarName);
                _builder.append((Object)_newStdMarqueeEntry, "");
                _builder.newLineIfNotEmpty();
            } else {
                StandardEntryKind _kind_2 = it.getKind();
                boolean _equals_2 = Objects.equal((Object)_kind_2, (Object)StandardEntryKind.ZOOM_LITERAL);
                if (_equals_2) {
                    CharSequence _newStdZoomEntry = this.newStdZoomEntry(it, toolVarName);
                    _builder.append((Object)_newStdZoomEntry, "");
                    _builder.newLineIfNotEmpty();
                } else {
                    CharSequence _newStdOtherEntry = this.newStdOtherEntry(it, toolVarName);
                    _builder.append((Object)_newStdOtherEntry, "");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence newStdSelectEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.gef.palette.PanningSelectionToolEntry ");
        _builder.append((Object)toolVarName, "");
        _builder.append((Object)" = new org.eclipse.gef.palette.PanningSelectionToolEntry();");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence newStdMarqueeEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.gef.palette.MarqueeToolEntry ");
        _builder.append((Object)toolVarName, "");
        _builder.append((Object)" = new org.eclipse.gef.palette.MarqueeToolEntry();");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence newStdZoomEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"FIXME");
        _builder.newLine();
        return _builder;
    }

    public CharSequence newStdOtherEntry(StandardEntry it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        StandardEntryKind _kind = it.getKind();
        String _plus = "override newStdOtherEntry(StandardEntry, String) for kind " + _kind;
        this._common_qvto.ERROR(_plus);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence setSmallImage(EntryBase it, String toolVarName, Palette palette) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _smallIconPath = it.getSmallIconPath();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_smallIconPath);
        if (_notEquals) {
            _builder.append((Object)toolVarName, "");
            _builder.append((Object)".setSmallIcon(");
            String _activatorFQN = this._utils_qvto.activatorFQN((EObject)palette);
            _builder.append((Object)_activatorFQN, "");
            _builder.append((Object)".findImageDescriptor(\"");
            String _smallIconPath_1 = it.getSmallIconPath();
            _builder.append((Object)_smallIconPath_1, "");
            _builder.append((Object)"\")); ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS, "");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it, ToolEntry.class);
            if (_oclIsKindOf) {
                boolean _notEquals_1;
                EList _elements = ((ToolEntry)it).getElements();
                GenCommonBase _head = (GenCommonBase)IterableExtensions.head((Iterable)_elements);
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_head, null);
                if (_notEquals_1) {
                    _builder.append((Object)toolVarName, "");
                    _builder.append((Object)".setSmallIcon(");
                    GenDiagram _diagram = palette.getDiagram();
                    CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(_diagram);
                    _builder.append((Object)_qualifiedClassName, "");
                    _builder.append((Object)".getImageDescriptor(");
                    EList _elements_1 = ((ToolEntry)it).getElements();
                    GenCommonBase _head_1 = (GenCommonBase)IterableExtensions.head((Iterable)_elements_1);
                    CharSequence _accessElementType = this.xptElementTypes.accessElementType(_head_1);
                    _builder.append((Object)_accessElementType, "");
                    _builder.append((Object)"));");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence setLargeImage(EntryBase it, String toolVarName, Palette palette) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _largeIconPath = it.getLargeIconPath();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_largeIconPath);
        if (_notEquals) {
            _builder.append((Object)toolVarName, "");
            _builder.append((Object)".setLargeIcon(");
            String _activatorFQN = this._utils_qvto.activatorFQN((EObject)palette);
            _builder.append((Object)_activatorFQN, "");
            _builder.append((Object)".findImageDescriptor(\"");
            String _largeIconPath_1 = it.getLargeIconPath();
            _builder.append((Object)_largeIconPath_1, "");
            _builder.append((Object)"\")); ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS, "");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it, ToolEntry.class);
            if (_oclIsKindOf) {
                boolean _notEquals_1;
                EList _elements = ((ToolEntry)it).getElements();
                GenCommonBase _head = (GenCommonBase)IterableExtensions.head((Iterable)_elements);
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_head, null);
                if (_notEquals_1) {
                    _builder.append((Object)toolVarName, "");
                    _builder.append((Object)".setLargeIcon(");
                    _builder.append((Object)toolVarName, "");
                    _builder.append((Object)".getSmallIcon());");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence setToolClass(AbstractToolEntry it, String toolVarName) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _qualifiedToolName = it.getQualifiedToolName();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_qualifiedToolName);
        if (_notEquals) {
            _builder.append((Object)toolVarName, "");
            _builder.append((Object)".setToolClass(");
            String _qualifiedToolName_1 = it.getQualifiedToolName();
            _builder.append((Object)_qualifiedToolName_1, "");
            _builder.append((Object)".class);");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence setToolProperty(Map.Entry<String, String> it, String toolVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)toolVarName, "");
        _builder.append((Object)".setToolProperty(");
        String _key = it.getKey();
        _builder.append((Object)_key, "");
        _builder.append((Object)", ");
        String _value = it.getValue();
        _builder.append((Object)_value, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    protected CharSequence _i18nTitle(ToolEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        boolean _equals = Objects.equal((Object)_title, null);
        if (_equals) {
            _builder.append((Object)"null");
        } else {
            ToolGroup _group = it.getGroup();
            Palette _palette = _group.getPalette();
            GenDiagram _diagram = _palette.getDiagram();
            GenEditorGenerator _editorGen = _diagram.getEditorGen();
            String _i18nTitleKey = this._utils_qvto.i18nTitleKey((EntryBase)it);
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen, _i18nTitleKey);
            _builder.append((Object)_accessorCall, "");
        }
        return _builder;
    }

    @Localization
    protected CharSequence _i18nTitle(ToolGroup it) {
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        boolean _equals = Objects.equal((Object)_title, null);
        if (_equals) {
            _builder.append((Object)"null");
        } else {
            Palette _palette = it.getPalette();
            GenDiagram _diagram = _palette.getDiagram();
            GenEditorGenerator _editorGen = _diagram.getEditorGen();
            String _i18nTitleKey = this._utils_qvto.i18nTitleKey((EntryBase)it);
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen, _i18nTitleKey);
            _builder.append((Object)_accessorCall, "");
        }
        return _builder;
    }

    @Localization
    protected CharSequence _i18nDesc(ToolEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        String _description = it.getDescription();
        boolean _equals = Objects.equal((Object)_description, null);
        if (_equals) {
            _builder.append((Object)"null");
        } else {
            ToolGroup _group = it.getGroup();
            Palette _palette = _group.getPalette();
            GenDiagram _diagram = _palette.getDiagram();
            GenEditorGenerator _editorGen = _diagram.getEditorGen();
            String _i18nDescKey = this._utils_qvto.i18nDescKey((EntryBase)it);
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen, _i18nDescKey);
            _builder.append((Object)_accessorCall, "");
        }
        return _builder;
    }

    @Localization
    protected CharSequence _i18nDesc(ToolGroup it) {
        StringConcatenation _builder = new StringConcatenation();
        String _description = it.getDescription();
        boolean _equals = Objects.equal((Object)_description, null);
        if (_equals) {
            _builder.append((Object)"null");
        } else {
            Palette _palette = it.getPalette();
            GenDiagram _diagram = _palette.getDiagram();
            GenEditorGenerator _editorGen = _diagram.getEditorGen();
            String _i18nDescKey = this._utils_qvto.i18nDescKey((EntryBase)it);
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen, _i18nDescKey);
            _builder.append((Object)_accessorCall, "");
        }
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<ToolGroup> _collectGroups = this._utils_qvto.collectGroups(it);
        for (ToolGroup group : _collectGroups) {
            CharSequence _internal_i18n_accessors = this.internal_i18n_accessors((EntryBase)group);
            _builder.append((Object)_internal_i18n_accessors, "");
            _builder.newLineIfNotEmpty();
        }
        Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
        for (AbstractToolEntry tool : _collectTools) {
            CharSequence _internal_i18n_accessors_1 = this.internal_i18n_accessors((EntryBase)tool);
            _builder.append((Object)_internal_i18n_accessors_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<ToolGroup> _collectGroups = this._utils_qvto.collectGroups(it);
        for (ToolGroup group : _collectGroups) {
            CharSequence _internal_i18n_values = this.internal_i18n_values((EntryBase)group);
            _builder.append((Object)_internal_i18n_values, "");
            _builder.newLineIfNotEmpty();
        }
        Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
        for (AbstractToolEntry tool : _collectTools) {
            CharSequence _internal_i18n_values_1 = this.internal_i18n_values((EntryBase)tool);
            _builder.append((Object)_internal_i18n_values_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Localization
    protected CharSequence internal_i18n_accessors(EntryBase it) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_title);
        if (_notEquals) {
            String _i18nTitleKey = this._utils_qvto.i18nTitleKey(it);
            CharSequence _accessorField = this.xptExternalizer.accessorField(_i18nTitleKey);
            _builder.append((Object)_accessorField, "");
        }
        _builder.newLineIfNotEmpty();
        String _description = it.getDescription();
        boolean bl2 = _notEquals_1 = !Objects.equal(null, (Object)_description);
        if (_notEquals_1) {
            String _i18nDescKey = this._utils_qvto.i18nDescKey(it);
            CharSequence _accessorField_1 = this.xptExternalizer.accessorField(_i18nDescKey);
            _builder.append((Object)_accessorField_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    protected CharSequence internal_i18n_values(EntryBase it) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _title = it.getTitle();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_title);
        if (_notEquals) {
            String _i18nTitleKey = this._utils_qvto.i18nTitleKey(it);
            String _title_1 = it.getTitle();
            CharSequence _messageEntry = this.xptExternalizer.messageEntry(_i18nTitleKey, _title_1);
            _builder.append((Object)_messageEntry, "");
        }
        _builder.newLineIfNotEmpty();
        String _description = it.getDescription();
        boolean bl2 = _notEquals_1 = !Objects.equal(null, (Object)_description);
        if (_notEquals_1) {
            String _i18nDescKey = this._utils_qvto.i18nDescKey(it);
            String _description_1 = it.getDescription();
            CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(_i18nDescKey, _description_1);
            _builder.append((Object)_messageEntry_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence cleanStandardToolsHack(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Workaround for https://bugs.eclipse.org/bugs/show_bug.cgi?id=159289");
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private void cleanStandardTools(org.eclipse.gef.palette.PaletteRoot paletteRoot) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (java.util.Iterator it = paletteRoot.getChildren().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gef.palette.PaletteEntry entry = (org.eclipse.gef.palette.PaletteEntry) it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (!\"standardGroup\".equals(entry.getId())) { ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"continue;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator it2 = ((org.eclipse.gef.palette.PaletteContainer) entry).getChildren().iterator(); it2.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.gef.palette.PaletteEntry entry2 = (org.eclipse.gef.palette.PaletteEntry) it2.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (\"zoomTool\".equals(entry2.getId())) { ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"it2.remove();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else if (\"noteStack\".equals(entry2.getId())) { ");
        CharSequence _nonNLS_2 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_2, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"it2.remove();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else if (\"selectionTool\".equals(entry2.getId())) { ");
        CharSequence _nonNLS_3 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_3, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"it2.remove();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (paletteRoot.getDefaultEntry() == entry2) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"paletteRoot.setDefaultEntry(null);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence nodeToolEntry(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static class NodeToolEntry extends org.eclipse.gef.palette.ToolEntry {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> elementTypes;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private NodeToolEntry(String title, String description, java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> elementTypes) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"super(title, description, null, null);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.elementTypes = elementTypes;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public org.eclipse.gef.Tool createTool() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gef.Tool tool = new org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool(elementTypes);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"tool.setProperties(getToolProperties());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return tool;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence linkToolEntry(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static class LinkToolEntry extends org.eclipse.gef.palette.ToolEntry {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> relationshipTypes;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private LinkToolEntry(String title, String description, java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> relationshipTypes) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"super(title, description, null, null);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.relationshipTypes = relationshipTypes;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public org.eclipse.gef.Tool createTool() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gef.Tool tool = new org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeConnectionTool(relationshipTypes);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"tool.setProperties(getToolProperties());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return tool;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setIdentity(EntryBase it, String toolVarName) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _id = it.getId();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_id);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)toolVarName, "");
            _builder.append((Object)".setId(");
            String _id_1 = it.getId();
            _builder.append((Object)_id_1, "");
            _builder.append((Object)");");
            boolean _and = false;
            String _id_2 = it.getId();
            boolean _startsWith = _id_2.startsWith("\"");
            if (!_startsWith) {
                _and = false;
            } else {
                String _id_3 = it.getId();
                boolean _endsWith = _id_3.endsWith("\"");
                boolean bl2 = _and = _startsWith && _endsWith;
            }
            if (_and) {
                _builder.append((Object)" ");
                CharSequence _nonNLS = this._common.nonNLS(1);
                _builder.append((Object)_nonNLS, "");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence additions(Palette it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence addEntry(ToolGroupItem it, String varName) {
        if (it instanceof AbstractToolEntry) {
            return this._addEntry((AbstractToolEntry)it, varName);
        }
        if (it instanceof Separator) {
            return this._addEntry((Separator)it, varName);
        }
        if (it instanceof ToolGroup) {
            return this._addEntry((ToolGroup)it, varName);
        }
        if (it != null) {
            return this._addEntry(it, varName);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, varName).toString());
    }

    public CharSequence newEntry(AbstractToolEntry it, String toolVarName) {
        if (it instanceof StandardEntry) {
            return this._newEntry((StandardEntry)it, toolVarName);
        }
        if (it instanceof ToolEntry) {
            return this._newEntry((ToolEntry)it, toolVarName);
        }
        if (it != null) {
            return this._newEntry(it, toolVarName);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, toolVarName).toString());
    }

    public CharSequence i18nTitle(EObject it) {
        if (it instanceof ToolEntry) {
            return this._i18nTitle((ToolEntry)it);
        }
        if (it instanceof ToolGroup) {
            return this._i18nTitle((ToolGroup)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence i18nDesc(EObject it) {
        if (it instanceof ToolEntry) {
            return this._i18nDesc((ToolEntry)it);
        }
        if (it instanceof ToolGroup) {
            return this._i18nDesc((ToolGroup)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

