/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.gmf.internal.xpand.Activator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EPackageRegistryBasedURIResourceMap
extends HashMap<URI, Resource> {
    private static final long serialVersionUID = -3716798352459745813L;
    private URIConverter uriConverter;
    private SAXParser parser;

    public EPackageRegistryBasedURIResourceMap(URIConverter uriConverter) {
        this.uriConverter = uriConverter;
    }

    @Override
    public Resource get(Object key) {
        if (this.containsKey(key)) {
            return (Resource)super.get(key);
        }
        if (key instanceof URI) {
            this.initializePlatformPluginToRegistryMapEntry((URI)key);
        }
        return (Resource)super.get(key);
    }

    private void initializePlatformPluginToRegistryMapEntry(URI uri) {
        if (!uri.isPlatformPlugin()) {
            return;
        }
        try {
            Handler handler = new Handler();
            try {
                this.getParser().parse(new InputSource(this.uriConverter.createInputStream(uri)), (DefaultHandler)handler);
            }
            catch (SAXException sAXException) {
                if (handler.getNsURI() != null && EPackage.Registry.INSTANCE.getEPackage(handler.getNsURI()) != null) {
                    this.put(uri, EPackage.Registry.INSTANCE.getEPackage(handler.getNsURI()).eResource());
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException e) {
            Activator.logError(e);
        }
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.parser == null) {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        return this.parser;
    }

    private class Handler
    extends DefaultHandler {
        private String nsURI;

        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("EPackage".equals(localName) && "http://www.eclipse.org/emf/2002/Ecore".equals(uri)) {
                this.nsURI = attributes.getValue("nsURI");
            }
            throw new SAXException("Done");
        }

        public String getNsURI() {
            return this.nsURI;
        }
    }
}

