/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ManifestUtil {
    private static final String defaultManifestContent = "Manifest-Version: 1.0\nBundle-ManifestVersion: 2\nBundle-Version: 2.9.0.qualifier\nBundle-Activator: org.eclipse.gmf.codegen.util.Activator\nBundle-RequiredExecutionEnvironment: JavaSE-1.6\nRequire-Bundle: org.eclipse.gmf.codegen";

    public static void createOrFillManifest(IProject project) {
        try {
            IFile manifest2 = project.getFile("META-INF/MANIFEST.MF");
            if (!manifest2.exists()) {
                ManifestUtil.createManifest(manifest2);
                return;
            }
            BufferedReader manifestStream = new BufferedReader(new InputStreamReader(manifest2.getContents(), manifest2.getCharset()));
            StringBuilder manifestContent = ManifestUtil.checkRequiredBundles(manifestStream);
            manifest2.setContents((InputStream)new ByteArrayInputStream(manifestContent.toString().getBytes(manifest2.getCharset())), true, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException("Cannot create or read mainfest file in " + project.getName(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get project " + project.getName() + " ready to be started as bundle", ex);
        }
    }

    public static void createManifest(IFile file) throws CoreException {
        StringBuilder manifestContent = new StringBuilder(defaultManifestContent);
        String projectName = file.getProject().getName();
        manifestContent.append("Bundle-Name: " + projectName + "\n");
        manifestContent.append("Bundle-SymbolicName: " + projectName + "\n");
        manifestContent.append("Bundle-ClassPath: bin/, .\n");
        manifestContent.append("Bundle-Activator: org.eclipse.gmf.codegen.util.DefaultActivator\n");
        ByteArrayInputStream manifestInputStream = new ByteArrayInputStream(manifestContent.toString().getBytes());
        file.create((InputStream)manifestInputStream, false, null);
    }

    public static StringBuilder checkRequiredBundles(BufferedReader manifestStream) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        boolean foundClassPath = false;
        boolean foundActivator = false;
        while ((line = manifestStream.readLine()) != null) {
            result.append(line);
            if (!foundClassPath && line.startsWith("Bundle-ClassPath:")) {
                if (!Arrays.asList(line.split(",\\s*")).contains("bin/")) {
                    result.append(", bin/");
                }
                foundClassPath = true;
            }
            if (!foundActivator && line.contains("Bundle-Activator:")) {
                foundActivator = true;
            }
            result.append("\n");
        }
        if (!foundClassPath) {
            result.insert(0, "Bundle-ClassPath: bin/, .\n");
        }
        if (!foundActivator) {
            result.insert(0, "Bundle-Activator: org.eclipse.gmf.codegen.util.DefaultActivator\n");
        }
        return result;
    }
}

