/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate.expressions;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;

public class EnvironmentProvider {
    private EnvironmentProvider() {
    }

    public static IParseEnvironment createParseEnv() {
        return new EnvImpl();
    }

    public static IEvaluationEnvironment createEvaluationEnv() {
        return new EvalEnvImpl();
    }

    private static class EnvImpl
    extends HashMap<String, EClassifier>
    implements IParseEnvironment {
        private static final long serialVersionUID = 5282996418130231176L;
        private EPackage.Registry importReg;

        EnvImpl() {
            super(5);
        }

        @Override
        public void setVariable(String name, EClassifier type) {
            if (type == null || type.getName() == null) {
                throw new IllegalArgumentException("Invalid EClassifier passed:" + type);
            }
            if (name == null) {
                throw new IllegalArgumentException("null variable name passed");
            }
            this.put(name, type);
        }

        @Override
        public EClassifier getTypeOf(String name) {
            return (EClassifier)this.get(name);
        }

        @Override
        public Set<String> getVariableNames() {
            return this.keySet();
        }

        @Override
        public void clear() {
            super.clear();
            this.importReg = null;
        }

        @Override
        public EPackage.Registry getImportRegistry() {
            return this.importReg;
        }

        @Override
        public void setImportRegistry(EPackage.Registry importReg) {
            this.importReg = importReg;
        }
    }

    private static class EvalEnvImpl
    extends HashMap<String, Object>
    implements IEvaluationEnvironment {
        private static final long serialVersionUID = 9087665669257460401L;

        EvalEnvImpl() {
            super(5);
        }

        @Override
        public void setVariable(String name, Object value) {
            this.put(name, value);
        }

        @Override
        public Object getValueOf(String name) {
            return this.get(name);
        }

        @Override
        public Set<String> getVariableNames() {
            return this.keySet();
        }

        @Override
        public void clear() {
            super.clear();
        }
    }
}

