/**
 * Copyright (c) 2006, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package impl.diagram.editparts

import com.google.inject.Inject
import org.eclipse.gmf.codegen.gmfgen.GenDiagram
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel
import xpt.Common
import xpt.diagram.ViewmapAttributesUtils_qvto
import xpt.editor.VisualIDRegistry
import xpt.diagram.editpolicies.TextSelectionEditPolicy

@com.google.inject.Singleton class LinkLabelEditPart {
	@Inject extension Common;
	@Inject extension ViewmapAttributesUtils_qvto;

	@Inject xpt.diagram.editparts.Common xptEditpartsCommon;
	@Inject VisualIDRegistry xptVisualIDRegistry;
	@Inject TextSelectionEditPolicy textSelection;

	def className(GenLinkLabel it) '''«editPartClassName»'''

	def packageName(GenLinkLabel it) '''«getDiagram().editPartsPackageName»'''

	def initializer(GenLinkLabel it) '''
		«generatedMemberComment»
		static {
			registerSnapBackPosition(«xptVisualIDRegistry.typeMethodCall(it)», new org.eclipse.draw2d.geometry.Point(«labelOffsetX(viewmap, 0)», «labelOffsetY(viewmap, 0)»));
		}
	'''

	def constructor(GenLinkLabel it) '''
		«generatedMemberComment»
		public «className(it)»(org.eclipse.gmf.runtime.notation.View view) {
			super(view);
		}
	'''

	def createDefaultEditPoliciesBody(GenLinkLabel it) '''
		super.createDefaultEditPolicies();
		installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());
		installEditPolicy(org.eclipse.gef.EditPolicy.SELECTION_FEEDBACK_ROLE, new «textSelection.qualifiedClassName(getDiagram())»());
		installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE,	new «linkLabelDragPolicyQualifiedClassName(
			it.getDiagram())»());
		«xptEditpartsCommon.behaviour(it)»
		«additionalEditPolicies(it)»
	'''


	def additionalEditPolicies(GenLinkLabel it) ''''''

	def getKeyPoint(GenLinkLabel it) '''
		«generatedMemberComment»
		public int getKeyPoint() {
			return org.eclipse.draw2d.ConnectionLocator.«alignment»;
		}
	'''

	def handleNotificationEventBody(GenLinkLabel it) '''
		Object feature = event.getFeature();
		«xptEditpartsCommon.handleText(it)»
		super.handleNotificationEvent(event);
	'''

	/**
 * since 3.1, old generated NodeLabelDragPolicy extracted to GMFT-runtime, 
 * see org.eclipse.gmf.tooling.runtime.edit.policies.DefaultNodeLabelDragPolicy.
 * The next 2 DEFINE's are left here as a hook for possible AROUND's
 */
	def linkLabelDragPolicyQualifiedClassName(GenDiagram it) '''org.eclipse.gmf.tooling.runtime.edit.policies.DefaultLinkLabelDragPolicy'''

	def linkLabelDragPolicyClass(GenDiagram it) '''«/*not generated by default anymore */»'''
}
