/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.internal.bridge.wizards.pages.ToolDefSupplier;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.ToolContainer;
import org.eclipse.gmf.tooldef.ToolRegistry;

public class ToolDefLookup
implements ToolDefSupplier {
    private final ToolRegistry myRegistry;
    private final ToolContainer myNodeTools;
    private final ToolContainer myLinkTools;
    private final boolean sameToolContainer;
    private int myNodeUseIndex = 0;
    private int myLinkUseIndex = 0;

    public ToolDefLookup(ToolRegistry registry) {
        ToolContainer t;
        assert (registry != null && registry.getPalette() != null);
        this.myRegistry = registry;
        EList tools = this.myRegistry.getPalette().getTools();
        int i = tools.size();
        boolean found = false;
        while (!found && i > 0) {
            if (!(tools.get(--i) instanceof ToolContainer)) continue;
            t = (ToolContainer)tools.get(i);
            boolean bl = found = t.getTools().size() > 0;
        }
        if (!found) {
            this.myNodeTools = this.myLinkTools = this.myRegistry.getPalette();
            this.sameToolContainer = true;
            return;
        }
        this.myLinkTools = (ToolContainer)tools.get(i);
        found = false;
        while (i > 0 && !found) {
            if (!(tools.get(--i) instanceof ToolContainer)) continue;
            t = (ToolContainer)tools.get(i);
            boolean bl = found = t.getTools().size() > 0;
        }
        if (!found) {
            this.myNodeTools = this.myLinkTools;
            this.sameToolContainer = true;
        } else {
            this.sameToolContainer = false;
            this.myNodeTools = (ToolContainer)tools.get(i);
        }
    }

    @Override
    public AbstractTool findTool(NodeMapping nm) {
        int nodeToolsLen = this.myNodeTools.getTools().size();
        int i = 0;
        while (i < nodeToolsLen) {
            Object next = this.myNodeTools.getTools().get((this.myNodeUseIndex + i) % nodeToolsLen);
            if (this.isTool(next)) {
                this.myNodeUseIndex = (this.myNodeUseIndex + i + 1) % nodeToolsLen;
                if (this.sameToolContainer) {
                    this.myLinkUseIndex = this.myNodeUseIndex;
                }
                return (AbstractTool)next;
            }
            ++i;
        }
        return null;
    }

    @Override
    public AbstractTool findTool(LinkMapping lm) {
        int linkToolsLen = this.myLinkTools.getTools().size();
        int i = 0;
        while (i < linkToolsLen) {
            Object next = this.myLinkTools.getTools().get((this.myLinkUseIndex + i) % linkToolsLen);
            if (this.isTool(next)) {
                this.myLinkUseIndex = (this.myLinkUseIndex + i + 1) % linkToolsLen;
                if (this.sameToolContainer) {
                    this.myNodeUseIndex = this.myLinkUseIndex;
                }
                return (AbstractTool)next;
            }
            ++i;
        }
        return null;
    }

    private boolean isTool(Object next) {
        return next instanceof CreationTool;
    }
}

