/*
 * Decompiled with CFR 0.152.
 */
package xpt.diagram.updater;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Set;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramUpdater;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.GenModelUtils_qvto;
import xpt.diagram.updater.LinkDescriptor;
import xpt.diagram.updater.NodeDescriptor;
import xpt.diagram.updater.UpdaterLinkType;
import xpt.diagram.updater.Utils_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.providers.ElementTypes;

@Singleton
public class DiagramUpdater {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    @Extension
    private GenModelUtils_qvto _genModelUtils_qvto;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private ElementTypes xptElementTypes;
    @Inject
    private CodeStyle xptCodeStyle;
    @Inject
    private NodeDescriptor nodeDescriptor;
    @Inject
    private LinkDescriptor linkDescriptor;

    @MetaDef
    public CharSequence getSemanticChildrenMethodName(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _uniqueIdentifier = it.getUniqueIdentifier();
        _builder.append((Object)_uniqueIdentifier, "");
        _builder.append((Object)"SemanticChildren");
        return _builder;
    }

    @MetaDef
    public CharSequence getSemanticChildrenMethodCall(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagram _diagram = it.getDiagram();
        GenEditorGenerator _editorGen = _diagram.getEditorGen();
        GenDiagramUpdater _diagramUpdater = _editorGen.getDiagramUpdater();
        CharSequence _qualifiedClassName = this.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _semanticChildrenMethodName = this.getSemanticChildrenMethodName(it);
        _builder.append((Object)_semanticChildrenMethodName, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getContainedLinksMethodCall(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _doGetSomeLinksMethodCall = this.doGetSomeLinksMethodCall(it, UpdaterLinkType.CONTAINED);
        _builder.append((Object)_doGetSomeLinksMethodCall, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getIncomingLinksMethodCall(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _doGetSomeLinksMethodCall = this.doGetSomeLinksMethodCall(it, UpdaterLinkType.INCOMING);
        _builder.append((Object)_doGetSomeLinksMethodCall, "");
        return _builder;
    }

    @MetaDef
    public CharSequence getOutgoingLinksMethodCall(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _doGetSomeLinksMethodCall = this.doGetSomeLinksMethodCall(it, UpdaterLinkType.OUTGOING);
        _builder.append((Object)_doGetSomeLinksMethodCall, "");
        return _builder;
    }

    @MetaDef
    protected CharSequence doGetSomeLinksMethodCall(GenCommonBase it, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagram _diagram = it.getDiagram();
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)_diagram);
        CharSequence _qualifiedClassName = this.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _linkGetterName = this.linkGetterName(it, linkType);
        _builder.append((Object)_linkGetterName, "");
        return _builder;
    }

    @MetaDef
    protected CharSequence linkGetterName(GenCommonBase it, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _uniqueIdentifier = it.getUniqueIdentifier();
        _builder.append((Object)_uniqueIdentifier, "");
        String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
        _builder.append((Object)_linkMethodSuffix, "");
        _builder.append((Object)"Links");
        return _builder;
    }

    @MetaDef
    public CharSequence runtimeTypedInstanceName(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"TYPED_INSTANCE");
        return _builder;
    }

    @MetaDef
    public CharSequence runtimeTypedInstanceCall(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".");
        CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
        _builder.append((Object)_runtimeTypedInstanceName, "");
        return _builder;
    }

    public CharSequence className(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        String _diagramUpdaterClassName = it.getDiagramUpdaterClassName();
        _builder.append((Object)_diagramUpdaterClassName, "");
        return _builder;
    }

    public CharSequence packageName(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenEditorView _editor = _editorGen.getEditor();
        String _packageName = _editor.getPackageName();
        _builder.append((Object)_packageName, "");
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        return _builder;
    }

    public CharSequence fullPath(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    public CharSequence DiagramUpdater(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        CharSequence _copyright = this._common.copyright(_editorGen);
        _builder.append((Object)_copyright, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _isShortcutOrphaned = this.isShortcutOrphaned(it);
        _builder.append((Object)_isShortcutOrphaned, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenDiagram _diagram = _editorGen_1.getDiagram();
        EList _allContainers = _diagram.getAllContainers();
        Functions.Function1<GenContainerBase, Boolean> _function = new Functions.Function1<GenContainerBase, Boolean>(){

            public Boolean apply(GenContainerBase container) {
                return DiagramUpdater.this._utils_qvto.hasSemanticChildren(container);
            }
        };
        Iterable semanticContainers = IterableExtensions.filter((Iterable)_allContainers, (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _genericSemanticChildrenOfView = this.getGenericSemanticChildrenOfView(it, semanticContainers);
        _builder.append((Object)_genericSemanticChildrenOfView, "\t");
        _builder.newLineIfNotEmpty();
        for (GenContainerBase next : semanticContainers) {
            _builder.append((Object)"\t");
            CharSequence _semanticChildrenOfView = this.getSemanticChildrenOfView(next);
            _builder.append((Object)_semanticChildrenOfView, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _phantomNodesIterator = this.getPhantomNodesIterator(it);
        _builder.append((Object)_phantomNodesIterator, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        GenDiagram _diagram_1 = _editorGen_2.getDiagram();
        Iterable<GenCommonBase> _allSemanticElements = this._utils_qvto.getAllSemanticElements(_diagram_1);
        CharSequence _genericConnectedLinks = this.getGenericConnectedLinks(it, _allSemanticElements, UpdaterLinkType.CONTAINED);
        _builder.append((Object)_genericConnectedLinks, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen_3 = it.getEditorGen();
        GenDiagram _diagram_2 = _editorGen_3.getDiagram();
        Iterable<GenLinkEnd> _allSemanticDiagramElements = this._utils_qvto.getAllSemanticDiagramElements(_diagram_2);
        CharSequence _genericConnectedLinks_1 = this.getGenericConnectedLinks(it, _allSemanticDiagramElements, UpdaterLinkType.INCOMING);
        _builder.append((Object)_genericConnectedLinks_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen_4 = it.getEditorGen();
        GenDiagram _diagram_3 = _editorGen_4.getDiagram();
        Iterable<GenLinkEnd> _allSemanticDiagramElements_1 = this._utils_qvto.getAllSemanticDiagramElements(_diagram_3);
        CharSequence _genericConnectedLinks_2 = this.getGenericConnectedLinks(it, _allSemanticDiagramElements_1, UpdaterLinkType.OUTGOING);
        _builder.append((Object)_genericConnectedLinks_2, "\t");
        _builder.newLineIfNotEmpty();
        GenEditorGenerator _editorGen_5 = it.getEditorGen();
        GenDiagram _diagram_4 = _editorGen_5.getDiagram();
        Iterable<GenCommonBase> _allSemanticElements_1 = this._utils_qvto.getAllSemanticElements(_diagram_4);
        for (GenCommonBase e : _allSemanticElements_1) {
            _builder.append((Object)"\t");
            CharSequence _containedLinks = this.getContainedLinks(e);
            _builder.append((Object)_containedLinks, "\t");
            _builder.newLineIfNotEmpty();
        }
        GenEditorGenerator _editorGen_6 = it.getEditorGen();
        GenDiagram _diagram_5 = _editorGen_6.getDiagram();
        Iterable<GenLinkEnd> _allSemanticDiagramElements_2 = this._utils_qvto.getAllSemanticDiagramElements(_diagram_5);
        for (GenLinkEnd e_1 : _allSemanticDiagramElements_2) {
            _builder.append((Object)"\t");
            CharSequence _incomingLinks = this.getIncomingLinks(e_1);
            _builder.append((Object)_incomingLinks, "\t");
            _builder.newLineIfNotEmpty();
        }
        GenEditorGenerator _editorGen_7 = it.getEditorGen();
        GenDiagram _diagram_6 = _editorGen_7.getDiagram();
        Iterable<GenLinkEnd> _allSemanticDiagramElements_3 = this._utils_qvto.getAllSemanticDiagramElements(_diagram_6);
        for (GenLinkEnd e_2 : _allSemanticDiagramElements_3) {
            _builder.append((Object)"\t");
            CharSequence _outgoingLinks = this.getOutgoingLinks(e_2);
            _builder.append((Object)_outgoingLinks, "\t");
            _builder.newLineIfNotEmpty();
        }
        GenEditorGenerator _editorGen_8 = it.getEditorGen();
        GenDiagram _diagram_7 = _editorGen_8.getDiagram();
        Iterable<GenLink> _allContainedLinks = this._utils_qvto.getAllContainedLinks(_diagram_7);
        for (GenLink link : _allContainedLinks) {
            _builder.append((Object)"\t");
            CharSequence _containedLinksByTypeMethod = this.getContainedLinksByTypeMethod(link);
            _builder.append((Object)_containedLinksByTypeMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        GenEditorGenerator _editorGen_9 = it.getEditorGen();
        GenDiagram _diagram_8 = _editorGen_9.getDiagram();
        Iterable<GenLink> _allIncomingLinks = this._utils_qvto.getAllIncomingLinks(_diagram_8);
        for (GenLink link_1 : _allIncomingLinks) {
            _builder.append((Object)"\t");
            CharSequence _incomingLinksByTypeMethod = this.getIncomingLinksByTypeMethod(link_1);
            _builder.append((Object)_incomingLinksByTypeMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        GenEditorGenerator _editorGen_10 = it.getEditorGen();
        GenDiagram _diagram_9 = _editorGen_10.getDiagram();
        Iterable<GenLink> _allOutgoingLinks = this._utils_qvto.getAllOutgoingLinks(_diagram_9);
        for (GenLink link_2 : _allOutgoingLinks) {
            _builder.append((Object)"\t");
            CharSequence _outgoingLinksByTypeMethod = this.getOutgoingLinksByTypeMethod(link_2);
            _builder.append((Object)_outgoingLinksByTypeMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _runtimeTypedInstance = this.runtimeTypedInstance(it);
        _builder.append((Object)_runtimeTypedInstance, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isShortcutOrphaned(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenDiagram _diagram = _editorGen.getDiagram();
        EList _containsShortcutsTo = _diagram.getContainsShortcutsTo();
        boolean _notEmpty = this._common_qvto.notEmpty(_containsShortcutsTo);
        if (_notEmpty) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public static boolean isShortcutOrphaned(org.eclipse.gmf.runtime.notation.View view) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return !view.isSetElement() || view.getElement() == null || view.getElement().eIsProxy();");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected GenDiagramUpdater diagramUpdater(GenCommonBase base) {
        GenDiagram _diagram = base.getDiagram();
        GenEditorGenerator _editorGen = _diagram.getEditorGen();
        return _editorGen.getDiagramUpdater();
    }

    protected CharSequence nodeDescriptorQualifiedClassName(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater(it);
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    protected CharSequence linkDescriptorQualifiedClassName(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater(it);
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    protected CharSequence _listOfNodeDescriptors(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.List<");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)">");
        return _builder;
    }

    protected CharSequence _listOfNodeDescriptors(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater(it);
        CharSequence _listOfNodeDescriptors = this.listOfNodeDescriptors((EObject)_diagramUpdater);
        _builder.append((Object)_listOfNodeDescriptors, "");
        return _builder;
    }

    protected CharSequence _listOfLinkDescriptors(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.List<");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)">");
        return _builder;
    }

    protected CharSequence _listOfLinkDescriptors(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater(it);
        CharSequence _listOfLinkDescriptors = this.listOfLinkDescriptors((EObject)_diagramUpdater);
        _builder.append((Object)_listOfLinkDescriptors, "");
        return _builder;
    }

    protected CharSequence newEmptyList() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.Collections.emptyList()");
        return _builder;
    }

    protected CharSequence newLinkedListOfNodeDescriptors(GenDiagramUpdater it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.LinkedList<");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)"> result = new java.util.LinkedList<");
        String _nodeDescriptorQualifiedClassName = it.getNodeDescriptorQualifiedClassName();
        _builder.append((Object)_nodeDescriptorQualifiedClassName, "");
        _builder.append((Object)">");
        return _builder;
    }

    protected CharSequence newLinkedListOfLinkDescriptors(GenDiagramUpdater it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.LinkedList<");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)"> result = new java.util.LinkedList<");
        String _linkDescriptorQualifiedClassName = it.getLinkDescriptorQualifiedClassName();
        _builder.append((Object)_linkDescriptorQualifiedClassName, "");
        _builder.append((Object)">");
        return _builder;
    }

    protected CharSequence typeOfCrossReferenceMap() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.Map<org.eclipse.emf.ecore.EObject, java.util.Collection<org.eclipse.emf.ecore.EStructuralFeature.Setting>>");
        return _builder;
    }

    public CharSequence getGenericSemanticChildrenOfView(GenDiagramUpdater it, Iterable<GenContainerBase> semanticContainers) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static ");
        CharSequence _listOfNodeDescriptors = this.listOfNodeDescriptors((EObject)it);
        _builder.append((Object)_listOfNodeDescriptors, "");
        _builder.append((Object)" getSemanticChildren(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(semanticContainers);
        if (_notEmpty) {
            _builder.append((Object)"\t");
            _builder.append((Object)"switch (");
            GenEditorGenerator _editorGen = it.getEditorGen();
            GenDiagram _diagram = _editorGen.getDiagram();
            CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(_diagram);
            _builder.append((Object)_visualIDMethodCall, "\t");
            _builder.append((Object)"(view)) {");
            _builder.newLineIfNotEmpty();
            for (GenContainerBase next : semanticContainers) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _semanticChildrenCase = this.getSemanticChildrenCase(next);
                _builder.append((Object)_semanticChildrenCase, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append((Object)_newEmptyList, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getSemanticChildrenCase(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID((GenCommonBase)it);
        _builder.append((Object)_caseVisualID, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _semanticChildrenMethodName = this.getSemanticChildrenMethodName(it);
        _builder.append((Object)_semanticChildrenMethodName, "\t");
        _builder.append((Object)"(view);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getSemanticChildrenOfView(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static ");
        CharSequence _listOfNodeDescriptors = this.listOfNodeDescriptors((EObject)it);
        _builder.append((Object)_listOfNodeDescriptors, "");
        _builder.append((Object)" ");
        CharSequence _semanticChildrenMethodName = this.getSemanticChildrenMethodName(it);
        _builder.append((Object)_semanticChildrenMethodName, "");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        boolean _or = false;
        Set<GenFeature> _semanticChildrenChildFeatures = this._utils_qvto.getSemanticChildrenChildFeatures(it);
        boolean _notEmpty = this._common_qvto.notEmpty(_semanticChildrenChildFeatures);
        if (_notEmpty) {
            _or = true;
        } else {
            boolean _notEmpty_1;
            Iterable<GenNode> _phantomNodes = this._utils_qvto.getPhantomNodes(it);
            _or = _notEmpty_1 = this._common_qvto.notEmpty(_phantomNodes);
        }
        if (_or) {
            _builder.append((Object)"\t");
            CharSequence _defineModelElement = this.defineModelElement(it);
            _builder.append((Object)_defineModelElement, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)it);
            CharSequence _newLinkedListOfNodeDescriptors = this.newLinkedListOfNodeDescriptors(_diagramUpdater, "result");
            _builder.append((Object)_newLinkedListOfNodeDescriptors, "\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            Set<GenFeature> _semanticChildrenChildFeatures_1 = this._utils_qvto.getSemanticChildrenChildFeatures(it);
            for (GenFeature childMetaFeature : _semanticChildrenChildFeatures_1) {
                boolean _equals = Objects.equal(null, (Object)childMetaFeature);
                if (_equals) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"{ \t/*FIXME no containment/child feature found in the genmodel, toolsmith need to specify Class here manually*/ childElement = ");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"/*FIXME no containment/child feature found in the genmodel, toolsmith need to specify correct one here manually*/;");
                    _builder.newLine();
                } else {
                    boolean _isListType = childMetaFeature.isListType();
                    if (_isListType) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"for (java.util.Iterator<?> it = ");
                        GenClass _modelElementType = this._utils_qvto.getModelElementType(it);
                        CharSequence _featureValue = this.xptMetaModel.getFeatureValue(childMetaFeature, "modelElement", _modelElementType);
                        _builder.append((Object)_featureValue, "\t");
                        _builder.append((Object)".iterator(); it.hasNext();) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        GenClass _typeGenClass = childMetaFeature.getTypeGenClass();
                        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)_typeGenClass, "childElement", "it.next()", true);
                        _builder.append((Object)_DeclareAndAssign, "\t");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"{ ");
                        GenClass _typeGenClass_1 = childMetaFeature.getTypeGenClass();
                        GenClass _modelElementType_1 = this._utils_qvto.getModelElementType(it);
                        CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(_typeGenClass_1, "childElement", "modelElement", _modelElementType_1, childMetaFeature);
                        _builder.append((Object)_DeclareAndAssign_1, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"int visualID = ");
                GenDiagram _diagram = it.getDiagram();
                CharSequence _nodeVisualIDMethodCall = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(_diagram);
                _builder.append((Object)_nodeVisualIDMethodCall, "\t\t");
                _builder.append((Object)"(view, ");
                GenClass _typeGenClass_2 = childMetaFeature.getTypeGenClass();
                CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_typeGenClass_2, "childElement");
                _builder.append((Object)_DowncastToEObject, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                Iterable<GenNode> _semanticChildren = this._utils_qvto.getSemanticChildren(it, childMetaFeature);
                for (GenNode next : _semanticChildren) {
                    boolean _isListType_1;
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    boolean _and = false;
                    boolean _notEquals = !Objects.equal(null, (Object)childMetaFeature);
                    _and = !_notEquals ? false : (_isListType_1 = childMetaFeature.isListType());
                    CharSequence _checkChildElementVisualID = this.checkChildElementVisualID(next, _and);
                    _builder.append((Object)_checkChildElementVisualID, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            Iterable<GenNode> _phantomNodes_1 = this._utils_qvto.getPhantomNodes(it);
            boolean _notEmpty_2 = this._common_qvto.notEmpty(_phantomNodes_1);
            if (_notEmpty_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource resource = modelElement.eResource();");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.EObject> it = getPhantomNodesIterator(resource); it.hasNext();) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"org.eclipse.emf.ecore.EObject childElement = it.next();");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"if (childElement == modelElement) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"continue;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                Iterable<GenNode> _phantomNodes_2 = this._utils_qvto.getPhantomNodes(it);
                for (GenNode phantom : _phantomNodes_2) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _addNextIfPhantom = this.addNextIfPhantom(phantom);
                    _builder.append((Object)_addNextIfPhantom, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"return result;");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            CharSequence _newEmptyList = this.newEmptyList();
            _builder.append((Object)_newEmptyList, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _defineModelElement(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (!view.isSetElement()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append((Object)_newEmptyList, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        GenClass _modelElementType = this._utils_qvto.getModelElementType(it);
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(_modelElementType, "modelElement", "view.getElement()");
        _builder.append((Object)_DeclareAndAssign, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _defineModelElement(GenCompartment it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (false == view.eContainer() instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append((Object)_newEmptyList, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View containerView = (org.eclipse.gmf.runtime.notation.View) view.eContainer();");
        _builder.newLine();
        _builder.append((Object)"if (!containerView.isSetElement()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _newEmptyList_1 = this.newEmptyList();
        _builder.append((Object)_newEmptyList_1, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        GenClass _modelElementType = this._utils_qvto.getModelElementType((GenContainerBase)it);
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(_modelElementType, "modelElement", "containerView.getElement()");
        _builder.append((Object)_DeclareAndAssign, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence checkChildElementVisualID(GenNode it, Boolean inLoop) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (visualID == ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"result.add(new ");
        GenDiagram _diagram = it.getDiagram();
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)_diagram);
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)"(");
        TypeModelFacet _modelFacet = it.getModelFacet();
        GenFeature _childMetaFeature = _modelFacet.getChildMetaFeature();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_childMetaFeature);
        if (_notEquals) {
            TypeModelFacet _modelFacet_1 = it.getModelFacet();
            GenFeature _childMetaFeature_1 = _modelFacet_1.getChildMetaFeature();
            GenClass _typeGenClass = _childMetaFeature_1.getTypeGenClass();
            CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_typeGenClass, "childElement");
            _builder.append((Object)_DowncastToEObject, "\t");
            _builder.append((Object)", ");
        }
        _builder.append((Object)"visualID));");
        _builder.newLineIfNotEmpty();
        if (inLoop.booleanValue()) {
            _builder.append((Object)"continue;");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addNextIfPhantom(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (");
        GenDiagram _diagram = it.getDiagram();
        CharSequence _nodeVisualIDMethodCall = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(_diagram);
        _builder.append((Object)_nodeVisualIDMethodCall, "");
        _builder.append((Object)"(view, childElement) == ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"result.add(new ");
        GenDiagram _diagram_1 = it.getDiagram();
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)_diagram_1);
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)"(childElement, ");
        CharSequence _visualID_1 = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID_1, "\t");
        _builder.append((Object)"));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"continue;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getPhantomNodesIterator(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenDiagram _diagram = _editorGen.getDiagram();
        boolean _hasPhantomNodes = this._utils_qvto.hasPhantomNodes(_diagram);
        if (_hasPhantomNodes) {
            _builder.newLine();
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"private static java.util.Iterator<org.eclipse.emf.ecore.EObject> getPhantomNodesIterator(org.eclipse.emf.ecore.resource.Resource resource) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return resource.getAllContents();");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getGenericConnectedLinks(GenDiagramUpdater it, Iterable<? extends GenCommonBase> linkContainers, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static ");
        CharSequence _listOfLinkDescriptors = this.listOfLinkDescriptors((EObject)it);
        _builder.append((Object)_listOfLinkDescriptors, "");
        _builder.append((Object)" get");
        String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
        _builder.append((Object)_linkMethodSuffix, "");
        _builder.append((Object)"Links(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(linkContainers);
        if (_notEmpty) {
            _builder.append((Object)"\t");
            _builder.append((Object)"switch (");
            GenEditorGenerator _editorGen = it.getEditorGen();
            GenDiagram _diagram = _editorGen.getDiagram();
            CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(_diagram);
            _builder.append((Object)_visualIDMethodCall, "\t");
            _builder.append((Object)"(view)) {");
            _builder.newLineIfNotEmpty();
            for (GenCommonBase genCommonBase : linkContainers) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _containedLinksCase = this.getContainedLinksCase(genCommonBase, linkType);
                _builder.append((Object)_containedLinksCase, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append((Object)_newEmptyList, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getContainedLinksCase(GenCommonBase it, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(it);
        _builder.append((Object)_caseVisualID, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        CharSequence _linkGetterName = this.linkGetterName(it, linkType);
        _builder.append((Object)_linkGetterName, "\t");
        _builder.append((Object)"(view);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getContainedLinks(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        GenClass _metaClass = this._utils_qvto.getMetaClass((EObject)it);
        GenDiagram _diagram = it.getDiagram();
        Iterable<GenLink> _computeContainedLinks = this._utils_qvto.computeContainedLinks(_metaClass, _diagram);
        CharSequence _connectedLinks = this.getConnectedLinks(it, _computeContainedLinks, UpdaterLinkType.CONTAINED, false);
        _builder.append((Object)_connectedLinks, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getContainedLinks(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        GenClass _metaClass = this._utils_qvto.getMetaClass((EObject)it);
        GenDiagram _diagram = it.getDiagram();
        Iterable<GenLink> _computeContainedLinks = this._utils_qvto.computeContainedLinks(_metaClass, _diagram);
        CharSequence _connectedLinks = this.getConnectedLinks((GenCommonBase)it, _computeContainedLinks, UpdaterLinkType.CONTAINED, false);
        _builder.append((Object)_connectedLinks, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getIncomingLinks(GenLinkEnd it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<GenLink> _computeIncomingLinks = this._utils_qvto.computeIncomingLinks(it);
        CharSequence _connectedLinks = this.getConnectedLinks((GenCommonBase)it, _computeIncomingLinks, UpdaterLinkType.INCOMING, true);
        _builder.append((Object)_connectedLinks, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getOutgoingLinks(GenLinkEnd it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<GenLink> _computeOutgoingLinks = this._utils_qvto.computeOutgoingLinks(it);
        CharSequence _connectedLinks = this.getConnectedLinks((GenCommonBase)it, _computeOutgoingLinks, UpdaterLinkType.OUTGOING, false);
        _builder.append((Object)_connectedLinks, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getConnectedLinks(GenCommonBase it, Iterable<GenLink> genLinks, UpdaterLinkType linkType, boolean needCrossReferencer) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static ");
        CharSequence _listOfLinkDescriptors = this.listOfLinkDescriptors((EObject)it);
        _builder.append((Object)_listOfLinkDescriptors, "");
        _builder.append((Object)" ");
        CharSequence _linkGetterName = this.linkGetterName(it, linkType);
        _builder.append((Object)_linkGetterName, "");
        _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(genLinks);
        if (_notEmpty) {
            GenClass _metaClass = this._utils_qvto.getMetaClass((EObject)it);
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(_metaClass, "modelElement", "view.getElement()");
            _builder.append((Object)_DeclareAndAssign, "");
            _builder.newLineIfNotEmpty();
            if (needCrossReferencer) {
                CharSequence _typeOfCrossReferenceMap = this.typeOfCrossReferenceMap();
                _builder.append((Object)_typeOfCrossReferenceMap, "");
                _builder.append((Object)" crossReferences = org.eclipse.emf.ecore.util.EcoreUtil.CrossReferencer.find(view.eResource().getResourceSet().getResources());");
                _builder.newLineIfNotEmpty();
            }
            GenDiagramUpdater _diagramUpdater = this.diagramUpdater(it);
            CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(_diagramUpdater, "result");
            _builder.append((Object)_newLinkedListOfLinkDescriptors, "");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            for (GenLink link : genLinks) {
                GenClass _metaClass_1 = this._utils_qvto.getMetaClass((EObject)it);
                boolean _isExternalInterface = this._genModelUtils_qvto.isExternalInterface(_metaClass_1);
                CharSequence _colectConnectedLinks = this.colectConnectedLinks(link, linkType, needCrossReferencer, _isExternalInterface);
                _builder.append((Object)_colectConnectedLinks, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"return result;");
            _builder.newLine();
        } else {
            _builder.append((Object)"return ");
            CharSequence _newEmptyList = this.newEmptyList();
            _builder.append((Object)_newEmptyList, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence colectConnectedLinks(GenLink it, UpdaterLinkType linkType, boolean needCrossReferencer, boolean isExternalInterface) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        LinkModelFacet _modelFacet = it.getModelFacet();
        boolean bl = _notEquals = !Objects.equal((Object)_modelFacet, null);
        if (_notEquals) {
            LinkModelFacet _modelFacet_6;
            boolean _oclIsKindOf_2;
            boolean _not_2;
            LinkModelFacet _modelFacet_4;
            boolean _oclIsKindOf_1;
            boolean _not_1;
            LinkModelFacet _modelFacet_1;
            boolean _oclIsKindOf;
            boolean _not;
            boolean _and = false;
            _and = !isExternalInterface ? false : (_not = !(_oclIsKindOf = this._common_qvto.oclIsKindOf(_modelFacet_1 = it.getModelFacet(), FeatureLinkModelFacet.class)));
            if (_and) {
                _builder.append((Object)"if (");
                LinkModelFacet _modelFacet_2 = it.getModelFacet();
                GenClass _linkEndType = this._utils_qvto.getLinkEndType(_modelFacet_2, linkType);
                CharSequence _IsInstance = this.xptMetaModel.IsInstance(_linkEndType, "modelElement");
                _builder.append((Object)_IsInstance, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"result.addAll(");
            LinkModelFacet _modelFacet_3 = it.getModelFacet();
            CharSequence _chooseConnectedLinksByTypeMethodName = this.chooseConnectedLinksByTypeMethodName(_modelFacet_3, linkType, it);
            _builder.append((Object)_chooseConnectedLinksByTypeMethodName, "\t");
            _builder.append((Object)"(");
            boolean _and_1 = false;
            _and_1 = !isExternalInterface ? false : (_not_1 = !(_oclIsKindOf_1 = this._common_qvto.oclIsKindOf(_modelFacet_4 = it.getModelFacet(), FeatureLinkModelFacet.class)));
            if (_and_1) {
                LinkModelFacet _modelFacet_5 = it.getModelFacet();
                GenClass _linkEndType_1 = this._utils_qvto.getLinkEndType(_modelFacet_5, linkType);
                CharSequence _CastEObject = this.xptMetaModel.CastEObject(_linkEndType_1, "modelElement");
                _builder.append((Object)_CastEObject, "\t");
            } else {
                _builder.append((Object)"modelElement");
            }
            if (needCrossReferencer) {
                _builder.append((Object)", crossReferences");
            }
            _builder.append((Object)"));\t");
            _builder.newLineIfNotEmpty();
            boolean _and_2 = false;
            _and_2 = !isExternalInterface ? false : (_not_2 = !(_oclIsKindOf_2 = this._common_qvto.oclIsKindOf(_modelFacet_6 = it.getModelFacet(), FeatureLinkModelFacet.class)));
            if (_and_2) {
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    protected CharSequence _chooseConnectedLinksByTypeMethodName(LinkModelFacet it, UpdaterLinkType type, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet, "");
        return _builder;
    }

    protected CharSequence _chooseConnectedLinksByTypeMethodName(FeatureLinkModelFacet it, UpdaterLinkType type, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.CONTAINED));
        if (_equals) {
            CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(genLink, UpdaterLinkType.OUTGOING);
            _builder.append((Object)_connectedLinksByTypeMethodName, "");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _connectedLinksByTypeMethodName_1 = this.getConnectedLinksByTypeMethodName(genLink, type);
            _builder.append((Object)_connectedLinksByTypeMethodName_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _chooseConnectedLinksByTypeMethodName(TypeLinkModelFacet it, UpdaterLinkType type, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean _equals = Objects.equal((Object)((Object)type), (Object)((Object)UpdaterLinkType.OUTGOING));
        if (!_equals) {
            _and = false;
        } else {
            boolean _equals_1;
            GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
            _and = _equals_1 = Objects.equal((Object)_sourceMetaFeature, null);
        }
        if (_and) {
            CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(genLink, UpdaterLinkType.CONTAINED);
            _builder.append((Object)_connectedLinksByTypeMethodName, "");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _connectedLinksByTypeMethodName_1 = this.getConnectedLinksByTypeMethodName(genLink, type);
            _builder.append((Object)_connectedLinksByTypeMethodName_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getContainedLinksByTypeMethod(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        LinkModelFacet _modelFacet = it.getModelFacet();
        CharSequence _containedLinksByTypeMethod = this.getContainedLinksByTypeMethod(_modelFacet, it);
        _builder.append((Object)_containedLinksByTypeMethod, "");
        return _builder;
    }

    public CharSequence getConnectedLinksByTypeMethodName(GenLink it, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
        _builder.append((Object)_linkMethodSuffix, "");
        LinkModelFacet _modelFacet = it.getModelFacet();
        CharSequence _connectedLinksByTypeMethodFragment = this.getConnectedLinksByTypeMethodFragment(_modelFacet);
        _builder.append((Object)_connectedLinksByTypeMethodFragment, "");
        _builder.append((Object)"_");
        int _visualID = it.getVisualID();
        _builder.append((Object)_visualID, "");
        return _builder;
    }

    protected CharSequence _getConnectedLinksByTypeMethodFragment(TypeLinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"TypeModelFacetLinks_");
        GenClass _metaClass = it.getMetaClass();
        EClass _ecoreClass = _metaClass.getEcoreClass();
        String _name = _ecoreClass.getName();
        _builder.append((Object)_name, "");
        return _builder;
    }

    protected CharSequence _getConnectedLinksByTypeMethodFragment(FeatureLinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"FeatureModelFacetLinks_");
        GenFeature _metaFeature = it.getMetaFeature();
        GenClass _genClass = _metaFeature.getGenClass();
        EClass _ecoreClass = _genClass.getEcoreClass();
        String _name = _ecoreClass.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_");
        GenFeature _metaFeature_1 = it.getMetaFeature();
        EStructuralFeature _ecoreFeature = _metaFeature_1.getEcoreFeature();
        String _name_1 = _ecoreFeature.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    protected CharSequence _getConnectedLinksByTypeMethodFragment(LinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet, "");
        return _builder;
    }

    protected CharSequence _getContainedLinksByTypeMethod(LinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet, "");
        return _builder;
    }

    protected CharSequence _getContainedLinksByTypeMethod(FeatureLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _getContainedLinksByTypeMethod(TypeLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static java.util.Collection<");
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)genLink);
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)"> ");
        CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(genLink, UpdaterLinkType.CONTAINED);
        _builder.append((Object)_connectedLinksByTypeMethodName, "");
        _builder.append((Object)"(");
        GenFeature _childMetaFeature = it.getChildMetaFeature();
        GenClass _genClass = _childMetaFeature.getGenClass();
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_genClass);
        _builder.append((Object)_QualifiedClassName, "");
        _builder.append((Object)" container) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _containedLinksByTypeMethodBody = this.getContainedLinksByTypeMethodBody(it, genLink, false);
        _builder.append((Object)_containedLinksByTypeMethodBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getContainedLinksByTypeMethodBody(TypeLinkModelFacet it, GenLink genLink, boolean sourceVarDefined) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)genLink);
        CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(_diagramUpdater, "result");
        _builder.append((Object)_newLinkedListOfLinkDescriptors, "");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        GenFeature _childMetaFeature = it.getChildMetaFeature();
        boolean inLoop = _childMetaFeature.isListType();
        _builder.newLineIfNotEmpty();
        if (inLoop) {
            _builder.append((Object)"for (java.util.Iterator<?> links = ");
            GenFeature _childMetaFeature_1 = it.getChildMetaFeature();
            GenFeature _childMetaFeature_2 = it.getChildMetaFeature();
            GenClass _genClass = _childMetaFeature_2.getGenClass();
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(_childMetaFeature_1, "container", _genClass);
            _builder.append((Object)_featureValue, "");
            _builder.append((Object)".iterator(); links.hasNext();) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.emf.ecore.EObject linkObject = (org.eclipse.emf.ecore.EObject ) links.next();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (");
            GenClass _metaClass = it.getMetaClass();
            CharSequence _NotInstance = this.xptMetaModel.NotInstance(_metaClass, "linkObject");
            _builder.append((Object)_NotInstance, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"continue;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            GenClass _metaClass_1 = it.getMetaClass();
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(_metaClass_1, "link", "linkObject");
            _builder.append((Object)_DeclareAndAssign, "\t");
            _builder.newLineIfNotEmpty();
        } else {
            GenClass _metaClass_2;
            GenFeature _childMetaFeature_3 = it.getChildMetaFeature();
            GenClass _typeGenClass = _childMetaFeature_3.getTypeGenClass();
            boolean _equals = Objects.equal((Object)_typeGenClass, (Object)(_metaClass_2 = it.getMetaClass()));
            if (_equals) {
                GenClass _metaClass_3 = it.getMetaClass();
                GenClass _sourceType = it.getSourceType();
                GenFeature _childMetaFeature_4 = it.getChildMetaFeature();
                CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(_metaClass_3, "link", "container", _sourceType, _childMetaFeature_4);
                _builder.append((Object)_DeclareAndAssign_1, "");
                _builder.newLineIfNotEmpty();
            } else {
                GenFeature _childMetaFeature_5 = it.getChildMetaFeature();
                GenClass _typeGenClass_1 = _childMetaFeature_5.getTypeGenClass();
                GenClass _sourceType_1 = it.getSourceType();
                GenFeature _childMetaFeature_6 = it.getChildMetaFeature();
                CharSequence _DeclareAndAssign_2 = this.xptMetaModel.DeclareAndAssign(_typeGenClass_1, "linkObject", "container", _sourceType_1, _childMetaFeature_6);
                _builder.append((Object)_DeclareAndAssign_2, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"if (");
                GenClass _metaClass_4 = it.getMetaClass();
                CharSequence _NotInstance_1 = this.xptMetaModel.NotInstance(_metaClass_4, "linkObject");
                _builder.append((Object)_NotInstance_1, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return result;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                GenClass _metaClass_5 = it.getMetaClass();
                CharSequence _DeclareAndAssign_3 = this.xptMetaModel.DeclareAndAssign(_metaClass_5, "link", "linkObject");
                _builder.append((Object)_DeclareAndAssign_3, "");
                _builder.newLineIfNotEmpty();
            }
        }
        CharSequence _checkLinkVisualID = this.checkLinkVisualID(it, genLink, inLoop);
        _builder.append((Object)_checkLinkVisualID, "");
        _builder.newLineIfNotEmpty();
        CharSequence _defineLinkDestination = this.defineLinkDestination(it, inLoop);
        _builder.append((Object)_defineLinkDestination, "");
        _builder.newLineIfNotEmpty();
        GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_sourceMetaFeature);
        if (_notEquals) {
            CharSequence _defineLinkSource = this.defineLinkSource(it, inLoop);
            _builder.append((Object)_defineLinkSource, "");
            _builder.newLineIfNotEmpty();
            if (sourceVarDefined) {
                CharSequence _checkLinkSource = this.checkLinkSource(it, inLoop);
                _builder.append((Object)_checkLinkSource, "");
                _builder.newLineIfNotEmpty();
            }
            CharSequence _addLinkDescriptor = this.addLinkDescriptor(it, genLink, "src", "dst");
            _builder.append((Object)_addLinkDescriptor, "");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _addLinkDescriptor_1 = this.addLinkDescriptor(it, genLink, "container", "dst");
            _builder.append((Object)_addLinkDescriptor_1, "");
            _builder.newLineIfNotEmpty();
        }
        if (inLoop) {
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"return result;\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addLinkDescriptor(TypeLinkModelFacet it, GenLink genLink, String srcVar, String dstVar) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"result.add(new ");
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)genLink);
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)"(");
        GenClass _sourceType = it.getSourceType();
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_sourceType, srcVar);
        _builder.append((Object)_DowncastToEObject, "");
        _builder.append((Object)", ");
        GenClass _targetType = it.getTargetType();
        CharSequence _DowncastToEObject_1 = this.xptMetaModel.DowncastToEObject(_targetType, dstVar);
        _builder.append((Object)_DowncastToEObject_1, "");
        _builder.append((Object)", ");
        GenClass _metaClass = it.getMetaClass();
        CharSequence _DowncastToEObject_2 = this.xptMetaModel.DowncastToEObject(_metaClass, "link");
        _builder.append((Object)_DowncastToEObject_2, "");
        _builder.append((Object)", ");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType((GenCommonBase)genLink);
        _builder.append((Object)_accessElementType, "");
        _builder.append((Object)", ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)genLink);
        _builder.append((Object)_visualID, "");
        _builder.append((Object)"));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence checkLinkVisualID(TypeLinkModelFacet it, GenLink genLink, boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)genLink);
        _builder.append((Object)_visualID, "");
        _builder.append((Object)" != ");
        GenDiagram _diagram = genLink.getDiagram();
        CharSequence _linkWithClassVisualIDMethodCall = this.xptVisualIDRegistry.getLinkWithClassVisualIDMethodCall(_diagram);
        _builder.append((Object)_linkWithClassVisualIDMethodCall, "");
        _builder.append((Object)"(");
        GenClass _metaClass = it.getMetaClass();
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_metaClass, "link");
        _builder.append((Object)_DowncastToEObject, "");
        _builder.append((Object)")) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
        _builder.append((Object)_stopLinkProcessing, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence defineLinkSource(TypeLinkModelFacet it, boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
        boolean _isListType = _sourceMetaFeature.isListType();
        if (_isListType) {
            _builder.append((Object)"java.util.List sources = ");
            GenFeature _sourceMetaFeature_1 = it.getSourceMetaFeature();
            GenClass _metaClass = it.getMetaClass();
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(_sourceMetaFeature_1, "link", _metaClass);
            _builder.append((Object)_featureValue, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"Object theSource = sources.size() == 1 ? sources.get(0) : null;");
            _builder.newLine();
            _builder.append((Object)"if (");
            GenClass _sourceType = it.getSourceType();
            CharSequence _NotInstance = this.xptMetaModel.NotInstance(_sourceType, "theSource");
            _builder.append((Object)_NotInstance, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
            _builder.append((Object)_stopLinkProcessing, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            GenClass _sourceType_1 = it.getSourceType();
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)_sourceType_1, "src", "theSource", true);
            _builder.append((Object)_DeclareAndAssign, "");
            _builder.newLineIfNotEmpty();
        } else {
            GenClass _sourceType_2 = it.getSourceType();
            GenClass _metaClass_1 = it.getMetaClass();
            GenFeature _sourceMetaFeature_2 = it.getSourceMetaFeature();
            CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(_sourceType_2, "src", "link", _metaClass_1, _sourceMetaFeature_2);
            _builder.append((Object)_DeclareAndAssign_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence checkLinkSource(TypeLinkModelFacet it, boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (src != source) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
        _builder.append((Object)_stopLinkProcessing, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence defineLinkDestination(TypeLinkModelFacet it, Boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        GenFeature _targetMetaFeature = it.getTargetMetaFeature();
        boolean _isListType = _targetMetaFeature.isListType();
        if (_isListType) {
            _builder.append((Object)"java.util.List targets = ");
            GenFeature _targetMetaFeature_1 = it.getTargetMetaFeature();
            GenClass _metaClass = it.getMetaClass();
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(_targetMetaFeature_1, "link", _metaClass);
            _builder.append((Object)_featureValue, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"Object theTarget = targets.size() == 1 ? targets.get(0) : null;");
            _builder.newLine();
            _builder.append((Object)"if (");
            GenClass _targetType = it.getTargetType();
            CharSequence _NotInstance = this.xptMetaModel.NotInstance(_targetType, "theTarget");
            _builder.append((Object)_NotInstance, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
            _builder.append((Object)_stopLinkProcessing, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            GenClass _targetType_1 = it.getTargetType();
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)_targetType_1, "dst", "theTarget", true);
            _builder.append((Object)_DeclareAndAssign, "");
            _builder.newLineIfNotEmpty();
        } else {
            GenClass _targetType_2 = it.getTargetType();
            GenClass _metaClass_1 = it.getMetaClass();
            GenFeature _targetMetaFeature_2 = it.getTargetMetaFeature();
            CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(_targetType_2, "dst", "link", _metaClass_1, _targetMetaFeature_2);
            _builder.append((Object)_DeclareAndAssign_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence stopLinkProcessing(boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        if (inLoop) {
            _builder.append((Object)"continue;");
            _builder.newLine();
        } else {
            _builder.append((Object)"return result;");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getIncomingLinksByTypeMethod(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static java.util.Collection<");
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)it);
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)"> ");
        CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(it, UpdaterLinkType.INCOMING);
        _builder.append((Object)_connectedLinksByTypeMethodName, "");
        _builder.append((Object)"(");
        LinkModelFacet _modelFacet = it.getModelFacet();
        GenClass _targetType = _modelFacet.getTargetType();
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_targetType);
        _builder.append((Object)_QualifiedClassName, "");
        _builder.append((Object)" target, ");
        CharSequence _typeOfCrossReferenceMap = this.typeOfCrossReferenceMap();
        _builder.append((Object)_typeOfCrossReferenceMap, "");
        _builder.append((Object)" crossReferences) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        GenDiagramUpdater _diagramUpdater_1 = this.diagramUpdater((GenCommonBase)it);
        CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(_diagramUpdater_1, "result");
        _builder.append((Object)_newLinkedListOfLinkDescriptors, "\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.Collection<org.eclipse.emf.ecore.EStructuralFeature.Setting> settings = crossReferences.get(target);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.emf.ecore.EStructuralFeature.Setting setting : settings) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        LinkModelFacet _modelFacet_1 = it.getModelFacet();
        CharSequence _incomingLinksByTypeMethodBody = this.getIncomingLinksByTypeMethodBody(_modelFacet_1, it);
        _builder.append((Object)_incomingLinksByTypeMethodBody, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;\t");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _getIncomingLinksByTypeMethodBody(TypeLinkModelFacet it, GenLink genLink) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (setting.getEStructuralFeature() != ");
        GenFeature _targetMetaFeature = it.getTargetMetaFeature();
        CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(_targetMetaFeature);
        _builder.append((Object)_MetaFeature, "");
        _builder.append((Object)" || ");
        GenClass _metaClass = it.getMetaClass();
        CharSequence _NotInstance = this.xptMetaModel.NotInstance(_metaClass, "setting.getEObject()");
        _builder.append((Object)_NotInstance, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"continue;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        GenClass _metaClass_1 = it.getMetaClass();
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(_metaClass_1, "link", "setting.getEObject()");
        _builder.append((Object)_DeclareAndAssign, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _checkLinkVisualID = this.checkLinkVisualID(it, genLink, true);
        _builder.append((Object)_checkLinkVisualID, "\t");
        _builder.newLineIfNotEmpty();
        GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_sourceMetaFeature);
        if (_notEquals) {
            _builder.append((Object)"\t");
            CharSequence _defineLinkSource = this.defineLinkSource(it, true);
            _builder.append((Object)_defineLinkSource, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _addLinkDescriptor = this.addLinkDescriptor(it, genLink, "src", "target");
            _builder.append((Object)_addLinkDescriptor, "\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"\t");
            CharSequence _defineLinkContainer = this.defineLinkContainer(it, true);
            _builder.append((Object)_defineLinkContainer, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _addLinkDescriptor_1 = this.addLinkDescriptor(it, genLink, "container", "target");
            _builder.append((Object)_addLinkDescriptor_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _extraLineBreak = this._common.extraLineBreak();
            _builder.append((Object)_extraLineBreak, "\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence defineLinkContainer(TypeLinkModelFacet it, boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (false == ");
        GenFeature _containmentMetaFeature = it.getContainmentMetaFeature();
        GenClass _genClass = _containmentMetaFeature.getGenClass();
        GenClass _metaClass = it.getMetaClass();
        CharSequence _IsContainerInstance = this.xptMetaModel.IsContainerInstance(_genClass, "link", _metaClass);
        _builder.append((Object)_IsContainerInstance, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
        _builder.append((Object)_stopLinkProcessing, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        GenFeature _containmentMetaFeature_1 = it.getContainmentMetaFeature();
        GenClass _genClass_1 = _containmentMetaFeature_1.getGenClass();
        GenClass _metaClass_1 = it.getMetaClass();
        CharSequence _DeclareAndAssignContainer = this.xptMetaModel.DeclareAndAssignContainer(_genClass_1, "container", "link", _metaClass_1);
        _builder.append((Object)_DeclareAndAssignContainer, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getIncomingLinksByTypeMethodBody(FeatureLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (setting.getEStructuralFeature() == ");
        GenFeature _metaFeature = it.getMetaFeature();
        CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(_metaFeature);
        _builder.append((Object)_MetaFeature, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"result.add(new ");
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)genLink);
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)"(setting.getEObject(), ");
        GenClass _targetType = it.getTargetType();
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_targetType, "target");
        _builder.append((Object)_DowncastToEObject, "\t");
        _builder.append((Object)", ");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType((GenCommonBase)genLink);
        _builder.append((Object)_accessElementType, "\t");
        _builder.append((Object)", ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)genLink);
        _builder.append((Object)_visualID, "\t");
        _builder.append((Object)"));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _getIncomingLinksByTypeMethodBody(LinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet, "");
        return _builder;
    }

    public CharSequence getOutgoingLinksByTypeMethod(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        LinkModelFacet _modelFacet = it.getModelFacet();
        CharSequence _outgoingLinksByTypeMethod = this.getOutgoingLinksByTypeMethod(_modelFacet, it);
        _builder.append((Object)_outgoingLinksByTypeMethod, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getOutgoingLinksByTypeMethodSignature(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"private static java.util.Collection<");
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)it);
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(_diagramUpdater);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)"> ");
        CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(it, UpdaterLinkType.OUTGOING);
        _builder.append((Object)_connectedLinksByTypeMethodName, "");
        _builder.append((Object)"(");
        LinkModelFacet _modelFacet = it.getModelFacet();
        GenClass _sourceType = _modelFacet.getSourceType();
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_sourceType);
        _builder.append((Object)_QualifiedClassName, "");
        _builder.append((Object)" source)");
        return _builder;
    }

    protected CharSequence _getOutgoingLinksByTypeMethod(FeatureLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        CharSequence _outgoingLinksByTypeMethodSignature = this.getOutgoingLinksByTypeMethodSignature(genLink);
        _builder.append((Object)_outgoingLinksByTypeMethodSignature, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        GenDiagramUpdater _diagramUpdater = this.diagramUpdater((GenCommonBase)genLink);
        CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(_diagramUpdater, "result");
        _builder.append((Object)_newLinkedListOfLinkDescriptors, "\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        GenFeature _metaFeature = it.getMetaFeature();
        boolean _isListType = _metaFeature.isListType();
        if (_isListType) {
            _builder.append((Object)"\t");
            _builder.append((Object)"for (java.util.Iterator<?> destinations = ");
            GenFeature _metaFeature_1 = it.getMetaFeature();
            GenClass _sourceType = it.getSourceType();
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(_metaFeature_1, "source", _sourceType);
            _builder.append((Object)_featureValue, "\t");
            _builder.append((Object)".iterator(); destinations.hasNext();) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            GenClass _targetType = it.getTargetType();
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)_targetType, "destination", "destinations.next()", true);
            _builder.append((Object)_DeclareAndAssign, "\t\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"\t");
            GenClass _targetType_1 = it.getTargetType();
            GenClass _sourceType_1 = it.getSourceType();
            GenFeature _metaFeature_2 = it.getMetaFeature();
            CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(_targetType_1, "destination", "source", _sourceType_1, _metaFeature_2);
            _builder.append((Object)_DeclareAndAssign_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (destination == null) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return result;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"result.add(new ");
        GenDiagramUpdater _diagramUpdater_1 = this.diagramUpdater((GenCommonBase)genLink);
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(_diagramUpdater_1);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)"(");
        GenClass _sourceType_2 = it.getSourceType();
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_sourceType_2, "source");
        _builder.append((Object)_DowncastToEObject, "\t");
        _builder.append((Object)", ");
        GenClass _targetType_2 = it.getTargetType();
        CharSequence _DowncastToEObject_1 = this.xptMetaModel.DowncastToEObject(_targetType_2, "destination");
        _builder.append((Object)_DowncastToEObject_1, "\t");
        _builder.append((Object)", ");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType((GenCommonBase)genLink);
        _builder.append((Object)_accessElementType, "\t");
        _builder.append((Object)", ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)genLink);
        _builder.append((Object)_visualID, "\t");
        _builder.append((Object)"));");
        _builder.newLineIfNotEmpty();
        GenFeature _metaFeature_3 = it.getMetaFeature();
        boolean _isListType_1 = _metaFeature_3.isListType();
        if (_isListType_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _getOutgoingLinksByTypeMethod(TypeLinkModelFacet it, GenLink genLink) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_sourceMetaFeature);
        if (_notEquals) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment, "");
            _builder.newLineIfNotEmpty();
            CharSequence _outgoingLinksByTypeMethodSignature = this.getOutgoingLinksByTypeMethodSignature(genLink);
            _builder.append((Object)_outgoingLinksByTypeMethodSignature, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            GenFeature _containmentMetaFeature = it.getContainmentMetaFeature();
            GenClass _genClass = _containmentMetaFeature.getGenClass();
            CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_genClass);
            _builder.append((Object)_QualifiedClassName, "\t");
            _builder.append((Object)" container = null;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"// Find container element for the link.");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"// Climb up by containment hierarchy starting from the source");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"// and return the first element that is instance of the container class.");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"for (org.eclipse.emf.ecore.EObject element = ");
            GenClass _sourceType = it.getSourceType();
            CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_sourceType, "source");
            _builder.append((Object)_DowncastToEObject, "\t");
            _builder.append((Object)"; element != null && container == null; element = element.eContainer()) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (");
            GenFeature _containmentMetaFeature_1 = it.getContainmentMetaFeature();
            GenClass _genClass_1 = _containmentMetaFeature_1.getGenClass();
            CharSequence _IsInstance = this.xptMetaModel.IsInstance(_genClass_1, "element");
            _builder.append((Object)_IsInstance, "\t\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"container = ");
            GenFeature _containmentMetaFeature_2 = it.getContainmentMetaFeature();
            GenClass _genClass_2 = _containmentMetaFeature_2.getGenClass();
            CharSequence _CastEObject = this.xptMetaModel.CastEObject(_genClass_2, "element");
            _builder.append((Object)_CastEObject, "\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (container == null) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return ");
            CharSequence _newEmptyList = this.newEmptyList();
            _builder.append((Object)_newEmptyList, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _containedLinksByTypeMethodBody = this.getContainedLinksByTypeMethodBody(it, genLink, true);
            _builder.append((Object)_containedLinksByTypeMethodBody, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}\t\t");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _getOutgoingLinksByTypeMethod(LinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet, "");
        return _builder;
    }

    public CharSequence incorrectLinkModelFacet(LinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Incorrect LinkModelFacet: " + it);
        return _builder;
    }

    public CharSequence runtimeTypedInstance(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static final org.eclipse.gmf.tooling.runtime.update.DiagramUpdater ");
        CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
        _builder.append((Object)_runtimeTypedInstanceName, "");
        _builder.append((Object)" = new org.eclipse.gmf.tooling.runtime.update.DiagramUpdater() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenDiagram _diagram = _editorGen.getDiagram();
        CharSequence _overrideI = this.xptCodeStyle.overrideI((GenCommonBase)_diagram);
        _builder.append((Object)_overrideI, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public java.util.List<");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)"> getSemanticChildren(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "\t\t");
        _builder.append((Object)".getSemanticChildren(view);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenDiagram _diagram_1 = _editorGen_1.getDiagram();
        CharSequence _overrideI_1 = this.xptCodeStyle.overrideI((GenCommonBase)_diagram_1);
        _builder.append((Object)_overrideI_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public java.util.List<");
        CharSequence _qualifiedClassName_1 = this.linkDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append((Object)"> getContainedLinks(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _className_1 = this.className(it);
        _builder.append((Object)_className_1, "\t\t");
        _builder.append((Object)".getContainedLinks(view);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        GenDiagram _diagram_2 = _editorGen_2.getDiagram();
        CharSequence _overrideI_2 = this.xptCodeStyle.overrideI((GenCommonBase)_diagram_2);
        _builder.append((Object)_overrideI_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public java.util.List<");
        CharSequence _qualifiedClassName_2 = this.linkDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append((Object)"> getIncomingLinks(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _className_2 = this.className(it);
        _builder.append((Object)_className_2, "\t\t");
        _builder.append((Object)".getIncomingLinks(view);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen_3 = it.getEditorGen();
        GenDiagram _diagram_3 = _editorGen_3.getDiagram();
        CharSequence _overrideI_3 = this.xptCodeStyle.overrideI((GenCommonBase)_diagram_3);
        _builder.append((Object)_overrideI_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public java.util.List<");
        CharSequence _qualifiedClassName_3 = this.linkDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_3, "\t");
        _builder.append((Object)"> getOutgoingLinks(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        CharSequence _className_3 = this.className(it);
        _builder.append((Object)_className_3, "\t\t");
        _builder.append((Object)".getOutgoingLinks(view);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}; ");
        _builder.newLine();
        return _builder;
    }

    public CharSequence additions(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence listOfNodeDescriptors(EObject it) {
        if (it instanceof GenCommonBase) {
            return this._listOfNodeDescriptors((GenCommonBase)it);
        }
        if (it instanceof GenDiagramUpdater) {
            return this._listOfNodeDescriptors((GenDiagramUpdater)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    protected CharSequence listOfLinkDescriptors(EObject it) {
        if (it instanceof GenCommonBase) {
            return this._listOfLinkDescriptors((GenCommonBase)it);
        }
        if (it instanceof GenDiagramUpdater) {
            return this._listOfLinkDescriptors((GenDiagramUpdater)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence defineModelElement(GenContainerBase it) {
        if (it instanceof GenCompartment) {
            return this._defineModelElement((GenCompartment)it);
        }
        if (it != null) {
            return this._defineModelElement(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence getContainedLinks(GenCommonBase it) {
        if (it instanceof GenLink) {
            return this._getContainedLinks((GenLink)it);
        }
        if (it != null) {
            return this._getContainedLinks(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence chooseConnectedLinksByTypeMethodName(LinkModelFacet it, UpdaterLinkType type, GenLink genLink) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._chooseConnectedLinksByTypeMethodName((FeatureLinkModelFacet)it, type, genLink);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._chooseConnectedLinksByTypeMethodName((TypeLinkModelFacet)it, type, genLink);
        }
        if (it != null) {
            return this._chooseConnectedLinksByTypeMethodName(it, type, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{it, type, genLink}).toString());
    }

    public CharSequence getConnectedLinksByTypeMethodFragment(LinkModelFacet it) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._getConnectedLinksByTypeMethodFragment((FeatureLinkModelFacet)it);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._getConnectedLinksByTypeMethodFragment((TypeLinkModelFacet)it);
        }
        if (it != null) {
            return this._getConnectedLinksByTypeMethodFragment(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence getContainedLinksByTypeMethod(LinkModelFacet it, GenLink genLink) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._getContainedLinksByTypeMethod((FeatureLinkModelFacet)it, genLink);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._getContainedLinksByTypeMethod((TypeLinkModelFacet)it, genLink);
        }
        if (it != null) {
            return this._getContainedLinksByTypeMethod(it, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, genLink).toString());
    }

    public CharSequence getIncomingLinksByTypeMethodBody(LinkModelFacet it, GenLink genLink) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._getIncomingLinksByTypeMethodBody((FeatureLinkModelFacet)it, genLink);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._getIncomingLinksByTypeMethodBody((TypeLinkModelFacet)it, genLink);
        }
        if (it != null) {
            return this._getIncomingLinksByTypeMethodBody(it, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, genLink).toString());
    }

    public CharSequence getOutgoingLinksByTypeMethod(LinkModelFacet it, GenLink genLink) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._getOutgoingLinksByTypeMethod((FeatureLinkModelFacet)it, genLink);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._getOutgoingLinksByTypeMethod((TypeLinkModelFacet)it, genLink);
        }
        if (it != null) {
            return this._getOutgoingLinksByTypeMethod(it, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, genLink).toString());
    }
}

