/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.editor.Editor;
import xpt.editor.GenDiagram_qvto;
import xpt.editor.VisualIDRegistry;

@Singleton
public class DiagramEditorUtil {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private GenDiagram_qvto _genDiagram_qvto;
    @Inject
    @Extension
    private ExternalizerUtils_qvto _externalizerUtils_qvto;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private Activator xptActivator;
    @Inject
    private Editor xptEditor;

    @MetaDef
    public CharSequence callSetCharset(GenDiagram it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        String _diagramEditorUtilQualifiedClassName = it.getDiagramEditorUtilQualifiedClassName();
        _builder.append((Object)_diagramEditorUtilQualifiedClassName, "");
        _builder.append((Object)".setCharset(");
        _builder.append((Object)varName, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @MetaDef
    public CharSequence callGetSaveOptions(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".getSaveOptions()");
        return _builder;
    }

    @Localization
    public String i18nKeyForDiagramEditorUtil(GenDiagram diagram) {
        CharSequence _className = this.className(diagram);
        return "" + _className;
    }

    @Localization
    public String i18nKeyForOpenModelResourceErrorDialog(GenDiagram diagram) {
        String _i18nKeyForDiagramEditorUtil = this.i18nKeyForDiagramEditorUtil(diagram);
        return String.valueOf(_i18nKeyForDiagramEditorUtil) + ".OpenModelResourceErrorDialog";
    }

    @Localization
    public String i18nKeyForCreateDiagramProgressTask(GenDiagram diagram) {
        String _i18nKeyForDiagramEditorUtil = this.i18nKeyForDiagramEditorUtil(diagram);
        return String.valueOf(_i18nKeyForDiagramEditorUtil) + ".CreateDiagramProgressTask";
    }

    @Localization
    public String i18nKeyForCreateDiagramCommandLabel(GenDiagram diagram) {
        String _i18nKeyForDiagramEditorUtil = this.i18nKeyForDiagramEditorUtil(diagram);
        return String.valueOf(_i18nKeyForDiagramEditorUtil) + ".CreateDiagramCommandLabel";
    }

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _diagramEditorUtilClassName = it.getDiagramEditorUtilClassName();
        _builder.append((Object)_diagramEditorUtilClassName, "");
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenEditorView _editor = _editorGen.getEditor();
        String _packageName = _editor.getPackageName();
        _builder.append((Object)_packageName, "");
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    public CharSequence DiagramEditorUtil(GenDiagram it) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        CharSequence _copyright = this._common.copyright(_editorGen);
        _builder.append((Object)_copyright, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _saveOptions = this.saveOptions(it);
        _builder.append((Object)_saveOptions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _openDiagramMethod = this.openDiagramMethod(it);
        _builder.append((Object)_openDiagramMethod, "");
        _builder.newLineIfNotEmpty();
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenApplication _application = _editorGen_1.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        if (_equals) {
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _setCharsetMethods = this.setCharsetMethods(it);
            _builder.append((Object)_setCharsetMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _uniqueFileNameMethod = this.getUniqueFileNameMethod(it);
        _builder.append((Object)_uniqueFileNameMethod, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        GenApplication _application_1 = _editorGen_2.getApplication();
        boolean bl = _notEquals = !Objects.equal((Object)_application_1, null);
        if (_notEquals) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment("Allows user to select file and loads it as a model.");
            _builder.append((Object)_generatedMemberComment, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public static org.eclipse.emf.ecore.resource.Resource openModel(");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"org.eclipse.swt.widgets.Shell shell, String description, org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain) {");
            _builder.newLine();
            _builder.append((Object)"org.eclipse.swt.widgets.FileDialog fileDialog = new org.eclipse.swt.widgets.FileDialog(shell, org.eclipse.swt.SWT.OPEN);");
            _builder.newLine();
            _builder.append((Object)"if (description != null) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"fileDialog.setText(description);");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"fileDialog.open();");
            _builder.newLine();
            _builder.append((Object)"String fileName = fileDialog.getFileName();");
            _builder.newLine();
            _builder.append((Object)"if (fileName == null || fileName.length() == 0) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return null;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"if (fileDialog.getFilterPath() != null) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"fileName = fileDialog.getFilterPath() + java.io.File.separator + fileName;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"org.eclipse.emf.common.util.URI uri = org.eclipse.emf.common.util.URI.createFileURI(fileName);");
            _builder.newLine();
            _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource resource = null;");
            _builder.newLine();
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"resource = editingDomain.getResourceSet().getResource(uri, true);");
            _builder.newLine();
            _builder.append((Object)"} catch (org.eclipse.emf.common.util.WrappedException we) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            GenEditorGenerator _editorGen_3 = it.getEditorGen();
            GenPlugin _plugin = _editorGen_3.getPlugin();
            CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append((Object)".getInstance().logError(\"Unable to load resource: \" + uri, we);  ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.jface.dialogs.MessageDialog.openError(shell, ");
            _builder.newLine();
            _builder.append((Object)"\t          ");
            GenEditorGenerator _editorGen_4 = it.getEditorGen();
            String _i18nKeyForOpenModelResourceErrorDialog = this.i18nKeyForOpenModelResourceErrorDialog(it);
            String _titleKey = this._externalizerUtils_qvto.titleKey(_i18nKeyForOpenModelResourceErrorDialog);
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen_4, _titleKey);
            _builder.append((Object)_accessorCall, "\t          ");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.osgi.util.NLS.bind(");
            _builder.newLine();
            _builder.append((Object)"\t    ");
            GenEditorGenerator _editorGen_5 = it.getEditorGen();
            String _i18nKeyForOpenModelResourceErrorDialog_1 = this.i18nKeyForOpenModelResourceErrorDialog(it);
            String _messageKey = this._externalizerUtils_qvto.messageKey(_i18nKeyForOpenModelResourceErrorDialog_1);
            CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(_editorGen_5, _messageKey);
            _builder.append((Object)_accessorCall_1, "\t    ");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t    ");
            _builder.append((Object)"fileName));");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"return resource;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment("Runs the wizard in a dialog.\n");
        _builder.append((Object)_generatedMemberComment_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static void runWizard(org.eclipse.swt.widgets.Shell shell, org.eclipse.jface.wizard.Wizard wizard, String settingsKey) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.jface.dialogs.IDialogSettings pluginDialogSettings = ");
        GenEditorGenerator _editorGen_6 = it.getEditorGen();
        GenPlugin _plugin_1 = _editorGen_6.getPlugin();
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(_plugin_1);
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append((Object)".getInstance().getDialogSettings();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.jface.dialogs.IDialogSettings wizardDialogSettings = pluginDialogSettings.getSection(settingsKey);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (wizardDialogSettings == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"wizardDialogSettings = pluginDialogSettings.addNewSection(settingsKey);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"wizard.setDialogSettings(wizardDialogSettings);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.jface.wizard.WizardDialog dialog = new org.eclipse.jface.wizard.WizardDialog(shell, wizard);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"dialog.create();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"dialog.open();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _createDiagramMethod = this.createDiagramMethod(it);
        _builder.append((Object)_createDiagramMethod, "\t");
        _builder.newLineIfNotEmpty();
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_domainDiagramElement, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            CharSequence _createInitialModelMethod = this.createInitialModelMethod(it);
            _builder.append((Object)_createInitialModelMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _attachModelMethod = this.attachModelMethod(it);
            _builder.append((Object)_attachModelMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            boolean _hasDocumentRoot = this._genDiagram_qvto.hasDocumentRoot(it);
            if (_hasDocumentRoot) {
                CharSequence _createDocumentRootMethod = this.createDocumentRootMethod(it);
                _builder.append((Object)_createDocumentRootMethod, "\t");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _selectElementsMethod = this.selectElementsMethod(it);
        _builder.append((Object)_selectElementsMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _findElementsMethod = this.findElementsMethod(it);
        _builder.append((Object)_findElementsMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _findViewMethod = this.findViewMethod(it);
        _builder.append((Object)_findViewMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence additions(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence saveOptions(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static java.util.Map<?, ?> getSaveOptions() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.HashMap<String, Object> saveOptions = new java.util.HashMap<String, Object>(); ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"saveOptions.put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_ENCODING, \"UTF-8\");  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"saveOptions.put(org.eclipse.emf.ecore.resource.Resource.OPTION_SAVE_ONLY_IF_CHANGED, org.eclipse.emf.ecore.resource.Resource.OPTION_SAVE_ONLY_IF_CHANGED_MEMORY_BUFFER);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return saveOptions;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence openDiagramMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static boolean openDiagram(org.eclipse.emf.ecore.resource.Resource diagram) throws org.eclipse.ui.PartInitException {");
        _builder.newLine();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        if (_equals) {
            _builder.append((Object)"String path = diagram.getURI().toPlatformString(true);");
            _builder.newLine();
            _builder.append((Object)"org.eclipse.core.resources.IResource workspaceResource = org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRoot().findMember(new org.eclipse.core.runtime.Path(path));");
            _builder.newLine();
            _builder.append((Object)"if (workspaceResource instanceof org.eclipse.core.resources.IFile) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.ui.IWorkbenchPage page = org.eclipse.ui.PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return null != page.openEditor(new org.eclipse.ui.part.FileEditorInput((org.eclipse.core.resources.IFile) workspaceResource), ");
            GenEditorGenerator _editorGen_1 = it.getEditorGen();
            GenEditorView _editor = _editorGen_1.getEditor();
            CharSequence _qualifiedClassName = this.xptEditor.qualifiedClassName(_editor);
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append((Object)".ID);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"return false;");
            _builder.newLine();
        } else {
            _builder.append((Object)"org.eclipse.ui.IWorkbenchPage page = org.eclipse.ui.PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();");
            _builder.newLine();
            _builder.append((Object)"page.openEditor(new org.eclipse.emf.common.ui.URIEditorInput(diagram.getURI()), ");
            GenEditorGenerator _editorGen_2 = it.getEditorGen();
            GenEditorView _editor_1 = _editorGen_2.getEditor();
            CharSequence _qualifiedClassName_1 = this.xptEditor.qualifiedClassName(_editor_1);
            _builder.append((Object)_qualifiedClassName_1, "");
            _builder.append((Object)".ID);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"return true;");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setCharsetMethods(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static void setCharset(org.eclipse.core.resources.IFile file) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (file == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"file.setCharset(\"UTF-8\", new org.eclipse.core.runtime.NullProgressMonitor());  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"} catch (org.eclipse.core.runtime.CoreException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenPlugin _plugin = _editorGen.getPlugin();
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append((Object)".getInstance().logError(\"Unable to set charset for file \" + file.getFullPath(), e);  ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getUniqueFileNameMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static String getUniqueFileName(org.eclipse.core.runtime.IPath containerFullPath, String fileName, String extension) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return org.eclipse.gmf.tooling.runtime.part.DefaultDiagramEditorUtil.getUniqueFileName(containerFullPath, fileName, extension, ");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gmf.tooling.runtime.part.DefaultDiagramEditorUtil.");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        if (_equals) {
            _builder.append((Object)"EXISTS_IN_WORKSPACE");
        } else {
            _builder.append((Object)"EXISTS_AS_IO_FILE");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createDiagramMethod(GenDiagram it) {
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        StringConcatenation _builder = new StringConcatenation();
        String _xifexpression = null;
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        _xifexpression = _equals ? "This method should be called within a workspace modify operation since it creates resources." : "";
        CharSequence _generatedMemberComment = this._common.generatedMemberComment(_xifexpression);
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static org.eclipse.emf.ecore.resource.Resource createDiagram(org.eclipse.emf.common.util.URI diagramURI,");
        boolean _standaloneDomainModel = this._genDiagram_qvto.standaloneDomainModel(it);
        if (_standaloneDomainModel) {
            _builder.append((Object)" org.eclipse.emf.common.util.URI modelURI,");
        }
        _builder.append((Object)" org.eclipse.core.runtime.IProgressMonitor progressMonitor) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain = org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory.INSTANCE.createEditingDomain();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"progressMonitor.beginTask(");
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        String _i18nKeyForCreateDiagramProgressTask = this.i18nKeyForCreateDiagramProgressTask(it);
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen_1, _i18nKeyForCreateDiagramProgressTask);
        _builder.append((Object)_accessorCall, "\t");
        _builder.append((Object)", 3);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"final org.eclipse.emf.ecore.resource.Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);");
        _builder.newLine();
        boolean _standaloneDomainModel_1 = this._genDiagram_qvto.standaloneDomainModel(it);
        if (_standaloneDomainModel_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"final org.eclipse.emf.ecore.resource.Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);");
            _builder.newLine();
        } else {
            boolean _hasDocumentRoot;
            boolean _and = false;
            GenClass _domainDiagramElement = it.getDomainDiagramElement();
            boolean _notEquals = !Objects.equal((Object)_domainDiagramElement, null);
            _and = !_notEquals ? false : (_hasDocumentRoot = this._genDiagram_qvto.hasDocumentRoot(it));
            if (_and) {
                _builder.append((Object)"\t");
                _builder.append((Object)"((org.eclipse.emf.ecore.xmi.XMLResource) diagramResource).getDefaultSaveOptions().put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_EXTENDED_META_DATA, Boolean.TRUE);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"((org.eclipse.emf.ecore.xmi.XMLResource) diagramResource).getDefaultLoadOptions().put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_EXTENDED_META_DATA, Boolean.TRUE);");
                _builder.newLine();
            }
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"final String diagramName = diagramURI.lastSegment();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand command = new org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand(editingDomain, ");
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        String _i18nKeyForCreateDiagramCommandLabel = this.i18nKeyForCreateDiagramCommandLabel(it);
        CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(_editorGen_2, _i18nKeyForCreateDiagramCommandLabel);
        _builder.append((Object)_accessorCall_1, "\t");
        _builder.append((Object)", java.util.Collections.EMPTY_LIST) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
        _builder.newLine();
        GenClass _domainDiagramElement_1 = it.getDomainDiagramElement();
        boolean bl = _notEquals_1 = !Objects.equal((Object)_domainDiagramElement_1, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t\t\t");
            GenClass _domainDiagramElement_2 = it.getDomainDiagramElement();
            CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_domainDiagramElement_2);
            _builder.append((Object)_QualifiedClassName, "\t\t\t");
            _builder.append((Object)" model = createInitialModel();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"attachModelToResource(model, ");
            boolean _standaloneDomainModel_2 = this._genDiagram_qvto.standaloneDomainModel(it);
            if (_standaloneDomainModel_2) {
                _builder.append((Object)"model");
            } else {
                _builder.append((Object)"diagram");
            }
            _builder.append((Object)"Resource);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t");
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append((Object)_extraLineBreak, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.Diagram diagram = org.eclipse.gmf.runtime.diagram.core.services.ViewService.createDiagram(");
        _builder.newLine();
        GenClass _domainDiagramElement_3 = it.getDomainDiagramElement();
        boolean bl2 = _notEquals_2 = !Objects.equal((Object)_domainDiagramElement_3, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t\t\t\t");
            GenClass _domainDiagramElement_4 = it.getDomainDiagramElement();
            CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_domainDiagramElement_4, "model");
            _builder.append((Object)_DowncastToEObject, "\t\t\t\t");
            _builder.append((Object)", ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t\t");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t\t\t\t");
        _builder.append((Object)", ");
        GenEditorGenerator _editorGen_3 = it.getEditorGen();
        CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(_editorGen_3);
        _builder.append((Object)_preferenceHintAccess, "\t\t\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (diagram != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"diagramResource.getContents().add(diagram);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"diagram.setName(diagramName);");
        _builder.newLine();
        GenClass _domainDiagramElement_5 = it.getDomainDiagramElement();
        boolean bl3 = _notEquals_3 = !Objects.equal((Object)_domainDiagramElement_5, null);
        if (_notEquals_3) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"diagram.setElement(");
            GenClass _domainDiagramElement_6 = it.getDomainDiagramElement();
            CharSequence _DowncastToEObject_1 = this.xptMetaModel.DowncastToEObject(_domainDiagramElement_6, "model");
            _builder.append((Object)_DowncastToEObject_1, "\t\t\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        boolean _standaloneDomainModel_3 = this._genDiagram_qvto.standaloneDomainModel(it);
        if (_standaloneDomainModel_3) {
            _builder.append((Object)"modelResource.save(");
            CharSequence _callGetSaveOptions = this.callGetSaveOptions(it);
            _builder.append((Object)_callGetSaveOptions, "\t\t\t\t");
            _builder.append((Object)");");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"diagramResource.save(");
        CharSequence _callGetSaveOptions_1 = this.callGetSaveOptions(it);
        _builder.append((Object)_callGetSaveOptions_1, "\t\t\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} catch (java.io.IOException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
        _builder.append((Object)_extraLineBreak_1, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        GenEditorGenerator _editorGen_4 = it.getEditorGen();
        GenPlugin _plugin = _editorGen_4.getPlugin();
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName, "\t\t\t\t");
        _builder.append((Object)".getInstance().logError(\"Unable to store model and diagram resources\", e);  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.core.commands.operations.OperationHistoryFactory.getOperationHistory().execute(command, new org.eclipse.core.runtime.SubProgressMonitor(progressMonitor, 1), null);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} catch (org.eclipse.core.commands.ExecutionException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        GenEditorGenerator _editorGen_5 = it.getEditorGen();
        GenPlugin _plugin_1 = _editorGen_5.getPlugin();
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(_plugin_1);
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append((Object)".getInstance().logError(\"Unable to create model and diagram\", e);  ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GenEditorGenerator _editorGen_6 = it.getEditorGen();
        GenApplication _application_1 = _editorGen_6.getApplication();
        boolean _equals_1 = Objects.equal((Object)_application_1, null);
        if (_equals_1) {
            _builder.append((Object)"\t");
            boolean _standaloneDomainModel_4 = this._genDiagram_qvto.standaloneDomainModel(it);
            if (_standaloneDomainModel_4) {
                _builder.append((Object)"setCharset(org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(modelResource));");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"setCharset(org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(diagramResource));");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"return diagramResource;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createInitialModelMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Create a new instance of domain element associated with canvas.\n<!-- begin-user-doc -->\n<!-- end-user-doc -->");
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static ");
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_domainDiagramElement);
        _builder.append((Object)_QualifiedClassName, "");
        _builder.append((Object)" createInitialModel() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        GenClass _domainDiagramElement_1 = it.getDomainDiagramElement();
        CharSequence _NewInstance = this.xptMetaModel.NewInstance(_domainDiagramElement_1);
        _builder.append((Object)_NewInstance, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attachModelMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Store model element in the resource.\n<!-- begin-user-doc -->\n<!-- end-user-doc -->");
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static void attachModelToResource(");
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_domainDiagramElement);
        _builder.append((Object)_QualifiedClassName, "");
        _builder.append((Object)" model, org.eclipse.emf.ecore.resource.Resource resource) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"resource.getContents().add(");
        boolean _hasDocumentRoot = this._genDiagram_qvto.hasDocumentRoot(it);
        if (_hasDocumentRoot) {
            _builder.append((Object)"createDocumentRoot(model)");
        } else {
            GenClass _domainDiagramElement_1 = it.getDomainDiagramElement();
            CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(_domainDiagramElement_1, "model");
            _builder.append((Object)_DowncastToEObject, "\t");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createDocumentRootMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static ");
        GenClass _documentRoot = this._genDiagram_qvto.getDocumentRoot(it);
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)_documentRoot);
        _builder.append((Object)_QualifiedClassName, "");
        _builder.append((Object)" createDocumentRoot(");
        GenClass _domainDiagramElement = it.getDomainDiagramElement();
        CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName((GenClassifier)_domainDiagramElement);
        _builder.append((Object)_QualifiedClassName_1, "");
        _builder.append((Object)" model) {");
        _builder.newLineIfNotEmpty();
        GenClass _domainDiagramElement_1 = it.getDomainDiagramElement();
        GenClass _documentRoot_1 = this._genDiagram_qvto.getDocumentRoot(it);
        boolean _equals = Objects.equal((Object)_domainDiagramElement_1, (Object)_documentRoot_1);
        if (_equals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"return model;");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            GenClass _documentRoot_2 = this._genDiagram_qvto.getDocumentRoot(it);
            CharSequence _NewInstance = this.xptMetaModel.NewInstance(_documentRoot_2, "docRoot");
            _builder.append((Object)_NewInstance, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            GenFeature rootFeature = this._genDiagram_qvto.getDocumentRootSetFeature(it);
            _builder.newLineIfNotEmpty();
            boolean _equals_1 = Objects.equal((Object)rootFeature, null);
            if (_equals_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"docRoot.set");
                GenClass _domainDiagramElement_2 = it.getDomainDiagramElement();
                EClass _ecoreClass = _domainDiagramElement_2.getEcoreClass();
                String _name = _ecoreClass.getName();
                _builder.append((Object)_name, "\t");
                _builder.append((Object)"(model); // FIXME name of the set method is pure guess");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                GenClass _documentRoot_3 = this._genDiagram_qvto.getDocumentRoot(it);
                CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(rootFeature, "docRoot", _documentRoot_3, "model");
                _builder.append((Object)_modifyFeature, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"return docRoot;");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence selectElementsMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static void selectElementsInDiagram(org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart diagramPart, java.util.List<org.eclipse.gef.EditPart> editParts) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"diagramPart.getDiagramGraphicalViewer().deselectAll();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gef.EditPart firstPrimary = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.gef.EditPart nextPart : editParts) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"diagramPart.getDiagramGraphicalViewer().appendSelection(nextPart);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if(firstPrimary == null && nextPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"firstPrimary = nextPart;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if(!editParts.isEmpty()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"diagramPart.getDiagramGraphicalViewer().reveal(firstPrimary != null ? firstPrimary : (org.eclipse.gef.EditPart)editParts.get(0));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence findElementsMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static int findElementsInDiagramByID(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramPart, org.eclipse.emf.ecore.EObject element, java.util.List<org.eclipse.gef.EditPart> editPartCollector) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer viewer = (org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer) diagramPart.getViewer();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"final int intialNumOfEditParts = editPartCollector.size();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (element instanceof org.eclipse.gmf.runtime.notation.View) { // support notation element lookup");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gef.EditPart editPart = (org.eclipse.gef.EditPart) viewer.getEditPartRegistry().get(element);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (editPart != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"editPartCollector.add(editPart);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return 1;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"String elementID = org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getProxyID(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.List<org.eclipse.gef.EditPart> associatedParts = viewer.findEditPartsForElement(elementID, org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// perform the possible hierarchy disjoint -> take the top-most parts only");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.gef.EditPart nextPart : associatedParts) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gef.EditPart parentPart = nextPart.getParent();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"while (parentPart != null && !associatedParts.contains(parentPart)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"parentPart = parentPart.getParent();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (parentPart == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"editPartCollector.add(nextPart);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (intialNumOfEditParts == editPartCollector.size()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (!associatedParts.isEmpty()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"editPartCollector.add(associatedParts.get(0));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (element.eContainer() != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return findElementsInDiagramByID(diagramPart, element.eContainer(), editPartCollector);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return editPartCollector.size() - intialNumOfEditParts;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence findViewMethod(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static org.eclipse.gmf.runtime.notation.View findView(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart, org.eclipse.emf.ecore.EObject targetElement, LazyElement2ViewMap lazyElement2ViewMap) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"boolean hasStructuralURI = false;\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if(targetElement.eResource() instanceof org.eclipse.emf.ecore.xmi.XMLResource) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"hasStructuralURI = ((org.eclipse.emf.ecore.xmi.XMLResource)targetElement.eResource()).getID(targetElement) == null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View view = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.gef.EditPart> editPartHolder = new java.util.LinkedList<org.eclipse.gef.EditPart>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if(hasStructuralURI && !lazyElement2ViewMap.getElement2ViewMap().isEmpty()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"view = lazyElement2ViewMap.getElement2ViewMap().get(targetElement);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (findElementsInDiagramByID(diagramEditPart, targetElement, editPartHolder) > 0) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gef.EditPart editPart = editPartHolder.get(0);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"view = editPart.getModel() instanceof org.eclipse.gmf.runtime.notation.View ? (org.eclipse.gmf.runtime.notation.View) editPart.getModel() : null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return (view == null) ? diagramEditPart.getDiagramView() : view;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment("XXX This is quite suspicious code (especially editPartTmpHolder) and likely to be removed soon");
        _builder.append((Object)_generatedMemberComment_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static class LazyElement2ViewMap {");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private java.util.Map<org.eclipse.emf.ecore.EObject, org.eclipse.gmf.runtime.notation.View> element2ViewMap;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private org.eclipse.gmf.runtime.notation.View scope;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private java.util.Set<? extends org.eclipse.emf.ecore.EObject> elementSet;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public LazyElement2ViewMap(org.eclipse.gmf.runtime.notation.View scope, java.util.Set<? extends org.eclipse.emf.ecore.EObject> elements) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.scope = scope;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.elementSet = elements;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_6, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public final java.util.Map<org.eclipse.emf.ecore.EObject, org.eclipse.gmf.runtime.notation.View> getElement2ViewMap() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if(element2ViewMap == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"element2ViewMap = new java.util.HashMap<org.eclipse.emf.ecore.EObject, org.eclipse.gmf.runtime.notation.View>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// map possible notation elements to itself as these can't be found by view.getElement()");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (org.eclipse.emf.ecore.EObject element : elementSet) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if(element instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) element;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if(view.getDiagram() == scope.getDiagram()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"element2ViewMap.put(element, view); // take only those that part of our diagram");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"buildElement2ViewMap(scope, element2ViewMap, elementSet);\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return element2ViewMap;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_7, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static boolean buildElement2ViewMap(org.eclipse.gmf.runtime.notation.View parentView, java.util.Map<org.eclipse.emf.ecore.EObject, org.eclipse.gmf.runtime.notation.View> element2ViewMap, java.util.Set<? extends org.eclipse.emf.ecore.EObject> elements) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (elements.size() == element2ViewMap.size()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if(parentView.isSetElement() && !element2ViewMap.containsKey(parentView.getElement()) && elements.contains(parentView.getElement())) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"element2ViewMap.put(parentView.getElement(), parentView);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (elements.size() == element2ViewMap.size()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"boolean complete = false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<?> it = parentView.getChildren().iterator(); it.hasNext() && !complete;) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"complete = buildElement2ViewMap((org.eclipse.gmf.runtime.notation.View) it.next(), element2ViewMap, elements);\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<?> it = parentView.getSourceEdges().iterator(); it.hasNext() && !complete;) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"complete = buildElement2ViewMap((org.eclipse.gmf.runtime.notation.View) it.next(), element2ViewMap, elements);\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<?> it = parentView.getTargetEdges().iterator(); it.hasNext() && !complete;) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"complete = buildElement2ViewMap((org.eclipse.gmf.runtime.notation.View) it.next(), element2ViewMap, elements);\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return complete;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"} //LazyElement2ViewMap\t");
        _builder.newLine();
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _i18nKeyForOpenModelResourceErrorDialog = this.i18nKeyForOpenModelResourceErrorDialog(it);
        String _titleKey = this._externalizerUtils_qvto.titleKey(_i18nKeyForOpenModelResourceErrorDialog);
        CharSequence _accessorField = this.xptExternalizer.accessorField(_titleKey);
        _builder.append((Object)_accessorField, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForOpenModelResourceErrorDialog_1 = this.i18nKeyForOpenModelResourceErrorDialog(it);
        String _messageKey = this._externalizerUtils_qvto.messageKey(_i18nKeyForOpenModelResourceErrorDialog_1);
        CharSequence _accessorField_1 = this.xptExternalizer.accessorField(_messageKey);
        _builder.append((Object)_accessorField_1, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForCreateDiagramProgressTask = this.i18nKeyForCreateDiagramProgressTask(it);
        CharSequence _accessorField_2 = this.xptExternalizer.accessorField(_i18nKeyForCreateDiagramProgressTask);
        _builder.append((Object)_accessorField_2, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForCreateDiagramCommandLabel = this.i18nKeyForCreateDiagramCommandLabel(it);
        CharSequence _accessorField_3 = this.xptExternalizer.accessorField(_i18nKeyForCreateDiagramCommandLabel);
        _builder.append((Object)_accessorField_3, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _i18nKeyForOpenModelResourceErrorDialog = this.i18nKeyForOpenModelResourceErrorDialog(it);
        String _titleKey = this._externalizerUtils_qvto.titleKey(_i18nKeyForOpenModelResourceErrorDialog);
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(_titleKey, "Error");
        _builder.append((Object)_messageEntry, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForOpenModelResourceErrorDialog_1 = this.i18nKeyForOpenModelResourceErrorDialog(it);
        String _messageKey = this._externalizerUtils_qvto.messageKey(_i18nKeyForOpenModelResourceErrorDialog_1);
        CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(_messageKey, "Failed to load model file {0}");
        _builder.append((Object)_messageEntry_1, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForCreateDiagramProgressTask = this.i18nKeyForCreateDiagramProgressTask(it);
        CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(_i18nKeyForCreateDiagramProgressTask, "Creating diagram and model files");
        _builder.append((Object)_messageEntry_2, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForCreateDiagramCommandLabel = this.i18nKeyForCreateDiagramCommandLabel(it);
        CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(_i18nKeyForCreateDiagramCommandLabel, "Creating diagram and model");
        _builder.append((Object)_messageEntry_3, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

