/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf;

import java.util.Arrays;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class LinkLFShapeNodeAnchorDelegate {
    public static final String KEY_ROUTED_LINK_POINTS = String.valueOf(LinkLFShapeNodeAnchorDelegate.class.getName()) + ":RoutedPoints";
    private NodeFigure myNodeFigure;

    public LinkLFShapeNodeAnchorDelegate(NodeFigure nodeFigure) {
        this.myNodeFigure = nodeFigure;
    }

    public NodeFigure getNodeFigure() {
        return this.myNodeFigure;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point fromRequest = this.safeGetPointFromLinkRequest(request);
        ConnectionAnchor result = this.getNodeFigure().getSourceConnectionAnchorAt(fromRequest);
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reqImpl = (ReconnectRequest)request;
            AbstractConnectionEditPart linkEP = (AbstractConnectionEditPart)reqImpl.getConnectionEditPart();
            Connection conn = linkEP.getConnectionFigure();
            ConnectionRouter router = conn.getConnectionRouter();
            PointList pointsBefore = conn.getPoints().getCopy();
            ConnectionAnchor oldSourceAnchor = conn.getSourceAnchor();
            conn.setSourceAnchor(result);
            router.route(conn);
            PointList pointsAfter = conn.getPoints().getCopy();
            Point routedLocation = pointsAfter.getFirstPoint();
            conn.translateToAbsolute((Translatable)routedLocation);
            result = this.getNodeFigure().getSourceConnectionAnchorAt(routedLocation);
            if (!Arrays.equals(pointsAfter.toIntArray(), pointsBefore.toIntArray())) {
                conn.setPoints(pointsBefore);
                if (router instanceof OrthogonalRouter) {
                    request.getExtendedData().put(KEY_ROUTED_LINK_POINTS, pointsAfter);
                }
            }
            conn.setSourceAnchor(oldSourceAnchor);
        }
        return result;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point fromRequestAbs = this.safeGetPointFromLinkRequest(request);
        ConnectionAnchor result = this.getNodeFigure().getTargetConnectionAnchorAt(fromRequestAbs);
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reqImpl = (ReconnectRequest)request;
            AbstractConnectionEditPart linkEP = (AbstractConnectionEditPart)reqImpl.getConnectionEditPart();
            Connection conn = linkEP.getConnectionFigure();
            ConnectionRouter router = conn.getConnectionRouter();
            PointList pointsBefore = conn.getPoints().getCopy();
            ConnectionAnchor oldTargetAnchor = conn.getTargetAnchor();
            conn.setTargetAnchor(result);
            router.route(conn);
            PointList pointsAfter = conn.getPoints().getCopy();
            Point routedTarget = pointsAfter.getLastPoint();
            conn.translateToAbsolute((Translatable)routedTarget);
            result = this.getNodeFigure().getTargetConnectionAnchorAt(routedTarget);
            if (!Arrays.equals(pointsAfter.toIntArray(), pointsBefore.toIntArray())) {
                conn.setPoints(pointsBefore);
                if (router instanceof OrthogonalRouter) {
                    request.getExtendedData().put(KEY_ROUTED_LINK_POINTS, pointsAfter);
                }
            }
            conn.setTargetAnchor(oldTargetAnchor);
        }
        return result;
    }

    private Point safeGetPointFromLinkRequest(Request request) {
        Point result = null;
        if (request instanceof DropRequest) {
            result = ((DropRequest)request).getLocation();
        }
        if (result != null && request instanceof ReconnectRequest) {
            result = result.getCopy();
        }
        return result;
    }
}

