/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.parsers;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.tooling.runtime.Messages;
import org.eclipse.gmf.tooling.runtime.parsers.AbstractFeatureParser;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractAttributeParser
extends AbstractFeatureParser {
    private String viewPattern;
    private String editorPattern;
    private String editPattern;
    protected final EAttribute[] features;
    protected final EAttribute[] editableFeatures;

    public AbstractAttributeParser(EAttribute[] features) {
        super((EStructuralFeature[])features);
        this.editableFeatures = features;
        this.features = features;
    }

    public AbstractAttributeParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super((EStructuralFeature[])features, (EStructuralFeature[])editableFeatures);
        this.features = features;
        this.editableFeatures = editableFeatures;
    }

    @Override
    protected Object getValue(EObject element, EStructuralFeature feature) {
        Object value = super.getValue(element, feature);
        Class iClass = ((EAttribute)feature).getEAttributeType().getInstanceClass();
        if (String.class.equals((Object)iClass) && value == null) {
            value = "";
        }
        return value;
    }

    @Override
    protected Object getValidNewValue(EStructuralFeature feature, Object value) {
        EClassifier type = feature.getEType();
        if (type instanceof EDataType) {
            Class iClass = type.getInstanceClass();
            if (Boolean.TYPE.equals(iClass)) {
                if (!(value instanceof Boolean)) {
                    value = value instanceof String ? Boolean.valueOf((String)value) : new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Character.TYPE.equals(iClass)) {
                if (!(value instanceof Character)) {
                    String s;
                    value = value instanceof String ? ((s = (String)value).length() == 0 ? null : new Character(s.charAt(0))) : new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                }
            } else if (Byte.TYPE.equals(iClass)) {
                if (!(value instanceof Byte)) {
                    if (value instanceof Number) {
                        value = new Byte(((Number)value).byteValue());
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Byte.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_WrongStringConversion, (Object)iClass.getName()));
                            }
                        }
                    } else {
                        value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                    }
                }
            } else if (Short.TYPE.equals(iClass)) {
                if (!(value instanceof Short)) {
                    if (value instanceof Number) {
                        value = new Short(((Number)value).shortValue());
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Short.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_WrongStringConversion, (Object)iClass.getName()));
                            }
                        }
                    } else {
                        value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                    }
                }
            } else if (Integer.TYPE.equals(iClass)) {
                if (!(value instanceof Integer)) {
                    if (value instanceof Number) {
                        value = new Integer(((Number)value).intValue());
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Integer.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_WrongStringConversion, (Object)iClass.getName()));
                            }
                        }
                    } else {
                        value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                    }
                }
            } else if (Long.TYPE.equals(iClass)) {
                if (!(value instanceof Long)) {
                    if (value instanceof Number) {
                        value = new Long(((Number)value).longValue());
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Long.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_WrongStringConversion, (Object)iClass.getName()));
                            }
                        }
                    } else {
                        value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                    }
                }
            } else if (Float.TYPE.equals(iClass)) {
                if (!(value instanceof Float)) {
                    if (value instanceof Number) {
                        value = new Float(((Number)value).floatValue());
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Float.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_WrongStringConversion, (Object)iClass.getName()));
                            }
                        }
                    } else {
                        value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                    }
                }
            } else if (Double.TYPE.equals(iClass)) {
                if (!(value instanceof Double)) {
                    if (value instanceof Number) {
                        value = new Double(((Number)value).doubleValue());
                    } else if (value instanceof String) {
                        String s = (String)value;
                        if (s.length() == 0) {
                            value = null;
                        } else {
                            try {
                                value = Double.valueOf(s);
                            }
                            catch (NumberFormatException numberFormatException) {
                                value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_WrongStringConversion, (Object)iClass.getName()));
                            }
                        }
                    } else {
                        value = new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)iClass.getName()));
                    }
                }
            } else if (type instanceof EEnum) {
                EEnumLiteral literal;
                value = value instanceof String ? ((literal = ((EEnum)type).getEEnumLiteralByLiteral((String)value)) == null ? new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnknownLiteral, (Object)value)) : literal.getInstance()) : new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)String.class.getName()));
            }
        }
        return value;
    }

    public String getViewPattern() {
        return this.viewPattern;
    }

    public void setViewPattern(String viewPattern) {
        this.viewPattern = viewPattern;
    }

    public String getEditorPattern() {
        return this.editorPattern;
    }

    public void setEditorPattern(String editorPattern) {
        this.editorPattern = editorPattern;
    }

    public String getEditPattern() {
        return this.editPattern;
    }

    public void setEditPattern(String editPattern) {
        this.editPattern = editPattern;
    }
}

