/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;
import org.eclipse.gmf.graphdef.editor.edit.parts.LabelText3EditPart;
import org.eclipse.gmf.graphdef.editor.edit.policies.BorderLayoutEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.FigureContainerXYLayoutEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.GridLayoutEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.Label3ItemSemanticEditPolicy;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphVisualIDRegistry;
import org.eclipse.gmf.graphdef.editor.providers.GMFGraphElementTypes;
import org.eclipse.gmf.graphdef.editor.sheet.AttachAdapter;
import org.eclipse.gmf.graphdef.editor.sheet.ChangeTracker;
import org.eclipse.gmf.graphdef.editor.sheet.FeatureTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class Label3EditPart
extends AbstractFigureEditPart {
    public static final int VISUAL_ID = 3028;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private Collection<Adapter> myDomainElementAdapters = new ArrayList<Adapter>();

    public Label3EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new Label3ItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        Layout layout = this.getGmfgraphElement().getLayout();
        if (layout != null) {
            switch (layout.eClass().getClassifierID()) {
                case 67: {
                    return new BorderLayoutEditPolicy();
                }
                case 66: {
                    return new GridLayoutEditPolicy();
                }
            }
        }
        return new FigureContainerXYLayoutEditPolicy(this.getMapMode());
    }

    protected IFigure createNodeShape() {
        BorderedLabelFigure figure = new BorderedLabelFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public BorderedLabelFigure getPrimaryShape() {
        return (BorderedLabelFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof LabelText3EditPart) {
            ((LabelText3EditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureBorderedLabelFigure_TextLabel());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return childEditPart instanceof LabelText3EditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(0, 0);
        result.setMinimumSize(new Dimension(0, 0));
        return result;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy result = super.getPrimaryDragEditPolicy();
        if (result instanceof ResizableEditPolicy) {
            ResizableEditPolicy ep = (ResizableEditPolicy)result;
            ep.setResizeDirections(0);
        }
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(GMFGraphVisualIDRegistry.getType(5012));
    }

    public List getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        types.add(GMFGraphElementTypes.ChildAccess_4002);
        return types;
    }

    public List getMATypesForSource(IElementType relationshipType) {
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        if (relationshipType == GMFGraphElementTypes.ChildAccess_4002) {
            types.add(GMFGraphElementTypes.FigureDescriptor_3009);
        }
        return types;
    }

    private Label getGmfgraphElement() {
        View view = this.getNotationView();
        if (view == null) {
            return null;
        }
        EObject element = view.getElement();
        if (element instanceof Label) {
            Label modelFigureElement = (Label)element;
            return modelFigureElement;
        }
        return null;
    }

    protected void removeSemanticListeners() {
        Label modelElement = this.getGmfgraphElement();
        if (modelElement != null) {
            modelElement.eAdapters().removeAll(this.myDomainElementAdapters);
            this.myDomainElementAdapters.clear();
        }
        super.removeSemanticListeners();
    }

    protected void setFigure(IFigure figure) {
        super.setFigure(figure);
        Label modelElement = this.getGmfgraphElement();
        if (modelElement != null) {
            this.getPrimaryShape().setBackgroundColor(Label3EditPart.getColor(modelElement.getBackgroundColor()));
            this.getPrimaryShape().setForegroundColor(Label3EditPart.getColor(modelElement.getForegroundColor()));
            this.refreshFont();
        }
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        final Label modelElement = this.getGmfgraphElement();
        if (modelElement == null) {
            super.activate();
            return;
        }
        ChangeTracker backgroundColorTracker = new ChangeTracker(){

            public void modelChanged(Notification msg) {
                Label3EditPart.this.getPrimaryShape().setBackgroundColor(Label3EditPart.getColor(modelElement.getBackgroundColor()));
            }
        };
        this.myDomainElementAdapters.add((Adapter)new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_BackgroundColor(), backgroundColorTracker, new Adapter[]{new FeatureTracker(backgroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getConstantColor_Value()}), new FeatureTracker(backgroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Red()}), new FeatureTracker(backgroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Green()}), new FeatureTracker(backgroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Blue()})}));
        ChangeTracker foregroundColorTracker = new ChangeTracker(){

            public void modelChanged(Notification msg) {
                Label3EditPart.this.getPrimaryShape().setForegroundColor(Label3EditPart.getColor(modelElement.getForegroundColor()));
            }
        };
        this.myDomainElementAdapters.add((Adapter)new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_ForegroundColor(), foregroundColorTracker, new Adapter[]{new FeatureTracker(foregroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getConstantColor_Value()}), new FeatureTracker(foregroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Red()}), new FeatureTracker(foregroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Green()}), new FeatureTracker(foregroundColorTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getRGBColor_Blue()})}));
        ChangeTracker refreshFontTracker = new ChangeTracker(){

            public void modelChanged(Notification msg) {
                Label3EditPart.this.refreshFont();
            }
        };
        this.myDomainElementAdapters.add((Adapter)new AttachAdapter(GMFGraphPackage.eINSTANCE.getFigure_Font(), refreshFontTracker, new Adapter[]{new FeatureTracker(refreshFontTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getBasicFont_FaceName()}), new FeatureTracker(refreshFontTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getBasicFont_Height()}), new FeatureTracker(refreshFontTracker, new EStructuralFeature[]{GMFGraphPackage.eINSTANCE.getBasicFont_Style()})}));
        modelElement.eAdapters().addAll(this.myDomainElementAdapters);
        super.activate();
    }

    public class BorderedLabelFigure
    extends RectangleFigure {
        private WrappingLabel fFigureBorderedLabelFigure_TextLabel;
        private boolean myUseLocalCoordinates = false;

        public BorderedLabelFigure() {
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.setFill(false);
            this.setLineWidth(1);
            this.createContents();
        }

        private void createContents() {
            this.fFigureBorderedLabelFigure_TextLabel = new WrappingLabel();
            this.fFigureBorderedLabelFigure_TextLabel.setText("<<Label>>");
            this.add((IFigure)this.fFigureBorderedLabelFigure_TextLabel);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public WrappingLabel getFigureBorderedLabelFigure_TextLabel() {
            return this.fFigureBorderedLabelFigure_TextLabel;
        }
    }
}

