/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.directedit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.tooling.runtime.directedit.CellEditorEx;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public abstract class DirectEditManagerBase
extends DirectEditManager {
    private Color proposalPopupBackgroundColor = null;
    private Color proposalPopupForegroundColor = null;
    private boolean committed = false;
    private boolean listenersAttached = true;
    private StringBuffer initialString = new StringBuffer();
    private List cachedFontDescriptors = new ArrayList();
    private Font zoomLevelFont = null;
    private AncestorListener textFigureListener;
    private Class editorType;

    public DirectEditManagerBase(ITextAwareEditPart source) {
        this((GraphicalEditPart)source, null, DirectEditManagerBase.getCellEditorLocator(source));
    }

    public DirectEditManagerBase(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
        this.editorType = editorType;
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        if (this.editorType != null) {
            return super.createCellEditorOn(composite);
        }
        return this.doCreateCellEditorOn(composite);
    }

    public static CellEditorLocator getCellEditorLocator(final ITextAwareEditPart source) {
        final ILabelDelegate label = (ILabelDelegate)source.getAdapter(ILabelDelegate.class);
        if (label != null) {
            return new CellEditorLocator(){

                public void relocate(CellEditor celleditor) {
                    org.eclipse.swt.graphics.Rectangle newRect;
                    Scrollable control = (Scrollable)celleditor.getControl();
                    Rectangle rect = label.getTextBounds().getCopy();
                    if (label.getText().length() <= 0) {
                        rect.setSize(TextUtilities.INSTANCE.getTextExtents("a", control.getFont()));
                        if (label.isTextWrapOn()) {
                            if (label.getTextJustification() == 4) {
                                rect.translate(-rect.width, 0);
                            } else if (label.getTextJustification() == 2) {
                                rect.translate(-rect.width / 2, 0);
                            }
                        }
                    }
                    if (!control.getFont().isDisposed()) {
                        if (label.isTextWrapOn()) {
                            int charHeight = FigureUtilities.getFontMetrics((Font)control.getFont()).getHeight();
                            rect.resize(0, charHeight / 2);
                        } else {
                            rect.setSize(new Dimension(control.computeSize(-1, -1)));
                            int avr = FigureUtilities.getFontMetrics((Font)control.getFont()).getAverageCharWidth();
                            rect.setSize(new Dimension(control.computeSize(-1, -1)).expand(avr * 2, 0));
                        }
                    }
                    if (!(newRect = control.computeTrim(rect.x, rect.y, rect.width, rect.height)).equals((Object)control.getBounds())) {
                        control.setBounds(newRect.x, newRect.y, newRect.width, newRect.height);
                    }
                }
            };
        }
        return new CellEditorLocator(){

            public void relocate(CellEditor celleditor) {
                Control control = celleditor.getControl();
                Rectangle rect = source.getFigure().getBounds().getCopy();
                source.getFigure().translateToAbsolute((Translatable)rect);
                if (!rect.equals((Object)new Rectangle(control.getBounds()))) {
                    control.setBounds(rect.x, rect.y, rect.width, rect.height);
                }
            }
        };
    }

    protected Font getScaledFont(IFigure label) {
        Font scaledFont = label.getFont();
        FontData data = scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, MapModeUtil.getMapMode((IFigure)label).DPtoLP(data.getHeight()));
        label.translateToAbsolute((Translatable)fontSize);
        if (Math.abs(data.getHeight() - fontSize.height) < 2) {
            fontSize.height = data.getHeight();
        }
        try {
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)data);
            this.cachedFontDescriptors.add(fontDescriptor);
            return this.getResourceManager().createFont(fontDescriptor);
        }
        catch (DeviceResourceException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getScaledFont", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getScaledFont", (Throwable)e);
            return JFaceResources.getDefaultFont();
        }
    }

    protected void initCellEditor() {
        IContentAssistProcessor processor;
        this.committed = false;
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        this.setEditText(textEP.getEditText());
        IFigure label = textEP.getFigure();
        Assert.isNotNull((Object)label);
        Control control = this.getCellEditor().getControl();
        control.setFont(this.getScaledFont(label));
        this.getCellEditor().setValidator(textEP.getEditTextValidator());
        if (textEP.getParser() != null && (processor = textEP.getCompletionProcessor()) != null) {
            this.proposalPopupBackgroundColor = new Color((Device)this.getCellEditor().getControl().getShell().getDisplay(), new RGB(254, 241, 233));
            this.proposalPopupForegroundColor = new Color((Device)this.getCellEditor().getControl().getShell().getDisplay(), new RGB(0, 0, 0));
            this.createContentAssistant(control, this.proposalPopupForegroundColor, this.proposalPopupBackgroundColor, processor);
        }
    }

    protected void commit() {
        Control[] children;
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (activeShell != null && this.getCellEditor().getControl().getShell().equals(activeShell.getParent()) && (children = activeShell.getChildren()).length == 1 && children[0] instanceof Table) {
            this.getCellEditor().getControl().setVisible(true);
            ((CellEditorEx)this.getCellEditor()).setDeactivationLock(true);
            return;
        }
        if (this.committed) {
            this.bringDown();
            return;
        }
        this.committed = true;
        super.commit();
    }

    protected void bringDown() {
        if (this.proposalPopupForegroundColor != null) {
            this.proposalPopupForegroundColor.dispose();
            this.proposalPopupForegroundColor = null;
        }
        if (this.proposalPopupBackgroundColor != null) {
            this.proposalPopupBackgroundColor.dispose();
            this.proposalPopupBackgroundColor = null;
        }
        this.eraseFeedback();
        this.initialString = new StringBuffer();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                DirectEditManagerBase.super.bringDown();
            }
        });
        Iterator iter = this.cachedFontDescriptors.iterator();
        while (iter.hasNext()) {
            this.getResourceManager().destroyFont((FontDescriptor)iter.next());
        }
        this.cachedFontDescriptors.clear();
    }

    public void setEditText(String toEdit) {
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        textEP.setLabelText(toEdit);
        if (cellEditor instanceof CellEditorEx) {
            ((CellEditorEx)cellEditor).setValueAndProcessEditOccured(toEdit);
        } else {
            cellEditor.setValue((Object)toEdit);
        }
    }

    public void show(char initialChar) {
        this.initialString = this.initialString.append(initialChar);
        this.show();
        if (SWT.getPlatform() != "carbon") {
            this.setEditText(this.initialString.toString());
        }
    }

    private Font getZoomLevelFont(Font actualFont, Display display) {
        Object zoom = this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoom != null) {
            double zoomLevel = ((ZoomManager)zoom).getZoom();
            if (zoomLevel == 1.0) {
                return actualFont;
            }
            FontData[] fd = new FontData[actualFont.getFontData().length];
            FontData tempFD = null;
            int i = 0;
            while (i < fd.length) {
                tempFD = actualFont.getFontData()[i];
                fd[i] = new FontData(tempFD.getName(), (int)(zoomLevel * (double)tempFD.getHeight()), tempFD.getStyle());
                ++i;
            }
            try {
                FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData[])fd);
                this.cachedFontDescriptors.add(fontDescriptor);
                return this.getResourceManager().createFont(fontDescriptor);
            }
            catch (DeviceResourceException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getZoomLevelFonts", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getZoomLevelFonts", (Throwable)e);
                return actualFont;
            }
        }
        return actualFont;
    }

    public void show() {
        super.show();
        IFigure fig = this.getEditPart().getFigure();
        Control control = this.getCellEditor().getControl();
        this.zoomLevelFont = this.getZoomLevelFont(fig.getFont(), control.getDisplay());
        control.setFont(this.zoomLevelFont);
        this.getLocator().relocate(this.getCellEditor());
    }

    public void show(Point location) {
        this.show();
        this.sendClickToCellEditor(location);
    }

    private void sendClickToCellEditor(Point location) {
        this.getCellEditor().getControl().setCapture(true);
        if (this.getCellEditor() != null && this.getCellEditor().getControl().getBounds().contains(location)) {
            this.sendMouseClick(location);
        }
    }

    private void sendMouseClick(final Point location) {
        final Display currDisplay = Display.getCurrent();
        currDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                Event event = new Event();
                event.type = 3;
                event.button = 1;
                event.x = location.x;
                event.y = location.y;
                currDisplay.post(event);
                event.type = 4;
                currDisplay.post(event);
            }
        });
    }

    protected void hookListeners() {
        super.hookListeners();
        ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
        if (label != null && this.getEditPart().getFigure() instanceof WrappingLabel) {
            this.textFigureListener = new AncestorListener.Stub(){

                public void ancestorMoved(IFigure ancestor) {
                    DirectEditManagerBase.this.getLocator().relocate(DirectEditManagerBase.this.getCellEditor());
                }
            };
            ((IFigure)((WrappingLabel)this.getEditPart().getFigure()).getTextFigure().getChildren().get(0)).addAncestorListener(this.textFigureListener);
        }
    }

    protected void unhookListeners() {
        if (this.listenersAttached) {
            this.listenersAttached = false;
            super.unhookListeners();
            ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
            if (label != null && this.textFigureListener != null) {
                ((IFigure)((WrappingLabel)this.getEditPart().getFigure()).getTextFigure().getChildren().get(0)).removeAncestorListener(this.textFigureListener);
                this.textFigureListener = null;
            }
        }
    }

    protected void setCellEditor(CellEditor editor) {
        super.setCellEditor(editor);
        if (editor != null) {
            this.listenersAttached = true;
        }
    }

    public void showFeedback() {
        try {
            this.getEditPart().getRoot();
            super.showFeedback();
        }
        catch (Exception exception) {}
    }

    protected ResourceManager getResourceManager() {
        return ((DiagramGraphicalViewer)this.getEditPart().getViewer()).getResourceManager();
    }

    protected abstract CellEditor doCreateCellEditorOn(Composite var1);

    protected abstract void createContentAssistant(Control var1, Color var2, Color var3, IContentAssistProcessor var4);
}

