/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.parsers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTracker;
import org.eclipse.gmf.tooling.runtime.parsers.ChoiceParserBase;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.delegate.OCLQueryDelegateFactory;
import org.eclipse.ocl.expressions.OCLExpression;

public class OclChoiceParser
extends ChoiceParserBase {
    private static final String ITEM_PARAM_NAME = "_item";
    private static final String FILTER_ID = "OCLChoiceParser";
    private final OCL myOcl;
    private final org.eclipse.ocl.ecore.OCLExpression myItemsOclExpression;
    private final QueryDelegate myShowOclQuery;
    private final AdapterFactory myAdapterFactory;
    private Tracker myTracker;

    public OclChoiceParser(EStructuralFeature feature, String itemsExpression, String showExpression, AdapterFactory adapterFactory) {
        super(feature);
        this.myAdapterFactory = adapterFactory;
        this.myOcl = OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactory());
        EClass contextClass = feature.getEContainingClass();
        OCL.Helper helper = this.myOcl.createOCLHelper();
        helper.setContext((Object)contextClass);
        try {
            this.myItemsOclExpression = helper.createQuery(itemsExpression);
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
        if (showExpression == null) {
            this.myShowOclQuery = null;
        } else {
            HashMap<String, EClassifier> parameters = new HashMap<String, EClassifier>();
            parameters.put(ITEM_PARAM_NAME, this.getFeature().getEType());
            this.myShowOclQuery = new OCLQueryDelegateFactory().createQueryDelegate((EClassifier)contextClass, parameters, showExpression);
        }
        this.myTracker = new Tracker();
    }

    @Override
    protected Collection<Object> getItems(EObject element) {
        return (Collection)this.myOcl.evaluate((Object)element, (OCLExpression)this.myItemsOclExpression);
    }

    @Override
    protected String getEditChoice(EObject element, Object item) {
        Object result;
        if (item == null) {
            result = null;
        } else if (this.myShowOclQuery == null) {
            result = item;
        } else {
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put(ITEM_PARAM_NAME, item);
            try {
                result = this.myShowOclQuery.execute((Object)element, arguments);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (result == null) {
            return this.getNullItemEditChoice();
        }
        if (result instanceof EObject) {
            EObject eResult = (EObject)result;
            this.myTracker.setTracked(eResult);
            return ((IItemLabelProvider)this.myAdapterFactory.adapt((Notifier)eResult, IItemLabelProvider.class)).getText((Object)eResult);
        }
        return result.toString();
    }

    protected String getNullItemEditChoice() {
        return "";
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        return this.myTracker.isAffectingEvent(event, flags) || super.isAffectingEvent(event, flags);
    }

    public void installListeners(NotificationListener listener, OclTracker.Registrator oclRegistrator) {
        this.myTracker.start(listener, oclRegistrator);
    }

    public void uninstallListeners() {
        this.myTracker.stop();
    }

    private static class Tracker {
        private OclTracker.Registrator myOclRegistrator;
        private NotificationListener myListener;
        private EObject myTracked;
        private boolean myTracking = false;

        private Tracker() {
        }

        public void start(NotificationListener listener, OclTracker.Registrator oclRegistrator) {
            this.myOclRegistrator = oclRegistrator;
            this.myListener = listener;
            this.myTracking = true;
            this.registerListener();
        }

        public void stop() {
            this.unregisterListener();
            this.myTracking = false;
        }

        public void setTracked(EObject tracked) {
            if (tracked != this.myTracked) {
                this.unregisterListener();
                this.myTracked = tracked;
                this.registerListener();
            }
        }

        private void registerListener() {
            if (!this.myTracking || this.myTracked == null) {
                return;
            }
            this.myOclRegistrator.registerListener(OclChoiceParser.FILTER_ID, this.myListener, this.myTracked);
        }

        private void unregisterListener() {
            if (!this.myTracking || this.myTracked == null) {
                return;
            }
            this.myOclRegistrator.unregisterListener(OclChoiceParser.FILTER_ID);
        }

        public boolean isAffectingEvent(Object event, int flags) {
            Notification notification;
            return event instanceof Notification && (notification = (Notification)event).getNotifier() == this.myTracked;
        }
    }
}

