/*
 * Copyright (c) 2006, 2009 Borland Software Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     committers of openArchitectureWare - Xpand language syntax
 *     Artem Tikhomirov (Borland) - LALR grammar
 *                                - Migration to OCL expressions
 */
package org.eclipse.gmf.internal.xpand.parser;

public interface XpandParsersym {
    public final static int
      TK_INTEGER_LITERAL = 25,
      TK_REAL_LITERAL = 26,
      TK_STRING_LITERAL = 6,
      TK_PLUS = 37,
      TK_MINUS = 5,
      TK_MULTIPLY = 2,
      TK_DIVIDE = 41,
      TK_GREATER = 47,
      TK_LESS = 48,
      TK_EQUAL = 38,
      TK_GREATER_EQUAL = 49,
      TK_LESS_EQUAL = 50,
      TK_NOT_EQUAL = 51,
      TK_LPAREN = 1,
      TK_RPAREN = 4,
      TK_LBRACE = 58,
      TK_RBRACE = 56,
      TK_LBRACKET = 43,
      TK_RBRACKET = 70,
      TK_ARROW = 44,
      TK_BAR = 39,
      TK_COMMA = 21,
      TK_COLON = 52,
      TK_COLONCOLON = 40,
      TK_SEMICOLON = 61,
      TK_DOT = 45,
      TK_DOTDOT = 71,
      TK_RESET_ASSIGN = 62,
      TK_ADD_ASSIGN = 103,
      TK_EXCLAMATION_MARK = 46,
      TK_COLONCOLONEQUAL = 104,
      TK_QUESTIONMARK = 105,
      TK_SINGLE_LINE_COMMENT = 106,
      TK_MULTI_LINE_COMMENT = 107,
      TK_IMPORT = 72,
      TK_EXTENSION = 73,
      TK_AROUND = 63,
      TK_ENDAROUND = 59,
      TK_DEFINE = 64,
      TK_ENDDEFINE = 65,
      TK_ERROR = 74,
      TK_EXPAND = 75,
      TK_FOR = 53,
      TK_SEPARATOR = 76,
      TK_AS = 66,
      TK_ITERATOR = 77,
      TK_FOREACH = 67,
      TK_ENDFOREACH = 78,
      TK_FILE = 79,
      TK_ENDFILE = 80,
      TK_IF = 81,
      TK_ELSEIF = 82,
      TK_ELSE = 83,
      TK_ENDIF = 84,
      TK_LET = 85,
      TK_ENDLET = 86,
      TK_PROTECT = 87,
      TK_CSTART = 88,
      TK_CEND = 89,
      TK_ID = 90,
      TK_DISABLE = 91,
      TK_ENDPROTECT = 92,
      TK_LG = 93,
      TK_self = 32,
      TK_if = 33,
      TK_then = 94,
      TK_else = 95,
      TK_endif = 68,
      TK_and = 54,
      TK_or = 55,
      TK_xor = 57,
      TK_not = 31,
      TK_implies = 60,
      TK_let = 34,
      TK_in = 96,
      TK_true = 27,
      TK_false = 28,
      TK_null = 29,
      TK_invalid = 30,
      TK_Set = 7,
      TK_Bag = 8,
      TK_Sequence = 9,
      TK_Collection = 10,
      TK_OrderedSet = 11,
      TK_String = 12,
      TK_Integer = 13,
      TK_UnlimitedNatural = 14,
      TK_Real = 15,
      TK_Boolean = 16,
      TK_Tuple = 17,
      TK_OclAny = 18,
      TK_OclVoid = 19,
      TK_OclInvalid = 20,
      TK_Dict = 22,
      TK_List = 23,
      TK_break = 35,
      TK_switch = 108,
      TK_case = 109,
      TK_xselect = 97,
      TK_xcollect = 98,
      TK_selectOne = 99,
      TK_collectOne = 100,
      TK_collectselect = 101,
      TK_collectselectOne = 102,
      TK_forEach = 110,
      TK_forOne = 111,
      TK_compute = 112,
      TK_return = 113,
      TK_var = 114,
      TK_while = 115,
      TK_continue = 36,
      TK_log = 116,
      TK_assert = 117,
      TK_with = 118,
      TK_new = 119,
      TK_static = 120,
      TK_init = 121,
      TK_end = 122,
      TK_out = 123,
      TK_object = 124,
      TK_transformation = 125,
      TK_import = 126,
      TK_library = 127,
      TK_metamodel = 128,
      TK_mapping = 129,
      TK_query = 130,
      TK_helper = 131,
      TK_inout = 132,
      TK_when = 133,
      TK_configuration = 134,
      TK_intermediate = 135,
      TK_property = 136,
      TK_opposites = 137,
      TK_class = 138,
      TK_population = 139,
      TK_map = 140,
      TK_xmap = 141,
      TK_late = 142,
      TK_resolve = 143,
      TK_resolveone = 144,
      TK_resolveIn = 145,
      TK_resolveoneIn = 146,
      TK_invresolve = 147,
      TK_invresolveone = 148,
      TK_invresolveIn = 149,
      TK_invresolveoneIn = 150,
      TK_modeltype = 151,
      TK_uses = 152,
      TK_where = 153,
      TK_refines = 154,
      TK_access = 155,
      TK_extends = 156,
      TK_blackbox = 157,
      TK_abstract = 158,
      TK_result = 159,
      TK_main = 160,
      TK_this = 161,
      TK_rename = 162,
      TK_disjuncts = 163,
      TK_merges = 164,
      TK_inherits = 165,
      TK_composes = 166,
      TK_constructor = 167,
      TK_datatype = 168,
      TK_default = 169,
      TK_derived = 170,
      TK_do = 171,
      TK_elif = 172,
      TK_enum = 173,
      TK_except = 174,
      TK_exception = 175,
      TK_from = 176,
      TK_literal = 177,
      TK_ordered = 178,
      TK_primitive = 179,
      TK_raise = 180,
      TK_readonly = 181,
      TK_references = 182,
      TK_tag = 183,
      TK_try = 184,
      TK_typedef = 185,
      TK_unlimited = 186,
      TK_EOF_TOKEN = 69,
      TK_IDENTIFIER = 3,
      TK_STEREOTYPE_QUALIFIER_OPEN = 187,
      TK_STEREOTYPE_QUALIFIER_CLOSE = 188,
      TK_MULTIPLICITY_RANGE = 189,
      TK_TILDE_SIGN = 190,
      TK_NOT_EQUAL_EXEQ = 191,
      TK_AT_SIGN = 192,
      TK_TEXT = 24,
      TK_ERROR_TOKEN = 42;

    public final static String orderedTerminalSymbols[] = {
                 "",
                 "LPAREN",
                 "MULTIPLY",
                 "IDENTIFIER",
                 "RPAREN",
                 "MINUS",
                 "STRING_LITERAL",
                 "Set",
                 "Bag",
                 "Sequence",
                 "Collection",
                 "OrderedSet",
                 "String",
                 "Integer",
                 "UnlimitedNatural",
                 "Real",
                 "Boolean",
                 "Tuple",
                 "OclAny",
                 "OclVoid",
                 "OclInvalid",
                 "COMMA",
                 "Dict",
                 "List",
                 "TEXT",
                 "INTEGER_LITERAL",
                 "REAL_LITERAL",
                 "true",
                 "false",
                 "null",
                 "invalid",
                 "not",
                 "self",
                 "if",
                 "let",
                 "break",
                 "continue",
                 "PLUS",
                 "EQUAL",
                 "BAR",
                 "COLONCOLON",
                 "DIVIDE",
                 "ERROR_TOKEN",
                 "LBRACKET",
                 "ARROW",
                 "DOT",
                 "EXCLAMATION_MARK",
                 "GREATER",
                 "LESS",
                 "GREATER_EQUAL",
                 "LESS_EQUAL",
                 "NOT_EQUAL",
                 "COLON",
                 "FOR",
                 "and",
                 "or",
                 "RBRACE",
                 "xor",
                 "LBRACE",
                 "ENDAROUND",
                 "implies",
                 "SEMICOLON",
                 "RESET_ASSIGN",
                 "AROUND",
                 "DEFINE",
                 "ENDDEFINE",
                 "AS",
                 "FOREACH",
                 "endif",
                 "EOF_TOKEN",
                 "RBRACKET",
                 "DOTDOT",
                 "IMPORT",
                 "EXTENSION",
                 "ERROR",
                 "EXPAND",
                 "SEPARATOR",
                 "ITERATOR",
                 "ENDFOREACH",
                 "FILE",
                 "ENDFILE",
                 "IF",
                 "ELSEIF",
                 "ELSE",
                 "ENDIF",
                 "LET",
                 "ENDLET",
                 "PROTECT",
                 "CSTART",
                 "CEND",
                 "ID",
                 "DISABLE",
                 "ENDPROTECT",
                 "LG",
                 "then",
                 "else",
                 "in",
                 "xselect",
                 "xcollect",
                 "selectOne",
                 "collectOne",
                 "collectselect",
                 "collectselectOne",
                 "ADD_ASSIGN",
                 "COLONCOLONEQUAL",
                 "QUESTIONMARK",
                 "SINGLE_LINE_COMMENT",
                 "MULTI_LINE_COMMENT",
                 "switch",
                 "case",
                 "forEach",
                 "forOne",
                 "compute",
                 "return",
                 "var",
                 "while",
                 "log",
                 "assert",
                 "with",
                 "new",
                 "static",
                 "init",
                 "end",
                 "out",
                 "object",
                 "transformation",
                 "import",
                 "library",
                 "metamodel",
                 "mapping",
                 "query",
                 "helper",
                 "inout",
                 "when",
                 "configuration",
                 "intermediate",
                 "property",
                 "opposites",
                 "class",
                 "population",
                 "map",
                 "xmap",
                 "late",
                 "resolve",
                 "resolveone",
                 "resolveIn",
                 "resolveoneIn",
                 "invresolve",
                 "invresolveone",
                 "invresolveIn",
                 "invresolveoneIn",
                 "modeltype",
                 "uses",
                 "where",
                 "refines",
                 "access",
                 "extends",
                 "blackbox",
                 "abstract",
                 "result",
                 "main",
                 "this",
                 "rename",
                 "disjuncts",
                 "merges",
                 "inherits",
                 "composes",
                 "constructor",
                 "datatype",
                 "default",
                 "derived",
                 "do",
                 "elif",
                 "enum",
                 "except",
                 "exception",
                 "from",
                 "literal",
                 "ordered",
                 "primitive",
                 "raise",
                 "readonly",
                 "references",
                 "tag",
                 "try",
                 "typedef",
                 "unlimited",
                 "STEREOTYPE_QUALIFIER_OPEN",
                 "STEREOTYPE_QUALIFIER_CLOSE",
                 "MULTIPLICITY_RANGE",
                 "TILDE_SIGN",
                 "NOT_EQUAL_EXEQ",
                 "AT_SIGN"
             };

    public final static int numTokenKinds = orderedTerminalSymbols.length;
    public final static boolean isValidForParser = true;
}
