/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Feature;
import org.apache.batik.svggen.font.table.Lookup;
import org.apache.batik.svggen.font.table.LookupSubtableFactory;

public class LookupList {
    private int lookupCount;
    private int[] lookupOffsets;
    private Lookup[] lookups;

    public LookupList(RandomAccessFile randomAccessFile, int n, LookupSubtableFactory lookupSubtableFactory) throws IOException {
        randomAccessFile.seek(n);
        this.lookupCount = randomAccessFile.readUnsignedShort();
        this.lookupOffsets = new int[this.lookupCount];
        this.lookups = new Lookup[this.lookupCount];
        int n2 = 0;
        while (n2 < this.lookupCount) {
            this.lookupOffsets[n2] = randomAccessFile.readUnsignedShort();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.lookupCount) {
            this.lookups[n3] = new Lookup(lookupSubtableFactory, randomAccessFile, n + this.lookupOffsets[n3]);
            ++n3;
        }
    }

    public Lookup getLookup(Feature feature, int n) {
        if (feature.getLookupCount() > n) {
            int n2 = feature.getLookupListIndex(n);
            return this.lookups[n2];
        }
        return null;
    }
}

