/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies.assistant;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class SelectionBorder
extends LineBorder {
    private static final int CORNER_SIZE = 5;
    private boolean myShowBorder = false;
    private Insets myOuterInsets;
    private Insets myInnerInsets;

    public SelectionBorder(Color borderColor, int lineWidth, int lineStyle, Insets outerInsets, Insets innerInsets) {
        super(borderColor, lineWidth, lineStyle);
        this.myOuterInsets = outerInsets;
        this.myInnerInsets = innerInsets;
    }

    public void setShowBorder(boolean show) {
        this.myShowBorder = show;
    }

    public Insets getInsets(IFigure figure) {
        return super.getInsets(figure).add(this.myOuterInsets).add(this.myInnerInsets);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        if (!this.myShowBorder) {
            return;
        }
        tempRect.setBounds(SelectionBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        tempRect.crop(this.myOuterInsets);
        if (this.getWidth() % 2 == 1) {
            --SelectionBorder.tempRect.width;
            --SelectionBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        graphics.setLineStyle(this.getStyle());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRoundRectangle(tempRect, 5, 5);
    }
}

