/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.lite.edit.parts.labels.AbstractLabelTextDisplayer;
import org.eclipse.gmf.runtime.lite.edit.parts.labels.ILabelController;
import org.eclipse.gmf.runtime.lite.edit.parts.labels.ILabelTextDisplayer;
import org.eclipse.gmf.runtime.lite.edit.parts.labels.ItemProviderLabelTextDisplayer;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IExternallyUpdatableEditPart;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IUpdatableEditPart;
import org.eclipse.gmf.runtime.lite.edit.parts.update.RefreshAdapter;
import org.eclipse.gmf.runtime.lite.edit.parts.update.TransactionalUpdateManager;
import org.eclipse.gmf.runtime.lite.services.TreeDirectEditManager;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;

public class BaseTreeEditPart
extends AbstractTreeEditPart
implements IUpdatableEditPart,
IExternallyUpdatableEditPart,
ILabelController {
    private Image myImage;
    private ImageDescriptor myImageDescriptor;
    private AdapterFactory myAdapterFactory;
    private ILabelTextDisplayer myLabelTextDisplayer;
    private RefreshAdapter myDomainModelRefresher = new RefreshAdapter(this);
    private TreeDirectEditManager directEditManager;
    private HashMap<EStructuralFeature, IUpdatableEditPart.Refresher> structuralFeatures2Refresher;
    private Collection<IExternallyUpdatableEditPart.ExternalRefresher> myExternalRefreshers;

    public BaseTreeEditPart(View view, AdapterFactory adapterFactory) {
        this.setModel(view);
        this.myAdapterFactory = adapterFactory;
    }

    public View getNotationView() {
        return (View)this.getModel();
    }

    public EObject getElement() {
        return this.getNotationView().getElement();
    }

    public void activate() {
        super.activate();
        if (this.getElement() != null) {
            TransactionalUpdateManager updateManager = this.getTransactionalUpdateManager();
            if (updateManager == null) {
                this.getElement().eAdapters().add((Object)this.myDomainModelRefresher);
            } else {
                updateManager.addUpdatableEditPart(this.getElement(), this);
            }
        }
    }

    public void deactivate() {
        TransactionalUpdateManager updateManager = this.getTransactionalUpdateManager();
        if (this.getElement() != null) {
            if (updateManager == null) {
                this.getElement().eAdapters().remove((Object)this.myDomainModelRefresher);
            } else {
                updateManager.removeUpdatableEditPart(this.getElement(), this);
            }
        }
        super.deactivate();
    }

    protected TransactionalUpdateManager getTransactionalUpdateManager() {
        if (this.getParent() instanceof BaseTreeEditPart) {
            return ((BaseTreeEditPart)this.getParent()).getTransactionalUpdateManager();
        }
        return null;
    }

    protected List getModelChildren() {
        return this.getNotationView().getVisibleChildren();
    }

    protected Image getImage() {
        ImageDescriptor descriptor = this.getImageDescriptor();
        if (descriptor == null) {
            this.disposeImage();
            this.myImageDescriptor = null;
            return null;
        }
        if (this.myImageDescriptor != descriptor) {
            this.disposeImage();
            this.myImageDescriptor = descriptor;
            return this.createImage();
        }
        if (this.myImage == null || this.myImage.isDisposed()) {
            return this.createImage();
        }
        return this.myImage;
    }

    @Override
    public final ILabelTextDisplayer getLabelTextDisplayer() {
        if (this.myLabelTextDisplayer == null) {
            this.myLabelTextDisplayer = this.createLabelTextDisplayer();
            if (this.myLabelTextDisplayer == null) {
                this.myLabelTextDisplayer = new NullLabelTextDisplayer();
            }
        }
        return this.myLabelTextDisplayer;
    }

    protected ILabelTextDisplayer createLabelTextDisplayer() {
        return new ItemProviderLabelTextDisplayer(this.myAdapterFactory);
    }

    @Override
    public void setLabelText(String text) {
        if (text == null || text.length() == 0) {
            text = this.getDefaultLabelText();
        }
        this.setWidgetText(text);
    }

    protected String getDefaultLabelText() {
        return "";
    }

    private Image createImage() {
        this.disposeImage();
        this.myImage = this.myImageDescriptor.createImage();
        return this.myImage;
    }

    private void disposeImage() {
        if (this.myImage != null && !this.myImage.isDisposed()) {
            this.myImage.dispose();
        }
        this.myImage = null;
    }

    protected ImageDescriptor getImageDescriptor() {
        if (this.getElement() == null) {
            return null;
        }
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.myAdapterFactory.adapt((Notifier)this.getElement(), IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)this.getElement()));
        }
        return null;
    }

    protected String getText() {
        String result = this.getLabelTextDisplayer().getDisplayText(this.getElement());
        if (result == null || result.length() == 0) {
            return this.getDefaultLabelText();
        }
        return result;
    }

    @Override
    public IUpdatableEditPart.Refresher getRefresher(EStructuralFeature feature, Notification msg) {
        if (this.structuralFeatures2Refresher == null) {
            this.createRefreshers();
        }
        return this.structuralFeatures2Refresher.get(feature);
    }

    protected void createRefreshers() {
        this.structuralFeatures2Refresher = new HashMap();
        IUpdatableEditPart.Refresher childrenRefresher = new IUpdatableEditPart.Refresher(){

            @Override
            public void refresh() {
                BaseTreeEditPart.this.refreshChildren();
            }
        };
        this.registerRefresher((EStructuralFeature)NotationPackage.eINSTANCE.getView_PersistedChildren(), childrenRefresher);
        this.registerRefresher((EStructuralFeature)NotationPackage.eINSTANCE.getView_TransientChildren(), childrenRefresher);
        this.registerRefresher((EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible(), childrenRefresher);
        this.registerRefresher((EStructuralFeature)NotationPackage.eINSTANCE.getView_Styles(), childrenRefresher);
        this.registerRefresher((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed(), childrenRefresher);
        this.registerRefresher((EStructuralFeature)NotationPackage.eINSTANCE.getView_SourceEdges(), childrenRefresher);
    }

    @Override
    public Collection<IExternallyUpdatableEditPart.ExternalRefresher> getExternalRefreshers() {
        if (this.myExternalRefreshers == null) {
            this.myExternalRefreshers = this.createExternalRefreshers();
        }
        return this.myExternalRefreshers;
    }

    protected Collection<IExternallyUpdatableEditPart.ExternalRefresher> createExternalRefreshers() {
        return Collections.singleton(new ILabelController.ExternalRefresherAdapter(this, this.getElement()));
    }

    protected final void registerRefresher(EStructuralFeature feature, IUpdatableEditPart.Refresher refresher) {
        IUpdatableEditPart.Refresher oldRefresher = this.structuralFeatures2Refresher.get(feature);
        if (oldRefresher == null) {
            this.structuralFeatures2Refresher.put(feature, refresher);
        } else {
            IUpdatableEditPart.CompositeRefresher compositeRefresher = new IUpdatableEditPart.CompositeRefresher();
            compositeRefresher.addRefresher(oldRefresher);
            compositeRefresher.addRefresher(refresher);
            this.structuralFeatures2Refresher.put(feature, compositeRefresher);
        }
    }

    public void performRequest(Request req) {
        if ("direct edit" == req.getType() && this.understandsRequest(req)) {
            this.performDirectEdit();
        } else {
            super.performRequest(req);
        }
    }

    protected TreeDirectEditManager getDirectEditManager() {
        if (this.directEditManager == null) {
            this.directEditManager = new TreeDirectEditManager((EditPart)this, this.getCellEditorClass(), new CellEditorLocator(){

                public void relocate(CellEditor celleditor) {
                    if (BaseTreeEditPart.this.checkTreeItem()) {
                        celleditor.getControl().setFont(((TreeItem)BaseTreeEditPart.this.getWidget()).getFont());
                        celleditor.getControl().setBounds(((TreeItem)BaseTreeEditPart.this.getWidget()).getBounds());
                    }
                }
            }){

                @Override
                protected void initCellEditor() {
                    this.getCellEditor().setValue((Object)BaseTreeEditPart.this.getLabelTextDisplayer().getEditText(BaseTreeEditPart.this.getElement()));
                }
            };
        }
        return this.directEditManager;
    }

    protected Class<? extends CellEditor> getCellEditorClass() {
        return TextCellEditor.class;
    }

    protected void performDirectEdit() {
        if (this.isReadOnly()) {
            return;
        }
        this.getDirectEditManager().show();
    }

    protected boolean isReadOnly() {
        if (this.getElement() == null) {
            return true;
        }
        Resource notationResource = this.getNotationView().eResource();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)notationResource);
        if (editingDomain == null) {
            return false;
        }
        if (editingDomain.isReadOnly(notationResource)) {
            return true;
        }
        Resource domainResource = this.getElement().eResource();
        if (domainResource == null) {
            return false;
        }
        return editingDomain.isReadOnly(domainResource);
    }

    private class NullLabelTextDisplayer
    extends AbstractLabelTextDisplayer {
        private NullLabelTextDisplayer() {
        }

        @Override
        public String getDisplayText(EObject source) {
            return BaseTreeEditPart.this.getDefaultLabelText();
        }

        @Override
        public boolean isAffectingEvent(Notification notification) {
            return false;
        }
    }
}

