/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.lite.edit.parts.decorations.IDecoratableEditPart;
import org.eclipse.gmf.runtime.lite.edit.parts.decorations.IDecorationManager;
import org.eclipse.gmf.runtime.lite.validation.IValidationStateListener;
import org.eclipse.gmf.runtime.lite.validation.Severity;
import org.eclipse.gmf.runtime.lite.validation.ValidationStateEvent;
import org.eclipse.gmf.runtime.lite.validation.ViolationDescriptor;

public abstract class ValidationDecorationProvider
implements IValidationStateListener {
    public static final String VALIDATION_KEY = "validation";

    public void dispose() {
    }

    @Override
    public void validationStateChanged(ValidationStateEvent event) {
        EObject sourceDiagram = this.getResourceSet().getEObject(event.getSourceValidationState().getDiagramUri(), false);
        if (sourceDiagram == null || !sourceDiagram.equals(this.getGraphicalViewer().getContents().getModel())) {
            return;
        }
        for (URI uri : event.getViolationKeys()) {
            IDecoratableEditPart decoratableEditPart;
            IDecorationManager decorationManager;
            EObject nextView = this.getResourceSet().getEObject(uri, false);
            GraphicalEditPart editPart = (GraphicalEditPart)this.getGraphicalViewer().getEditPartRegistry().get(nextView);
            if (!(editPart instanceof IDecoratableEditPart) || (decorationManager = (decoratableEditPart = (IDecoratableEditPart)editPart).getDecorationManager()) == null) continue;
            this.updateDecorations(decorationManager, event.getOldViolations(uri), event.getNewViolations(uri));
        }
    }

    protected void updateDecorations(IDecorationManager decorationManager, Collection<ViolationDescriptor> oldViolations, Collection<ViolationDescriptor> newViolations) {
        if (newViolations.isEmpty()) {
            decorationManager.installDecoration(VALIDATION_KEY, null);
            return;
        }
        ArrayList<String> messages = new ArrayList<String>(newViolations.size());
        Severity highestSeverity = null;
        for (ViolationDescriptor next : newViolations) {
            Severity nextSeverity = next.getSeverity();
            if (highestSeverity == null || highestSeverity.compareTo(nextSeverity) < 0) {
                messages.clear();
                highestSeverity = nextSeverity;
            }
            if (!highestSeverity.equals((Object)nextSeverity)) continue;
            messages.add(next.getMessage());
        }
        ImageFigure decoration = new ImageFigure(highestSeverity.getImage());
        String tooltip = this.formatLabel(messages);
        if (tooltip != null) {
            Label label = new Label(tooltip);
            decoration.setToolTip((IFigure)label);
        }
        decorationManager.installDecoration(VALIDATION_KEY, (IFigure)decoration);
    }

    protected String formatLabel(List<String> messages) {
        assert (!messages.isEmpty());
        if (messages.size() == 1) {
            return messages.get(0);
        }
        StringBuilder result = new StringBuilder();
        result.append("Multiple problems:");
        for (String next : messages) {
            result.append("\n").append(next);
        }
        return result.toString();
    }

    protected abstract ResourceSet getResourceSet();

    protected abstract GraphicalViewer getGraphicalViewer();
}

