/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.mapping;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.Identity;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooling.simplemap.model.triggers.AbstractTrigger;

class SetDomainMetaElementTrigger
extends AbstractTrigger {
    private EClass newElement;
    private NodeMapping nodeMapping;

    public SetDomainMetaElementTrigger(TransactionalEditingDomain domain, NodeMapping nodeMapping, EClass newElement) {
        super(domain);
        this.newElement = newElement;
        this.nodeMapping = nodeMapping;
    }

    @Override
    public void executeTrigger() {
        String newElementName = this.newElement != null ? this.newElement.getName() : "";
        this.updateMapping();
        this.updateCanvas(newElementName);
    }

    private void updateMapping() {
        EAttribute defaultLabelAttribute = this.getDefaultLabelAttribute();
        FeatureLabelMapping defaultFeatureLabelMapping = this.getDefaultFeatureLabelMapping();
        if (defaultFeatureLabelMapping != null && defaultLabelAttribute != null) {
            defaultFeatureLabelMapping.getFeatures().add((Object)defaultLabelAttribute);
        }
    }

    private EAttribute getDefaultLabelAttribute() {
        if (this.newElement != null) {
            for (EAttribute attribute : this.newElement.getEAllAttributes()) {
                Class attributeInstanceClass = attribute.getEType().getInstanceClass();
                Class stringInstanceClass = EcorePackage.eINSTANCE.getEString().getInstanceClass();
                if (attributeInstanceClass == null || !stringInstanceClass.isAssignableFrom(attributeInstanceClass)) continue;
                return attribute;
            }
        }
        return null;
    }

    private FeatureLabelMapping getDefaultFeatureLabelMapping() {
        for (LabelMapping labelMapping : this.nodeMapping.getLabelMappings()) {
            if (!(labelMapping instanceof FeatureLabelMapping)) continue;
            return (FeatureLabelMapping)labelMapping;
        }
        return null;
    }

    private void updateCanvas(String newElementName) {
        DiagramLabel diagramLabelToRename = null;
        if (!this.nodeMapping.getLabelMappings().isEmpty()) {
            diagramLabelToRename = ((LabelMapping)this.nodeMapping.getLabelMappings().get(0)).getDiagramLabel();
        }
        Node nodeToRename = this.nodeMapping.getDiagramNode();
        AbstractTool toolToRename = this.nodeMapping.getTool();
        if (nodeToRename != null && this.canRename((EObject)nodeToRename)) {
            String newNodeName = this.getNewCanvasElementName(newElementName, (Identity)nodeToRename);
            nodeToRename.setName(newNodeName);
            this.renameNode(nodeToRename, newElementName);
        }
        if (toolToRename != null && this.canRename((EObject)toolToRename)) {
            String newToolName = this.getNewToolName(newElementName, toolToRename);
            toolToRename.setTitle(newToolName);
            toolToRename.setDescription("Create new " + newElementName);
        }
        String newDiagramLabelName = String.valueOf(newElementName) + "Name";
        if (diagramLabelToRename != null && this.canRename((EObject)diagramLabelToRename)) {
            String newLabelName = this.getNewCanvasElementName(newDiagramLabelName, (Identity)diagramLabelToRename);
            diagramLabelToRename.setName(newLabelName);
            this.renameNode((Node)diagramLabelToRename, newElementName);
        }
    }

    private void renameNode(Node nodeToRename, String newElementName) {
        ChildAccess labelAccessor;
        String newFigureName = String.valueOf(newElementName) + "Figure";
        FigureDescriptor figDesc = nodeToRename.getFigure();
        String newFigDescName = this.getNewCanvasElementName(newFigureName, (Identity)figDesc);
        figDesc.setName(newFigDescName);
        if (figDesc.getActualFigure() instanceof RealFigure) {
            ((RealFigure)figDesc.getActualFigure()).setName(newFigDescName);
        }
        if (nodeToRename instanceof DiagramLabel && (labelAccessor = ((DiagramLabel)nodeToRename).getAccessor()) != null && labelAccessor.getFigure() instanceof Label) {
            String newLabelName = String.valueOf(newElementName) + "NameFigure";
            String newLabelAccessorName = "getFigure" + newLabelName;
            ((Label)labelAccessor.getFigure()).setName(newLabelName);
            labelAccessor.setAccessor(newLabelAccessorName);
        }
    }
}

