/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.lite.commands.RemoveNotationalElementCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class RemoveNotationalEdgeCommand
extends RemoveNotationalElementCommand {
    private View source;
    private View target;

    public RemoveNotationalEdgeCommand(View parentView, View childView) {
        super(parentView, childView);
    }

    @Override
    protected boolean prepare() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getParent());
        if (domain != null && domain.isReadOnly(this.getParent().eResource())) {
            return false;
        }
        return this.getParent() instanceof Diagram && this.getChildView() instanceof Edge && ((Diagram)this.getParent()).getEdges().contains((Object)this.getChildView());
    }

    @Override
    public void execute() {
        Edge edgeToRemove = (Edge)this.getChildView();
        this.source = edgeToRemove.getSource();
        this.target = edgeToRemove.getTarget();
        edgeToRemove.setSource(null);
        edgeToRemove.setTarget(null);
        ((Diagram)this.getParent()).removeEdge(edgeToRemove);
        this.sweepElement();
    }

    @Override
    public void undo() {
        this.restoreElement();
        Edge edge = (Edge)this.getChildView();
        ((Diagram)this.getParent()).insertEdge(edge);
        edge.setSource(this.source);
        edge.setTarget(this.target);
    }
}

