/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.update.canonical;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.IViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public abstract class DelegatingViewService
implements IViewService {
    private final IExactMatchFinder myExactMatchFinder;

    public DelegatingViewService(IExactMatchFinder exactMatchFinder) {
        this.myExactMatchFinder = exactMatchFinder;
    }

    @Override
    public View findView(EObject modelElement) {
        View result;
        if (modelElement == null) {
            return null;
        }
        View exactMatch = this.myExactMatchFinder.findView(modelElement);
        if (exactMatch != null) {
            return exactMatch;
        }
        View parentView = this.findView(modelElement.eContainer());
        if (parentView != null && (result = this.findNode(parentView, modelElement)) != null) {
            return result;
        }
        return this.findEdge(modelElement);
    }

    private View findNode(View parentView, EObject modelElement) {
        for (View next : parentView.getChildren()) {
            View result;
            if (!(next.isSetElement() && next.getElement() != parentView.getElement() || (result = this.findNode(next, modelElement)) == null)) {
                return result;
            }
            if (!next.isSetElement() || next.getElement() != modelElement) continue;
            return next;
        }
        return null;
    }

    private View findEdge(EObject modelElement) {
        for (Edge next : this.myExactMatchFinder.getDiagram().getEdges()) {
            if (!next.isSetElement() || next.getElement() != modelElement) continue;
            return next;
        }
        return null;
    }

    public static interface IExactMatchFinder
    extends IViewService {
        public Diagram getDiagram();
    }
}

