/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.internal.runtime.lite.PluginImages;
import org.eclipse.gmf.runtime.lite.commands.WrappingCommand;
import org.eclipse.gmf.runtime.lite.properties.AdvancedPropertySection;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ColorsAndFontsPropertySection
extends AbstractPropertySection {
    protected CCombo fontFamilyCombo;
    private CCombo fontSizeCombo;
    private Button fontBoldButton;
    private Button fontItalicButton;
    protected Button fontColorButton;
    protected Button lineColorButton;
    protected Button fillColorButton;
    protected RGB fontColorRGB;
    protected RGB lineColorRGB;
    protected RGB fillColorRGB;
    private Group colorsAndFontsGroup;
    private ResourceSetListener myResourceSetListener = new ResourceSetListenerImpl(){

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            ColorsAndFontsPropertySection.this.refresh();
        }
    };
    private CommandStack myCommandStack;
    private TransactionalEditingDomain myEditingDomain;
    private Collection<View> myViews;
    private static String[] FONT_FAMILY_NAMES;
    private static final String[] FONT_SIZES;
    private static final IValueConverter<Boolean> TO_BOOLEAN_CONVERTER;
    private static final IValueConverter<RGB> TO_RGB_CONVERTER;
    private static final IValueConverter<String> FROM_INT_CONVERTER;
    private static final IValueConverter<String> ID_CONVERTER;

    static {
        FONT_SIZES = new String[]{String.valueOf(8), String.valueOf(9), String.valueOf(10), String.valueOf(11), String.valueOf(12), String.valueOf(14), String.valueOf(16), String.valueOf(18), String.valueOf(20), String.valueOf(22), String.valueOf(24), String.valueOf(26), String.valueOf(28), String.valueOf(36), String.valueOf(48), String.valueOf(72)};
        TO_BOOLEAN_CONVERTER = new IValueConverter<Boolean>(){

            @Override
            public Boolean convertFromStyleValue(Object value) {
                return value instanceof Boolean ? (Boolean)value : Boolean.FALSE;
            }

            @Override
            public Object convertToStyleValue(Boolean literalValue) {
                return literalValue;
            }
        };
        TO_RGB_CONVERTER = new IValueConverter<RGB>(){

            @Override
            public RGB convertFromStyleValue(Object styleValue) {
                int value = (Integer)styleValue;
                return new RGB(value & 0xFF, (value & 0xFF00) >> 8, (value & 0xFF0000) >> 16);
            }

            @Override
            public Object convertToStyleValue(RGB rgb) {
                return new Integer(rgb.blue << 16 | rgb.green << 8 | rgb.red);
            }
        };
        FROM_INT_CONVERTER = new IValueConverter<String>(){

            @Override
            public String convertFromStyleValue(Object styleValue) {
                if (styleValue == null) {
                    return null;
                }
                return String.valueOf(styleValue);
            }

            @Override
            public Object convertToStyleValue(String literalValue) {
                if (literalValue == null) {
                    return null;
                }
                return Integer.parseInt(literalValue);
            }
        };
        ID_CONVERTER = new IValueConverter<String>(){

            @Override
            public String convertFromStyleValue(Object styleValue) {
                return (String)styleValue;
            }

            @Override
            public Object convertToStyleValue(String literalValue) {
                return literalValue;
            }
        };
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            super.setInput(part, selection);
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        this.myViews = new ArrayList<View>(structuredSelection.size());
        Iterator it = structuredSelection.iterator();
        while (it.hasNext()) {
            Object r = this.transformSelection(it.next());
            if (!(r instanceof View)) continue;
            this.myViews.add((View)r);
        }
        this.myEditingDomain = this.getEditingDomain(this.myViews);
        this.myCommandStack = AdvancedPropertySection.getCommandStack(this.myEditingDomain);
        super.setInput(part, (ISelection)new StructuredSelection(this.myViews));
    }

    private TransactionalEditingDomain getEditingDomain(Collection<View> transformedSelection) {
        TransactionalEditingDomain result = null;
        for (View next : transformedSelection) {
            TransactionalEditingDomain candidate = TransactionUtil.getEditingDomain((EObject)next);
            if (candidate == null) {
                return null;
            }
            if (result != null && result != candidate) {
                return null;
            }
            result = candidate;
        }
        return result;
    }

    protected Object transformSelection(Object selected) {
        if (selected instanceof EditPart) {
            EditPart ep = (EditPart)selected;
            return ep.getModel() instanceof View ? ep.getModel() : null;
        }
        if (selected instanceof View) {
            return selected;
        }
        if (selected instanceof IAdaptable) {
            return ((IAdaptable)selected).getAdapter(View.class);
        }
        return null;
    }

    public void aboutToBeShown() {
        if (this.myEditingDomain != null) {
            this.myEditingDomain.addResourceSetListener(this.getListener());
        }
    }

    public void aboutToBeHidden() {
        if (this.myEditingDomain != null) {
            this.myEditingDomain.addResourceSetListener(this.getListener());
        }
    }

    protected final ResourceSetListener getListener() {
        return this.myResourceSetListener;
    }

    public void dispose() {
        this.disposeImageFor(this.fillColorButton, "icons/fill_color.gif");
        this.disposeImageFor(this.fontColorButton, "icons/font_color.gif");
        this.disposeImageFor(this.lineColorButton, "icons/line_color.gif");
        this.myViews = null;
        this.myEditingDomain = null;
        this.myCommandStack = null;
        super.dispose();
    }

    protected final void disposeImageFor(Button button, String key) {
        if (button == null || button.isDisposed()) {
            return;
        }
        Image img = button.getImage();
        if (img == PluginImages.get(key)) {
            return;
        }
        img.dispose();
    }

    public void refresh() {
        if (this.myEditingDomain != null) {
            boolean isReadOnly = this.isReadOnly();
            this.refresh(this.fontFamilyCombo, isReadOnly, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontName(), ID_CONVERTER);
            this.refresh(this.fontSizeCombo, isReadOnly, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight(), FROM_INT_CONVERTER);
            this.refresh(this.fontBoldButton, isReadOnly, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold());
            this.refresh(this.fontItalicButton, isReadOnly, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic());
            this.fontColorRGB = this.refreshColor(this.fontColorButton, isReadOnly, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor(), "icons/font_color.gif");
            this.lineColorRGB = this.refreshColor(this.lineColorButton, isReadOnly, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), "icons/line_color.gif");
            this.fillColorRGB = this.refreshColor(this.fillColorButton, isReadOnly, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), "icons/fill_color.gif");
        }
        super.refresh();
    }

    private boolean isReadOnly() {
        if (this.myCommandStack == null) {
            return true;
        }
        for (View next : this.myViews) {
            if (next.eResource() != null && !this.myEditingDomain.isReadOnly(next.eResource())) continue;
            return true;
        }
        return false;
    }

    protected void refresh(CCombo combo, boolean isReadOnly, EStructuralFeature feature, IValueConverter<String> converter) {
        if (!this.hasStyles(feature.getEContainingClass())) {
            combo.setEnabled(false);
            combo.select(-1);
            return;
        }
        combo.setEnabled(!isReadOnly);
        String result = this.getStructuralFeatureValue(feature, converter);
        if (result == null) {
            combo.select(-1);
        } else {
            combo.select(combo.indexOf(result));
        }
    }

    protected void refresh(Button button, boolean isReadOnly, EStructuralFeature feature) {
        if (!this.hasStyles(feature.getEContainingClass())) {
            button.setEnabled(false);
            button.setSelection(false);
            return;
        }
        button.setEnabled(!isReadOnly);
        button.setSelection(this.getStructuralFeatureValue(feature, TO_BOOLEAN_CONVERTER).booleanValue());
    }

    protected RGB refreshColor(Button button, boolean isReadOnly, EStructuralFeature feature, String baseImageKey) {
        RGB rgb;
        if (!this.hasStyles(feature.getEContainingClass())) {
            button.setEnabled(false);
            rgb = null;
        } else {
            button.setEnabled(!isReadOnly);
            rgb = this.getStructuralFeatureValue(feature, TO_RGB_CONVERTER);
        }
        this.disposeImageFor(button, baseImageKey);
        if (rgb == null) {
            button.setImage(PluginImages.get(baseImageKey));
        } else {
            button.setImage(new ColorOverlayImageDescriptor(PluginImages.get(baseImageKey).getImageData(), rgb).createImage());
        }
        return rgb;
    }

    protected final boolean hasStyles(EClass styleClass) {
        for (View next : this.myViews) {
            if (next.getStyle(styleClass) != null) continue;
            return false;
        }
        return true;
    }

    protected <E> E getStructuralFeatureValue(EStructuralFeature feature, IValueConverter<E> converter) {
        Object result = null;
        for (View next : this.myViews) {
            Style style = next.getStyle(feature.getEContainingClass());
            if (style == null) {
                return null;
            }
            E nextResult = converter.convertFromStyleValue(style.eGet(feature));
            if (nextResult == null) {
                return null;
            }
            if (result == null) {
                result = nextResult;
                continue;
            }
            if (result.equals(nextResult)) continue;
            return null;
        }
        return (E)result;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout layout = (FormLayout)composite.getLayout();
        layout.spacing = 3;
        this.createFontsAndColorsGroups(composite);
    }

    protected Group createFontsAndColorsGroups(Composite parent) {
        this.colorsAndFontsGroup = this.getWidgetFactory().createGroup(parent, "Fonts and Colors");
        this.colorsAndFontsGroup.setLayout((Layout)new GridLayout(1, false));
        this.createFontsGroup((Composite)this.colorsAndFontsGroup);
        return this.colorsAndFontsGroup;
    }

    protected Composite createFontsGroup(Composite parent) {
        Composite familySize = this.getWidgetFactory().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        familySize.setLayout((Layout)layout);
        this.fontFamilyCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        this.fontFamilyCombo.setItems(ColorsAndFontsPropertySection.getFontFamilyNames());
        this.fontFamilyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorsAndFontsPropertySection.this.change(ColorsAndFontsPropertySection.this.fontFamilyCombo, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontName(), ID_CONVERTER, "Change font family");
            }
        });
        this.fontSizeCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        this.fontSizeCombo.setItems(ColorsAndFontsPropertySection.getFontSizes());
        this.fontSizeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.change(ColorsAndFontsPropertySection.this.fontSizeCombo, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight(), FROM_INT_CONVERTER, "Change font size");
            }
        });
        Composite toolBar = new Composite(parent, 32);
        toolBar.setLayout((Layout)new GridLayout(5, false));
        toolBar.setBackground(parent.getBackground());
        this.fontBoldButton = new Button(toolBar, 2);
        this.fontBoldButton.setLayoutData((Object)new GridData(2, 2, false, false));
        this.fontBoldButton.setImage(PluginImages.get("icons/bold.gif"));
        this.fontBoldButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Bold Font Style";
            }
        });
        this.fontBoldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.change(ColorsAndFontsPropertySection.this.fontBoldButton, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold(), TO_BOOLEAN_CONVERTER, "Change font bold");
            }
        });
        this.fontItalicButton = new Button(toolBar, 2);
        this.fontItalicButton.setLayoutData((Object)new GridData(2, 2, false, false));
        this.fontItalicButton.setImage(PluginImages.get("icons/italic.gif"));
        this.fontItalicButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Italic Font Style";
            }
        });
        this.fontItalicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.change(ColorsAndFontsPropertySection.this.fontItalicButton, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic(), TO_BOOLEAN_CONVERTER, "Change font italic");
            }
        });
        this.fontColorButton = new Button(toolBar, 8);
        GridData fontColorButtonGridData = new GridData(2, 2, false, false);
        fontColorButtonGridData.horizontalIndent = 5;
        this.fontColorButton.setLayoutData((Object)fontColorButtonGridData);
        this.fontColorButton.setImage(PluginImages.get("icons/font_color.gif"));
        this.fontColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Font Color";
            }
        });
        this.fontColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.changeColor(ColorsAndFontsPropertySection.this.fontColorButton, ColorsAndFontsPropertySection.this.fontColorRGB, (EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor(), "Change font color");
            }
        });
        this.lineColorButton = new Button(toolBar, 8);
        GridData lineColorButtonGridData = new GridData(2, 2, false, false);
        lineColorButtonGridData.horizontalIndent = 5;
        this.fontColorButton.setLayoutData((Object)lineColorButtonGridData);
        this.lineColorButton.setImage(PluginImages.get("icons/line_color.gif"));
        this.lineColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Line Color";
            }
        });
        this.lineColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.changeColor(ColorsAndFontsPropertySection.this.lineColorButton, ColorsAndFontsPropertySection.this.lineColorRGB, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), "Change line color");
            }
        });
        this.fillColorButton = new Button(toolBar, 8);
        this.fillColorButton.setLayoutData((Object)new GridData(2, 2, false, false));
        this.fillColorButton.setImage(PluginImages.get("icons/fill_color.gif"));
        this.fillColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Fill Color";
            }
        });
        this.fillColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorsAndFontsPropertySection.this.changeColor(ColorsAndFontsPropertySection.this.fillColorButton, ColorsAndFontsPropertySection.this.fillColorRGB, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), "Change fill color");
            }
        });
        return toolBar;
    }

    protected void change(CCombo combo, EStructuralFeature feature, IValueConverter<String> converter, String commandName) {
        if (combo.getSelectionIndex() == -1) {
            return;
        }
        String selectedValue = combo.getText();
        if (selectedValue == null || selectedValue.length() == 0) {
            selectedValue = null;
        }
        Object value = converter.convertToStyleValue(selectedValue);
        this.executeChange(commandName, feature, value);
    }

    protected void change(Button button, EStructuralFeature feature, IValueConverter<Boolean> converter, String commandName) {
        boolean isSelected = button.getSelection();
        Object value = converter.convertToStyleValue(isSelected);
        this.executeChange(commandName, feature, value);
    }

    protected void changeColor(Button button, RGB currentRGB, EStructuralFeature feature, String commandName) {
        ColorDialog colorDialog = new ColorDialog(button.getShell());
        colorDialog.setRGB(currentRGB);
        RGB newRGB = colorDialog.open();
        if (newRGB == null || newRGB.equals((Object)currentRGB)) {
            return;
        }
        Object featureValue = TO_RGB_CONVERTER.convertToStyleValue(newRGB);
        this.executeChange(commandName, feature, featureValue);
    }

    protected void executeChange(String commandName, EStructuralFeature feature, Object value) {
        if (feature.isRequired() && value == null) {
            value = SetCommand.UNSET_VALUE;
        }
        CompoundCommand cc = new CompoundCommand(commandName);
        for (View next : this.myViews) {
            Style style = next.getStyle(feature.getEContainingClass());
            Command command = SetCommand.create((EditingDomain)this.myEditingDomain, (Object)style, (Object)feature, (Object)value);
            cc.append(command);
        }
        if (cc.canExecute()) {
            this.myCommandStack.execute((org.eclipse.gef.commands.Command)new WrappingCommand(this.myEditingDomain, (Command)cc));
        }
    }

    private static String[] getFontFamilyNames() {
        if (FONT_FAMILY_NAMES == null) {
            FontData[] fontFamilies = Display.getDefault().getFontList(null, true);
            HashSet<String> fontFamilyNames = new HashSet<String>(fontFamilies.length * 3 / 2);
            FontData[] fontDataArray = fontFamilies;
            int n = fontFamilies.length;
            int n2 = 0;
            while (n2 < n) {
                FontData next = fontDataArray[n2];
                fontFamilyNames.add(next.getName());
                ++n2;
            }
            fontFamilyNames.remove(null);
            fontFamilyNames.add("");
            FONT_FAMILY_NAMES = fontFamilyNames.toArray(new String[fontFamilyNames.size()]);
            Arrays.sort(FONT_FAMILY_NAMES);
        }
        return FONT_FAMILY_NAMES;
    }

    private static String[] getFontSizes() {
        return FONT_SIZES;
    }

    protected static class ColorOverlayImageDescriptor
    extends CompositeImageDescriptor {
        private final ImageData myOriginal;
        private final RGB mySubstrate;
        private final Point mySize;

        public ColorOverlayImageDescriptor(ImageData original, RGB substrate) {
            this.myOriginal = original;
            this.mySubstrate = substrate;
            this.mySize = new Point(this.myOriginal.width, this.myOriginal.height);
        }

        protected Point getSize() {
            return this.mySize;
        }

        protected void drawCompositeImage(int width, int height) {
            ImageData substrate = new ImageData(width, height / 5, 1, new PaletteData(new RGB[]{this.mySubstrate}));
            this.drawImage(substrate, 0, height - substrate.height);
            this.drawImage(this.myOriginal, 0, 0);
        }
    }

    protected static interface IValueConverter<E> {
        public E convertFromStyleValue(Object var1);

        public Object convertToStyleValue(E var1);
    }
}

