/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.properties.figure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.Shape;
import org.eclipse.gmf.gmfgraph.provider.GMFGraphItemProviderAdapterFactory;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.FontHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesImages;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorPalettePopup;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.tooling.simplemap.diagram.properties.AbstractExtendedPropertiesSection;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleMappingElementWithFigure;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public class FigurePropertiesSection
extends AbstractExtendedPropertiesSection {
    protected static final String FONTS_LABEL = "Label Font";
    protected static final String COLORS_LABEL = "Figure";
    protected Button backgroundColorButton;
    protected Button foregroundColorButton;
    protected static final RGB DEFAULT_TOP_NODE_BACKGROUND = new RGB(242, 245, 252);
    protected static final RGB DEFAULT_TOP_NODE_FOREGROUND = new RGB(111, 142, 194);
    protected static final RGB DEFAULT_COMPARTMENT_BACKGROUND = new RGB(251, 252, 255);
    protected static final RGB DEFAULT_COMPARTMENT_FOREGROUND = new RGB(133, 156, 194);
    protected CCombo fontFamilyCombo;
    protected CCombo shapeFamilyCombo;
    protected Map<Shape, Integer> shapeFamilyMap;
    private CCombo fontSizeCombo;
    private Button fontBoldButton;
    private Button fontItalicButton;
    protected Group fontGroup;
    protected Group colorsGroup;
    protected Group shapeGroup;
    private Figure nodeFigure;
    private RGB defaultBackgroundColor = DEFAULT_TOP_NODE_BACKGROUND;
    private RGB defaultForegroundColor = DEFAULT_TOP_NODE_FOREGROUND;
    private BasicFont labelFont;
    private GMFGraphItemProviderAdapterFactory adapterFactory = new GMFGraphItemProviderAdapterFactory();
    private static List<EClass> availableFigures = new ArrayList<EClass>();

    static {
        availableFigures.add(GMFGraphPackage.eINSTANCE.getRoundedRectangle());
        availableFigures.add(GMFGraphPackage.eINSTANCE.getRectangle());
    }

    @Override
    protected void initializeControls(Composite parent) {
        super.initializeControls(parent);
        this.createFontsAndColorsGroups(this.composite);
    }

    protected Group createFontsAndColorsGroups(Composite parent) {
        Group fontsLabelGroup = this.getWidgetFactory().createGroup(parent, "");
        fontsLabelGroup.setLayout((Layout)new GridLayout(2, false));
        GridLayout layout = new GridLayout(1, false);
        this.colorsGroup = this.getWidgetFactory().createGroup((Composite)fontsLabelGroup, COLORS_LABEL);
        this.colorsGroup.setLayout((Layout)layout);
        this.createColorsGroup((Composite)this.colorsGroup);
        this.fontGroup = this.getWidgetFactory().createGroup((Composite)fontsLabelGroup, FONTS_LABEL);
        this.fontGroup.setLayout((Layout)layout);
        this.createFontGroup((Composite)this.fontGroup);
        return fontsLabelGroup;
    }

    protected Composite createFontGroup(Composite parent) {
        Composite familySize = this.getWidgetFactory().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        familySize.setLayout((Layout)layout);
        Composite toolBar = new Composite(parent, 32);
        toolBar.setLayout((Layout)new GridLayout(7, false));
        toolBar.setBackground(parent.getBackground());
        this.fontFamilyCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        this.fontFamilyCombo.setItems(FontHelper.getFontNames());
        this.fontFamilyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigurePropertiesSection.this.updateFontFamily();
            }
        });
        this.fontSizeCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        this.fontSizeCombo.setItems(FontHelper.getFontSizes());
        this.fontSizeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigurePropertiesSection.this.updateFontSize();
            }
        });
        this.fontBoldButton = new Button(toolBar, 2);
        this.fontBoldButton.setImage(DiagramUIPropertiesImages.get((String)"icons/bold.gif"));
        this.fontBoldButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIMessages.PropertyDescriptorFactory_FontStyle_Bold;
            }
        });
        this.fontBoldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigurePropertiesSection.this.updateFontBold();
            }
        });
        this.fontItalicButton = new Button(toolBar, 2);
        this.fontItalicButton.setImage(DiagramUIPropertiesImages.get((String)"icons/italic.gif"));
        this.fontItalicButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIMessages.PropertyDescriptorFactory_FontStyle_Italic;
            }
        });
        this.fontItalicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigurePropertiesSection.this.updateFontItalic();
            }
        });
        return toolBar;
    }

    protected Composite createColorsGroup(Composite parent) {
        Composite toolBar = new Composite(parent, 32);
        toolBar.setLayout((Layout)new GridLayout(2, false));
        toolBar.setBackground(parent.getBackground());
        Label figureLabel = new Label(toolBar, 16384);
        figureLabel.setText("Shape");
        this.shapeFamilyCombo = this.getWidgetFactory().createCCombo(toolBar, 2060);
        this.shapeFamilyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigurePropertiesSection.this.updateShapeFamily();
            }
        });
        Label bckLabel = new Label(toolBar, 16384);
        bckLabel.setText("Background");
        this.backgroundColorButton = new Button(toolBar, 8);
        this.backgroundColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIMessages.PropertyDescriptorFactory_FontColor;
            }
        });
        this.backgroundColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigurePropertiesSection.this.changeBackgroundColor(event);
            }
        });
        GridData data = new GridData(256);
        Point minSize = this.backgroundColorButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(120, minSize.x);
        this.backgroundColorButton.setLayoutData((Object)data);
        Label foreLabel = new Label(toolBar, 16384);
        foreLabel.setText("Foreground");
        this.foregroundColorButton = new Button(toolBar, 8);
        this.foregroundColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIMessages.PropertyDescriptorFactory_FontColor;
            }
        });
        this.foregroundColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FigurePropertiesSection.this.changeForegroundColor(event);
            }
        });
        this.foregroundColorButton.setLayoutData((Object)data);
        return toolBar;
    }

    protected void updateFontBold() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        final FontStyle newStyle = Boolean.valueOf(this.fontBoldButton.getSelection()) != false ? FontStyle.BOLD_LITERAL : FontStyle.NORMAL_LITERAL;
        commands.add(this.createCommand("UpdateFontStyle", this.labelFont.eResource(), new Runnable(){

            @Override
            public void run() {
                FigurePropertiesSection.this.labelFont.setStyle(newStyle);
            }
        }));
        this.executeAsCompositeCommand("UpdateFontStyle", commands);
    }

    protected void updateFontItalic() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        final FontStyle newStyle = Boolean.valueOf(this.fontItalicButton.getSelection()) != false ? FontStyle.ITALIC_LITERAL : FontStyle.NORMAL_LITERAL;
        commands.add(this.createCommand("UpdateFontStyle", this.labelFont.eResource(), new Runnable(){

            @Override
            public void run() {
                FigurePropertiesSection.this.labelFont.setStyle(newStyle);
            }
        }));
        this.executeAsCompositeCommand("UpdateFontStyle", commands);
    }

    protected void updateFontFamily() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        if (this.fontFamilyCombo.getText() != null && !this.fontFamilyCombo.getText().equals("")) {
            final String newFontFamily = this.fontFamilyCombo.getText();
            commands.add(this.createCommand("UpdateFontFamily", this.labelFont.eResource(), new Runnable(){

                @Override
                public void run() {
                    FigurePropertiesSection.this.labelFont.setFaceName(newFontFamily);
                }
            }));
            this.executeAsCompositeCommand("UpdateFontFamily", commands);
        }
    }

    protected void updateShapeFamily() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        final int newShapeID = this.shapeFamilyCombo.getSelectionIndex();
        commands.add(this.createCommand("UpdateFontFamily", this.nodeFigure.eResource(), new Runnable(){

            @Override
            public void run() {
                Shape newShape = null;
                for (Map.Entry<Shape, Integer> entry : FigurePropertiesSection.this.shapeFamilyMap.entrySet()) {
                    if (entry.getValue() != newShapeID) continue;
                    newShape = entry.getKey();
                }
                Figure newFigure = (Figure)EcoreUtil.copy(newShape);
                EStructuralFeature containingFeature = FigurePropertiesSection.this.nodeFigure.eContainingFeature();
                EObject container = FigurePropertiesSection.this.nodeFigure.eContainer();
                for (EStructuralFeature.Setting setting : EcoreUtil.UsageCrossReferencer.find((EObject)FigurePropertiesSection.this.nodeFigure, (Resource)FigurePropertiesSection.this.nodeFigure.eResource())) {
                    if (setting.getEStructuralFeature().isDerived()) continue;
                    EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)FigurePropertiesSection.this.nodeFigure, (Object)newFigure);
                }
                if (containingFeature != null) {
                    EcoreUtil.replace((EObject)container, (EStructuralFeature)containingFeature, (Object)FigurePropertiesSection.this.nodeFigure, (Object)newFigure);
                }
                FigurePropertiesSection.this.nodeFigure = newFigure;
            }
        }));
        this.executeAsCompositeCommand("UpdateShape", commands);
    }

    protected void updateFontSize() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        if (this.fontSizeCombo.getText() != null && !this.fontSizeCombo.getText().equals("")) {
            final int newFontSize = new Integer(this.fontSizeCombo.getText());
            commands.add(this.createCommand("UpdateFontSize", this.labelFont.eResource(), new Runnable(){

                @Override
                public void run() {
                    FigurePropertiesSection.this.labelFont.setHeight(newFontSize);
                }
            }));
            this.executeAsCompositeCommand("UpdateFontSize", commands);
        }
    }

    protected void changeBackgroundColor(SelectionEvent event) {
        org.eclipse.gmf.gmfgraph.Color figureBackgroundColor = this.nodeFigure != null ? this.nodeFigure.getBackgroundColor() : null;
        final RGBColor figureBackgroundRGBColor = figureBackgroundColor instanceof RGBColor ? (RGBColor)figureBackgroundColor : null;
        RGB rgbBackgroundColor = this.getBackgroungRGBColor();
        int previousBackgroundColor = rgbBackgroundColor != null ? FigureUtilities.RGBToInteger((RGB)rgbBackgroundColor) : FigureUtilities.RGBToInteger((RGB)this.defaultBackgroundColor);
        final RGB pickedColor = this.pickColor(this.backgroundColorButton, previousBackgroundColor, this.defaultBackgroundColor);
        if (pickedColor != null) {
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            this.backgroundColorButton.setBackground(new Color(null, pickedColor));
            commands.add(this.createCommand("ChangeBackgroundColor", this.nodeFigure.eResource(), new Runnable(){

                @Override
                public void run() {
                    figureBackgroundRGBColor.setBlue(pickedColor.blue);
                    figureBackgroundRGBColor.setGreen(pickedColor.green);
                    figureBackgroundRGBColor.setRed(pickedColor.red);
                }
            }));
            this.executeAsCompositeCommand("ChangeBackgroundColor", commands);
        }
    }

    protected void changeForegroundColor(SelectionEvent event) {
        org.eclipse.gmf.gmfgraph.Color figureForegroundColor = this.nodeFigure != null ? this.nodeFigure.getForegroundColor() : null;
        final RGBColor figureForegroundRGBColor = figureForegroundColor instanceof RGBColor ? (RGBColor)figureForegroundColor : null;
        RGB rgbForegroundColor = this.getForegroundRGBColor();
        int previousForegroundColor = rgbForegroundColor != null ? FigureUtilities.RGBToInteger((RGB)rgbForegroundColor) : FigureUtilities.RGBToInteger((RGB)this.defaultForegroundColor);
        final RGB pickedColor = this.pickColor(this.foregroundColorButton, previousForegroundColor, this.defaultForegroundColor);
        if (pickedColor != null) {
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            this.foregroundColorButton.setBackground(new Color(null, pickedColor));
            commands.add(this.createCommand("ChangeForegroundColor", this.nodeFigure.eResource(), new Runnable(){

                @Override
                public void run() {
                    figureForegroundRGBColor.setBlue(pickedColor.blue);
                    figureForegroundRGBColor.setGreen(pickedColor.green);
                    figureForegroundRGBColor.setRed(pickedColor.red);
                }
            }));
            this.executeAsCompositeCommand("ChangeForegroundColor", commands);
        }
    }

    protected RGB pickColor(Button button, int previousColor, RGB defaultColor) {
        ColorPalettePopup popup = new ColorPalettePopup(button.getParent().getShell(), 25);
        popup.setPreviousColor(previousColor);
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x - r.height / 6, location.y - 6 * r.height));
        RGB selectedColor = popup.getSelectedColor();
        if (selectedColor == null && popup.useDefaultColor()) {
            return defaultColor;
        }
        return selectedColor;
    }

    protected RGB changeColor(SelectionEvent event, Button button, String commandName, ImageDescriptor imageDescriptor, final RGBColor inputColor, int previousColor) {
        ColorPalettePopup popup = new ColorPalettePopup(button.getParent().getShell(), 25);
        popup.setPreviousColor(previousColor);
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.getSelectedColor() == null && !popup.useDefaultColor()) {
            return null;
        }
        RGB selectedColor = popup.getSelectedColor();
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        RGB colorToReturn = selectedColor;
        RGB color = selectedColor;
        color = selectedColor;
        if (colorToReturn == null) {
            colorToReturn = color;
        }
        if (color != null) {
            final RGB finalColor = color;
            commands.add(this.createCommand(commandName, inputColor.eResource(), new Runnable(){

                @Override
                public void run() {
                    inputColor.setBlue(finalColor.blue);
                    inputColor.setGreen(finalColor.green);
                    inputColor.setRed(finalColor.red);
                }
            }));
        }
        if (!commands.isEmpty()) {
            this.executeAsCompositeCommand(commandName, commands);
            Image overlyedImage = new ColorOverlayImageDescriptor(imageDescriptor.getImageData(), color).createImage();
            this.disposeImage(button.getImage());
            button.setImage(overlyedImage);
        }
        return colorToReturn;
    }

    public void refresh() {
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    Color newButtonColor;
                    boolean isReadOnly = FigurePropertiesSection.this.isReadOnly();
                    boolean enableFontWidgets = FigurePropertiesSection.this.labelFont != null && !isReadOnly;
                    FigurePropertiesSection.this.fontFamilyCombo.setEnabled(enableFontWidgets);
                    FigurePropertiesSection.this.fontSizeCombo.setEnabled(enableFontWidgets);
                    FigurePropertiesSection.this.fontBoldButton.setEnabled(enableFontWidgets);
                    FigurePropertiesSection.this.fontItalicButton.setEnabled(enableFontWidgets);
                    if (FigurePropertiesSection.this.labelFont != null) {
                        FigurePropertiesSection.this.fontFamilyCombo.setText(FigurePropertiesSection.this.labelFont.getFaceName());
                        FigurePropertiesSection.this.fontSizeCombo.setText(Integer.toString(FigurePropertiesSection.this.labelFont.getHeight()));
                        FigurePropertiesSection.this.fontBoldButton.setSelection(FigurePropertiesSection.this.labelFont.getStyle() == FontStyle.BOLD_LITERAL);
                        FigurePropertiesSection.this.fontItalicButton.setSelection(FigurePropertiesSection.this.labelFont.getStyle() == FontStyle.ITALIC_LITERAL);
                    } else {
                        FigurePropertiesSection.this.fontFamilyCombo.setText("");
                        FigurePropertiesSection.this.fontSizeCombo.setText("");
                        FigurePropertiesSection.this.fontBoldButton.setSelection(false);
                        FigurePropertiesSection.this.fontItalicButton.setSelection(false);
                    }
                    for (Shape shape : FigurePropertiesSection.this.shapeFamilyMap.keySet()) {
                        if (!FigurePropertiesSection.this.nodeFigure.eClass().equals(shape.eClass())) continue;
                        FigurePropertiesSection.this.shapeFamilyCombo.setText(FigurePropertiesSection.this.getFigureLabel(shape));
                    }
                    RGB rgbBackgroundColor = FigurePropertiesSection.this.getBackgroungRGBColor();
                    RGB rgbForegroundColor = FigurePropertiesSection.this.getForegroundRGBColor();
                    FigurePropertiesSection.this.backgroundColorButton.setEnabled(rgbBackgroundColor != null && !isReadOnly);
                    if (FigurePropertiesSection.this.backgroundColorButton.isEnabled()) {
                        newButtonColor = new Color(null, rgbBackgroundColor);
                        FigurePropertiesSection.this.backgroundColorButton.setBackground(newButtonColor);
                        FigurePropertiesSection.this.backgroundColorButton.setForeground(newButtonColor);
                        FigurePropertiesSection.this.setButtonImage(FigurePropertiesSection.this.backgroundColorButton, rgbBackgroundColor, FigurePropertiesSection.this.backgroundColorButton.getDisplay());
                        FigurePropertiesSection.this.backgroundColorButton.setToolTipText(rgbBackgroundColor.toString());
                    }
                    FigurePropertiesSection.this.foregroundColorButton.setEnabled(rgbForegroundColor != null && !isReadOnly);
                    if (FigurePropertiesSection.this.foregroundColorButton.isEnabled()) {
                        newButtonColor = new Color(null, rgbForegroundColor);
                        FigurePropertiesSection.this.foregroundColorButton.setBackground(newButtonColor);
                        FigurePropertiesSection.this.foregroundColorButton.setForeground(newButtonColor);
                        FigurePropertiesSection.this.setButtonImage(FigurePropertiesSection.this.foregroundColorButton, rgbForegroundColor, FigurePropertiesSection.this.foregroundColorButton.getDisplay());
                        FigurePropertiesSection.this.foregroundColorButton.setToolTipText(rgbForegroundColor.toString());
                    }
                }
            });
        }
    }

    protected void setButtonImage(Button btn, RGB rgbColor, Display display) {
        Image image = btn.getImage();
        if (image != null) {
            image.dispose();
        }
        Color color1 = new Color((Device)display, rgbColor);
        image = new Image((Device)display, 80, 16);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color1);
        Rectangle rect = image.getBounds();
        gc.fillRectangle(rect);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        gc.dispose();
        color1.dispose();
        btn.setImage(image);
    }

    public void update(final Notification notification, final EObject element) {
        if (!this.isDisposed() && this.isCurrentSelection(notification, element)) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!FigurePropertiesSection.this.isDisposed() && FigurePropertiesSection.this.isCurrentSelection(notification, element) && !FigurePropertiesSection.this.isNotifierDeleted(notification)) {
                        FigurePropertiesSection.this.refresh();
                    }
                }
            });
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nodeFigure = ((SimpleMappingElementWithFigure)this.getEObject()).getNodeFigure();
        this.shapeFamilyMap = new HashMap<Shape, Integer>();
        ArrayList<Object> childClasses = new ArrayList<Object>();
        this.shapeFamilyCombo.removeAll();
        for (Object childDescriptor : this.getEditingDomain().getNewChildDescriptors(null, (Object)this.nodeFigure)) {
            if (!(childDescriptor instanceof CommandParameter)) continue;
            childClasses.add(((CommandParameter)childDescriptor).getValue());
        }
        Collection figures = EcoreUtil.getObjectsByType(childClasses, (EClassifier)GMFGraphPackage.eINSTANCE.getShape());
        int i = 0;
        for (Object figure : figures) {
            this.shapeFamilyMap.put((Shape)figure, i++);
            this.shapeFamilyCombo.add(this.getFigureLabel(figure));
        }
        Figure labelFigure = ((SimpleMappingElementWithFigure)this.getEObject()).getLabelFigure();
        BasicFont basicFont = this.labelFont = labelFigure != null && labelFigure.getFont() instanceof BasicFont ? (BasicFont)labelFigure.getFont() : null;
        if (this.getEObject() instanceof SimpleCompartment) {
            this.defaultBackgroundColor = DEFAULT_COMPARTMENT_BACKGROUND;
            this.defaultForegroundColor = DEFAULT_COMPARTMENT_FOREGROUND;
        } else {
            this.defaultBackgroundColor = DEFAULT_TOP_NODE_BACKGROUND;
            this.defaultForegroundColor = DEFAULT_TOP_NODE_FOREGROUND;
        }
    }

    public String getFigureLabel(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getText(item);
        }
        return null;
    }

    protected void disposeImage(Image image) {
        if (image == null) {
            return;
        }
        if (image.equals((Object)DiagramUIPropertiesImages.get((String)"icons/fill_color.gif"))) {
            return;
        }
        if (!image.isDisposed()) {
            image.dispose();
        }
    }

    public void dispose() {
        if (this.backgroundColorButton != null && !this.backgroundColorButton.isDisposed()) {
            this.disposeImage(this.backgroundColorButton.getImage());
        }
        if (this.foregroundColorButton != null && !this.foregroundColorButton.isDisposed()) {
            this.disposeImage(this.foregroundColorButton.getImage());
        }
        if (this.shapeFamilyCombo != null) {
            this.shapeFamilyCombo.dispose();
        }
        if (this.fontFamilyCombo != null) {
            this.fontFamilyCombo.dispose();
        }
        if (this.fontSizeCombo != null) {
            this.fontSizeCombo.dispose();
        }
        if (this.fontBoldButton != null) {
            this.fontBoldButton.dispose();
        }
        if (this.fontItalicButton != null) {
            this.fontItalicButton.dispose();
        }
        super.dispose();
    }

    private RGB getBackgroungRGBColor() {
        RGBColor figureBackgroundRGBColor = this.nodeFigure.getBackgroundColor() instanceof RGBColor ? (RGBColor)this.nodeFigure.getBackgroundColor() : null;
        RGB rgbBackgroundColor = null;
        if (figureBackgroundRGBColor != null) {
            rgbBackgroundColor = new RGB(figureBackgroundRGBColor.getRed(), figureBackgroundRGBColor.getGreen(), figureBackgroundRGBColor.getBlue());
        }
        return rgbBackgroundColor;
    }

    private RGB getForegroundRGBColor() {
        RGBColor figureForegroundRGBColor = this.nodeFigure.getForegroundColor() instanceof RGBColor ? (RGBColor)this.nodeFigure.getForegroundColor() : null;
        RGB rgbForegroundColor = null;
        if (figureForegroundRGBColor != null) {
            rgbForegroundColor = new RGB(figureForegroundRGBColor.getRed(), figureForegroundRGBColor.getGreen(), figureForegroundRGBColor.getBlue());
        }
        return rgbForegroundColor;
    }

    protected static class ColorOverlayImageDescriptor
    extends CompositeImageDescriptor {
        private static final Point ICON_SIZE = new Point(16, 16);
        private ImageData basicImgData;
        private RGB rgb;

        public ColorOverlayImageDescriptor(ImageData basicImgData, RGB rgb) {
            this.basicImgData = basicImgData;
            this.rgb = rgb;
        }

        protected void drawCompositeImage(int width, int height) {
            if (this.rgb != null) {
                ImageData colorBar = new ImageData(width, height / 5, 1, new PaletteData(new RGB[]{this.rgb}));
                this.drawImage(colorBar, 0, height - height / 5);
            }
            this.drawImage(this.basicImgData, 0, 0);
        }

        protected Point getSize() {
            return ICON_SIZE;
        }
    }
}

