/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.parts;

import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.gmf.internal.runtime.lite.Activator;
import org.eclipse.gmf.runtime.lite.parts.CommandStackAdapterManager;
import org.eclipse.gmf.runtime.lite.parts.IDiagramManager;
import org.eclipse.gmf.runtime.lite.parts.IDiagramOutlineHost;
import org.eclipse.gmf.runtime.lite.parts.UpdatableActionGroup;
import org.eclipse.gmf.runtime.lite.properties.PropertySourceProvider;
import org.eclipse.gmf.runtime.lite.properties.RootUndoablePropertySheetEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class DiagramDisplayer
implements IDiagramOutlineHost {
    private TransactionalEditingDomain editingDomain;
    private PaletteRoot paletteRoot;
    private PropertySheetPage undoablePropertySheetPage;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private UpdatableActionGroup stackActions = new UpdatableActionGroup();
    private EditDomain myEditDomain;
    private IDiagramManager myDiagramManager;
    private FlyoutPaletteComposite mySplitter;
    private PaletteViewerProvider myPaletteViewerProvider;
    private PaletteViewerPage myPalettePage;
    private SelectionSynchronizer synchronizer;
    private Control myTopLevelControl;
    private CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            DiagramDisplayer.this.stackActions.update();
        }
    };
    private UpdatableActionGroup editPartActions = new UpdatableActionGroup();
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            DiagramDisplayer.this.editPartActions.update();
        }
    };
    private UpdatableActionGroup propertyActions = new UpdatableActionGroup();
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            DiagramDisplayer.this.propertyActions.update();
        }
    };

    public DiagramDisplayer(IDiagramManager diagramManager, EditDomain gefEditDomain, TransactionalEditingDomain emfEditingDomain) {
        this.myDiagramManager = diagramManager;
        assert (gefEditDomain != null);
        assert (emfEditingDomain != null);
        this.setEditDomain(gefEditDomain);
        this.editingDomain = emfEditingDomain;
        gefEditDomain.setCommandStack(this.createCommandStack());
        this.getCommandStack().addCommandStackListener(this.commandStackListener);
        this.myDiagramManager.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        this.myDiagramManager.getSite().getPart().addPropertyListener(this.propertyListener);
    }

    private CommandStack createCommandStack() {
        CommandStackAdapterManager manager = (CommandStackAdapterManager)EcoreUtil.getExistingAdapter((Notifier)this.editingDomain.getResourceSet(), CommandStackAdapterManager.class);
        if (manager == null) {
            manager = new CommandStackAdapterManager();
            this.editingDomain.getResourceSet().eAdapters().add((Object)manager);
        }
        manager.acquire();
        return manager.getCommandStack();
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackListener(this.commandStackListener);
        this.myDiagramManager.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        this.myDiagramManager.getSite().getPart().removePropertyListener(this.propertyListener);
        this.getEditDomain().setActiveTool(null);
        CommandStackAdapterManager manager = (CommandStackAdapterManager)EcoreUtil.getExistingAdapter((Notifier)this.getEditingDomain().getResourceSet(), CommandStackAdapterManager.class);
        assert (manager != null);
        manager.release();
        if (manager.isReleased()) {
            this.getEditingDomain().getResourceSet().eAdapters().remove((Object)manager);
        }
        this.getActionRegistry().dispose();
    }

    protected ZoomManager getZoomManager() {
        return this.getZoomManager(this.getGraphicalViewer());
    }

    private ZoomManager getZoomManager(GraphicalViewer viewer) {
        RootEditPart rootEditPart = viewer.getRootEditPart();
        ZoomManager zoomManager = null;
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            zoomManager = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager();
        } else if (rootEditPart instanceof ScalableRootEditPart) {
            zoomManager = ((ScalableRootEditPart)rootEditPart).getZoomManager();
        }
        return zoomManager;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = new PaletteRoot();
            this.myDiagramManager.configurePalette(this.paletteRoot);
        }
        return this.paletteRoot;
    }

    public CommandStack getCommandStack() {
        return this.myEditDomain.getCommandStack();
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.undoablePropertySheetPage == null) {
            this.undoablePropertySheetPage = new PropertySheetPage();
            RootUndoablePropertySheetEntry rootEntry = new RootUndoablePropertySheetEntry(this.getCommandStack(), this.undoablePropertySheetPage);
            rootEntry.setPropertySourceProvider(new PropertySourceProvider(this.myDiagramManager.getDomainAdapterFactory()));
            this.undoablePropertySheetPage.setRootEntry((IPropertySheetEntry)rootEntry);
        }
        return this.undoablePropertySheetPage;
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addEditorAction(WorkbenchPartAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.propertyActions.addAction((UpdateAction)action);
    }

    protected void addEditPartAction(SelectionAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editPartActions.addAction((UpdateAction)action);
    }

    protected void addStackAction(StackAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.stackActions.addAction((UpdateAction)action);
    }

    @Override
    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void createViewer(Composite parent) {
        if (this.myDiagramManager.isFlyoutPalette()) {
            this.mySplitter = new FlyoutPaletteComposite(parent, 0, this.myDiagramManager.getSite().getPage(), this.getPaletteViewerProvider(), this.getPalettePreferences());
            this.createGraphicalViewer((Composite)this.mySplitter);
            this.myTopLevelControl = this.mySplitter;
        } else {
            SashForm sashForm = new SashForm(parent, 256);
            this.createGraphicalViewer((Composite)sashForm);
            this.getPaletteViewerProvider().createPaletteViewer((Composite)sashForm);
            sashForm.setWeights(new int[]{85, 15});
            this.myTopLevelControl = sashForm;
        }
    }

    protected void createGraphicalViewer(Composite parent) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.hookGraphicalViewer();
        this.myDiagramManager.configureGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        this.myEditDomain.addViewer((EditPartViewer)viewer);
        this.graphicalViewer = viewer;
        if (this.mySplitter != null) {
            this.mySplitter.setGraphicalControl(this.graphicalViewer.getControl());
        }
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
        this.myDiagramManager.getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
    }

    protected void initializeGraphicalViewer() {
        if (this.mySplitter != null) {
            this.mySplitter.hookDropTargetListener(this.getGraphicalViewer());
        }
        this.myDiagramManager.initializeGraphicalViewer();
    }

    @Override
    public final SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    private PaletteViewerProvider getPaletteViewerProvider() {
        if (this.myPaletteViewerProvider == null) {
            this.myPaletteViewerProvider = this.createPaletteViewerProvider();
        }
        return this.myPaletteViewerProvider;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider(this.myEditDomain);
    }

    protected void setEditDomain(EditDomain ed) {
        this.myEditDomain = ed;
        this.myEditDomain.setPaletteRoot(this.getPaletteRoot());
    }

    @Override
    public EditDomain getEditDomain() {
        return this.myEditDomain;
    }

    public Control getTopLevelControl() {
        return this.myTopLevelControl;
    }

    @Override
    public Control getGraphicalControl() {
        return this.getGraphicalViewer().getControl();
    }

    private FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return FlyoutPaletteComposite.createFlyoutPreferences((Preferences)Activator.getDefault().getPluginPreferences());
    }

    public PaletteViewerPage getPalettePage() {
        if (this.myPalettePage == null) {
            this.myPalettePage = new CustomPalettePage(this.getPaletteViewerProvider());
        }
        return this.myPalettePage;
    }

    public void save(IProgressMonitor progressMonitor) throws CoreException {
        this.save(Collections.emptyMap(), progressMonitor);
    }

    public void save(Map<?, ?> options, IProgressMonitor progressMonitor) throws CoreException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask("Saving", this.getEditingDomain().getResourceSet().getResources().size());
        try {
            try {
                for (Resource next : this.getEditingDomain().getResourceSet().getResources()) {
                    if (next.isLoaded() && !this.getEditingDomain().isReadOnly(next)) {
                        next.save(options);
                    }
                    progressMonitor.worked(1);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, "Error writing file.", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private class CustomPalettePage
    extends PaletteViewerPage {
        public CustomPalettePage(PaletteViewerProvider provider) {
            super(provider);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (DiagramDisplayer.this.mySplitter != null) {
                DiagramDisplayer.this.mySplitter.setExternalViewer(this.viewer);
            }
        }

        public void dispose() {
            if (DiagramDisplayer.this.mySplitter != null) {
                DiagramDisplayer.this.mySplitter.setExternalViewer(null);
            }
            super.dispose();
        }
    }
}

