/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Identity;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.ToolContainer;

public abstract class AbstractTrigger
extends AbstractOverrideableCommand {
    private RecordingCommand internalCommand;

    public AbstractTrigger(TransactionalEditingDomain domain) {
        super((EditingDomain)domain);
        this.internalCommand = new RecordingCommand(domain){

            protected void doExecute() {
                try {
                    AbstractTrigger.this.executeTrigger();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
    }

    public final void doExecute() {
        this.internalCommand.execute();
    }

    public abstract void executeTrigger();

    public final void doRedo() {
        this.internalCommand.redo();
    }

    public final void doUndo() {
        this.internalCommand.undo();
    }

    protected boolean prepare() {
        return true;
    }

    protected boolean canRemove(EObject element) {
        return this.findReferencingElements(element).size() == 1;
    }

    protected boolean canRename(EObject element) {
        return this.findReferencingElements(element).size() == 1;
    }

    private List<EObject> findReferencingElements(EObject element) {
        EClass elementType = GMFGraphPackage.eINSTANCE.getDiagramElement();
        if (element instanceof DiagramElement || element instanceof AbstractTool) {
            elementType = GMFMapPackage.eINSTANCE.getMappingEntry();
        }
        if (element instanceof DiagramLabel) {
            elementType = GMFMapPackage.eINSTANCE.getLabelMapping();
        }
        if (element instanceof Compartment) {
            elementType = GMFMapPackage.eINSTANCE.getCompartmentMapping();
        }
        if (element instanceof ChildAccess || element instanceof FigureDescriptor) {
            elementType = GMFGraphPackage.eINSTANCE.getDiagramElement();
        }
        return this.findReferencingElements(element, elementType);
    }

    private List<EObject> findReferencingElements(EObject element, EClass elementType) {
        ArrayList<EObject> referencingElements = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : EcoreUtil.UsageCrossReferencer.find((EObject)element, (ResourceSet)this.domain.getResourceSet())) {
            if (!elementType.isSuperTypeOf(setting.getEObject().eClass()) || referencingElements.contains(setting.getEObject())) continue;
            referencingElements.add(setting.getEObject());
        }
        return referencingElements;
    }

    protected String getNewCanvasElementName(String baseName, Identity elementToRename) {
        String newName = baseName;
        int i = 2;
        while (this.nameCollides(elementToRename, newName)) {
            newName = String.valueOf(newName) + i++;
        }
        return newName;
    }

    protected String getNewToolName(String baseName, AbstractTool toolToRename) {
        String newName = baseName;
        int i = 2;
        while (this.nameCollides(toolToRename, newName)) {
            newName = String.valueOf(newName) + i++;
        }
        return newName;
    }

    protected boolean nameCollides(Identity myElement, String baseName) {
        EObject elementContainer = myElement.eContainer();
        for (EObject child : elementContainer.eContents()) {
            Identity element;
            if (!(child instanceof Identity) || (element = (Identity)child) == myElement || element.getName() == null || !element.getName().equals(baseName)) continue;
            return true;
        }
        return false;
    }

    protected boolean nameCollides(AbstractTool myTool, String baseName) {
        EList tools = ((ToolContainer)myTool.eContainer()).getTools();
        for (AbstractTool tool : tools) {
            if (tool == myTool || tool.getTitle() == null || !tool.getTitle().equals(baseName)) continue;
            return true;
        }
        return false;
    }
}

