/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.DefaultResizeConfiguration;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IResizeConfiguration;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.pattern.AbstractBasePattern;
import org.eclipse.graphiti.pattern.IPattern;
import org.eclipse.graphiti.pattern.config.IPatternConfiguration;
import org.eclipse.graphiti.pattern.mapping.IStructureMapping;
import org.eclipse.graphiti.pattern.mapping.data.IDataMapping;
import org.eclipse.graphiti.pattern.mapping.data.IImageDataMapping;
import org.eclipse.graphiti.pattern.mapping.data.ITextDataMapping;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractPattern
extends AbstractBasePattern
implements IPattern {
    private IPatternConfiguration patternConfiguration;

    public AbstractPattern(IPatternConfiguration patternConfiguration) {
        this.setPatternConfiguration(patternConfiguration);
    }

    public boolean canCreate(ICreateContext context) {
        return false;
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        return this.isPatternControlled(pictogramElement);
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        return context.getSourceContainer() != null && context.getSourceContainer().equals(context.getTargetContainer()) && this.isPatternRoot(context.getPictogramElement());
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        return this.isPatternRoot(context.getPictogramElement());
    }

    public boolean canUpdate(IUpdateContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        return this.isPatternControlled(pictogramElement);
    }

    public Object[] create(ICreateContext context) {
        return EMPTY;
    }

    @Override
    public String getCreateDescription() {
        return null;
    }

    public String getCreateImageId() {
        return null;
    }

    public String getCreateLargeImageId() {
        return this.getCreateImageId();
    }

    @Override
    public String getCreateName() {
        return null;
    }

    @Override
    public abstract boolean isMainBusinessObjectApplicable(Object var1);

    public boolean layout(ILayoutContext context) {
        return false;
    }

    public final void moveShape(IMoveShapeContext context) {
        this.preMoveShape(context);
        this.moveAllBendpoints(context);
        this.internalMove(context);
        this.postMoveShape(context);
    }

    protected void postMoveShape(IMoveShapeContext context) {
    }

    protected void preMoveShape(IMoveShapeContext context) {
    }

    protected void internalMove(IMoveShapeContext context) {
        Shape shapeToMove = context.getShape();
        ContainerShape oldContainerShape = context.getSourceContainer();
        ContainerShape newContainerShape = context.getTargetContainer();
        int x = context.getX();
        int y = context.getY();
        if (oldContainerShape != newContainerShape) {
            EList children;
            if (oldContainerShape != null && (children = oldContainerShape.getChildren()) != null) {
                children.remove(shapeToMove);
            }
            shapeToMove.setContainer(newContainerShape);
            if (shapeToMove.getGraphicsAlgorithm() != null) {
                Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
            }
        } else if (shapeToMove.getGraphicsAlgorithm() != null) {
            Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
        }
    }

    protected void moveAllBendpoints(IMoveShapeContext context) {
        if (!(context.getShape() instanceof ContainerShape)) {
            return;
        }
        ContainerShape shapeToMove = (ContainerShape)context.getShape();
        int x = context.getX();
        int y = context.getY();
        int deltaX = x - shapeToMove.getGraphicsAlgorithm().getX();
        int deltaY = y - shapeToMove.getGraphicsAlgorithm().getY();
        if (deltaX != 0 || deltaY != 0) {
            List<Anchor> anchorsFrom = this.getAnchors(shapeToMove);
            ArrayList<Anchor> anchorsTo = new ArrayList<Anchor>(anchorsFrom);
            for (Anchor anchorFrom : anchorsFrom) {
                EList outgoingConnections = anchorFrom.getOutgoingConnections();
                for (Connection connection : outgoingConnections) {
                    for (Anchor anchorTo : anchorsTo) {
                        EList incomingConnections = anchorTo.getIncomingConnections();
                        if (!incomingConnections.contains(connection) || !(connection instanceof FreeFormConnection)) continue;
                        FreeFormConnection ffc = (FreeFormConnection)connection;
                        EList points = ffc.getBendpoints();
                        int i = 0;
                        while (i < points.size()) {
                            Point point = (Point)points.get(i);
                            int oldX = point.getX();
                            int oldY = point.getY();
                            points.set(i, Graphiti.getGaService().createPoint(oldX + deltaX, oldY + deltaY));
                            ++i;
                        }
                    }
                }
            }
        }
    }

    private List<Anchor> getAnchors(ContainerShape containerShape) {
        ArrayList<Anchor> ret = new ArrayList<Anchor>();
        ret.addAll((Collection<Anchor>)containerShape.getAnchors());
        EList children = containerShape.getChildren();
        for (Shape shape : children) {
            if (shape instanceof ContainerShape) {
                ret.addAll(this.getAnchors((ContainerShape)shape));
                continue;
            }
            ret.addAll((Collection<Anchor>)shape.getAnchors());
        }
        return ret;
    }

    public void resizeShape(IResizeShapeContext context) {
        Shape shape = context.getShape();
        int x = context.getX();
        int y = context.getY();
        int width = context.getWidth();
        int height = context.getHeight();
        if (shape.getGraphicsAlgorithm() != null) {
            Graphiti.getGaService().setLocationAndSize(shape.getGraphicsAlgorithm(), x, y, width, height);
        }
        this.layoutPictogramElement((PictogramElement)shape);
    }

    public boolean update(IUpdateContext context) {
        return false;
    }

    public IReason updateNeeded(IUpdateContext context) {
        return Reason.createFalseReason();
    }

    protected void addGraphicalRepresentation(IAreaContext context, Object newObject) {
        this.getFeatureProvider().addIfPossible((IAddContext)new AddContext(context, newObject));
    }

    protected boolean avoidNegativeCoordinates() {
        return false;
    }

    protected String getImage(IStructureMapping structureMapping, PictogramLink link) {
        String ret = null;
        IDataMapping dm = structureMapping.getDataMapping();
        if (dm instanceof IImageDataMapping) {
            ret = ((IImageDataMapping)dm).getImageId(link);
        }
        return ret;
    }

    protected String getText(IStructureMapping structureMapping, PictogramLink link) {
        String ret = null;
        IDataMapping dm = structureMapping.getDataMapping();
        if (dm instanceof ITextDataMapping) {
            ret = ((ITextDataMapping)dm).getText(link);
        }
        return ret;
    }

    protected abstract boolean isPatternControlled(PictogramElement var1);

    protected abstract boolean isPatternRoot(PictogramElement var1);

    protected void layoutPictogramElement(PictogramElement pe) {
        LayoutContext context = new LayoutContext(pe);
        this.getFeatureProvider().layoutIfPossible((ILayoutContext)context);
    }

    protected void updatePictogramElement(PictogramElement pe) {
        UpdateContext context = new UpdateContext(pe);
        this.getFeatureProvider().updateIfPossible((IUpdateContext)context);
        this.layoutPictogramElement(pe);
    }

    protected void setPatternConfiguration(IPatternConfiguration patternConfiguration) {
        this.patternConfiguration = patternConfiguration;
    }

    protected IPatternConfiguration getPatternConfiguration() {
        return this.patternConfiguration;
    }

    @Override
    public void completeInfo(IDirectEditingInfo info, Object bo) {
    }

    @Override
    public void completeInfo(IDirectEditingInfo info, Object bo, String keyProperty) {
    }

    @Override
    public IResizeConfiguration getResizeConfiguration(IResizeShapeContext context) {
        return new DefaultResizeConfiguration();
    }
}

