/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.MatchHeightAction;
import org.eclipse.gef.ui.actions.MatchWidthAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.DiagramScrollingBehavior;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPrintFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.internal.datatypes.impl.DimensionImpl;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramEditorContextMenuProvider;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.ui.internal.IResourceRegistryHolder;
import org.eclipse.graphiti.ui.internal.ResourceRegistry;
import org.eclipse.graphiti.ui.internal.action.AbstractPreDefinedAction;
import org.eclipse.graphiti.ui.internal.action.CopyAction;
import org.eclipse.graphiti.ui.internal.action.DeleteAction;
import org.eclipse.graphiti.ui.internal.action.PasteAction;
import org.eclipse.graphiti.ui.internal.action.PrintGraphicalViewerAction;
import org.eclipse.graphiti.ui.internal.action.RemoveAction;
import org.eclipse.graphiti.ui.internal.action.UpdateAction;
import org.eclipse.graphiti.ui.internal.config.ConfigurationProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderHolder;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonManagerForPad;
import org.eclipse.graphiti.ui.internal.contextbuttons.IContextButtonManager;
import org.eclipse.graphiti.ui.internal.dnd.GFTemplateTransferDropTargetListener;
import org.eclipse.graphiti.ui.internal.dnd.ObjectsTransferDropTargetListener;
import org.eclipse.graphiti.ui.internal.editor.DefaultFlyoutPalettePreferences;
import org.eclipse.graphiti.ui.internal.editor.DiagramChangeListener;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorBehavior;
import org.eclipse.graphiti.ui.internal.editor.DomainModelChangeListener;
import org.eclipse.graphiti.ui.internal.editor.GFCommandStack;
import org.eclipse.graphiti.ui.internal.editor.GFFigureCanvas;
import org.eclipse.graphiti.ui.internal.editor.GFPaletteRoot;
import org.eclipse.graphiti.ui.internal.editor.GFScrollingGraphicalViewer;
import org.eclipse.graphiti.ui.internal.editor.GraphitiScrollingGraphicalViewer;
import org.eclipse.graphiti.ui.internal.parts.IConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.IShapeEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DiagramEditorInternal
extends GraphicalEditorWithFlyoutPalette
implements IConfigurationProviderHolder,
IDiagramEditor,
ITabbedPropertySheetPageContributor,
IResourceRegistryHolder,
IEditingDomainProvider {
    private final CommandStackEventListener cmdStackListener = new CommandStackEventListener(){

        public void stackChanged(CommandStackEvent event) {
            if (Display.getCurrent() != null) {
                DiagramEditorInternal.this.firePropertyChange(257);
                DiagramEditorInternal.this.commandStackChanged((EventObject)event);
            }
        }
    };
    private final DiagramEditorBehavior behavior;
    private final Runnable mDirtyFlagUpdater = new DirtyFlagUpdater();
    private CommandStackListener fwListener;
    protected static final int DEFAULT_PALETTE_SIZE = 130;
    protected static final String PALETTE_DOCK_LOCATION = "Dock location";
    protected static final String PALETTE_SIZE = "Palette Size";
    public static final String PALETTE_STATE = "Palette state";
    private static final boolean REFRESH_ON_GAINED_FOCUS = false;
    private DiagramScrollingBehavior diagramScrollingBehavior = null;
    private PictogramElement[] pictogramElementsForSelection = null;
    private IConfigurationProvider configurationProvider = null;
    private KeyHandler keyHandler;
    private PaletteRoot paletteRoot;
    private Point mouseLocation;
    private DiagramChangeListener diagramChangeListener;
    private DomainModelChangeListener domainModelListener;
    private IContextButtonManager contextButtonManager = null;
    private String contributorId = null;
    private boolean directEditingActive = false;
    private HashSet<EditPart> refreshedFigure4EP = new HashSet();
    private HashSet<GraphicsAlgorithm> refreshedFigure4GA = new HashSet();
    private HashSet<PictogramElement> refreshedFigure4PE = new HashSet();
    private IResourceRegistry resourceRegistry = new ResourceRegistry();
    private RemoveAction removeAction;
    private boolean autoRefresh = true;
    private TransactionalEditingDomain editingDomain = null;

    public DiagramEditorInternal() {
        this.behavior = new DiagramEditorBehavior((IEditorPart)this);
    }

    private void buildNewObjectActions() {
        if (this.getConfigurationProvider() == null) {
            return;
        }
    }

    public Point calculateRealMouseLocation(Point nativeLocation) {
        Point ret = new Point(nativeLocation);
        Point viewLocation = this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE ? this.getGFFigureCanvas().getViewport().getViewLocation() : this.getFigureCanvas().getViewport().getViewLocation();
        ret.x += viewLocation.x;
        ret.y += viewLocation.y;
        ZoomManager zoomManager = (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        ret = ret.getScaled(1.0 / zoomManager.getZoom());
        return ret;
    }

    protected void configureGraphicalViewer() {
        GFFigureCanvas figureCanvas;
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableRootEditPartAnimated rootEditPart = new ScalableRootEditPartAnimated(viewer){

            protected GridLayer createGridLayer() {
                return new org.eclipse.graphiti.ui.internal.util.draw2d.GridLayer(DiagramEditorInternal.this.getConfigurationProvider());
            }
        };
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager zoomManager = rootEditPart.getZoomManager();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        zoomManager.setZoomLevelContributions(zoomLevels);
        IToolBehaviorProvider toolBehaviorProvider = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        zoomManager.setZoomLevels(toolBehaviorProvider.getZoomLevels());
        this.registerAction((IAction)new ZoomInAction(zoomManager));
        this.registerAction((IAction)new ZoomOutAction(zoomManager));
        this.registerAction((IAction)new DirectEditAction((IWorkbenchPart)this));
        this.registerAction((IAction)ActionFactory.SAVE_AS.create(this.getSite().getWorkbenchWindow()));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 1));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 4));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 8));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 32));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 2));
        this.registerAction((IAction)new AlignmentAction((IWorkbenchPart)this, 16));
        this.registerAction((IAction)new MatchWidthAction((IWorkbenchPart)this));
        this.registerAction((IAction)new MatchHeightAction((IWorkbenchPart)this));
        ToggleGridAction showGrid = new ToggleGridAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showGrid);
        this.initActionRegistry();
        viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler()));
        Diagram diagram = this.getConfigurationProvider().getDiagram();
        boolean snapToGrid = diagram.isSnapToGrid();
        int horizontalGridUnit = diagram.getGridUnit();
        int verticalGridUnit = diagram.getVerticalGridUnit();
        if (verticalGridUnit == -1) {
            verticalGridUnit = horizontalGridUnit;
        }
        boolean gridVisisble = horizontalGridUnit > 0 && verticalGridUnit > 0;
        viewer.setProperty("SnapToGrid.isVisible", (Object)new Boolean(gridVisisble));
        viewer.setProperty("SnapToGrid.isEnabled", (Object)new Boolean(snapToGrid));
        viewer.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(horizontalGridUnit, verticalGridUnit));
        viewer.setProperty("SnapToGeometry.isEnabled", (Object)toolBehaviorProvider.isShowGuides());
        this.contextButtonManager = new ContextButtonManagerForPad(this);
        if (this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE && (figureCanvas = this.getGFFigureCanvas()) != null) {
            figureCanvas.setScrollBarVisibility(FigureCanvas.ALWAYS);
        }
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new DiagramEditorContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry(), this.getConfigurationProvider());
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphitiScrollingGraphicalViewer viewer;
        if (this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE) {
            viewer = new GFScrollingGraphicalViewer(this);
            ((GFScrollingGraphicalViewer)viewer).createGFControl(parent);
        } else {
            viewer = new GraphitiScrollingGraphicalViewer(this);
            viewer.createControl(parent);
        }
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        return new DefaultFlyoutPalettePreferences();
    }

    protected PaletteRoot createPaletteRoot() {
        return new GFPaletteRoot(this.getConfigurationProvider());
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){
            private KeyHandler paletteKeyHandler;
            {
                this.paletteKeyHandler = null;
            }

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.getKeyHandler().setParent(this.getPaletteKeyHandler());
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }

            private KeyHandler getPaletteKeyHandler() {
                if (this.paletteKeyHandler == null) {
                    this.paletteKeyHandler = new KeyHandler(){

                        public boolean keyReleased(KeyEvent event) {
                            Tool tool;
                            if (event.keyCode == 13 && ((tool = this.getEditDomain().getPaletteViewer().getActiveTool().createTool()) instanceof CreationTool || tool instanceof ConnectionCreationTool)) {
                                tool.keyUp(event, (EditPartViewer)DiagramEditorInternal.this.getGraphicalViewer());
                                this.getEditDomain().getPaletteViewer().setActiveTool(null);
                                return true;
                            }
                            return super.keyReleased(event);
                        }
                    };
                }
                return this.paletteKeyHandler;
            }
        };
    }

    public void dispose() {
        this.unregisterDiagramResourceSetListener();
        this.unregisterBOListener();
        this.isDirty();
        if (this.getConfigurationProvider() != null) {
            this.getConfigurationProvider().dispose();
        }
        this.paletteRoot = null;
        if (this.getSite() != null && this.getSite().getPage() != null) {
            this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        }
        this.getEditDomain().getCommandStack().removeCommandStackEventListener(this.cmdStackListener);
        this.getEditDomain().getCommandStack().dispose();
        if (this.resourceRegistry != null) {
            this.resourceRegistry.dispose();
        }
        DiagramEditorBehavior behavior = this.getBehavior();
        behavior.getEditingDomain().getCommandStack().removeCommandStackListener(this.fwListener);
        this.fwListener = null;
        behavior.dispose();
        super.dispose();
        this.getEditDomain().setCommandStack(null);
    }

    public void doSave(IProgressMonitor monitor) {
        this.getBehavior().doSave(monitor);
        this.commandStackChanged(null);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        String METHOD = "setInput(IEditorInput)";
        try {
            IDiagramTypeProvider diagramTypeProvider;
            if (input == null) {
                throw new IllegalArgumentException("The IEditorInput must not be null");
            }
            if (!(input instanceof DiagramEditorInput)) {
                throw new IllegalArgumentException("The IEditorInput has the wrong type: " + input.getClass());
            }
            DiagramEditorInput diagramEditorInput = (DiagramEditorInput)input;
            Diagram diagram = diagramEditorInput.getDiagram();
            if (diagram == null) {
                throw new IllegalStateException("Cannot open diagram '" + diagramEditorInput.getName() + "'. Might have been deleted. See the error log for details.");
            }
            TransactionalEditingDomain editingDomain = this.getBehavior().getEditingDomain();
            this.setTransactionalEditingDomain(editingDomain);
            String providerId = diagramEditorInput.getProviderId();
            if (providerId == null) {
                providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
                diagramEditorInput.setProviderId(providerId);
            }
            if ((diagramTypeProvider = GraphitiUi.getExtensionManager().createDiagramTypeProvider(providerId)) == null) {
                throw new IllegalArgumentException("could not find diagram type provider for " + diagram.getDiagramTypeId());
            }
            diagramTypeProvider.init(diagram, (IDiagramEditor)this);
            ConfigurationProvider configurationProvider = new ConfigurationProvider(this, diagramTypeProvider);
            this.setConfigurationProvider(configurationProvider);
            this.handleAutoUpdateAtStartup(diagram, diagramTypeProvider);
            this.registerBOListener();
            this.registerDiagramResourceSetListener();
            this.refreshTitle();
        }
        catch (Exception e) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String message = "Can not open the modifier. Details " + e.getMessage();
                    T.racer().error(message, (Throwable)e);
                    T.racer().error("setInput(IEditorInput)", String.valueOf(message) + "\nDetails: " + GraphitiUiInternal.getTraceService().getStacktrace(e));
                }
            });
        }
    }

    public ActionRegistry getActionRegistryInternal() {
        return this.getActionRegistry();
    }

    public Object getAdapter(Class type) {
        Object ret;
        IToolBehaviorProvider tbp;
        IConfigurationProvider cfgProvider = this.getConfigurationProvider();
        if (cfgProvider != null && (tbp = cfgProvider.getDiagramTypeProvider().getCurrentToolBehaviorProvider()) != null && (ret = tbp.getAdapter(type)) != null) {
            return ret;
        }
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (type == ZoomManager.class && viewer != null) {
            return viewer.getProperty(ZoomManager.class.toString());
        }
        if (type == IPropertySheetPage.class) {
            if (cfgProvider != null && this.getContributorId() != null) {
                return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return null;
        }
        if (IUndoContext.class == type) {
            return this.getBehavior().getUndoContext();
        }
        return super.getAdapter(type);
    }

    public KeyHandler getCommonKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)131072), this.getActionRegistry().getAction((Object)"predefined remove action"));
            this.keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.keyHandler.put(KeyStroke.getPressed((char)'c', (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'v', (int)262144), this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId()));
        }
        return this.keyHandler;
    }

    @Override
    public IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected EditPart getContentEditPart() {
        if (this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getContents();
        }
        return null;
    }

    public IContextButtonManager getContextButtonManager() {
        return this.contextButtonManager;
    }

    public String getContributorId() {
        IToolBehaviorProvider tbp;
        if (this.contributorId == null && (tbp = this.getToolBehaviorProvider()) != null) {
            this.contributorId = tbp.getContributorId();
        }
        return this.contributorId;
    }

    public IDimension getCurrentSize() {
        if (this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE) {
            GFFigureCanvas canvas = this.getGFFigureCanvas();
            if (canvas != null) {
                Dimension size = canvas.getContents().getSize();
                return new DimensionImpl(size.width, size.height);
            }
            return new DimensionImpl(1024, 768);
        }
        FigureCanvas canvas = this.getFigureCanvas();
        if (canvas != null) {
            Dimension size = canvas.getContents().getSize();
            return new DimensionImpl(size.width, size.height);
        }
        return new DimensionImpl(1024, 768);
    }

    @Deprecated
    public DiagramScrollingBehavior getDiagramScrollingBehavior() {
        if (this.diagramScrollingBehavior == null) {
            IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            this.diagramScrollingBehavior = tbp.getDiagramScrollingBehavior();
        }
        return this.diagramScrollingBehavior;
    }

    public IDiagramTypeProvider getDiagramTypeProvider() {
        IConfigurationProvider cfgProvider = this.getConfigurationProvider();
        if (cfgProvider != null) {
            return cfgProvider.getDiagramTypeProvider();
        }
        return null;
    }

    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    public GraphicalEditPart getEditPartForPictogramElement(PictogramElement pe) {
        Object obj;
        Map editPartRegistry = this.getGraphicalViewer().getEditPartRegistry();
        if (editPartRegistry != null && (obj = editPartRegistry.get(pe)) instanceof GraphicalEditPart) {
            GraphicalEditPart ep = (GraphicalEditPart)obj;
            return ep;
        }
        return null;
    }

    public FigureCanvas getFigureCanvas() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer != null) {
            return (FigureCanvas)viewer.getControl();
        }
        return null;
    }

    public IFigure getFigureForPictogramElement(PictogramElement pe) {
        GraphicalEditPart ep = this.getEditPartForPictogramElement(pe);
        if (ep != null) {
            return ep.getFigure();
        }
        return null;
    }

    private GFFigureCanvas getGFFigureCanvas() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer != null) {
            return (GFFigureCanvas)viewer.getControl();
        }
        return null;
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public Point getMouseLocation() {
        if (this.mouseLocation == null) {
            this.mouseLocation = new Point();
        }
        return this.mouseLocation;
    }

    public ILocation getCurrentMouseLocation() {
        Point mL = this.getMouseLocation();
        return new LocationImpl(mL.x, mL.y);
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return DiagramEditorInternal.this.getPreferenceStore().getInt(DiagramEditorInternal.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return DiagramEditorInternal.this.getPreferenceStore().getInt(DiagramEditorInternal.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return DiagramEditorInternal.this.getPreferenceStore().getInt(DiagramEditorInternal.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                DiagramEditorInternal.this.getPreferenceStore().setValue(DiagramEditorInternal.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                DiagramEditorInternal.this.getPreferenceStore().setValue(DiagramEditorInternal.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                DiagramEditorInternal.this.getPreferenceStore().setValue(DiagramEditorInternal.PALETTE_SIZE, width);
            }
        };
    }

    private IPreferenceStore getPreferenceStore() {
        IPreferenceStore ps = GraphitiUIPlugin.getDefault().getPreferenceStore();
        ps.setDefault(PALETTE_STATE, 4);
        return ps;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = this.createPaletteRoot();
        }
        return this.paletteRoot;
    }

    protected PictogramElement[] getPictogramElementsForSelection() {
        return this.pictogramElementsForSelection;
    }

    public HashSet<EditPart> getRefreshedFigure4EP() {
        return this.refreshedFigure4EP;
    }

    public HashSet<GraphicsAlgorithm> getRefreshedFigure4GA() {
        return this.refreshedFigure4GA;
    }

    public HashSet<PictogramElement> getRefreshedFigure4PE() {
        return this.refreshedFigure4PE;
    }

    @Override
    public IResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public PictogramElement[] getSelectedPictogramElements() {
        ISelection s;
        PictogramElement[] pe = new PictogramElement[]{};
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        if (selectionProvider != null && (s = selectionProvider.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)s;
            ArrayList<PictogramElement> list = new ArrayList<PictogramElement>();
            for (Object o : sel) {
                EditPart editPart;
                if (!(o instanceof EditPart) || !((editPart = (EditPart)o).getModel() instanceof PictogramElement)) continue;
                list.add((PictogramElement)editPart.getModel());
            }
            pe = list.toArray(new PictogramElement[0]);
        }
        return pe;
    }

    public SelectionSynchronizer getSelectionSynchronizerInternal() {
        return this.getSelectionSynchronizer();
    }

    public String getTitleToolTip() {
        IToolBehaviorProvider tbp;
        String titleToolTip;
        if (this.getDiagramTypeProvider() != null && this.getDiagramTypeProvider().getCurrentToolBehaviorProvider() != null && (titleToolTip = (tbp = this.getDiagramTypeProvider().getCurrentToolBehaviorProvider()).getTitleToolTip()) != null) {
            return titleToolTip;
        }
        return super.getTitleToolTip();
    }

    private IToolBehaviorProvider getToolBehaviorProvider() {
        IDiagramTypeProvider dtp = this.getDiagramTypeProvider();
        if (dtp != null) {
            return dtp.getCurrentToolBehaviorProvider();
        }
        return null;
    }

    public double getZoomLevel() {
        ZoomManager zoomManager = (ZoomManager)this.getAdapter(ZoomManager.class);
        if (zoomManager == null) {
            return 1.0;
        }
        return Math.max(0.05, zoomManager.getZoom());
    }

    private void handleAutoUpdateAtStartup(Diagram diagram, IDiagramTypeProvider diagramTypeProvider) {
        if (diagramTypeProvider.isAutoUpdateAtStartup()) {
            this.autoUpdate(diagram, diagramTypeProvider);
        }
    }

    private void handleAutoUpdateAtReset(Diagram diagram, IDiagramTypeProvider diagramTypeProvider) {
        if (diagramTypeProvider.isAutoUpdateAtReset()) {
            this.autoUpdate(diagram, diagramTypeProvider);
        }
    }

    private void autoUpdate(Diagram diagram, IDiagramTypeProvider diagramTypeProvider) {
        IFeatureProvider featureProvider = diagramTypeProvider.getFeatureProvider();
        UpdateContext updateCtx = new UpdateContext((PictogramElement)diagram);
        featureProvider.updateIfPossible((IUpdateContext)updateCtx);
        this.refresh();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof DiagramEditorInput)) {
            DiagramEditorInput newInput = new DiagramEditorFactory().createEditorInput(input);
            if (!(newInput instanceof DiagramEditorInput)) {
                throw new PartInitException("Unknown editor input: " + newInput);
            }
            input = newInput;
        }
        this.getBehavior().init(site, input, this.mDirtyFlagUpdater);
        super.init(site, input);
        this.fwListener = new FWCommandStackListener();
        this.getBehavior().getEditingDomain().getCommandStack().addCommandStackListener(this.fwListener);
    }

    protected void initActionRegistry() {
        ActionRegistry actionRegistry = this.getActionRegistry();
        List selectionActions = this.getSelectionActions();
        AbstractPreDefinedAction action = new UpdateAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        if (this.removeAction == null) {
            this.removeAction = new RemoveAction((IWorkbenchPart)this, this.getConfigurationProvider());
            action = this.removeAction;
            actionRegistry.registerAction((IAction)action);
            selectionActions.add(action.getId());
        }
        action = new DeleteAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new CopyAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new PasteAction((IWorkbenchPart)this, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    protected void initializeGraphicalViewer() {
        ContextMenuProvider contextMenuProvider;
        IPrintFeature pf;
        super.initializeGraphicalViewer();
        IFeatureProvider featureProvider = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
        if (featureProvider != null && (pf = featureProvider.getPrintFeature()) != null) {
            this.registerAction((IAction)new PrintGraphicalViewerAction(this.getConfigurationProvider(), this.getConfigurationProvider().getWorkbenchPart(), pf));
        }
        this.buildNewObjectActions();
        if (this.getEditorSite().getActionBarContributor() != null) {
            this.getEditorSite().getActionBarContributor().setActiveEditor((IEditorPart)this);
        }
        if ((contextMenuProvider = this.createContextMenuProvider()) != null) {
            this.getGraphicalViewer().setContextMenu((MenuManager)contextMenuProvider);
            this.getSite().registerContextMenu((MenuManager)contextMenuProvider, (ISelectionProvider)this.getGraphicalViewer());
        }
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)this.getConfigurationProvider().getEditPartFactory());
        this.getGraphicalViewer().setContents((Object)this.getConfigurationProvider().getDiagram());
        PaletteViewer paletteViewer = this.getEditDomain().getPaletteViewer();
        if (paletteViewer != null) {
            IPreferenceStore store = GraphitiUIPlugin.getDefault().getPreferenceStore();
            paletteViewer.setPaletteViewerPreferences((PaletteViewerPreferences)new DefaultPaletteViewerPreferences(store));
            store.firePropertyChangeEvent("Palette Font", null, null);
        }
        this.getGraphicalViewer().getControl().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                DiagramEditorInternal.this.setMouseLocation(e.x, e.y);
            }
        });
        this.getGraphicalViewer().addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new ObjectsTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new GFTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
    }

    void internalRefreshEditPart(final EditPart editPart) {
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramEditorInternal.this.internalRefreshEditPart(editPart);
                }
            });
            return;
        }
        long start = System.currentTimeMillis();
        try {
            this.getContextButtonManager().hideContextButtonsInstantly();
            editPart.refresh();
            long stop = System.currentTimeMillis();
            long time = stop - start;
            if (time > 500L) {
                String output = "refreshEditPart took " + time + " ms.";
                T.racer().warning("DiagramEditorInternal.refreshEditPart() ", output);
            }
        }
        catch (NullPointerException e) {
            T.racer().error("refresh edit part problem", (Throwable)e);
        }
    }

    public boolean isAlive() {
        IConfigurationProvider cp = this.getConfigurationProvider();
        if (cp != null) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            Diagram diagram = cp.getDiagram();
            if (editingDomain != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)diagram)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void initRefresh() {
        this.refreshedFigure4EP = new HashSet();
        this.refreshedFigure4GA = new HashSet();
        this.refreshedFigure4PE = new HashSet();
    }

    public void refresh() {
        EditPart editPart;
        IDirectEditingInfo dei;
        if (!this.isAlive()) {
            return;
        }
        if (GFPreferences.getInstance().isCPUProfilingTraceActive() && T.racer().info()) {
            T.racer().info("DiagramEditorInternal.refresh()");
        }
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramEditorInternal.this.refresh();
                }
            });
            return;
        }
        if (this.paletteRoot == null) {
            return;
        }
        long start = System.currentTimeMillis();
        EditPart contentEditPart = this.getContentEditPart();
        if (contentEditPart == null) {
            return;
        }
        this.internalRefreshEditPart(contentEditPart);
        this.refreshTitle();
        long stop = System.currentTimeMillis();
        long time = stop - start;
        if (time > 500L) {
            String output = "refresh took " + time + " ms.";
            T.racer().warning("DiagramEditorInternal.refresh() ", output);
        }
        if ((dei = this.getConfigurationProvider().getFeatureProvider().getDirectEditingInfo()).isActive() && (editPart = (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(dei.getMainPictogramElement())) instanceof ShapeEditPart) {
            ShapeEditPart shapeEditPart = (ShapeEditPart)editPart;
            shapeEditPart.switchToDirectEditingMode(dei.getPictogramElement(), dei.getGraphicsAlgorithm());
            dei.reset();
        }
        this.selectBufferedPictogramElements();
    }

    public void refreshPalette() {
        PaletteRoot pr = this.getPaletteRoot();
        if (pr instanceof GFPaletteRoot) {
            GFPaletteRoot gpr = (GFPaletteRoot)pr;
            gpr.updatePaletteEntries();
        }
    }

    public void refreshRenderingDecorators(PictogramElement pe) {
        GraphicalEditPart ep = this.getEditPartForPictogramElement(pe);
        if (ep instanceof IShapeEditPart) {
            IShapeEditPart sep = (IShapeEditPart)ep;
            sep.refreshDecorators();
        }
    }

    private void refreshTitle() {
        String name = this.getConfigurationProvider().getDiagramTypeProvider().getDiagramTitle();
        if (name == null || name.length() == 0) {
            name = this.getConfigurationElement().getAttribute("name");
        }
        this.setPartName(name);
    }

    public void refreshTitleToolTip() {
        this.setTitleToolTip(this.getTitleToolTip());
    }

    protected void registerAction(IAction action) {
        if (action == null) {
            return;
        }
        this.getActionRegistry().registerAction(action);
        if (action.getActionDefinitionId() != null) {
            IHandlerService hs = (IHandlerService)this.getSite().getService(IHandlerService.class);
            hs.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
        }
        List selectionActions = this.getSelectionActions();
        selectionActions.add(action.getId());
    }

    private void registerDiagramResourceSetListener() {
        this.diagramChangeListener = new DiagramChangeListener(this);
        TransactionalEditingDomain eDomain = this.getEditingDomain();
        eDomain.addResourceSetListener((ResourceSetListener)this.diagramChangeListener);
    }

    protected void registerBOListener() {
        this.domainModelListener = new DomainModelChangeListener(this);
        TransactionalEditingDomain eDomain = this.getEditingDomain();
        eDomain.addResourceSetListener((ResourceSetListener)this.domainModelListener);
    }

    private void unregisterDiagramResourceSetListener() {
        if (this.diagramChangeListener != null) {
            this.diagramChangeListener.stopListening();
            TransactionalEditingDomain eDomain = this.getEditingDomain();
            eDomain.removeResourceSetListener((ResourceSetListener)this.diagramChangeListener);
        }
    }

    protected void unregisterBOListener() {
        if (this.domainModelListener != null) {
            TransactionalEditingDomain eDomain = this.getEditingDomain();
            eDomain.removeResourceSetListener((ResourceSetListener)this.domainModelListener);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorPart activeEditor;
        boolean editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
        if (!editorIsActive && (activeEditor = this.getSite().getPage().getActiveEditor()) != null) {
            Object selectedPage;
            editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)activeEditor);
            if (activeEditor instanceof MultiPageEditorPart && !((selectedPage = ((MultiPageEditorPart)activeEditor).getSelectedPage()) instanceof DiagramEditorInternal)) {
                editorIsActive = false;
            }
        }
        if (editorIsActive) {
            if (part instanceof CommonNavigator && !((CommonNavigator)part).isLinkingEnabled()) {
                return;
            }
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                ArrayList<PictogramElement> peList = new ArrayList<PictogramElement>();
                for (Object object : structuredSelection) {
                    if (object instanceof EObject) {
                        List referencingPes = Graphiti.getLinkService().getPictogramElements(this.getDiagramTypeProvider().getDiagram(), (EObject)object);
                        if (referencingPes.size() <= 0) continue;
                        peList.addAll(referencingPes);
                        continue;
                    }
                    PictogramElement[] relatedPictogramElements = this.getDiagramTypeProvider().getNotificationService().calculateRelatedPictogramElements(new Object[]{object});
                    int i = 0;
                    while (i < relatedPictogramElements.length) {
                        peList.add(relatedPictogramElements[i]);
                        ++i;
                    }
                }
                PictogramElement[] pes = null;
                if (peList.size() > 0) {
                    pes = peList.toArray(new PictogramElement[peList.size()]);
                }
                if (pes != null && pes.length > 0) {
                    this.selectPictogramElements(pes);
                }
            }
        }
        super.selectionChanged(part, selection);
    }

    public void selectPictogramElements(PictogramElement[] pictogramElements) {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        Map editPartRegistry = this.getGraphicalViewer().getEditPartRegistry();
        if (editPartRegistry != null) {
            EditPart editpart;
            int i = 0;
            while (i < pictogramElements.length) {
                PictogramElement pe = pictogramElements[i];
                Object obj = editPartRegistry.get(pe);
                if (obj instanceof EditPart) {
                    editParts.add((EditPart)obj);
                }
                ++i;
            }
            this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(editParts));
            if (editParts.size() > 0 && !((editpart = (EditPart)editParts.get(0)) instanceof IConnectionEditPart)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DiagramEditorInternal.this.getGraphicalViewer().reveal(editpart);
                    }
                });
            }
        }
    }

    protected void setAutoRefresh(boolean b) {
        this.autoRefresh = b;
    }

    private void setConfigurationProvider(IConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        this.configurationProvider.setWorkbenchPart((IWorkbenchPart)this);
        if (this.getGraphicalViewer() != null) {
            this.initializeGraphicalViewer();
        }
        DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this);
        GFCommandStack commandStack = new GFCommandStack(configurationProvider, this.getEditingDomain());
        editDomain.setCommandStack((CommandStack)commandStack);
        this.setEditDomain(editDomain);
    }

    public void setFocus() {
        if (this.getGraphicalViewer() == null) {
            return;
        }
        super.setFocus();
        this.getBehavior().setFocus();
    }

    void setMouseLocation(int x, int y) {
        this.getMouseLocation().setLocation(x, y);
    }

    public void setPictogramElementForSelection(PictogramElement pictogramElementForSelection) {
        this.pictogramElementsForSelection = pictogramElementForSelection == null ? null : new PictogramElement[]{pictogramElementForSelection};
    }

    public void setPictogramElementsForSelection(PictogramElement[] pictogramElementsForSelection) {
        this.pictogramElementsForSelection = pictogramElementsForSelection;
    }

    public void refreshContent() {
        Diagram currentDiagram = this.getDiagramTypeProvider().getDiagram();
        if (GraphitiInternal.getEmfService().isObjectAlive((EObject)currentDiagram)) {
            this.refresh();
        } else {
            DiagramEditorInput diagramEditorInput = (DiagramEditorInput)this.getEditorInput();
            Diagram diagram = diagramEditorInput.getDiagram();
            IDiagramTypeProvider diagramTypeProvider = this.getConfigurationProvider().getDiagramTypeProvider();
            diagramTypeProvider.resourceReloaded(diagram);
            this.initRefresh();
            this.setPictogramElementsForSelection(null);
            this.getGraphicalViewer().setContents((Object)diagram);
            this.handleAutoUpdateAtReset(diagram, diagramTypeProvider);
        }
    }

    public boolean isDirectEditingActive() {
        return this.directEditingActive;
    }

    public void setDirectEditingActive(boolean directEditingActive) {
        this.directEditingActive = directEditingActive;
        this.getContextButtonManager().hideContextButtonsInstantly();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getDiagramTypeProvider().postInit();
        this.getEditDomain().getCommandStack().addCommandStackEventListener(this.cmdStackListener);
    }

    public boolean isDirty() {
        return this.getBehavior().isDirty();
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ResourceSet getResourceSet() {
        ResourceSet ret = null;
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            ret = editingDomain.getResourceSet();
        }
        return ret;
    }

    private void setTransactionalEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    private DiagramEditorBehavior getBehavior() {
        return this.behavior;
    }

    public boolean isMultipleRefreshSupressionActive() {
        return true;
    }

    protected void selectBufferedPictogramElements() {
        if (this.getPictogramElementsForSelection() != null) {
            this.selectPictogramElements(this.getPictogramElementsForSelection());
            this.setPictogramElementsForSelection(null);
        }
    }

    final class DirtyFlagUpdater
    implements Runnable {
        DirtyFlagUpdater() {
        }

        @Override
        public void run() {
            DiagramEditorInternal.this.firePropertyChange(257);
        }
    }

    protected class FWCommandStackListener
    implements CommandStackListener {
        protected FWCommandStackListener() {
        }

        public void commandStackChanged(EventObject event) {
            DiagramEditorInternal.this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramEditorInternal.this.firePropertyChange(257);
                }
            });
        }
    }
}

