/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.parts.AnchorContainerDelegate;
import org.eclipse.graphiti.ui.internal.parts.IAnchorContainerDelegate;
import org.eclipse.graphiti.ui.internal.parts.IConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;

public abstract class ConnectionEditPart
extends AbstractConnectionEditPart
implements IConnectionEditPart {
    private final IAnchorContainerDelegate delegate;

    public ConnectionEditPart(IConfigurationProvider configurationProvider, Connection connection) {
        this.setModel(connection);
        this.delegate = new AnchorContainerDelegate(configurationProvider, (PictogramElement)connection, (EditPart)this);
    }

    public void activate() {
        super.activate();
        this.delegate.activate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionHighlightEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionDeleteEditPolicy(this.getConfigurationProvider()));
    }

    protected IFigure createFigure() {
        IFigure ret = this.delegate.createFigure();
        return ret;
    }

    public void deactivate() {
        this.delegate.deactivate();
        super.deactivate();
    }

    @Override
    public IConfigurationProvider getConfigurationProvider() {
        return this.delegate.getConfigurationProvider();
    }

    protected Connection getConnection() {
        Connection ret = null;
        if (this.getPictogramElement() instanceof Connection) {
            ret = (Connection)this.getPictogramElement();
        }
        return ret;
    }

    @Override
    public PictogramElement getPictogramElement() {
        return this.delegate.getPictogramElement();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.delegate.refreshFigureForEditPart();
    }

    @Override
    public List<PictogramElement> getModelChildren() {
        return new ArrayList<PictogramElement>();
    }

    @Override
    public List<Connection> getModelSourceConnections() {
        return new ArrayList<Connection>();
    }

    @Override
    public List<Connection> getModelTargetConnections() {
        return new ArrayList<Connection>();
    }

    public Object getAdapter(Class key) {
        Object ret = this.delegate.getAdapter(key);
        if (ret == null) {
            ret = super.getAdapter(key);
        }
        return ret;
    }

    public IFeatureProvider getFeatureProvider() {
        IFeatureProvider ret = null;
        if (this.delegate != null) {
            ret = this.delegate.getFeatureProvider();
        }
        return ret;
    }

    @Override
    public IPictogramElementDelegate getPictogramElementDelegate() {
        return this.delegate;
    }

    @Override
    public void forceVisualRefresh() {
        this.getPictogramElementDelegate().setForceRefresh(true);
        this.refreshVisuals();
        this.getPictogramElementDelegate().setForceRefresh(false);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }
}

