/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts.directedit;

import org.eclipse.graphiti.ui.internal.parts.directedit.IDirectEditHolder;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Control;

public class GFCellEditorValidator
implements ICellEditorValidator {
    private IDirectEditHolder directEditHolder;
    private CellEditor cellEditor;

    public GFCellEditorValidator(IDirectEditHolder directEditHolder, CellEditor cellEditor) {
        this.directEditHolder = directEditHolder;
        this.setCellEditor(cellEditor);
    }

    public String isValid(Object value) {
        String ret = null;
        if (value instanceof String) {
            ret = this.directEditHolder.getDirectEditingFeature().checkValueValid((String)value, this.directEditHolder.getDirectEditingContext());
        } else if (value instanceof Integer && this.getCellEditor() instanceof ComboBoxCellEditor) {
            ComboBoxCellEditor cb = (ComboBoxCellEditor)this.getCellEditor();
            String sValue = null;
            int index = (Integer)value;
            if (index < 0) {
                Control control = cb.getControl();
                if (control instanceof CCombo) {
                    CCombo cc = (CCombo)control;
                    sValue = cc.getText();
                }
            } else {
                String[] items = cb.getItems();
                if (items != null && index < items.length) {
                    sValue = items[index];
                }
            }
            if (sValue != null) {
                ret = this.directEditHolder.getDirectEditingFeature().checkValueValid(sValue, this.directEditHolder.getDirectEditingContext());
            }
        }
        return ret;
    }

    private CellEditor getCellEditor() {
        return this.cellEditor;
    }

    private void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }
}

