/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.internal.services.IWorkbenchService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;

public class WorkbenchService
implements IWorkbenchService {
    @Override
    public IStatusLineManager getActiveStatusLineManager() {
        IEditorPart editorPart;
        IEditorActionBarContributor contributor;
        IWorkbenchPart activePart = this.getActiveOrFirstWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)activePart;
            return viewPart.getViewSite().getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (editorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            EditorActionBarContributor editorContributor = (EditorActionBarContributor)contributor;
            return editorContributor.getActionBars().getStatusLineManager();
        }
        return new StatusLineManager();
    }

    @Override
    public IWorkbenchWindow getActiveOrFirstWorkbenchWindow() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow result = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (result == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()) != null && windows.length > 0) {
            result = windows[0];
        }
        return result;
    }

    @Override
    public IDiagramEditor openDiagramEditor(Diagram diagram, TransactionalEditingDomain domain, boolean disposeEditingDomain) {
        IDiagramEditor ret = null;
        String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        ret = this.openDiagramEditor(diagram, domain, providerId, disposeEditingDomain);
        return ret;
    }

    @Override
    public IDiagramEditor openDiagramEditor(Diagram diagram, TransactionalEditingDomain domain, String providerId, boolean disposeEditingDomain) {
        IDiagramEditor ret = null;
        DiagramEditorInput diagramEditorInput = DiagramEditorInput.createEditorInput(diagram, domain, providerId, disposeEditingDomain);
        IWorkbenchPage workbenchPage = WorkbenchService.getActivePage();
        try {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)diagramEditorInput, (String)"org.eclipse.graphiti.ui.editor.DiagramEditor");
            if (editorPart instanceof IDiagramEditor) {
                ret = (IDiagramEditor)editorPart;
            }
        }
        catch (PartInitException e) {
            T.racer().error(e.toString());
        }
        return ret;
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow.getActivePage();
        }
        return null;
    }

    @Override
    public Shell getShell() {
        return GraphitiUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

