/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.features;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.examples.common.ExampleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class TutorialRenameEClassFeature
extends AbstractCustomFeature {
    private boolean hasDoneChanges = false;

    public TutorialRenameEClassFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Re&name EClass";
    }

    public String getDescription() {
        return "Change the name of the EClass";
    }

    public boolean canExecute(ICustomContext context) {
        Object bo;
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof EClass) {
            ret = true;
        }
        return ret;
    }

    public void execute(ICustomContext context) {
        Object bo;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof EClass) {
            EClass eClass = (EClass)bo;
            String currentName = eClass.getName();
            String newName = ExampleUtil.askString((String)this.getName(), (String)this.getDescription(), (String)currentName);
            if (newName != null && !newName.equals(currentName)) {
                this.hasDoneChanges = true;
                eClass.setName(newName);
            }
        }
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }
}

