/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.examples.common.ExamplesCommonPlugin;
import org.eclipse.graphiti.examples.common.FileService;
import org.eclipse.graphiti.examples.common.Messages;
import org.eclipse.graphiti.examples.common.navigator.nodes.base.AbstractInstancesOfTypeContainerNode;
import org.eclipse.graphiti.examples.common.ui.DiagramNameWizardPage;
import org.eclipse.graphiti.examples.common.ui.DiagramTypeWizardPage;
import org.eclipse.graphiti.examples.common.ui.ITextProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class CreateDiagramWizard
extends BasicNewResourceWizard {
    private static final String PAGE_NAME_DIAGRAM_TYPE = Messages.CreateDiagramWizard_DiagramTypeField;
    private static final String PAGE_NAME_DIAGRAM_NAME = Messages.CreateDiagramWizard_DiagramNameField;
    private static final String WIZARD_WINDOW_TITLE = "New Diagram";
    private Diagram diagram;

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new DiagramTypeWizardPage(PAGE_NAME_DIAGRAM_TYPE));
        this.addPage((IWizardPage)new DiagramNameWizardPage(PAGE_NAME_DIAGRAM_NAME));
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(WIZARD_WINDOW_TITLE);
    }

    public boolean performFinish() {
        ITextProvider typePage = (ITextProvider)this.getPage(PAGE_NAME_DIAGRAM_TYPE);
        String diagramTypeId = typePage.getText();
        ITextProvider namePage = (ITextProvider)this.getPage(PAGE_NAME_DIAGRAM_NAME);
        String diagramName = namePage.getText();
        IProject project = null;
        IFolder diagramFolder = null;
        Object element = this.getSelection().getFirstElement();
        if (element instanceof IProject) {
            project = (IProject)element;
        } else if (element instanceof AbstractInstancesOfTypeContainerNode) {
            AbstractInstancesOfTypeContainerNode aiocn = (AbstractInstancesOfTypeContainerNode)element;
            project = aiocn.getProject();
        } else if (element instanceof IFolder) {
            diagramFolder = (IFolder)element;
            project = diagramFolder.getProject();
        }
        if (project == null || !project.isAccessible()) {
            String error = Messages.CreateDiagramWizard_NoProjectFoundError;
            Status status = new Status(4, ExamplesCommonPlugin.getID(), error);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CreateDiagramWizard_NoProjectFoundErrorTitle, null, (IStatus)status);
            return false;
        }
        Diagram diagram = Graphiti.getPeCreateService().createDiagram(diagramTypeId, diagramName, true);
        if (diagramFolder == null) {
            diagramFolder = project.getFolder("src/diagrams/");
        }
        String editorID = "org.eclipse.graphiti.ui.editor.DiagramEditor";
        String editorExtension = "diagram";
        String diagramTypeProviderId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagramTypeId);
        String namingConventionID = String.valueOf(diagramTypeProviderId) + ".editor";
        IEditorDescriptor specificEditor = PlatformUI.getWorkbench().getEditorRegistry().findEditor(namingConventionID);
        if (specificEditor != null) {
            IExtension[] extensions;
            editorID = namingConventionID;
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.ui.editors");
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configurationElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configurationElements = ext.getConfigurationElements();
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileExt;
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String id = ce.getAttribute("id");
                    if (editorID.equals(id) && (fileExt = ce.getAttribute("extensions")) != null) {
                        editorExtension = fileExt;
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        IFile diagramFile = diagramFolder.getFile(String.valueOf(diagramName) + "." + editorExtension);
        URI uri = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        TransactionalEditingDomain domain = FileService.createEmfFileForDiagram(uri, diagram);
        String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        DiagramEditorInput editorInput = new DiagramEditorInput(EcoreUtil.getURI((EObject)diagram), domain, providerId);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, editorID);
        }
        catch (PartInitException e) {
            String error = Messages.CreateDiagramWizard_OpeningEditorError;
            Status status = new Status(4, ExamplesCommonPlugin.getID(), error, (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CreateDiagramWizard_ErrorOccuredTitle, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }
}

