/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.func.ICreateInfo;
import org.eclipse.graphiti.internal.command.CommandExec;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.command.AbstractCommand;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CreateConnectionCommand
extends AbstractCommand {
    private List<IFeature> features;
    private Point location;
    private ILocation sourceLocation;
    private final PictogramElement sourceObject;
    private PictogramElement targetObject;
    private static ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            GenericFeatureCommandWithContext command = (GenericFeatureCommandWithContext)element;
            IFeature feature = command.getFeature();
            if (feature instanceof ICreateInfo) {
                return ((ICreateInfo)feature).getCreateName();
            }
            if (feature instanceof ICustomFeature) {
                return ((ICustomFeature)feature).getName();
            }
            return null;
        }

        public Image getImage(Object element) {
            GenericFeatureCommandWithContext command = (GenericFeatureCommandWithContext)element;
            IFeature feature = command.getFeature();
            if (feature instanceof ICreateInfo) {
                return GraphitiUi.getImageService().getImageForId(((ICreateInfo)feature).getCreateImageId());
            }
            if (feature instanceof ICustomFeature) {
                return GraphitiUi.getImageService().getImageForId(((ICustomFeature)feature).getImageId());
            }
            return null;
        }
    };

    public CreateConnectionCommand(IConfigurationProvider configurationProvider, PictogramElement pe, List<IFeature> features) {
        super(configurationProvider);
        this.setLabel(Messages.CreateConnectionCommand_0_xmsg);
        this.features = features;
        this.sourceObject = pe;
    }

    public boolean canExecute() {
        Anchor sourceAnchor = this.getAnchor(this.sourceObject);
        Anchor targetAnchor = this.getAnchor(this.targetObject);
        CreateConnectionContext connectionContext = new CreateConnectionContext();
        connectionContext.setSourceAnchor(sourceAnchor);
        connectionContext.setTargetAnchor(targetAnchor);
        connectionContext.setSourcePictogramElement(this.sourceObject);
        connectionContext.setTargetPictogramElement(this.targetObject);
        connectionContext.setTargetLocation(this.getCurrentLocation());
        connectionContext.setSourceLocation(this.sourceLocation);
        CustomContext customContext = new CustomContext();
        customContext.setPictogramElements(new PictogramElement[]{this.sourceObject, this.targetObject});
        customContext.setX(this.location.x);
        customContext.setY(this.location.y);
        Object context = null;
        Iterator<IFeature> iterator = this.features.iterator();
        while (iterator.hasNext()) {
            IFeature feature;
            context = (feature = iterator.next()) instanceof ICreateConnectionFeature ? connectionContext : customContext;
            GenericFeatureCommandWithContext ccc = new GenericFeatureCommandWithContext(feature, (IContext)context);
            if (!ccc.canExecute()) continue;
            return true;
        }
        return false;
    }

    public void execute() {
        Anchor sourceAnchor = this.getAnchor(this.sourceObject);
        Anchor targetAnchor = this.getAnchor(this.targetObject);
        CreateConnectionContext connectionContext = new CreateConnectionContext();
        connectionContext.setSourceAnchor(sourceAnchor);
        connectionContext.setTargetAnchor(targetAnchor);
        connectionContext.setSourcePictogramElement(this.sourceObject);
        connectionContext.setTargetPictogramElement(this.targetObject);
        connectionContext.setTargetLocation(this.getCurrentLocation());
        connectionContext.setSourceLocation(this.sourceLocation);
        CustomContext customContext = new CustomContext();
        customContext.setPictogramElements(new PictogramElement[]{this.sourceObject, this.targetObject});
        DiagramEditorInternal diagramEditor = (DiagramEditorInternal)this.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor();
        Point newLocation = diagramEditor.calculateRealMouseLocation(this.location);
        customContext.setLocation(newLocation.x, newLocation.y);
        ArrayList<GenericFeatureCommandWithContext> commands = new ArrayList<GenericFeatureCommandWithContext>();
        Object context = null;
        Iterator<IFeature> iterator = this.features.iterator();
        while (iterator.hasNext()) {
            IFeature feature;
            context = (feature = iterator.next()) instanceof ICreateConnectionFeature ? connectionContext : customContext;
            GenericFeatureCommandWithContext ccc = new GenericFeatureCommandWithContext(feature, (IContext)context);
            if (!ccc.canExecute()) continue;
            commands.add(ccc);
        }
        if (commands.size() == 0) {
            return;
        }
        if (commands.size() == 1) {
            CommandExec.getSingleton().executeCommand((ICommand)commands.get(0), this.getTransactionalEditingDomain());
            return;
        }
        PopupMenu popupMenu = new PopupMenu(commands, labelProvider);
        boolean b = popupMenu.show((Control)Display.getCurrent().getActiveShell());
        if (b) {
            GenericFeatureCommandWithContext result = (GenericFeatureCommandWithContext)popupMenu.getResult();
            CommandExec.getSingleton().executeCommand((ICommand)result, this.getTransactionalEditingDomain());
        }
    }

    public boolean canStartConnection() {
        Anchor sourceAnchor = this.getAnchor(this.sourceObject);
        Anchor targetAnchor = null;
        CreateConnectionContext connectionContext = new CreateConnectionContext();
        connectionContext.setSourceAnchor(sourceAnchor);
        connectionContext.setTargetAnchor(targetAnchor);
        connectionContext.setSourcePictogramElement(this.sourceObject);
        connectionContext.setTargetPictogramElement(null);
        connectionContext.setTargetLocation(null);
        this.sourceLocation = this.getCurrentLocation();
        connectionContext.setSourceLocation(this.sourceLocation);
        for (IFeature feature : this.features) {
            if (feature instanceof ICreateConnectionFeature) {
                ICreateConnectionFeature ccf = (ICreateConnectionFeature)feature;
                if (!ccf.canStartConnection((ICreateConnectionContext)connectionContext)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void redo() {
    }

    public void setTarget(PictogramElement pe) {
        this.targetObject = pe;
    }

    public void undo() {
    }

    private Anchor getAnchor(PictogramElement pe) {
        Anchor ret = null;
        if (pe instanceof Anchor) {
            ret = (Anchor)pe;
        } else if (pe instanceof AnchorContainer) {
            ret = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
        }
        return ret;
    }

    public PictogramElement getSourceObject() {
        return this.sourceObject;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public IFeature[] getFeatures() {
        return this.features.toArray(new IFeature[0]);
    }

    private ILocation getCurrentLocation() {
        if (this.location == null) {
            return null;
        }
        DiagramEditorInternal diagramEditor = (DiagramEditorInternal)this.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor();
        Point realLocation = diagramEditor.calculateRealMouseLocation(this.location);
        LocationImpl currentLocation = new LocationImpl(realLocation.x, realLocation.y);
        return currentLocation;
    }
}

