/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.fixed;

import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.ui.internal.fixed.FixedScaledGraphics;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class FixedThumbnail
extends Figure
implements UpdateListener {
    private boolean isDirty;
    private float scaleX;
    private float scaleY;
    private IFigure sourceFigure;
    Dimension targetSize = new Dimension(0, 0);
    private Image thumbnailImage;
    private Dimension thumbnailImageSize;
    private ThumbnailUpdater updater = new ThumbnailUpdater();

    public FixedThumbnail() {
    }

    public FixedThumbnail(IFigure fig) {
        this();
        this.setSource(fig);
    }

    private Dimension adjustToAspectRatio(Dimension size, boolean adjustToMaxDimension) {
        int height;
        int width;
        Dimension sourceSize = this.getSourceRectangle().getSize();
        Dimension borderSize = new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight());
        size.expand(borderSize.getNegated());
        if (adjustToMaxDimension) {
            width = Math.max(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.max(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        } else {
            width = Math.min(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.min(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        }
        size.width = width;
        size.height = height;
        return size.expand(borderSize);
    }

    public void deactivate() {
        this.sourceFigure.getUpdateManager().removeUpdateListener((UpdateListener)this);
        this.updater.deactivate();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            return this.adjustToAspectRatio(this.getBounds().getSize(), false);
        }
        Dimension preferredSize = this.adjustToAspectRatio(this.prefSize.getCopy(), true);
        if (this.maxSize == null) {
            return preferredSize;
        }
        Dimension maximumSize = this.adjustToAspectRatio(this.maxSize.getCopy(), true);
        if (preferredSize.contains(maximumSize)) {
            return maximumSize;
        }
        return preferredSize;
    }

    protected float getScaleX() {
        return this.scaleX;
    }

    protected float getScaleY() {
        return this.scaleY;
    }

    protected IFigure getSource() {
        return this.sourceFigure;
    }

    protected Rectangle getSourceRectangle() {
        return this.sourceFigure.getBounds();
    }

    protected Image getThumbnailImage() {
        Dimension oldSize = this.targetSize;
        this.targetSize = this.getPreferredSize();
        this.targetSize.expand(new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight()).negate());
        this.setScales((float)this.targetSize.width / (float)this.getSourceRectangle().width, (float)this.targetSize.height / (float)this.getSourceRectangle().height);
        if (this.isDirty() && !this.updater.isRunning()) {
            this.updater.start();
        } else if (oldSize != null && !this.targetSize.equals((Object)oldSize)) {
            this.revalidate();
            this.updater.restart();
        }
        return this.thumbnailImage;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    public void notifyPainting(Rectangle damage, Map dirtyRegions) {
        for (IFigure current : dirtyRegions.keySet()) {
            while (current != null) {
                if (current == this.getSource()) {
                    this.setDirty(true);
                    this.repaint();
                    return;
                }
                current = current.getParent();
            }
        }
    }

    public void notifyValidating() {
    }

    protected void paintFigure(Graphics graphics) {
        Image thumbnail = this.getThumbnailImage();
        if (thumbnail == null) {
            return;
        }
        graphics.drawImage(thumbnail, this.getClientArea().getLocation());
    }

    public void setDirty(boolean value) {
        this.isDirty = value;
    }

    protected void setScales(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
    }

    public void setSource(IFigure fig) {
        if (this.sourceFigure == fig) {
            return;
        }
        if (this.sourceFigure != null) {
            this.sourceFigure.getUpdateManager().removeUpdateListener((UpdateListener)this);
        }
        this.sourceFigure = fig;
        if (this.sourceFigure != null) {
            this.setScales((float)this.getSize().width / (float)this.getSourceRectangle().width, (float)this.getSize().height / (float)this.getSourceRectangle().height);
            this.sourceFigure.getUpdateManager().addUpdateListener((UpdateListener)this);
            this.repaint();
        }
    }

    class ThumbnailUpdater
    implements Runnable {
        static final int MAX_BUFFER_SIZE = 256;
        private int currentHTile;
        private int currentVTile;
        private int hTiles;
        private int vTiles;
        private boolean isActive = true;
        private boolean isRunning = false;
        private GC thumbnailGC;
        private Graphics thumbnailGraphics;
        private Dimension tileSize;

        ThumbnailUpdater() {
        }

        public void deactivate() {
            this.setActive(false);
            this.stop();
            if (FixedThumbnail.this.thumbnailImage != null) {
                FixedThumbnail.this.thumbnailImage.dispose();
                FixedThumbnail.this.thumbnailImage = null;
                FixedThumbnail.this.thumbnailImageSize = null;
            }
        }

        protected int getCurrentHTile() {
            return this.currentHTile;
        }

        protected int getCurrentVTile() {
            return this.currentVTile;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void resetTileValues() {
            this.hTiles = (int)Math.ceil((float)FixedThumbnail.this.getSourceRectangle().width / 256.0f);
            this.vTiles = (int)Math.ceil((float)FixedThumbnail.this.getSourceRectangle().height / 256.0f);
            this.tileSize = new Dimension((int)Math.ceil((float)FixedThumbnail.this.getSourceRectangle().width / (float)this.hTiles), (int)Math.ceil((float)FixedThumbnail.this.getSourceRectangle().height / (float)this.vTiles));
            this.currentHTile = 0;
            this.currentVTile = 0;
        }

        public void restart() {
            this.stop();
            this.start();
        }

        @Override
        public void run() {
            if (!this.isActive() || !this.isRunning()) {
                return;
            }
            int v = this.getCurrentVTile();
            int sy1 = v * this.tileSize.height;
            int sy2 = Math.min((v + 1) * this.tileSize.height, FixedThumbnail.this.getSourceRectangle().height);
            int h = this.getCurrentHTile();
            int sx1 = h * this.tileSize.width;
            int sx2 = Math.min((h + 1) * this.tileSize.width, FixedThumbnail.this.getSourceRectangle().width);
            Point p = FixedThumbnail.this.getSourceRectangle().getLocation();
            Rectangle rect = new Rectangle(sx1 + p.x, sy1 + p.y, sx2 - sx1, sy2 - sy1);
            rect = FixedThumbnail.this.getSourceRectangle().getCopy();
            this.thumbnailGraphics.pushState();
            this.thumbnailGraphics.setClip(rect);
            this.thumbnailGraphics.fillRectangle(rect);
            try {
                FixedThumbnail.this.sourceFigure.paint(this.thumbnailGraphics);
            }
            catch (SWTException sWTException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.thumbnailGraphics.popState();
            if (this.getCurrentHTile() < this.hTiles - 1) {
                this.setCurrentHTile(this.getCurrentHTile() + 1);
            } else {
                this.setCurrentHTile(0);
                if (this.getCurrentVTile() < this.vTiles - 1) {
                    this.setCurrentVTile(this.getCurrentVTile() + 1);
                } else {
                    this.setCurrentVTile(0);
                }
            }
            this.stop();
            FixedThumbnail.this.repaint();
        }

        public void setActive(boolean value) {
            this.isActive = value;
        }

        protected void setCurrentHTile(int count) {
            this.currentHTile = count;
        }

        protected void setCurrentVTile(int count) {
            this.currentVTile = count;
        }

        public void start() {
            if (!this.isActive() || this.isRunning()) {
                return;
            }
            this.isRunning = true;
            FixedThumbnail.this.setDirty(false);
            this.resetTileValues();
            if (!FixedThumbnail.this.targetSize.equals((Object)FixedThumbnail.this.thumbnailImageSize)) {
                this.resetThumbnailImage();
            }
            if (FixedThumbnail.this.targetSize.isEmpty()) {
                return;
            }
            this.thumbnailGC = new GC((Drawable)FixedThumbnail.this.thumbnailImage, FixedThumbnail.this.sourceFigure.isMirrored() ? 0x4000000 : 0);
            this.thumbnailGraphics = new FixedScaledGraphics((Graphics)new SWTGraphics(this.thumbnailGC));
            this.thumbnailGraphics.scale((double)FixedThumbnail.this.getScaleX());
            this.thumbnailGraphics.translate(FixedThumbnail.this.getSourceRectangle().getLocation().negate());
            Color color = FixedThumbnail.this.sourceFigure.getForegroundColor();
            if (color != null) {
                this.thumbnailGraphics.setForegroundColor(color);
            }
            if ((color = FixedThumbnail.this.sourceFigure.getBackgroundColor()) != null) {
                this.thumbnailGraphics.setBackgroundColor(color);
            }
            this.thumbnailGraphics.setFont(FixedThumbnail.this.sourceFigure.getFont());
            FixedThumbnail.this.setScales((float)FixedThumbnail.this.targetSize.width / (float)FixedThumbnail.this.getSourceRectangle().width, (float)FixedThumbnail.this.targetSize.height / (float)FixedThumbnail.this.getSourceRectangle().height);
            Display.getCurrent().asyncExec((Runnable)this);
        }

        private void resetThumbnailImage() {
            if (FixedThumbnail.this.thumbnailImage != null) {
                FixedThumbnail.this.thumbnailImage.dispose();
            }
            if (!FixedThumbnail.this.targetSize.isEmpty()) {
                if (FixedThumbnail.this.thumbnailImage != null && !FixedThumbnail.this.thumbnailImage.isDisposed()) {
                    FixedThumbnail.this.thumbnailImage.dispose();
                }
                FixedThumbnail.this.thumbnailImage = new Image((Device)Display.getDefault(), FixedThumbnail.this.targetSize.width, FixedThumbnail.this.targetSize.height);
                FixedThumbnail.this.thumbnailImageSize = new Dimension(FixedThumbnail.this.targetSize);
            } else {
                FixedThumbnail.this.thumbnailImage = null;
                FixedThumbnail.this.thumbnailImageSize = new Dimension(0, 0);
            }
        }

        public void stop() {
            this.isRunning = false;
            if (this.thumbnailGC != null) {
                this.thumbnailGC.dispose();
                this.thumbnailGC = null;
            }
            if (this.thumbnailGraphics != null) {
                this.thumbnailGraphics.dispose();
                this.thumbnailGraphics = null;
            }
        }
    }
}

