/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.platform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.dt.IDiagramType;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorDummy;
import org.eclipse.graphiti.ui.internal.platform.DiagramTypeImpl;
import org.eclipse.graphiti.ui.internal.util.ui.print.IDiagramsExporter;
import org.eclipse.graphiti.ui.platform.IImageProvider;
import org.eclipse.graphiti.ui.services.IExtensionManager;

public class ExtensionManager
implements IExtensionManager {
    private static ExtensionManager singleton;
    private static String EP_DIAGRAM_TYPES;
    private static String EP_IMAGE_PROVIDERS;
    private static String EP_DIAGRAM_TYPE_PROVIDERS;
    private static String EP_DIAGRAM_EXPORTERS;
    private static final String EP_CHILD_NODE_DIAGRAM_EXPORTER = "diagramexporter";
    private static final String EP_CHILD_NODE_IMAGE_PROVIDER = "imageProvider";
    private static final String EP_CHILD_NODE_DIAGRAM_TYPE = "diagramType";
    private static final String EP_ATTRIBUTE_CLASS = "class";
    private static final String EP_ATTRIBUTE_ID = "id";
    private static final String EP_ATTRIBUTE_TYPE = "type";
    private static final String EP_ATTRIBUTE_ENABLEUI = "enableScaling";
    private static final String EP_ATTRIBUTE_NAME = "name";
    private static final String EP_ATTRIBUTE_DESCRIPTION = "description";
    private IDiagramType[] diagramTypes = null;
    private IImageProvider[] imageProviders = null;

    static {
        EP_DIAGRAM_TYPES = "org.eclipse.graphiti.ui.diagramTypes";
        EP_IMAGE_PROVIDERS = "org.eclipse.graphiti.ui.imageProviders";
        EP_DIAGRAM_TYPE_PROVIDERS = "org.eclipse.graphiti.ui.diagramTypeProviders";
        EP_DIAGRAM_EXPORTERS = "org.eclipse.graphiti.ui.diagramExporters";
    }

    private ExtensionManager() {
        this.searchForExtensions();
    }

    public static ExtensionManager getSingleton() {
        if (singleton == null) {
            singleton = new ExtensionManager();
        }
        return singleton;
    }

    @Override
    public String[] getDiagramTypeProviderIds(String diagramTypeId) {
        String[] ret = new String[]{};
        if (diagramTypeId == null) {
            return ret;
        }
        ArrayList<String> retList = new ArrayList<String>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EP_DIAGRAM_TYPE_PROVIDERS);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement element = configurationElements[j];
                String extensionId = element.getAttribute(EP_ATTRIBUTE_ID);
                if (extensionId != null) {
                    IConfigurationElement[] children = element.getChildren();
                    int k = 0;
                    while (k < children.length) {
                        String typeId;
                        IConfigurationElement childElement = children[k];
                        String childName = childElement.getName();
                        String childExtensionId = childElement.getAttribute(EP_ATTRIBUTE_ID);
                        if (childName != null && childExtensionId != null && EP_CHILD_NODE_DIAGRAM_TYPE.equals(childName) && diagramTypeId.equals(typeId = this.getDiagramTypeIdForDiagramTypeProviderId(childExtensionId))) {
                            retList.add(extensionId);
                            break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        ret = retList.toArray(ret);
        return ret;
    }

    public Map<String, Boolean> getDiagramExporterTypes() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EP_DIAGRAM_EXPORTERS);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement element = configurationElements[j];
                String name = element.getName();
                String type = element.getAttribute(EP_ATTRIBUTE_TYPE);
                if (name != null && type != null && EP_CHILD_NODE_DIAGRAM_EXPORTER.equals(name)) {
                    String enableScaling = element.getAttribute(EP_ATTRIBUTE_ENABLEUI);
                    ret.put(type, Boolean.valueOf(enableScaling));
                    break;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public IDiagramsExporter getDiagramExporterForType(String type) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EP_DIAGRAM_EXPORTERS);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement element = configurationElements[j];
                String name = element.getName();
                String currType = element.getAttribute(EP_ATTRIBUTE_TYPE);
                if (name != null && type != null && EP_CHILD_NODE_DIAGRAM_EXPORTER.equals(name) && type.equals(currType)) {
                    try {
                        Object executableExtension = element.createExecutableExtension(EP_ATTRIBUTE_CLASS);
                        if (executableExtension instanceof IDiagramsExporter) {
                            return (IDiagramsExporter)executableExtension;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void searchForExtensions() {
        List<IDiagramType> diagramTypeList = this.createDiagramTypes();
        this.diagramTypes = diagramTypeList.toArray(new IDiagramType[0]);
        this.imageProviders = new IImageProvider[0];
        this.loadImageProvider("org.eclipse.graphiti.ui.platform.PlatformImageProvider");
    }

    @Override
    public IDiagramTypeProvider createDiagramTypeProvider(String providerId) {
        IDiagramTypeProvider diagramTypeProvider = null;
        if (providerId == null) {
            return diagramTypeProvider;
        }
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EP_DIAGRAM_TYPE_PROVIDERS);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement element = configurationElements[j];
                String extensionId = element.getAttribute(EP_ATTRIBUTE_ID);
                if (extensionId != null && extensionId.equals(providerId)) {
                    String name = element.getAttribute(EP_ATTRIBUTE_NAME);
                    String description = element.getAttribute(EP_ATTRIBUTE_DESCRIPTION);
                    if (description == null) {
                        description = "";
                    }
                    if (name != null) {
                        IConfigurationElement[] children = element.getChildren();
                        int k = 0;
                        while (k < children.length) {
                            boolean ret;
                            IConfigurationElement childElement = children[k];
                            String childName = childElement.getName();
                            String childExtensionId = childElement.getAttribute(EP_ATTRIBUTE_ID);
                            if (childName != null && childExtensionId != null && EP_CHILD_NODE_IMAGE_PROVIDER.equals(childName) && !(ret = this.loadImageProvider(childExtensionId))) {
                                return null;
                            }
                            ++k;
                        }
                        try {
                            Object executableExtension = element.createExecutableExtension(EP_ATTRIBUTE_CLASS);
                            if (executableExtension instanceof IDiagramTypeProvider) {
                                diagramTypeProvider = (IDiagramTypeProvider)executableExtension;
                                diagramTypeProvider.setProviderId(extensionId);
                            }
                        }
                        catch (CoreException e) {
                            T.racer().error(e.toString());
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return diagramTypeProvider;
    }

    public IImageProvider[] getImageProviders() {
        return this.imageProviders;
    }

    @Override
    public IDiagramType[] getDiagramTypes() {
        return this.diagramTypes;
    }

    private String getDiagramTypeIdForDiagramTypeProviderId(String providerId) {
        if (providerId != null) {
            IDiagramType[] diagramTypes = this.getDiagramTypes();
            int i = 0;
            while (i < diagramTypes.length) {
                IDiagramType diagramType = diagramTypes[i];
                if (providerId.equals(diagramType.getProviderId())) {
                    return diagramType.getId();
                }
                ++i;
            }
        }
        return null;
    }

    private boolean loadImageProvider(String providerId) {
        IImageProvider[] providers = this.getImageProviders();
        int i = 0;
        while (i < providers.length) {
            IImageProvider provider = providers[i];
            if (providerId.equals(provider.getProviderId())) {
                return true;
            }
            ++i;
        }
        IImageProvider newProvider = this.createImageProvider(providerId);
        if (newProvider != null) {
            IImageProvider[] imageProvidersDest = new IImageProvider[this.imageProviders.length + 1];
            System.arraycopy(this.imageProviders, 0, imageProvidersDest, 0, this.imageProviders.length);
            imageProvidersDest[this.imageProviders.length] = newProvider;
            this.imageProviders = imageProvidersDest;
            return true;
        }
        return false;
    }

    private List<IDiagramType> createDiagramTypes() {
        ArrayList<IDiagramType> ret = new ArrayList<IDiagramType>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EP_DIAGRAM_TYPES);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement element = configurationElements[j];
                String extensionId = element.getAttribute(EP_ATTRIBUTE_ID);
                String typeId = element.getAttribute(EP_ATTRIBUTE_TYPE);
                String typeName = element.getAttribute(EP_ATTRIBUTE_NAME);
                String typeDescription = element.getAttribute(EP_ATTRIBUTE_DESCRIPTION);
                if (typeDescription == null) {
                    typeDescription = "";
                }
                if (extensionId != null && typeId != null && typeName != null) {
                    DiagramTypeImpl diagramType = new DiagramTypeImpl(typeId, typeName, typeDescription);
                    diagramType.setProviderId(extensionId);
                    ret.add(diagramType);
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private IImageProvider createImageProvider(String providerId) {
        if (providerId == null) {
            return null;
        }
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EP_IMAGE_PROVIDERS);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement element = configurationElements[j];
                String extensionId = element.getAttribute(EP_ATTRIBUTE_ID);
                if (providerId.equals(extensionId)) {
                    try {
                        String pluginId;
                        IContributor contributor;
                        Object executableExtension = element.createExecutableExtension(EP_ATTRIBUTE_CLASS);
                        if (executableExtension instanceof IImageProvider && (contributor = extension.getContributor()) != null && (pluginId = contributor.getName()) != null) {
                            IImageProvider imageProvider = (IImageProvider)executableExtension;
                            imageProvider.setProviderId(extensionId);
                            imageProvider.setPluginId(pluginId);
                            return imageProvider;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IFeatureProvider createFeatureProvider(Diagram diagram) {
        Assert.isNotNull((Object)diagram);
        String providerId = this.getDiagramTypeProviderId(diagram.getDiagramTypeId());
        if (providerId != null) {
            IDiagramTypeProvider dtp = this.createDiagramTypeProvider(diagram, providerId);
            return dtp.getFeatureProvider();
        }
        return null;
    }

    @Override
    public IDiagramTypeProvider createDiagramTypeProvider(Diagram diagram, String providerId) {
        Assert.isNotNull((Object)diagram);
        IDiagramTypeProvider dtp = this.createDiagramTypeProvider(providerId);
        if (dtp != null) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
            DiagramEditorDummy diagramEditor = new DiagramEditorDummy(dtp, editingDomain);
            dtp.init(diagram, (IDiagramEditor)diagramEditor);
        }
        return dtp;
    }

    @Override
    public String getDiagramTypeProviderId(String diagramTypeId) {
        String[] diagramTypeProviders = this.getDiagramTypeProviderIds(diagramTypeId);
        if (diagramTypeProviders != null && diagramTypeProviders.length > 0) {
            return diagramTypeProviders[0];
        }
        return null;
    }
}

