/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.policy;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.policy.GFEditPolicyDelegate;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFHandleHelper;
import org.eclipse.graphiti.ui.internal.util.draw2d.TransparentGhostFigure;

public class GFNonResizableEditPolicy
extends NonResizableEditPolicy {
    private GFEditPolicyDelegate delegate;

    public GFNonResizableEditPolicy(IConfigurationProvider cfgProvider) {
        this.setDelegate(new GFEditPolicyDelegate(cfgProvider));
    }

    private IConfigurationProvider getConfigurationProvider() {
        return this.getDelegate().getConfigurationProvider();
    }

    private GFEditPolicyDelegate getDelegate() {
        return this.delegate;
    }

    private void setDelegate(GFEditPolicyDelegate delegate) {
        this.delegate = delegate;
    }

    protected IFigure createDragSourceFeedbackFigure() {
        TransparentGhostFigure feedback = new TransparentGhostFigure(this.getHostFigure(), 70, this.getConfigurationProvider().getDiagramEditor().getZoomLevel());
        this.addFeedback((IFigure)feedback);
        return feedback;
    }

    protected List<?> createSelectionHandles() {
        GraphicalEditPart owner = (GraphicalEditPart)this.getHost();
        List<AbstractHandle> list = GFHandleHelper.createShapeHandles(owner, this.getConfigurationProvider(), 0, this.isDragAllowed());
        return list;
    }

    protected void hideSelection() {
        this.getDelegate().hideSelection(this.getHostFigure());
        this.removeSelectionHandles();
    }

    protected void showPrimarySelection() {
        this.getDelegate().showPrimarySelection(this.getHostFigure());
        this.addSelectionHandles();
    }

    protected void showSelection() {
        this.getDelegate().showSelection(this.getHostFigure());
        this.addSelectionHandles();
    }

    public void eraseSourceFeedback(Request request) {
        List children = this.getFeedbackLayer().getChildren();
        for (IFigure child : children) {
            if (!(child instanceof TransparentGhostFigure)) continue;
            ((TransparentGhostFigure)child).dispose();
        }
        super.eraseSourceFeedback(request);
    }
}

