/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.internal.command.CommandExec;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public abstract class GFPropertySection
extends AbstractPropertySection
implements PropertyChangeListener {
    protected PictogramElement getSelectedPictogramElement() {
        if (this.getSelection() instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)this.getSelection();
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof PictogramElement) {
                return (PictogramElement)firstElement;
            }
            EditPart editPart = null;
            if (firstElement instanceof EditPart) {
                editPart = (EditPart)firstElement;
            } else if (firstElement instanceof IAdaptable) {
                editPart = (EditPart)((IAdaptable)firstElement).getAdapter(EditPart.class);
            }
            if (editPart != null && editPart.getModel() instanceof PictogramElement) {
                return (PictogramElement)editPart.getModel();
            }
        }
        return null;
    }

    public void execute(IFeature feature, IContext context) {
        CommandExec.executeFeatureWithContext((IFeature)feature, (IContext)context);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    protected IDiagramEditor getDiagramEditor() {
        IWorkbenchPart part = this.getPart();
        if (part instanceof DiagramEditorInternal) {
            return (DiagramEditorInternal)part;
        }
        IContributedContentsView contributedView = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        if (contributedView != null) {
            part = contributedView.getContributingPart();
        }
        if (part instanceof DiagramEditorInternal) {
            return (DiagramEditorInternal)part;
        }
        return null;
    }

    protected Diagram getDiagram() {
        IDiagramTypeProvider diagramTypeProvider = this.getDiagramTypeProvider();
        if (diagramTypeProvider == null) {
            return null;
        }
        return diagramTypeProvider.getDiagram();
    }

    protected IDiagramTypeProvider getDiagramTypeProvider() {
        IDiagramEditor diagramEditor = this.getDiagramEditor();
        if (diagramEditor == null) {
            return null;
        }
        return diagramEditor.getDiagramTypeProvider();
    }
}

