/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.command;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.internal.command.CommandExec;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.command.AbstractCommand;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;

public class ReconnectCommand
extends AbstractCommand
implements IFeatureAndContext {
    private IReconnectionContext ctx;
    private IReconnectionFeature feature;

    public ReconnectCommand(IConfigurationProvider configurationProvider, Connection connection, Anchor oldAnchor, Anchor newAnchor, PictogramElement newTargetPictogramElement, String reconnectType, Point location) {
        super(configurationProvider);
        LocationImpl targetLocation = null;
        if (location != null) {
            DiagramEditorInternal diagramEditor = (DiagramEditorInternal)this.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor();
            Point realLocation = diagramEditor.calculateRealMouseLocation(location);
            targetLocation = new LocationImpl(realLocation.x, realLocation.y);
        }
        this.ctx = new ReconnectionContext(connection, oldAnchor, newAnchor, targetLocation);
        this.ctx.setTargetPictogramElement(newTargetPictogramElement);
        ((ReconnectionContext)this.ctx).setReconnectType(reconnectType);
        this.feature = this.getFeatureProvider().getReconnectionFeature(this.ctx);
    }

    public boolean canExecute() {
        if (this.feature != null) {
            return this.feature.canReconnect(this.ctx);
        }
        return false;
    }

    public void execute() {
        if (this.feature != null) {
            GenericFeatureCommandWithContext genericFeatureCommandWithContext = new GenericFeatureCommandWithContext((IFeature)this.feature, (IContext)this.ctx);
            CommandExec.getSingleton().executeCommand((ICommand)genericFeatureCommandWithContext, this.getTransactionalEditingDomain());
        }
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public IContext getContext() {
        return this.ctx;
    }
}

